const { parse, format } = require('date-fns');

const CONTAINS_LIST = {    
    DROPDOWN :  [
        { name: "contains" },
        { name: "does not contain" },
        { name: "is empty" },
        { name: "is not empty" }
    ],
    LOOKUP :  [
        { name: "contains" },
        { name: "does not contain" },
        { name: "is empty" },
        { name: "is not empty" }
    ],
    NUMBERS: [
      { name: "< less than" },
      { name: "> greater than" },
      { name: "= equal to" },
      { name: "!= not equal to" },
      { name: "between" },
      { name: "is not empty" },
      { name: "is empty" }
    ],
    DATE: [
        { name: "today" },
        { name: "yesterday" },
        { name: "this week" },
        { name: "last week" },
        { name: "this month" },
        { name: "last month" },
        { name: "this year" },
        { name: "last year" },
        { name: "between" },
        { name: "is not empty" },
        { name: "is empty" }
    ],
    TEXT: [
        { name: "contains" },
        { name: "does not contain" },
        { name: "starts with" },
        { name: "ends with" },
        { name: "is empty" },
        { name: "is not empty" }
    ],
    DEFAULT: [
        { name: "contains" },
        { name: "does not contain" },
        { name: "starts with" },
        { name: "ends with" },
        { name: "is empty" },
        { name: "is not empty" }
    ]
};

const DATE_FORMAT = {    
    SYSTEM_FORMAT:'yyyy-MM-dd\'T\'HH:mm:ss.SSSxxx',
    DATE_TIME_FORMAT: 'yyyy-MM-dd hh:mm a',
    DATE_FORMAT: 'yyyy-MM-dd',
    DATE_FORMAT_NOT_USED: 'dd/MM/yyyy',
    TIME_FORMAT: 'hh:mm a',
};  

// Utility function for date conversion
const convertDate = (input, inputFormat, outputFormat) => {
    try {
        const parsedDate = parse(input, inputFormat, new Date());
        return format(parsedDate, outputFormat);
    } catch (error) {
        console.error('Error converting date:', error);
        return input;
    }
};

module.exports = {
    CONTAINS_LIST,
    convertDate,
    DATE_FORMAT
};


