const accountField = require('../models/accountFields');

// Create new accountField
const create = async (req, res) => {
    try {
        const accountFieldId = await accountField.create(req.body);
        res.status(201).json({
            status:201,
            message: 'accountField created successfully',
            accountFieldId
        });
    } catch (error) {
        // console.error('Error creating accountField:', error);
        res.status(500).json({ status:500, message: 'Error creating accountField'+ error });
    }
};

// Get all accountFields
const getAll = async (req, res) => {
    try {
        const userId = req.user.id;
        const accountFields = await accountField.findAll(userId);
        res.json({status:200, message: "Account fields fetched successfully.", accountFields});
    } catch (error) {
        // console.error('Error fetching accountFields:', error);
        res.status(500).json({ status:500, message: 'Error fetching accountFields '+ error });
    }
};

// Get accountField by ID
const getById = async (req, res) => {
    try {
        const field = await accountField.findById(req.params.id);
        if (!field) {
            return res.status(404).json({ 
                status: 404, 
                message: 'Account field not found' 
            });
        }
        res.json({
            status: 200, 
            message: 'Account field fetched successfully', 
            accountField: field
        });
    } catch (error) {
        console.error('Error fetching accountField:', error);
        res.status(500).json({ 
            status: 500, 
            message: `Error fetching accountField: ${error.message}` 
        });
    }
};
// Update accountField
const update = async (req, res) => {
    try {
        const success = await accountField.update(req.params.id, req.body);
        if (!success) {
            return res.status(404).json({ status:404, message: 'accountField not found' });
        }
        res.json({ status:200, message: 'accountField updated successfully' });
    } catch (error) {
        // console.error('Error updating accountField:', error);
        res.status(500).json({ status:500, message: 'Error updating accountField', errror: error });
    }
};

// Delete accountField
const remove = async (req, res) => {
    try {
        const success = await accountField.deleteRecord(req.params.id);
        if (!success) {
            return res.status(404).json({ status:404, message: 'accountField not found' });
        }
        res.json({ status:200, message: 'accountField inactivated successfully' });
    } catch (error) {
        // console.error('Error deleting accountField:', error);
        res.status(500).json({ status:500, message: 'Error  inactivating accountField' });
    }
};

// Get all account fields with groups
const getAllWithGroups = async (req, res) => {
    try {
        const result = await accountField.findAllWithGroupName();
        res.json(result);
    } catch (error) {
        console.error('Error in getAllWithGroups:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Error fetching account fields with groups'
        });
    }
};

const updateFieldOrder = async (req, res) => {
       try {
        const { fields } = req.body;
        // console.log(fields, "fields");
        if (!Array.isArray(fields) || fields.length === 0) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'Fields array is required'
            });
        }

        // Validate each field object
        for (const field of fields) {
            if (!field.id || typeof field.order !== 'number') {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: 'Each field must have an id and order number'
                });
            }
        }

        const result = await accountField.order(fields);
        console.log(result.message, "result");
        return res.status(200).json(

            result
        );

    } catch (error) {
        console.error('Error in updateFieldOrder:', error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Failed to update field order'
        });
    }
}

module.exports = {
    create,
    getAll,
    getById,
    update,
    remove,
    getAllWithGroups,
    updateFieldOrder
}; 