const addNotes = require('../models/noteModel');

const multer = require('multer');
const path = require('path');
const { v4: uuidv4 } = require('uuid');
const FileUpload = require('../models/fileUpload');

// Configure multer for file upload
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, FileUpload.uploadDir);
    },
    filename: function (req, file, cb) {
        const uniqueFilename = `${uuidv4()}${path.extname(file.originalname)}`;
        cb(null, uniqueFilename);
    }
});

const upload = multer({
    storage: storage,
    limits: {
        fileSize: 5 * 1024 * 1024 // 5MB limit
    },
    fileFilter: (req, file, cb) => {
        // Add file type validation if needed
        cb(null, true);
    }

});


async function addNotesWithFile(req, res) {
    console.log("uploadFile "+JSON.stringify(req.filename) );
    console.log("uploadFileBody "+JSON.stringify(req.body) );
    try {
        if (req.file) {
        console.log("uploadFileBody not found")
        const fileData = {
            //originalname: req.file.originalname,
            filename: req.file.filename,
          //  mimetype: req.file.mimetype,
          //  size: req.file.size,
          //  path: req.file.path,
            owner_id: 1, //req.user.id, // Assuming user info is added by auth middleware
            releted_to: req.body.releted_to,
            releted_id: req.body.releted_id,
            note: req.body.note,

        };

        const fileId = await addNotes.saveNoteWithFile(fileData);
        const file = await addNotes.getNoteById(fileId);

        res.status(201).json({
            status: 201,
            success: true,
            message: 'Note added successfully',
            data: file
        });
    }else{
        const fileData = {
            //originalname: req.file.originalname,
            filename: "",
          //  mimetype: req.file.mimetype,
          //  size: req.file.size,
          //  path: req.file.path,
            owner_id: 1, //req.user.id, // Assuming user info is added by auth middleware
            releted_to: req.body.releted_to,
            releted_id: req.body.releted_id,
            note: req.body.note,

        };

        const fileId = await addNotes.saveNoteWithFile(fileData);
        const file = await addNotes.getNoteById(fileId);

        res.status(201).json({
            status: 201,
            success: true,
            message: 'Note added successfully',
            data: file
        }); 
    }
    } catch (error) {
        console.error('Error in file upload:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Error uploading file',
            error: error.message || error.response || 'Internal Server Error'
        });
    }
}

const addNote = async (req, res) => {
    try {
        // console.log("NoteCreateUser "+req.user.id);
        // console.log("NoteCreateBody "+JSON.stringify(req.body));
        // console.log("note", JSON.stringify(req.body.note));
        const { releted_id, releted_to, note } = req.body;
        console.log("NoteCreateBody "+releted_id+" "+releted_to+" "+note);
        const user_id = req.user.id;
        const notes = await addNotes.createNote(releted_id, releted_to, note, user_id); 
        res.json({status:200, message: "Note added successfully.", notes});
    } catch (error) {
        console.error("Error creating note: ", error);
        res.status(500).json({
            success: false,
            status: false,
            message: 'Error creating note',
            error: error.message
        });
    }
}

const getNotes = async (req, res) => {
    try {   
        const notes = await addNotes.getNotes();
        res.json({status:200, message: "Notes fetched successfully.", notes});
    } catch (error) {
        console.error('Error fetching notes:', error);
        res.status(500).json({
            status: false,
            message: 'Error fetching notes',
            error: error.message
        });
    }   
}


const getNotesByUserId = async (req, res) => {
    console.log("getNotesByUserId "+req.params.id+" "+req.params.belongsto);
try {   
    const notes = await addNotes.getNotesByUserId(req.params.id,req.params.belongsto);
    res.json({status:200,
        success: true,
        message: "Notes fetched successfully.", 
        data: notes});
} catch (error) {
    console.error('Error fetching notes:', error);
    res.status(500).json({
        status: false,
        message: 'Error fetching notes',
        error: error.message
    });
}
}

const updateNote = async (req, res) => {
    try {   
        // console.log("updateNote ",JSON.stringify(req.body));
        const note = await addNotes.updateNote(req.params.id, req.body);

        res.json({status:200, message: "Note updated successfully.", note});
    } catch (error) {
        console.error('Error updating note:', error);
        res.status(500).json({
            status: false,
            message: 'Error updating note',
            error: error.message
        });
    }
}

const deleteNote = async (req, res) => {
    try {  
        const noteId = req.params.id; 
        const note = await addNotes.deleteNote(noteId);

        res.json({status:200, message: "Note deleted successfully.", note});
    } catch (error) {
        console.error('Error deleting note:', error);
        res.status(500).json({
            status: false,
            message: 'Error deleting note',
            error: error.message
        });
    }
}

module.exports = {
    addNote,
    getNotes,
    getNotesByUserId,
    updateNote,
    deleteNote,
    upload,
    addNotesWithFile
}
