const adminModel = require('../models/admin');
const bcrypt = require('bcrypt');


async function userList(req, res) {
    try {
        const users = await adminModel.getUserList();
        res.status(200).json({
            status: 200,
            success: true,  
            message: 'Users retrieved successfully',
            data: users
        });
    } catch (error) {
        console.error('Error fetching user list:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Error retrieving users'
        });
    }
}

// Get user by ID
async function userbyid(req, res) {
    try {
        const id = req.params.id;
        const user = await adminModel.userbyid(id);
        res.status(200).json({
            status: 200,
            success: true,
            message: 'User retrieved successfully',
            data: user
        });
    } catch (error) {
        console.error('Error fetching user by id:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Error fetching user by id'
        });
    }
}

async function createUser(req, res) {
    try {
        const userData = req.body;
        const password = userData.password; 
        const hashedPassword = await bcrypt.hash(password, 10);
        userData.password = hashedPassword;
        const result = await adminModel.createUser(userData);
        res.status(201).json({
            status: 201,
            success: true,
            message: 'User created successfully',
            data: result
        });
    } catch (error) {
        console.error('Error creating user:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Error creating user'
        });
    }
}

async function updateUser(req, res) {
    try {
        const userData = {
            ...req.body,
            id: req.params.id
        };
        const id = req.params.id;
        const result = await adminModel.updateUser(userData, id);
        
        if (result.affectedRows === 0) {
            return res.status(404).json({
                status: 404,
                success: false,
                message: 'User not found'
            });
        }

        res.status(200).json({
            status: 200,
            success: true,
            message: 'User updated successfully',
            data: result
        });
    } catch (error) {
        console.error('Error updating user:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Error updating user'
        });
    }
}

module.exports = {
    userList,
    userbyid,
    createUser,
    updateUser
};