const jwt = require('jsonwebtoken');
const User = require('../models/user');

const register = async (req, res) => {
    try {
        const { name, password, email, mobile, roles_id } = req.body;

        // Check if user already exists
        const existingUser = await User.findUserByUsername(username);
        if (existingUser) {
            return res.status(400).json({ status:400, message: 'Username already exists' });
        }

        // Create new user
        const userId = await User.createUser({
            name,
            password,
            email,
            mobile,
            roles_id
        });

        res.status(201).json({
            status:201,
            message: 'User registered successfully',
            userId
        });
    } catch (error) {
        // console.error('Registration error:', error);
        res.status(500).json({ status:500, message: 'Error registering user ' + error });
    }
};

const login = async (req, res) => {
    try {
        const { email, password } = req.body;
        console.log(email, password);
        
        // Find user
        const user = await User.findUserByUsername(email);
        if (!user) {
            return res.status(401).json({ status:401, message: 'Invalid credentials' });
        }

        // Validate password
        const isValidPassword = await User.validateUserPassword(password, user.password);
        if (!isValidPassword) {
            return res.status(401).json({ status:401, message: 'Invalid credentials' });
        }

        const userId = user.id;
        const fcm_token = req.body.fcm_token;
        if (fcm_token) {
            await User.updatetoken(userId, fcm_token);
        }

        // Generate JWT token
        const token = jwt.sign(
            { id: user.id, username: user.username, role: user.role },
            process.env.JWT_SECRET,
            { expiresIn: '30d' }
        );

        res.json({
            status: 200,
            message: 'Login successful',
            user: {
                token,
                id: user.id,
                username: user.name,
                email: user.email,
                mobile: user.mobile,
                role: user.roles_id,
                is_admin: user.roles_id === 1,
                fcm_token: user.token,
                access_scope: user.access_scope,
                territories: user.territories || [] // Add territories array
            }
        });
    } catch (error) {
        console.error('Login error:', error);
        res.status(500).json({ 
            status: 500, 
            message: 'Error logging in', 
            error: error.message 
        });
    }
};
module.exports = {
    register,
    login
}; 