const contactField = require('../models/contactField');

// Create new contactField
const create = async (req, res) => {
    try {
        const contactFieldId = await contactField.create(req.body);
        res.status(201).json({
            status: 201,
            message: 'contactField created successfully',
            contactFieldId
        });
    } catch (error) {
        // console.error('Error creating contactField:', error);
        res.status(500).json({ status: 500, message: 'Error creating contactField ' + error });
    }
};

// Get all contactFields
const getAll = async (req, res) => {
    try {
        const userId = req.user.id;
        const contactFields = await contactField.findAll(userId);
        res.json({ status: 200, message : "Contact fields fecthed successfully", contactFields});
    } catch (error) {
        // console.error('Error fetching contactFields:', error);
        res.status(500).json({ status: 500, message: 'Error fetching contactFields ' + error });
    }
};



// Get all contactFields
const viewAllFilters = async (req, res) => {
    try {
        const contactFields = await contactField.viewAllFilters(req.user.id);
        res.json({ status: 200, message : "Contact fields fecthed successfully", response:contactFields});
    } catch (error) {
        // console.error('Error fetching contactFields:', error);
        res.status(500).json({ status: 500, message: 'Error fetching contactFields :' + error });
    }
};

// Get contactField by ID
const getById = async (req, res) => {
    try {
        const field = await contactField.findById(req.params.id);
        
        if (!field) {
            return res.status(404).json({ 
                status: 404, 
                message: 'Contact field not found' 
            });
        }

        res.json({
            status: 200, 
            message: 'Contact field fetched successfully', 
            field: field
        });
    } catch (error) {
        console.error('Error fetching contact field:', error);
        res.status(500).json({ 
            status: 500, 
            message: `Error fetching contact field: ${error.message}` 
        });
    }
};
// Update contactField
const update = async (req, res) => {
    try {
        const success = await contactField.update(req.params.id, req.body);
        if (!success) {
            return res.status(404).json({ message: 'contactField not found' });
        }
        res.json({ status: 200, message: 'contactField updated successfully' });
    } catch (error) {
        // console.error('Error updating contactField:', error);
        res.status(500).json({ status: 500, message: 'Error updating contactField ' + error });
    }
};

// Delete contactField
const remove = async (req, res) => {
    try {
        const success = await contactField.deleteRecord(req.params.id);
        if (!success) {
            return res.status(404).json({ status: 404, message: 'contactField not found' });
        }
        res.json({ status: 200, message: 'contactField deleted successfully' });
    } catch (error) {
        // console.error('Error deleting contactField:', error);
        res.status(500).json({ status: 500, message: 'Error deleting contactField ' + error });
    }
};

// update field order
async function updateFieldOrder(req, res) {
    try {
        const { fields } = req.body;

        if (!Array.isArray(fields) || fields.length === 0) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'Fields array is required'
            });
        }

        // Validate each field object
        for (const field of fields) {
            if (!field.id || typeof field.order !== 'number') {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: 'Each field must have an id and order number'
                });
            }
        }

        const result = await contactField.order(fields);
        return res.status(200).json(result);

    } catch (error) {
        console.error('Error in updateFieldOrder:', error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Failed to update field order'
        });
    }
};

module.exports = {
    create,
    getAll,
    getById,
    update,
    remove,
    viewAllFilters,
    updateFieldOrder
}; 