const priceSettingsModel = require('../models/priceSettings');

async function getCPQSettings(req, res) {
    try {
        const priceSettings = await priceSettingsModel.getPriceSettings();
        const quoteCycles = await priceSettingsModel.getQuoteCycles();

        return res.status(200).json({
            status: 200,
            success: true,
            message: 'CPQ settings fetched successfully',
            data: {
                priceSettings,
                quoteCycles
            }
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching CPQ settings',
            error: error.message
        });
    }
}

async function updateCPQSettings(req, res) {
    try {
        const {
            tax_type,
            sales_tax,
            discount_type,
            discount,
            quote_types
        } = req.body;

        // Validate required fields
        if (!tax_type || !sales_tax || !discount_type || !discount) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'All fields are required: tax_type, sales_tax, discount_type, discount'
            });
        }

        // Update price settings
        const priceSettingsUpdated = await priceSettingsModel.updatePriceSettings({
            tax_type,
            sales_tax,
            discount_type,
            discount
        });

        // Update quote cycles if provided
        let quoteCyclesUpdated = true;
        if (quote_types && Array.isArray(quote_types)) {
            quoteCyclesUpdated = await priceSettingsModel.updateQuoteCycles(quote_types);
        }

        if (priceSettingsUpdated && quoteCyclesUpdated) {
            return res.status(200).json({
                status: 200,
                success: true,
                message: 'Tax settings updated successfully'
            });
        } else {
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'Failed to update tax settings'
            });
        }
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error updating CPQ settings',
            error: error.message
        });
    }
}

module.exports = {
    getCPQSettings,
    updateCPQSettings
}; 