const dealField = require('../models/dealField');

// Create new contactField
const create = async (req, res) => {
    try {
        const dealFieldId = await dealField.create(req.body);
        res.status(201).json({
            status: 201,
            message: 'dealField created successfully',
            dealFieldId
        });
    } catch (error) {
        // console.error('Error creating contactField:', error);
        res.status(500).json({ status: 500, message: 'Error creating dealField ' + error });
    }
};

// Get all dealFields
const getAll = async (req, res) => {
    try {
        const userId = req.user.id;
        const dealFields = await dealField.findAll(userId);
        res.json({ status: 200, message : "Deal fields fecthed successfully", dealFields});
    } catch (error) {
        // console.error('Error fetching dealFields:', error);
        res.status(500).json({ status: 500, message: 'Error fetching dealFields ' + error });
    }
};

// Get dealField by ID
const getById = async (req, res) => {
    try {
        const { id } = req.params;
        const userId = req.user.id;

        // Validate ID parameter
        if (!id || isNaN(parseInt(id))) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'Valid field ID is required'
            });
        }

        const field = await dealField.findById(parseInt(id), userId);
        
        if (!field) {
            return res.status(404).json({ 
                status: 404, 
                success: false,
                message: 'Deal field not found' 
            });
        }

        res.json({
            status: 200, 
            success: true,
            message: 'Deal field fetched successfully', 
            data: field
        });
    } catch (error) {
        console.error('Error fetching deal field:', error);
        res.status(500).json({ 
            status: 500, 
            success: false,
            message: `Error fetching deal field: ${error.message}`
        });
    }
};

// Update dealField
const update = async (req, res) => {
    try {
        const success = await dealField.update(req.params.id, req.body);
        if (!success) {
            return res.status(404).json({ message: 'dealField not found' });
        }
        res.json({ status: 200, message: 'dealField updated successfully' });
    } catch (error) {
        // console.error('Error updating dealField:', error);
        res.status(500).json({ status: 500, message: 'Error updating dealField ' + error });
    }
};

// Delete dealField
const remove = async (req, res) => {
    try {
        const success = await dealField.remove(req.params.id);
        if (!success) {
            return res.status(404).json({ status: 404, message: 'deal Field not found' });
        }
        res.json({ status: 200, message: 'dealField deleted successfully' });
    } catch (error) {
        // console.error('Error deleting dealField:', error);
        res.status(500).json({ status: 500, message: 'Error deleting dealField ' + error });
    }
};

// update the order of deal fields
async function updateFieldOrder(req, res) {
    try {
        const { fields } = req.body;

        if (!Array.isArray(fields) || fields.length === 0) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'Fields array is required'
            });
        }

        // Validate each field object
        for (const field of fields) {
            if (!field.id || typeof field.order !== 'number') {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: 'Each field must have an id and order number'
                });
            }
        }

        const result = await dealField.order(fields);
        return res.status(200).json(result);

    } catch (error) {
        console.error('Error in updateFieldOrder:', error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: error.message || 'Failed to update field order'
        });
    }
};

module.exports = {
    create,
    getAll,
    getById,
    update,
    remove,
    updateFieldOrder
}; 