const Domain = require('../models/domain');
const { validationResult } = require('express-validator');

// Verify domain
const verifyDomain = async (req, res) => {
    try {
        // Validate request body
        const errors = validationResult(req);
        if (!errors.isEmpty()) {
            return res.status(422).json({
                status: false,
                message: 'Validation Error',
                errors: errors.array()
            });
        }

        const { subdomain, domain } = req.body;

        // Check if domain exists and is active
        const domainExists = await Domain.findOne({
            subdomain: subdomain,
            domain: domain,
            active: true
        });

        if (domainExists) {
            return res.status(200).json({
                status: true,
                message: 'Domain verification success'
            });
        } else {
            return res.status(404).json({
                status: false,
                message: 'Domain does not exist'
            });
        }
    } catch (error) {
        console.error('Domain verification error:', error);
        return res.status(500).json({
            status: false,
            message: 'Internal Server Error: ' + error.message
        });
    }
};

module.exports = {
    verifyDomain
};