const productField = require('../models/productField');

// Create new productField
const create = async (req, res) => {
    try {
        const productFieldId = await productField.create(req.body);
        res.status(201).json({
            status: 201,
            message: 'productField created successfully',
            productFieldId
        });
    } catch (error) {
        // console.error('Error creating productField:', error);
        res.status(500).json({ status: 500, message: 'Error creating productField ' + error });
    }
};

// Get all productField
const getAll = async (req, res) => {
    try {
        const productFields = await productField.findAll();
        res.json({ status: 200, message : "Product fields fecthed successfully", productFields});
    } catch (error) {
        // console.error('Error fetching dealFields:', error);
        res.status(500).json({ status: 500, message: 'Error fetching productFields ' + error });
    }
};


// Get all productField with group name
async function getAllProductsWithGroupName(req, res) {
    try {
        const productFields = await productField.findAllWithGroupName();
        res.json({ status: 200,success: true, message : "Product fields fecthed successfully", productFields});
    } catch (error) {
        // console.error('Error fetching dealFields:', error);
        res.status(500).json({ status: 500, success: false, message: 'Error fetching productFields ' + error });
    }
}

// Get productField by ID
const getById = async (req, res) => {
    try {
        const productField = await productField.findById(req.params.id);
        if (!productField) {
            return res.status(404).json({ status: 404, message: 'productField not found ' });
        }
        res.json({ status: 200, message : "product Field fetched successfully", productField});
    } catch (error) {
        // console.error('Error fetching productField:', error);
        res.status(500).json({ status: 500, message: 'Error fetching productField ' + error });
    }
};

// Update productField
const update = async (req, res) => {
    try {
        const success = await productField.update(req.params.id, req.body);
        if (!success) {
            return res.status(404).json({ message: 'productField not found' });
        }
        res.json({ status: 200, message: 'productField updated successfully' });
    } catch (error) {
        // console.error('Error updating productField:', error);
        res.status(500).json({ status: 500, message: 'Error updating productField ' + error });
    }
};

// Delete productField
const remove = async (req, res) => {
    try {
        const success = await productField.delete(req.params.id);
        if (!success) {
            return res.status(404).json({ status: 404, message: 'product Field not found' });
        }
        res.json({ status: 200, message: 'productField deleted successfully' });
    } catch (error) {
        // console.error('Error deleting dealField:', error);
        res.status(500).json({ status: 500, message: 'Error deleting productField ' + error });
    }
};

// get product field by group name
const getGroupName = async (req, res) => {
    try {   
        const productGroup = await productField.getGroupName();
        res.json({ status: 200, success: true, message: 'Product group fetched successfully', productGroup });
        // console.log(productGroup);
    } catch (error) {
        res.status(500).json({ status: 500, success: false, message: 'Error fetching product group ' + error });
        // console.log(error);
    }
}

// add product group
const addProductGroup = async (req, res) => {
    try {
        const productGroup = await productField.addProductGroup(req.body);
        res.json({ status: 201, message: 'Product group added successfully', productGroup });
    } catch (error) {
        res.status(500).json({ status: 500, message: 'Error adding product group ' + error });
    }
};

// update product group
const updateProductGroup = async (req, res) => {
    try {
        const success = await productField.updateProductGroup(req.params.id, req.body);
        if (!success) {
            return res.status(404).json({ status: 404, message: 'Product group not found' });
        }
        res.json({ status: 200, message: 'Product group updated successfully' });
    } catch (error) {
        res.status(500).json({ status: 500, message: 'Error updating product group ' + error });
    }
};

// delete product group
const deleteProductGroup = async (req, res) => {
    try {
        const success = await productField.deleteProductGroup(req.params.id);
        if (!success) {
            return res.status(404).json({ status: 404, message: 'Product group not found' });
        }
        res.json({ status: 200, message: 'Product group deleted successfully' });
    } catch (error) {
        res.status(500).json({ status: 500, message: 'Error deleting product group ' + error });
    }
};

module.exports = {
    create,
    getAll,
    getById,
    update,
    remove,
    getAllProductsWithGroupName,
    addProductGroup,
    updateProductGroup,
    deleteProductGroup,
    getGroupName
}; 