const QuotationField = require('../models/quotationField');

async function create(req, res) {
    try {
        const fieldId = await QuotationField.create(req.body);
        res.json({
            status: true,
            message: 'Quotation field created successfully',
            response: { id: fieldId }
        });
    } catch (error) {
        console.error('Error in create:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Error creating quotation field'
        });
    }
}

async function findAll(req, res) {
    try {
        const userId = req.user.id;
        const fields = await QuotationField.findAll(userId);
        res.json({
            status: true,
            message: 'Quotation fields retrieved successfully',
            response: fields
        });
    } catch (error) {
        console.error('Error in findAll:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Error retrieving quotation fields'
        });
    }
}

async function findById(req, res) {
    try {
        const field = await QuotationField.findById(req.params.id);
        if (!field) {
            return res.status(404).json({
                status: false,
                message: 'Quotation field not found'
            });
        }
        res.json({
            status: true,
            message: 'Quotation field retrieved successfully',
            response: field
        });
    } catch (error) {
        console.error('Error in findById:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Error retrieving quotation field'
        });
    }
}

async function update(req, res) {
    try {
        const success = await QuotationField.update(req.params.id, req.body);
        if (!success) {
            return res.status(404).json({
                status: false,
                message: 'Quotation field not found'
            });
        }
        res.json({
            status: true,
            message: 'Quotation field updated successfully'
        });
    } catch (error) {
        console.error('Error in update:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Error updating quotation field'
        });
    }
}

async function deleteRecord(req, res) {
    try {
        const success = await QuotationField.deleteRecord(req.params.id);
        if (!success) {
            return res.status(404).json({
                status: false,
                message: 'Quotation field not found'
            });
        }
        res.json({
            status: true,
            message: 'Quotation field deleted successfully'
        });
    } catch (error) {
        console.error('Error in deleteRecord:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Error deleting quotation field'
        });
    }
}
async function addQuotation(req, res) {
    try {
        // Validate input
        if (!Array.isArray(req.body) || req.body.length === 0) {
            return res.status(400).json({
                status: false,
                message: 'Invalid input format'
            });
        }

        // Find required fields
        const requiredFields = req.body.filter(field => field.required === 'on');
        const missingFields = requiredFields.filter(field => !field.field_value);

        if (missingFields.length > 0) {
            return res.status(400).json({
                status: false,
                message: `Required fields missing: ${missingFields.map(f => f.field_label).join(', ')}`
            });
        }

        const result = await QuotationField.addQuotation(req.body, req.user.id);

        res.json({
            status: true,
            message: 'Quotation creation success',
            response: {
                id: result.id,
                quotation_no: result.quotation_no
            }
        });

    } catch (error) {
        console.error('Error in addQuotation:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Quotation creation failed'
        });
    }
}

const order = async (req, res) => {
    try {
     const { fields } = req.body;
     // console.log(fields, "fields");
     if (!Array.isArray(fields) || fields.length === 0) {
         return res.status(400).json({
             status: 400,
             success: false,
             message: 'Fields array is required'
         });
     }

     // Validate each field object
     for (const field of fields) {
         if (!field.id || typeof field.order !== 'number') {
             return res.status(400).json({
                 status: 400,
                 success: false,
                 message: 'Each field must have an id and order number'
             });
         }
     }

     const result = await QuotationField.order(fields);
     console.log(result.message, "result");
     return res.status(200).json(

         result
     );

 } catch (error) {
     console.error('Error in updateFieldOrder:', error);
     return res.status(500).json({
         status: 500,
         success: false,
         message: error.message || 'Failed to update field order'
     });
 }
}


module.exports = {
    create,
    findAll,
    findById,
    update,
    deleteRecord,
    addQuotation,
    order
};