const reportsModel = require('../models/reportsModel');

// get owner list
async function getOwnerList(req, res) {
    try {   
        const owners = await reportsModel.getOwnerList();
        res.status(200).json({
            status: 200,
            success: true,
            message: 'Owner list fetched successfully....!',
            data: owners
        });
    } catch (error) {
        console.error('Error in getOwnerList:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching owner list',
            error: error.message
        });
    }
}

// get deals report
async function getDealsReport(req, res) {
    try {
        const { owner_id, start_date, end_date } = req.query;

        // Validate date format if provided
        if ((start_date || end_date) && !(start_date && end_date)) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: "Both start_date and end_date are required for date filtering"
            });
        }

        if (start_date && end_date) {
            // Validate date format (YYYY-MM-DD)
            const dateRegex = /^\d{4}-\d{2}-\d{2}$/;
            if (!dateRegex.test(start_date) || !dateRegex.test(end_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "Invalid date format. Use YYYY-MM-DD"
                });
            }

            // Validate that end_date is not before start_date
            if (new Date(end_date) < new Date(start_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "End date cannot be before start date"
                });
            }
        }

        const deals = await reportsModel.getDealsReport(owner_id, start_date, end_date);
        res.status(200).json({
            status: 200,
            success: true,
            message: 'Deals report fetched successfully....!',
            // total_count: deals.length,
            data: deals,
            filters: {
                owner_id: owner_id || null,
                start_date: start_date || null,
                end_date: end_date || null
            }
        }); 

    } catch (error) {
        console.error('Error in getDealsReport:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching deals report',
            error: error.message
        });
    }
}

// get conveyance report
async function getConveyanceReport(req, res) {
    try {
        const { owner_id, start_date, end_date } = req.query;

        // Validate date format if provided
        if ((start_date || end_date) && !(start_date && end_date)) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: "Both start_date and end_date are required for date filtering"
            });
        }

        if (start_date && end_date) {
            // Validate date format (YYYY-MM-DD)
            const dateRegex = /^\d{4}-\d{2}-\d{2}$/;
            if (!dateRegex.test(start_date) || !dateRegex.test(end_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "Invalid date format. Use YYYY-MM-DD"
                });
            }

            // Validate that end_date is not before start_date
            if (new Date(end_date) < new Date(start_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "End date cannot be before start date"
                });
            }
        }

        const report = await reportsModel.getConveyanceReport(owner_id, start_date, end_date);
        res.status(200).json({
            status: 200,
            success: true,
            message: 'Conveyance report fetched successfully....',
            total_count: report.length,
            data: report,
            filters: {
                owner_id: owner_id || null,
                start_date: start_date || null,
                end_date: end_date || null
            }
        });
    } catch (error) {
        console.error('Error in getConveyanceReport:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching conveyance report',
            error: error.message
        });
    }
}

// get claim report
async function getClaimReport(req, res) {
    try {
        const { owner_id, start_date, end_date } = req.query;

        // Validate date format if provided
        if ((start_date || end_date) && !(start_date && end_date)) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: "Both start_date and end_date are required for date filtering"
            });
        }

        if (start_date && end_date) {
            // Validate date format (YYYY-MM-DD)
            const dateRegex = /^\d{4}-\d{2}-\d{2}$/;
            if (!dateRegex.test(start_date) || !dateRegex.test(end_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "Invalid date format. Use YYYY-MM-DD"
                });
            }

            // Validate that end_date is not before start_date
            if (new Date(end_date) < new Date(start_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "End date cannot be before start date"
                });
            }
        }

        const report = await reportsModel.getClaimReport(owner_id, start_date, end_date);
        res.status(200).json({
            status: 200,
            success: true,
            message: 'Claim report fetched successfully....',
            total_count: report.claims.length,
            data: report,
            filters: {
                owner_id: owner_id || null,
                start_date: start_date || null,
                end_date: end_date || null
            }
        });
    } catch (error) {
        console.error('Error in getClaimReport:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching claim report',
            error: error.message
        });
    }
}

// get attendance report
async function getAttendanceReport(req, res) {
    try {
        const { owner_id, start_date, end_date } = req.query;

        // Validate date format if provided
        if ((start_date || end_date) && !(start_date && end_date)) {
            return res.status(400).json({
                status: 400,
                success: false,
                message: "Both start_date and end_date are required for date filtering"
            });
        }

        if (start_date && end_date) {
            // Validate date format (YYYY-MM-DD)
            const dateRegex = /^\d{4}-\d{2}-\d{2}$/;
            if (!dateRegex.test(start_date) || !dateRegex.test(end_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "Invalid date format. Use YYYY-MM-DD"
                });
            }

            // Validate that end_date is not before start_date
            if (new Date(end_date) < new Date(start_date)) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: "End date cannot be before start date"
                });
            }
        }

        const report = await reportsModel.getAttendanceReport(owner_id, start_date, end_date);
        res.status(200).json({
            status: 200,
            success: true,
            message: 'Attendance report fetched successfully....',
            total_count: report.attendance_data.length,
            data: report,
            filters: {
                owner_id: owner_id || null,
                start_date: start_date || null,
                end_date: end_date || null
            }
        });
    } catch (error) {
        console.error('Error in getAttendanceReport:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching attendance report',
            error: error.message
        });
    }
}

module.exports = {
    getDealsReport,
    getConveyanceReport,
    getClaimReport,
    getOwnerList,
    getAttendanceReport
};  