const SalesActivityCustomFieldModel = require('../models/salesActivityCustomField');

class SalesActivityCustomFieldController {
    static async createField(req, res) {
        try {
            const { field_data, choices } = req.body;
console.log(field_data);
            if (!field_data || !field_data.field_label || !field_data.field_type) {
                return res.status(400).json({
                    status: false,
                    message: 'Field label and type are required'
                });
            }

            const id = await SalesActivityCustomFieldModel.createField(field_data, choices);
            
            res.status(201).json({
                status: true,
                message: 'Custom field created successfully',
                data: { id }
            });

        } catch (error) {
            console.error('Error creating custom field:', error);
            res.status(500).json({
                status: false,
                message: error.message
            });
        }
    }

    static async updateField(req, res) {
        try {
            const { id } = req.params;
            const { field_data, choices } = req.body;

            if (!field_data) {
                return res.status(400).json({
                    status: false,
                    message: 'Field data is required'
                });
            }

            const success = await SalesActivityCustomFieldModel.updateField(id, field_data, choices);

            if (!success) {
                return res.status(404).json({
                    status: false,
                    message: 'Custom field not found'
                });
            }

            res.json({
                status: true,
                message: 'Custom field updated successfully'
            });

        } catch (error) {
            console.error('Error updating custom field:', error);
            res.status(500).json({
                status: false,
                message: error.message
            });
        }
    }

    static async listFields(req, res) {
        try {
            const fields = await SalesActivityCustomFieldModel.listFields();
            
            res.json({
                status: true,
                message: 'Custom fields fetched successfully',
                data: fields
            });

        } catch (error) {
            console.error('Error listing custom fields:', error);
            res.status(500).json({
                status: false,
                message: error.message
            });
        }
    }

    static async deleteField(req, res) {
        try {
            const { id } = req.params;
            const success = await SalesActivityCustomFieldModel.deleteField(id);

            if (!success) {
                return res.status(404).json({
                    status: false,
                    message: 'Custom field not found'
                });
            }

            res.json({
                status: true,
                message: 'Custom field deleted successfully'
            });

        } catch (error) {
            console.error('Error deleting custom field:', error);
            res.status(500).json({
                status: false,
                message: error.message
            });
        }
    }
}

module.exports = SalesActivityCustomFieldController;