const TerritoryModel = require('../models/territory');

class TerritoryController {
    static async createTerritory(req, res) {
        try {
            const territoryData = {
                ...req.body,
                create_by: req.user.id // Assuming you have user info in request
            };

            if (!territoryData.territory) {
                return res.status(400).json({
                    status: 400,
                    success: false,
                    message: 'Territory name is required'
                });
            }

            const id = await TerritoryModel.createTerritory(territoryData);
            
            res.status(201).json({
                status: 201,
                success: true,
                message: 'Territory created successfully',
                data: { id }
            });

        } catch (error) {
            console.error('Error creating territory:', error);
            res.status(500).json({
                status: 500,
                success: false,
                message: 'Error creating territory',
                error: error.message
            });
        }
    }

    static async updateTerritory(req, res) {
        try {
            const { id } = req.params;
            const success = await TerritoryModel.updateTerritory(id, req.body);

            if (!success) {
                return res.status(404).json({
                    status: 404,
                    success: false,
                    message: 'Territory not found'
                });
            }

            res.json({
                status: 200,
                success: true,
                message: 'Territory updated successfully'
            });

        } catch (error) {
            console.error('Error updating territory:', error);
            res.status(500).json({
                status: 500,
                success: false,
                message: 'Error updating territory',
                error: error.message
            });
        }
    }

    static async listTerritories(req, res) {
        try {
            const territories = await TerritoryModel.listTerritories();
            
            res.json({
                status: 200,
                success: true,
                message: 'Territories fetched successfully',
                data: territories
            });

        } catch (error) {
            console.error('Error listing territories:', error);
            res.status(500).json({
                status: 500,
                success: false,
                message: 'Error fetching territories',
                error: error.message
            });
        }
    }

    static async deleteTerritory(req, res) {
        try {
            const { id } = req.params;
            const success = await TerritoryModel.softDeleteTerritory(id);

            if (!success) {
                return res.status(404).json({
                    status: 404,
                    success: false,
                    message: 'Territory not found'
                });
            }

            res.json({
                status: 200,
                success: true,
                message: 'Territory deleted successfully'
            });

        } catch (error) {
            console.error('Error deleting territory:', error);
            res.status(500).json({
                status: 500,
                success: false,
                message: 'Error deleting territory',
                error: error.message
            });
        }
    }
}

module.exports = TerritoryController;