const salesActivityModel = require('../models/salesActivity');
const salesActivityDataModel = require('../models/appointments');
const userModel = require('../models/user');
const SalesActivityData = require('../models/appointments');

async function addSalesActivity(req, res) {
    try {
        const id = await salesActivityModel.createSalesActivity(req.body);
        res.status(201).json({ id });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}

async function listSalesActivities(req, res) {
    try {
        const salesActivities = await salesActivityModel.getSalesActivities();
        res.status(200).json({
            status: 200,
            message: 'Sales activities fetched successfully',
            count: salesActivities.length,
            data: salesActivities
        });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}

async function editSalesActivity(req, res) {
    try {
        await salesActivityModel.updateSalesActivity(req.params.id, req.body);
        res.status(200).json({ message: 'Sales activity updated successfully' });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}

async function deleteSalesActivity(req, res) {
    try {
        await salesActivityModel.softDeleteSalesActivity(req.params.id);
        res.status(200).json({ message: 'Sales activity deleted successfully' });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}

async function createAttendanceForAllUsers(req, res) {
    try {
        const users = await userModel.getActiveUsers();

        const start_date = new Date().toISOString().split('T')[0];
        const end_date = start_date;
        const start_time = "09:00";
        const end_time = "18:00";

        for (const user of users) {
            await salesActivityDataModel.createSalesActivityData({
                salesactivities_id:10,
                activity_type: 'Attendance',
                activity_date: start_date,
                activity_title: `Attendance for ${start_date} for ${user.name}`,
                start_date: start_date,
                end_date: end_date,
                start_time: start_time,
                end_time: end_time,
                owner_id: user.id,
                creater_id: 141,
                status: 'Pending'
            });
        }

        res.status(201).json({ message: 'Attendance sales activities created for all active users' });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}
async function getSalesActivities(req, res) 
 {
    try {
        const { date } = req.body;
        const userId = req.user.id; // Assuming you have authentication middleware

        // Validate date
        if (!date) {
            return res.status(400).json({
                status: false,
                message: 'Date field is required'
            });
        }

        // Validate date format
        if (!/^\d{4}-\d{2}-\d{2}$/.test(date)) {
            return res.status(400).json({
                status: false,
                message: 'Invalid date format. Please use YYYY-MM-DD'
            });
        }

        const data = await SalesActivityData.getSalesActivitiesByDate(date, userId);

        if (!data.records.length && !data.salesactivities.length && !data.customactivities.length) {
            return res.status(200).json({
                status: false,
                message: 'Activities info not exists',
                response: null
            });
        }

        return res.status(200).json({
            status: true,
            message: 'Activities info',
            response: data
        });

    } catch (error) {
        console.error('Error in getSalesActivities:', error);
        return res.status(500).json({
            status: false,
            message: 'Internal server error',
            error: error.message
        });
    }
};

async function createSalesActivityData(req, res) {
    try {
        const data = req.body;
        const id = await salesActivityModel.createSalesActivityData(data);
        res.status(201).json({ status: 201, message: 'Sales activity data Created successfully' , data : {id} });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}
async function getAllSalesActivityData(req, res) {
    try {
        const { id } = req.user;
        const response = await salesActivityModel.getAllSalesActivityData(id);
        res.json({ status: 200, message: 'Sales activities fetched successfully', response});
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}
async function getSalesActivityData(req, res) {
    try {
        const { id } = req.params;
        const response = await salesActivityModel.getSalesActivityData(id);
        if (!response) {
            return res.status(404).json({ status: 404, message: 'Sales activity data not found' });
        }
        res.json({ status: 200, message: 'Sales activity fetched successfully', response});
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}


async function updateSalesActivityData(req, res) {
    try {
        const { id } = req.params;
        const data = req.body;
        const result = await salesActivityModel.updateSalesActivityData(data, id);
        if (!result) {
            return res.status(404).json({ status: 404, message: 'Sales activity not found' });
        }
	res.status(200).json({
            status: 200,
	    message: 'Sales activity updated successfully',
            data: { id: id }
        });
	
        
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}
async function updateActivityStatus(req, res) {
    try {
        const { id } = req.params;
        const { latitude, longitude, location } = req.body;
        const userId = req.user.id; // Get logged in user's ID from auth middleware

        // Validate required fields
        if (!latitude || !longitude || !location) {
            return res.status(400).json({
                status: false,
                message: 'Latitude, longitude and location are required'
            });
        }

        const result = await salesActivityModel.updateActivityStatus(id, {
            latitude,
            longitude,
            location
        }, userId);
	 return res.status(200).json({
                status: 200,
                message: `Activity ${result.newStatus === 'Inprogress' ? 'checked-in' : 'checked-out'} successfully`,
            });
        

    } catch (error) {
        console.error('Error updating activity status:', error);
        res.status(error.message === 'Activity not found' ? 404 : 500).json({
            success: false,
            message: error.message
        });
    }
}
async function getAttendanceHistory(req, res) {
    try {
        const userId = req.user.id;
        const { filter = 'today', month, year } = req.query;

        // Validate monthly filter parameters
        if (filter === 'monthly' && (!month || !year)) {
            return res.status(400).json({
                status: false,
                message: 'Month and year are required for monthly filter'
            });
        }

        const attendanceHistory = await salesActivityModel.getAttendanceHistory(
            userId,
            filter,
            month,
            year
        );

        res.status(200).json({
            status: true,
            message: 'Attendance history retrieved successfully',
            data: attendanceHistory
        });

    } catch (error) {
        console.error('Error fetching attendance history:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Error retrieving attendance history'
        });
    }
}
async function getConveyanceList(req, res) {
    try {
        const userId = req.user.id;
        const { filter = 'today', month, year } = req.body;

        // Validate monthly filter parameters
        if (filter === 'monthly' && (!month || !year)) {
            return res.status(400).json({
                status: false,
                message: 'Month and year are required for monthly filter'
            });
        }

        const conveyanceList = await salesActivityModel.getConveyanceList(
            userId,
            filter,
            month,
            year
        );

        res.json({
            status: true,
            message: 'Conveyance list retrieved successfully',
            data: conveyanceList
        });

    } catch (error) {
        console.error('Error fetching conveyance list:', error);
        res.status(500).json({
            status: false,
            message: error.message || 'Error retrieving conveyance list'
        });
    }
}
async function deleteSalesActivityData(req, res) {
    try {
        const success=await salesActivityModel.softDeleteSalesActivityData(req.params.id);
         if (!success) {
            return res.status(404).json({ status: 404, message: 'Meeting not found' });
        }
        res.json({ status: 200, message: 'Meeting deleted successfully' });
    
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
}
module.exports = {
    addSalesActivity,
    listSalesActivities,
    editSalesActivity,
    deleteSalesActivity,
    createAttendanceForAllUsers,
    getSalesActivities,
    createSalesActivityData,
    getAllSalesActivityData,
    getSalesActivityData,
    updateSalesActivityData,
    updateActivityStatus,
    getAttendanceHistory,
    getConveyanceList,
    deleteSalesActivityData
};