const db = require('../config/db');

async function getUserList() {
    const [rows] = await db.execute(
        `SELECT u.id, u.emp_id, u.name AS username, r.name AS role_name, u.email, u.mobile, u.active, m.name AS reporting_to
            FROM users u
            JOIN roles r ON u.roles_id = r.id
            LEFT JOIN users m ON u.reporting_to = m.id
            ORDER BY u.id ASC;`
    );
    // console.log(rows);
    return rows;
}

// Get user by ID
async function userbyid(id) {
    const [rows] = await db.execute(
        `SELECT u.id, u.emp_id, u.name AS username, r.name AS role_name, u.reporting_to as reportingto_id, u.email, u.mobile, u.active, m.name AS reporting_to,u.territory_id
            FROM users u
            LEFT JOIN roles r ON u.roles_id = r.id
            LEFT JOIN users m ON u.reporting_to = m.id
            WHERE u.id = ?`,
        [id]
    );
    return rows;
}


// Create user
async function createUser(userData) {
    // Validate required fields
    if (!userData.emp_id || !userData.name || !userData.email || !userData.password || !userData.roles_id) {
        throw new Error('Missing required fields');
    }

    // Convert territories array to comma-separated string if provided
    const territoryIds = userData.territories ? userData.territories.join(',') : null;

    const [result] = await db.execute(
        `INSERT INTO users (
            emp_id, 
            name, 
            password, 
            email, 
            mobile, 
            roles_id, 
            reporting_to, 
            active, 
            create_date, 
            create_by,
            territory_id
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?)`,

        [
            userData.emp_id,
            userData.name, 
            userData.password,
            userData.email, 
            userData.mobile || null, 
            userData.roles_id, 
            userData.reporting_to || null, 
            userData.active || 1,
            userData.create_by || 1,
            territoryIds
        ]
    );

    // for attendance
    const start_date = new Date().toISOString().split('T')[0];
    const end_date = start_date;
    const start_time = "09:00";
    const end_time = "18:00";

    const Data = {
        salesactivities_id:10,
        activity_type: 'Attendance',
        activity_date: start_date,
        activity_title: `Attendance for ${start_date} for ${userData.name}`,
        start_date: start_date,
        end_date: end_date,
        start_time: start_time,
        end_time: end_time,
        owner_id: result.insertId,
        creater_id: result.insertId,
        status: 'Pending'
    }
    Object.keys(Data).forEach(key => {
        if (Data[key] === undefined || Data[key] === '' || Data[key] === null) {
            delete Data[key];
        }
    });
    // console.log(Data);
    const keys =  Object.keys(Data);
    const values = Object.values(Data);
    const placeholders = '?' + ', ?'.repeat(values.length - 1);
    const [result1] = await db.execute(
        `INSERT INTO salesactivitydatas (${keys}) VALUES (${placeholders})`,
        values
    );
    return {id: result.insertId, salesactivity_id: result1.insertId};
}


// Update user
async function updateUser(userData, id) {
    try {

        if (!id) {
            throw new Error('User ID is required for update');
        }

        console.log(userData);

        if(userData.territories && typeof userData.territories === 'string'){
            userData.territories = userData.territories.split(',');
        }
        // Convert territories array to comma-separated string if provided
        const territoryIds = userData.territories ? userData.territories.join(',') : null;
        const [result] = await db.execute(
            `UPDATE users 
            SET emp_id = ?, 
            name = ?, 
            email = ?, 
            mobile = ?, 
            roles_id = ?, 
            reporting_to = ?, 
            active = ?,
            territory_id = ?
            WHERE id = ?`,
            [
                userData.emp_id,
                userData.name,
                userData.email,
                userData.mobile, 
                userData.roles_id,
                userData.reporting_to,
                userData.active,
                territoryIds,
                id
            ]
        );
        return result;
    } catch (error) {
        console.error('Error updating user:', error);
        return {
            success: false,
            status: 500,
            message: 'Error updating user',
            error: error.message
        };
    }
    }
    
    module.exports = {
    getUserList,
    userbyid,
    createUser,
    updateUser
};