const db = require('../config/db');
const NotificationModel = require('../models/NotificationModel');

async function createSalesActivityData(Data) {
    Object.keys(Data).forEach(key => {
        if (Data[key] === undefined || Data[key] === '' || Data[key] === null) {
            delete Data[key];
        }
    });
    console.log(Data);
    const keys =  Object.keys(Data);
    const values = Object.values(Data);
    const placeholders = '?' + ', ?'.repeat(values.length - 1);
   const [result] = await db.execute(
       `INSERT INTO salesactivitydatas (${keys}) VALUES (${placeholders})`,
       values
   );
   return result.insertId;
}

async function getSalesActivitiesByDate(date, userId) {
    try {
        console.log("date123456",date)
        // Get user's role and access scope
        const [userRole] = await db.execute(
            `SELECT r.access_scope, r.id as role_id, r.location 
             FROM users u 
             JOIN roles r ON u.roles_id = r.id 
             WHERE u.id = ? `,
            [userId]
        );

        if (!userRole || !userRole.length) {
            throw new Error('User role not found');
        }

        const accessScope = JSON.parse(userRole[0].access_scope);

        // Date calculations
        const currentDate = new Date(date);
        const lastDate = new Date(currentDate);
        lastDate.setDate(lastDate.getDate() - 1);
        const last7Date = new Date(currentDate);
        last7Date.setDate(last7Date.getDate() - 7);

        const formatDate = (date) => date.toISOString().split('T')[0];

        // Get all required data
        const [records] = await db.execute('SELECT * FROM salesrecords WHERE menu_title = "Records" AND active = 1');
        const [salesactivities] = await db.execute('SELECT * FROM salesrecords WHERE menu_title = "Sales Activities" AND active = 1');
        const [customactivities] = await db.execute('SELECT * FROM salesactivities WHERE custom_activity = 1 AND active = 1');
        
        // Get overdue tasks with related names
        const [overduetasks] = await db.execute(
            'SELECT t.*, COALESCE(a.name, c.first_name) as related_name FROM tasks t ' +
            'LEFT JOIN accounts a ON t.related_type = "accounts" AND t.related_to = a.id ' +
            'LEFT JOIN contacts c ON t.related_type = "contacts" AND t.related_to = c.id ' +
            'WHERE t.user_id = ? AND t.mark_as_complete = "false" AND t.due_date < ?',
            [userId, formatDate(currentDate)]
        );

        // Format overdue tasks
        const overdue = overduetasks.map(task => ({
            id: task.id,
            collaboratoes: task.collaboratoes,
            completed_date: task.completed_date,
            completed_time: task.completed_time,
            description: task.description,
            due_date: task.due_date,
            due_time: task.due_time,
            mark_as_complete: task.mark_as_complete,
            owner: task.owner,
            related_to: task.related_name,
            related_type: task.related_type,
            task_type: task.task_type,
            title: task.title,
            mobile_number: task.mobile_number
        }));

        // Get contacts and recent contacts
        const [contacts] = await db.execute(
            'SELECT * FROM contacts WHERE (owner_id = ? OR creater_id = ?) AND create_at BETWEEN ? AND ?',
            [userId, userId, formatDate(lastDate), formatDate(currentDate)]
        );

        const [recentcontacts] = await db.execute(
            'SELECT * FROM contacts WHERE (owner_id = ? OR creater_id = ?) AND create_at BETWEEN ? AND ?',
            [userId, userId, formatDate(last7Date), formatDate(currentDate)]
        );

        // Get links and activities
        const [links] = await db.execute('SELECT * FROM links WHERE active = 1 AND user_id = ?', [userId]);
        
        const [activities] = await db.execute(
            'SELECT * FROM salesactivitydatas WHERE start_date = ? AND owner_id = ? AND targetable_type != "users" AND activity_title != "attendance punch" AND active = 1',
            [formatDate(currentDate), userId]
        );

        // Get tasks with related names
        const [tasks] = await db.execute(
            `SELECT t.*,
                CASE 
                    WHEN t.related_type = 'contacts' THEN CONCAT(c.first_name, ' ', c.last_name)
                    WHEN t.related_type = 'accounts' THEN a.name
                    WHEN t.related_type = 'deals' THEN d.name
                    ELSE NULL 
                END as relatedto_name
            FROM tasks t
            LEFT JOIN contacts c ON t.related_type = 'contacts' AND t.related_to = c.id
            LEFT JOIN accounts a ON t.related_type = 'accounts' AND t.related_to = a.id
            LEFT JOIN deals d ON t.related_type = 'deals' AND t.related_to = d.id
            WHERE t.due_date = ? AND t.user_id = ?`,
            [formatDate(currentDate), userId]
        );

        // Get attendance and currency
        const [attendance] = await db.execute(
            'SELECT * FROM salesactivitydatas WHERE start_date = ? AND owner_id = ? AND salesactivities_id = 10 LIMIT 1',
            [formatDate(currentDate), userId]
        );

        const [currency] = await db.execute('SELECT * FROM currencies WHERE is_default = 1 LIMIT 1');

        // Get location tracking status
        const locationTrackingStatus = userRole[0]?.location === 'Yes' ? 1 : 0;

        return {
            records,
            salesactivities,
            customactivities,
            overduetasks: overdue,
            contacts,
            recentcontacts,
            links,
            tasks: tasks.map(task => ({
                ...task,
                relatedto_name: task.relatedto_name || 'N/A'
            })),
            activities,
            currency: currency[0],
            attendance: attendance[0] || null,
            locationtracking: [],
            Locationtrackingstatus: locationTrackingStatus,
            access_scope: accessScope // Added access_scope to response
        };

    } catch (error) {
        console.error('Error in getSalesActivitiesByDate:', error);
        throw error;
    }
}


module.exports = {
    createSalesActivityData,
    getSalesActivitiesByDate
};