const db = require('../config/db');

async function findOne(criteria) {
    const { subdomain, domain, active } = criteria;
    const [rows] = await db.execute(
        'SELECT * FROM domains WHERE subdomain = ? AND domain = ? AND active = ? LIMIT 1',
        [subdomain, domain, active ? 1 : 0]
    );
    return rows[0];
}

module.exports = {
    findOne
};