const db = require('../config/db');
const path = require('path');
const fs = require('fs');

// Ensure public/uploads directory exists
const uploadDir = path.join(__dirname, '../public/uploads');
if (!fs.existsSync(path.join(__dirname, '../public'))) {
    fs.mkdirSync(path.join(__dirname, '../public'));
}
if (!fs.existsSync(uploadDir)) {
    fs.mkdirSync(uploadDir);
}

async function saveFileInfo(fileData) {
    const {
        originalname,
        filename,
        size,
        share_with_team,
        owner_id,
        related_id,    // Fixed typo
        related_to     // Fixed typo
    } = fileData;
    
    const [result] = await db.execute(
        `INSERT INTO fileuploads (
            display_name,
            file_name,
            file_size,
            owner,
            share_with_team,    /* Added missing comma */
            type,
            type_id,
            upload_at,          /* Added missing comma */
            created_at,
            updated_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), NOW())`, /* Added one more ? for type_id */
        [
            originalname,
            filename,
            size,
            owner_id,
            share_with_team,
            related_to,
            related_id
        ]
    );
    console.log({result});
    return result.insertId;
}

async function getFileById(id) {
    const [rows] = await db.execute('SELECT * FROM fileuploads WHERE id = ?', [id]);
    return rows[0];
}

async function getFilesByUser(userId) {
    const [rows] = await db.execute('SELECT * FROM fileuploads WHERE owner = ? ORDER BY created_at DESC', [userId]);
    return rows;
}

async function deleteFile(id) {
    // Get file info first
    const file = await getFileById(id);
    if (!file) return false;

    // Delete physical file
    try {
        fs.unlinkSync(file.file_path);
    } catch (error) {
        console.error('Error deleting physical file:', error);
    }

    // Delete database record
    const [result] = await db.execute('DELETE FROM fileuploads WHERE id = ?', [id]);
    return result.affectedRows > 0;
}

module.exports = {
    saveFileInfo,
    getFileById,
    getFilesByUser,
    deleteFile,
    uploadDir
};