// const { bn } = require('date-fns/locale');
const db = require('../config/db');
// const { DATE_FORMAT, convertDate } = require('../config/utils');


async function saveNoteWithFile(fileData) {
    const {
        originalname,
        filename,
        owner_id,
        releted_to,
        releted_id,
        note,
    } = fileData;
    var currentDate = new Date();
    console.log("saveNoteWithFile "+filename+" \n "+originalname);
    const [result] = await db.execute(
       'INSERT INTO notes (voicenote ,belongsto_id, belongsto, notes,users_id,active,created_at,updated_at,note_time) VALUES (?,?, ?, ?,?,?,?,?,?)',
        [filename,releted_id, releted_to, note,owner_id,"1",currentDate,currentDate,currentDate]
    );

    return result.insertId;
}

async function getNoteById(id) {
    const [result] = await db.execute('SELECT * FROM notes WHERE id = ?', [id]);
    return result;
}


async function createNote(related_id, related_to, note, userId) {
    try {
        // console.log("NoteCreateUser "+userId);
        console.log("createNote "+related_id+" "+related_to+" "+note);
        // const { related_id, related_to, note } = noteData;
        const currentDate = new Date().toISOString().slice(0, 19).replace('T', ' ');

        const [result] = await db.execute(
        `INSERT INTO notes 
        (belongsto_id, belongsto, notes, users_id, active, created_at, updated_at, note_time) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)`,
        [related_id, related_to, note, userId, 1, currentDate, currentDate, currentDate]
        );

    //console.log(result);
    return result.insertId;
    } catch (error) {
        console.error("Error creating note: ", error);
        throw error;
    }
}

async function getNotes() {
    try {
        const [result] = await db.execute('SELECT * FROM notes');
        return result;
    } catch (error) {
        console.error("Error fetching notes: ", error);
        throw error;
    }   
}

async function getNotesByUserId(belongsto_id,belongsto) {
    try {
        console.log("getNotesByUserId "+belongsto_id+" "+belongsto);
        const [result] = await db.execute('SELECT * FROM notes WHERE belongsto_id = ? AND belongsto = ?', [belongsto_id,belongsto,]);
        return result;
    } catch (error) {
        console.error("Error fetching notes: ", error);
        throw error;
    }
}  

async function updateNote(id,noteData) {
    try {
        // console.log("updateNote "+id+" "+noteData.note+" "+noteData.releted_id+" "+noteData.releted_to);
    var currentDate = new Date();
    const {note, releted_id, releted_to } = noteData;
    const [result] = await db.execute(
        'UPDATE notes SET notes = ?,belongsto_id=?,belongsto=?, updated_at = ? WHERE id = ?',
        [note, releted_id, releted_to, currentDate, id]
    );
    return result.affectedRows;
    } catch (error) {
        console.error("Error updating note: ", error);
        throw error;
    }
}

async function deleteNote(id) {
    try {
    // const { id } = noteData;
    console.log("deleteNote "+id);
    const [result] = await db.execute('DELETE FROM notes WHERE id = ?', [id]);
    return result;
    } catch (error) {
        console.error("Error deleting note: ", error);
        throw error;
    }
}

        

module.exports = {
    createNote,
    getNotes,
    getNotesByUserId,
    updateNote,
    deleteNote,
    saveNoteWithFile,
    getNoteById
}



