const db = require('../config/db');

async function create(roleData) {
    const { 
        name, 
        scope, 
        reporting_to, 
        location, 
        eligible_transport, 
        default_transport,
        active 
    } = roleData;

    const [result] = await db.execute(
        'INSERT INTO roles (name, scope, reporting_to, location, eligible_transport, default_transport, active, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())',
        [
        name, 
        scope,
        reporting_to, 
        location, 
        eligible_transport, 
        default_transport, 
        active || 1
        ]
    );
    console.log(result);
    return result.insertId;
}

async function findAll() {
    const [rows] = await db.execute('SELECT * FROM roles ORDER BY created_at ASC');
    const [rows1] = await db.execute("SELECT id, name from roles where active =1 ORDER BY created_at ASC");
    console.log(rows, rows1);
    return { rows, rows1 };
}

async function findById(id) {
    const [rows] = await db.execute('SELECT * FROM roles WHERE id = ?', [id]);
    return rows[0];
}

async function update(id, roleData) {
    const { 
        name, 
        scope, 
        reporting_to, 
        location, 
        eligible_transport, 
        default_transport,
        active 
    } = roleData;

    const [result] = await db.execute(
        'UPDATE roles SET name = ?, scope = ?, reporting_to = ?, location = ?, eligible_transport = ?, default_transport = ?, active = ?, updated_at = NOW() WHERE id = ?',
        [name, scope, reporting_to, location, eligible_transport, default_transport, active, id]
    );
    return result.affectedRows > 0;
}

async function deleteRole(id) {
    const [result] = await db.execute('UPDATE roles SET active = 0, updated_at = NOW() WHERE id = ?', [id]);
    return result.affectedRows > 0;
}

async function roleactivate(id, active) {
    const [result] = await db.execute('UPDATE roles SET active = 0, updated_at = NOW() WHERE id = ?', [active, id]);
    return result.affectedRows > 0;
}

module.exports = {
    create,
    findAll,
    findById,
    update,
    deleteRole,
    roleactivate
};