/// <reference types="node" />
import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosPromise, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace aiplatform_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Vertex AI API
     *
     * Train high-quality custom machine learning models with minimal machine learning expertise and effort.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const aiplatform = google.aiplatform('v1');
     * ```
     */
    export class Aiplatform {
        context: APIRequestContext;
        batchPredictionJobs: Resource$Batchpredictionjobs;
        datasets: Resource$Datasets;
        endpoints: Resource$Endpoints;
        media: Resource$Media;
        projects: Resource$Projects;
        publishers: Resource$Publishers;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * Generate video response.
     */
    export interface Schema$CloudAiLargeModelsVisionGenerateVideoResponse {
        /**
         * The generates samples.
         */
        generatedSamples?: Schema$CloudAiLargeModelsVisionMedia[];
        /**
         * Returns if any videos were filtered due to RAI policies.
         */
        raiMediaFilteredCount?: number | null;
        /**
         * Returns rai failure reasons if any.
         */
        raiMediaFilteredReasons?: string[] | null;
        /**
         * List of videos, used to align naming with the external response.
         */
        videos?: Schema$CloudAiLargeModelsVisionGenerateVideoResponseVideo[];
    }
    export interface Schema$CloudAiLargeModelsVisionGenerateVideoResponseVideo {
        /**
         * Base64 encoded bytes string representing the video.
         */
        bytesBase64Encoded?: string | null;
        /**
         * Cloud Storage URI where the generated video is written.
         */
        gcsUri?: string | null;
        /**
         * The MIME type of the content of the video. - video/mp4
         */
        mimeType?: string | null;
    }
    /**
     * Image.
     */
    export interface Schema$CloudAiLargeModelsVisionImage {
        /**
         * Image encoding, encoded as "image/png" or "image/jpg".
         */
        encoding?: string | null;
        /**
         * Generation seed for the sampled image. This parameter is exposed to the user only if one of the following is true: 1. The user specified per-example seeds in the request. 2. The user doesn't specify the generation seed in the request.
         */
        generationSeed?: number | null;
        /**
         * Raw bytes.
         */
        image?: string | null;
        /**
         * RAI scores for generated image.
         */
        imageRaiScores?: Schema$CloudAiLargeModelsVisionImageRAIScores;
        /**
         * Image size. The size of the image. Can be self reported, or computed from the image bytes.
         */
        imageSize?: Schema$CloudAiLargeModelsVisionImageImageSize;
        /**
         * RAI info for image.
         */
        raiInfo?: Schema$CloudAiLargeModelsVisionRaiInfo;
        /**
         * Semantic filter info for image.
         */
        semanticFilterResponse?: Schema$CloudAiLargeModelsVisionSemanticFilterResponse;
        /**
         * Text/Expanded text input for imagen.
         */
        text?: string | null;
        /**
         * Path to another storage (typically Google Cloud Storage).
         */
        uri?: string | null;
    }
    /**
     * Image size.
     */
    export interface Schema$CloudAiLargeModelsVisionImageImageSize {
        channels?: number | null;
        height?: number | null;
        width?: number | null;
    }
    /**
     * RAI scores for generated image returned.
     */
    export interface Schema$CloudAiLargeModelsVisionImageRAIScores {
        /**
         * Agile watermark score for image.
         */
        agileWatermarkDetectionScore?: number | null;
    }
    /**
     * Media.
     */
    export interface Schema$CloudAiLargeModelsVisionMedia {
        /**
         * Image.
         */
        image?: Schema$CloudAiLargeModelsVisionImage;
        /**
         * Video
         */
        video?: Schema$CloudAiLargeModelsVisionVideo;
    }
    export interface Schema$CloudAiLargeModelsVisionNamedBoundingBox {
        classes?: string[] | null;
        entities?: string[] | null;
        scores?: number[] | null;
        x1?: number | null;
        x2?: number | null;
        y1?: number | null;
        y2?: number | null;
    }
    /**
     * Next ID: 6
     */
    export interface Schema$CloudAiLargeModelsVisionRaiInfo {
        /**
         * List of blocked entities from the blocklist if it is detected.
         */
        blockedEntities?: string[] | null;
        /**
         * The list of detected labels for different rai categories.
         */
        detectedLabels?: Schema$CloudAiLargeModelsVisionRaiInfoDetectedLabels[];
        /**
         * The model name used to indexing into the RaiFilterConfig map. Would either be one of imagegeneration@002-006, imagen-3.0-... api endpoint names, or internal names used for mapping to different filter configs (genselfie, ai_watermark) than its api endpoint.
         */
        modelName?: string | null;
        /**
         * List of rai categories' information to return
         */
        raiCategories?: string[] | null;
        /**
         * List of rai scores mapping to the rai categories. Rounded to 1 decimal place.
         */
        scores?: number[] | null;
    }
    /**
     * Filters returning list of deteceted labels, scores, and bounding boxes.
     */
    export interface Schema$CloudAiLargeModelsVisionRaiInfoDetectedLabels {
        /**
         * The list of detected entities for the rai signal.
         */
        entities?: Schema$CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity[];
        /**
         * The RAI category for the deteceted labels.
         */
        raiCategory?: string | null;
    }
    /**
     * An integer bounding box of original pixels of the image for the detected labels.
     */
    export interface Schema$CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox {
        /**
         * The X coordinate of the top-left corner, in pixels.
         */
        x1?: number | null;
        /**
         * The X coordinate of the bottom-right corner, in pixels.
         */
        x2?: number | null;
        /**
         * The Y coordinate of the top-left corner, in pixels.
         */
        y1?: number | null;
        /**
         * The Y coordinate of the bottom-right corner, in pixels.
         */
        y2?: number | null;
    }
    /**
     * The properties for a detected entity from the rai signal.
     */
    export interface Schema$CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity {
        /**
         * Bounding box of the label
         */
        boundingBox?: Schema$CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox;
        /**
         * Description of the label
         */
        description?: string | null;
        /**
         * The intersection ratio between the detection bounding box and the mask.
         */
        iouScore?: number | null;
        /**
         * MID of the label
         */
        mid?: string | null;
        /**
         * Confidence score of the label
         */
        score?: number | null;
    }
    export interface Schema$CloudAiLargeModelsVisionSemanticFilterResponse {
        /**
         * Class labels of the bounding boxes that failed the semantic filtering. Bounding box coordinates.
         */
        namedBoundingBoxes?: Schema$CloudAiLargeModelsVisionNamedBoundingBox[];
        /**
         * This response is added when semantic filter config is turned on in EditConfig. It reports if this image is passed semantic filter response. If passed_semantic_filter is false, the bounding box information will be populated for user to check what caused the semantic filter to fail.
         */
        passedSemanticFilter?: boolean | null;
    }
    /**
     * Video
     */
    export interface Schema$CloudAiLargeModelsVisionVideo {
        /**
         * Base 64 encoded video bytes.
         */
        encodedVideo?: string | null;
        /**
         * Video encoding, for example "video/mp4".
         */
        encoding?: string | null;
        /**
         * Text/Expanded text input for Help Me Write.
         */
        text?: string | null;
        /**
         * Path to another storage (typically Google Cloud Storage).
         */
        uri?: string | null;
        /**
         * Raw bytes.
         */
        video?: string | null;
    }
    /**
     * Create API error message for Vertex Pipeline.
     */
    export interface Schema$CloudAiPlatformCommonCreatePipelineJobApiErrorDetail {
        /**
         * The error root cause returned by CreatePipelineJob API.
         */
        errorCause?: string | null;
        /**
         * Public messages contains actionable items for the error cause.
         */
        publicMessage?: string | null;
    }
    /**
     * Message that represents an arbitrary HTTP body. It should only be used for payload formats that can't be represented as JSON, such as raw binary or an HTML page. This message can be used both in streaming and non-streaming API methods in the request as well as the response. It can be used as a top-level request field, which is convenient if one wants to extract parameters from either the URL or HTTP template into the request fields and also want access to the raw HTTP body. Example: message GetResourceRequest { // A unique request id. string request_id = 1; // The raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; \} service ResourceService { rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); \} Example with streaming methods: service CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns (stream google.api.HttpBody); \} Use of this type only changes how the request and response bodies are handled, all other features will continue to work unchanged.
     */
    export interface Schema$GoogleApiHttpBody {
        /**
         * The HTTP Content-Type header value specifying the content type of the body.
         */
        contentType?: string | null;
        /**
         * The HTTP request/response body as raw binary.
         */
        data?: string | null;
        /**
         * Application specific response metadata. Must be set in the first response for streaming APIs.
         */
        extensions?: Array<{
            [key: string]: any;
        }> | null;
    }
    /**
     * Parameters that configure the active learning pipeline. Active learning will label the data incrementally by several iterations. For every iteration, it will select a batch of data based on the sampling strategy.
     */
    export interface Schema$GoogleCloudAiplatformV1ActiveLearningConfig {
        /**
         * Max number of human labeled DataItems.
         */
        maxDataItemCount?: string | null;
        /**
         * Max percent of total DataItems for human labeling.
         */
        maxDataItemPercentage?: number | null;
        /**
         * Active learning data sampling config. For every active learning labeling iteration, it will select a batch of data based on the sampling strategy.
         */
        sampleConfig?: Schema$GoogleCloudAiplatformV1SampleConfig;
        /**
         * CMLE training config. For every active learning labeling iteration, system will train a machine learning model on CMLE. The trained model will be used by data sampling algorithm to select DataItems.
         */
        trainingConfig?: Schema$GoogleCloudAiplatformV1TrainingConfig;
    }
    /**
     * Request message for MetadataService.AddContextArtifactsAndExecutions.
     */
    export interface Schema$GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest {
        /**
         * The resource names of the Artifacts to attribute to the Context. Format: `projects/{project\}/locations/{location\}/metadataStores/{metadatastore\}/artifacts/{artifact\}`
         */
        artifacts?: string[] | null;
        /**
         * The resource names of the Executions to associate with the Context. Format: `projects/{project\}/locations/{location\}/metadataStores/{metadatastore\}/executions/{execution\}`
         */
        executions?: string[] | null;
    }
    /**
     * Response message for MetadataService.AddContextArtifactsAndExecutions.
     */
    export interface Schema$GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse {
    }
    /**
     * Request message for MetadataService.AddContextChildren.
     */
    export interface Schema$GoogleCloudAiplatformV1AddContextChildrenRequest {
        /**
         * The resource names of the child Contexts.
         */
        childContexts?: string[] | null;
    }
    /**
     * Response message for MetadataService.AddContextChildren.
     */
    export interface Schema$GoogleCloudAiplatformV1AddContextChildrenResponse {
    }
    /**
     * Request message for MetadataService.AddExecutionEvents.
     */
    export interface Schema$GoogleCloudAiplatformV1AddExecutionEventsRequest {
        /**
         * The Events to create and add.
         */
        events?: Schema$GoogleCloudAiplatformV1Event[];
    }
    /**
     * Response message for MetadataService.AddExecutionEvents.
     */
    export interface Schema$GoogleCloudAiplatformV1AddExecutionEventsResponse {
    }
    /**
     * Request message for VizierService.AddTrialMeasurement.
     */
    export interface Schema$GoogleCloudAiplatformV1AddTrialMeasurementRequest {
        /**
         * Required. The measurement to be added to a Trial.
         */
        measurement?: Schema$GoogleCloudAiplatformV1Measurement;
    }
    /**
     * Used to assign specific AnnotationSpec to a particular area of a DataItem or the whole part of the DataItem.
     */
    export interface Schema$GoogleCloudAiplatformV1Annotation {
        /**
         * Output only. The source of the Annotation.
         */
        annotationSource?: Schema$GoogleCloudAiplatformV1UserActionReference;
        /**
         * Output only. Timestamp when this Annotation was created.
         */
        createTime?: string | null;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize your Annotations. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Annotation(System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable. Following system labels exist for each Annotation: * "aiplatform.googleapis.com/annotation_set_name": optional, name of the UI's annotation set this Annotation belongs to. If not set, the Annotation is not visible in the UI. * "aiplatform.googleapis.com/payload_schema": output only, its value is the payload_schema's title.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Resource name of the Annotation.
         */
        name?: string | null;
        /**
         * Required. The schema of the payload can be found in payload_schema.
         */
        payload?: any | null;
        /**
         * Required. Google Cloud Storage URI points to a YAML file describing payload. The schema is defined as an [OpenAPI 3.0.2 Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). The schema files that can be used here are found in gs://google-cloud-aiplatform/schema/dataset/annotation/, note that the chosen schema must be consistent with the parent Dataset's metadata.
         */
        payloadSchemaUri?: string | null;
        /**
         * Output only. Timestamp when this Annotation was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Identifies a concept with which DataItems may be annotated with.
     */
    export interface Schema$GoogleCloudAiplatformV1AnnotationSpec {
        /**
         * Output only. Timestamp when this AnnotationSpec was created.
         */
        createTime?: string | null;
        /**
         * Required. The user-defined name of the AnnotationSpec. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Output only. Resource name of the AnnotationSpec.
         */
        name?: string | null;
        /**
         * Output only. Timestamp when AnnotationSpec was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * The generic reusable api auth config. Deprecated. Please use AuthConfig (google/cloud/aiplatform/master/auth.proto) instead.
     */
    export interface Schema$GoogleCloudAiplatformV1ApiAuth {
        /**
         * The API secret.
         */
        apiKeyConfig?: Schema$GoogleCloudAiplatformV1ApiAuthApiKeyConfig;
    }
    /**
     * The API secret.
     */
    export interface Schema$GoogleCloudAiplatformV1ApiAuthApiKeyConfig {
        /**
         * Required. The SecretManager secret version resource name storing API key. e.g. projects/{project\}/secrets/{secret\}/versions/{version\}
         */
        apiKeySecretVersion?: string | null;
    }
    /**
     * Instance of a general artifact.
     */
    export interface Schema$GoogleCloudAiplatformV1Artifact {
        /**
         * Output only. Timestamp when this Artifact was created.
         */
        createTime?: string | null;
        /**
         * Description of the Artifact
         */
        description?: string | null;
        /**
         * User provided display name of the Artifact. May be up to 128 Unicode characters.
         */
        displayName?: string | null;
        /**
         * An eTag used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The labels with user-defined metadata to organize your Artifacts. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Artifact (System labels are excluded).
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Properties of the Artifact. Top level metadata keys' heading and trailing spaces will be trimmed. The size of this field should not exceed 200KB.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * Output only. The resource name of the Artifact.
         */
        name?: string | null;
        /**
         * The title of the schema describing the metadata. Schema title and version is expected to be registered in earlier Create Schema calls. And both are used together as unique identifiers to identify schemas within the local metadata store.
         */
        schemaTitle?: string | null;
        /**
         * The version of the schema in schema_name to use. Schema title and version is expected to be registered in earlier Create Schema calls. And both are used together as unique identifiers to identify schemas within the local metadata store.
         */
        schemaVersion?: string | null;
        /**
         * The state of this Artifact. This is a property of the Artifact, and does not imply or capture any ongoing process. This property is managed by clients (such as Vertex AI Pipelines), and the system does not prescribe or check the validity of state transitions.
         */
        state?: string | null;
        /**
         * Output only. Timestamp when this Artifact was last updated.
         */
        updateTime?: string | null;
        /**
         * The uniform resource identifier of the artifact file. May be empty if there is no actual artifact file.
         */
        uri?: string | null;
    }
    /**
     * Metadata information for NotebookService.AssignNotebookRuntime.
     */
    export interface Schema$GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * A human-readable message that shows the intermediate progress details of NotebookRuntime.
         */
        progressMessage?: string | null;
    }
    /**
     * Request message for NotebookService.AssignNotebookRuntime.
     */
    export interface Schema$GoogleCloudAiplatformV1AssignNotebookRuntimeRequest {
        /**
         * Required. Provide runtime specific information (e.g. runtime owner, notebook id) used for NotebookRuntime assignment.
         */
        notebookRuntime?: Schema$GoogleCloudAiplatformV1NotebookRuntime;
        /**
         * Optional. User specified ID for the notebook runtime.
         */
        notebookRuntimeId?: string | null;
        /**
         * Required. The resource name of the NotebookRuntimeTemplate based on which a NotebookRuntime will be assigned (reuse or create a new one).
         */
        notebookRuntimeTemplate?: string | null;
    }
    /**
     * Attribution that explains a particular prediction output.
     */
    export interface Schema$GoogleCloudAiplatformV1Attribution {
        /**
         * Output only. Error of feature_attributions caused by approximation used in the explanation method. Lower value means more precise attributions. * For Sampled Shapley attribution, increasing path_count might reduce the error. * For Integrated Gradients attribution, increasing step_count might reduce the error. * For XRAI attribution, increasing step_count might reduce the error. See [this introduction](/vertex-ai/docs/explainable-ai/overview) for more information.
         */
        approximationError?: number | null;
        /**
         * Output only. Model predicted output if the input instance is constructed from the baselines of all the features defined in ExplanationMetadata.inputs. The field name of the output is determined by the key in ExplanationMetadata.outputs. If the Model's predicted output has multiple dimensions (rank \> 1), this is the value in the output located by output_index. If there are multiple baselines, their output values are averaged.
         */
        baselineOutputValue?: number | null;
        /**
         * Output only. Attributions of each explained feature. Features are extracted from the prediction instances according to explanation metadata for inputs. The value is a struct, whose keys are the name of the feature. The values are how much the feature in the instance contributed to the predicted result. The format of the value is determined by the feature's input format: * If the feature is a scalar value, the attribution value is a floating number. * If the feature is an array of scalar values, the attribution value is an array. * If the feature is a struct, the attribution value is a struct. The keys in the attribution value struct are the same as the keys in the feature struct. The formats of the values in the attribution struct are determined by the formats of the values in the feature struct. The ExplanationMetadata.feature_attributions_schema_uri field, pointed to by the ExplanationSpec field of the Endpoint.deployed_models object, points to the schema file that describes the features and their attribution values (if it is populated).
         */
        featureAttributions?: any | null;
        /**
         * Output only. Model predicted output on the corresponding explanation instance. The field name of the output is determined by the key in ExplanationMetadata.outputs. If the Model predicted output has multiple dimensions, this is the value in the output located by output_index.
         */
        instanceOutputValue?: number | null;
        /**
         * Output only. The display name of the output identified by output_index. For example, the predicted class name by a multi-classification Model. This field is only populated iff the Model predicts display names as a separate field along with the explained output. The predicted display name must has the same shape of the explained output, and can be located using output_index.
         */
        outputDisplayName?: string | null;
        /**
         * Output only. The index that locates the explained prediction output. If the prediction output is a scalar value, output_index is not populated. If the prediction output has multiple dimensions, the length of the output_index list is the same as the number of dimensions of the output. The i-th element in output_index is the element index of the i-th dimension of the output vector. Indices start from 0.
         */
        outputIndex?: number[] | null;
        /**
         * Output only. Name of the explain output. Specified as the key in ExplanationMetadata.outputs.
         */
        outputName?: string | null;
    }
    /**
     * Request message for AugmentPrompt.
     */
    export interface Schema$GoogleCloudAiplatformV1AugmentPromptRequest {
        /**
         * Optional. Input content to augment, only text format is supported for now.
         */
        contents?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Optional. Metadata of the backend deployed model.
         */
        model?: Schema$GoogleCloudAiplatformV1AugmentPromptRequestModel;
        /**
         * Optional. Retrieves contexts from the Vertex RagStore.
         */
        vertexRagStore?: Schema$GoogleCloudAiplatformV1VertexRagStore;
    }
    /**
     * Metadata of the backend deployed model.
     */
    export interface Schema$GoogleCloudAiplatformV1AugmentPromptRequestModel {
        /**
         * Optional. The model that the user will send the augmented prompt for content generation.
         */
        model?: string | null;
        /**
         * Optional. The model version of the backend deployed model.
         */
        modelVersion?: string | null;
    }
    /**
     * Response message for AugmentPrompt.
     */
    export interface Schema$GoogleCloudAiplatformV1AugmentPromptResponse {
        /**
         * Augmented prompt, only text format is supported for now.
         */
        augmentedPrompt?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Retrieved facts from RAG data sources.
         */
        facts?: Schema$GoogleCloudAiplatformV1Fact[];
    }
    /**
     * A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration. Each Model supporting these resources documents its specific guidelines.
     */
    export interface Schema$GoogleCloudAiplatformV1AutomaticResources {
        /**
         * Immutable. The maximum number of replicas that may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale to that many replicas is guaranteed (barring service outages). If traffic increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
         */
        maxReplicaCount?: number | null;
        /**
         * Immutable. The minimum number of replicas that will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
         */
        minReplicaCount?: number | null;
    }
    /**
     * The configs for autorater. This is applicable to both EvaluateInstances and EvaluateDataset.
     */
    export interface Schema$GoogleCloudAiplatformV1AutoraterConfig {
        /**
         * Optional. The fully qualified name of the publisher model or tuned autorater endpoint to use. Publisher model format: `projects/{project\}/locations/{location\}/publishers/x/models/x` Tuned model endpoint format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        autoraterModel?: string | null;
        /**
         * Optional. Default is true. Whether to flip the candidate and baseline responses. This is only applicable to the pairwise metric. If enabled, also provide PairwiseMetricSpec.candidate_response_field_name and PairwiseMetricSpec.baseline_response_field_name. When rendering PairwiseMetricSpec.metric_prompt_template, the candidate and baseline fields will be flipped for half of the samples to reduce bias.
         */
        flipEnabled?: boolean | null;
        /**
         * Optional. Number of samples for each instance in the dataset. If not specified, the default is 4. Minimum value is 1, maximum value is 32.
         */
        samplingCount?: number | null;
    }
    /**
     * The metric specification that defines the target resource utilization (CPU utilization, accelerator's duty cycle, and so on) for calculating the desired replica count.
     */
    export interface Schema$GoogleCloudAiplatformV1AutoscalingMetricSpec {
        /**
         * Required. The resource metric name. Supported metrics: * For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
         */
        metricName?: string | null;
        /**
         * The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
         */
        target?: number | null;
    }
    /**
     * The storage details for Avro input content.
     */
    export interface Schema$GoogleCloudAiplatformV1AvroSource {
        /**
         * Required. Google Cloud Storage location.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
    }
    /**
     * Request message for PipelineService.BatchCancelPipelineJobs.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest {
        /**
         * Required. The names of the PipelineJobs to cancel. A maximum of 32 PipelineJobs can be cancelled in a batch. Format: `projects/{project\}/locations/{location\}/pipelineJobs/{pipelineJob\}`
         */
        names?: string[] | null;
    }
    /**
     * Details of operations that perform batch create Features.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata {
        /**
         * Operation metadata for Feature.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for FeaturestoreService.BatchCreateFeatures. Request message for FeatureRegistryService.BatchCreateFeatures.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCreateFeaturesRequest {
        /**
         * Required. The request message specifying the Features to create. All Features must be created under the same parent EntityType / FeatureGroup. The `parent` field in each child request message can be omitted. If `parent` is set in a child request, then the value must match the `parent` value in this request message.
         */
        requests?: Schema$GoogleCloudAiplatformV1CreateFeatureRequest[];
    }
    /**
     * Response message for FeaturestoreService.BatchCreateFeatures.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCreateFeaturesResponse {
        /**
         * The Features created.
         */
        features?: Schema$GoogleCloudAiplatformV1Feature[];
    }
    /**
     * Request message for TensorboardService.BatchCreateTensorboardRuns.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest {
        /**
         * Required. The request message specifying the TensorboardRuns to create. A maximum of 1000 TensorboardRuns can be created in a batch.
         */
        requests?: Schema$GoogleCloudAiplatformV1CreateTensorboardRunRequest[];
    }
    /**
     * Response message for TensorboardService.BatchCreateTensorboardRuns.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse {
        /**
         * The created TensorboardRuns.
         */
        tensorboardRuns?: Schema$GoogleCloudAiplatformV1TensorboardRun[];
    }
    /**
     * Request message for TensorboardService.BatchCreateTensorboardTimeSeries.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest {
        /**
         * Required. The request message specifying the TensorboardTimeSeries to create. A maximum of 1000 TensorboardTimeSeries can be created in a batch.
         */
        requests?: Schema$GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest[];
    }
    /**
     * Response message for TensorboardService.BatchCreateTensorboardTimeSeries.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse {
        /**
         * The created TensorboardTimeSeries.
         */
        tensorboardTimeSeries?: Schema$GoogleCloudAiplatformV1TensorboardTimeSeries[];
    }
    /**
     * A description of resources that are used for performing batch operations, are dedicated to a Model, and need manual configuration.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchDedicatedResources {
        /**
         * Required. Immutable. The specification of a single machine.
         */
        machineSpec?: Schema$GoogleCloudAiplatformV1MachineSpec;
        /**
         * Immutable. The maximum number of machine replicas the batch operation may be scaled to. The default value is 10.
         */
        maxReplicaCount?: number | null;
        /**
         * Immutable. The number of machine replicas used at the start of the batch operation. If not set, Vertex AI decides starting number, not greater than max_replica_count
         */
        startingReplicaCount?: number | null;
    }
    /**
     * Request message for PipelineService.BatchDeletePipelineJobs.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest {
        /**
         * Required. The names of the PipelineJobs to delete. A maximum of 32 PipelineJobs can be deleted in a batch. Format: `projects/{project\}/locations/{location\}/pipelineJobs/{pipelineJob\}`
         */
        names?: string[] | null;
    }
    /**
     * Request message for ModelService.BatchImportEvaluatedAnnotations
     */
    export interface Schema$GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest {
        /**
         * Required. Evaluated annotations resource to be imported.
         */
        evaluatedAnnotations?: Schema$GoogleCloudAiplatformV1EvaluatedAnnotation[];
    }
    /**
     * Response message for ModelService.BatchImportEvaluatedAnnotations
     */
    export interface Schema$GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse {
        /**
         * Output only. Number of EvaluatedAnnotations imported.
         */
        importedEvaluatedAnnotationsCount?: number | null;
    }
    /**
     * Request message for ModelService.BatchImportModelEvaluationSlices
     */
    export interface Schema$GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest {
        /**
         * Required. Model evaluation slice resource to be imported.
         */
        modelEvaluationSlices?: Schema$GoogleCloudAiplatformV1ModelEvaluationSlice[];
    }
    /**
     * Response message for ModelService.BatchImportModelEvaluationSlices
     */
    export interface Schema$GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse {
        /**
         * Output only. List of imported ModelEvaluationSlice.name.
         */
        importedModelEvaluationSlices?: string[] | null;
    }
    /**
     * Runtime operation information for MigrationService.BatchMigrateResources.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * Partial results that reflect the latest migration operation progress.
         */
        partialResults?: Schema$GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult[];
    }
    /**
     * Represents a partial result in batch migration operation for one MigrateResourceRequest.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult {
        /**
         * Migrated dataset resource name.
         */
        dataset?: string | null;
        /**
         * The error result of the migration request in case of failure.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Migrated model resource name.
         */
        model?: string | null;
        /**
         * It's the same as the value in BatchMigrateResourcesRequest.migrate_resource_requests.
         */
        request?: Schema$GoogleCloudAiplatformV1MigrateResourceRequest;
    }
    /**
     * Request message for MigrationService.BatchMigrateResources.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchMigrateResourcesRequest {
        /**
         * Required. The request messages specifying the resources to migrate. They must be in the same location as the destination. Up to 50 resources can be migrated in one batch.
         */
        migrateResourceRequests?: Schema$GoogleCloudAiplatformV1MigrateResourceRequest[];
    }
    /**
     * Response message for MigrationService.BatchMigrateResources.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchMigrateResourcesResponse {
        /**
         * Successfully migrated resources.
         */
        migrateResourceResponses?: Schema$GoogleCloudAiplatformV1MigrateResourceResponse[];
    }
    /**
     * A job that uses a Model to produce predictions on multiple input instances. If predictions for significant portion of the instances fail, the job may finish without attempting predictions for all remaining instances.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchPredictionJob {
        /**
         * Output only. Statistics on completed and failed prediction instances.
         */
        completionStats?: Schema$GoogleCloudAiplatformV1CompletionStats;
        /**
         * Output only. Time when the BatchPredictionJob was created.
         */
        createTime?: string | null;
        /**
         * The config of resources used by the Model during the batch prediction. If the Model supports DEDICATED_RESOURCES this config may be provided (and the job will use these resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config must be provided.
         */
        dedicatedResources?: Schema$GoogleCloudAiplatformV1BatchDedicatedResources;
        /**
         * For custom-trained Models and AutoML Tabular Models, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Cloud Logging by default. Please note that the logs incur cost, which are subject to [Cloud Logging pricing](https://cloud.google.com/logging/pricing). User can disable container logging by setting this flag to true.
         */
        disableContainerLogging?: boolean | null;
        /**
         * Required. The user-defined name of this BatchPredictionJob.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key options for a BatchPredictionJob. If this is set, then all resources created by the BatchPredictionJob will be encrypted with the provided encryption key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Time when the BatchPredictionJob entered any of the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
         */
        endTime?: string | null;
        /**
         * Output only. Only populated when the job's state is JOB_STATE_FAILED or JOB_STATE_CANCELLED.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Explanation configuration for this BatchPredictionJob. Can be specified only if generate_explanation is set to `true`. This value overrides the value of Model.explanation_spec. All fields of explanation_spec are optional in the request. If a field of the explanation_spec object is not populated, the corresponding field of the Model.explanation_spec object is inherited.
         */
        explanationSpec?: Schema$GoogleCloudAiplatformV1ExplanationSpec;
        /**
         * Generate explanation with the batch prediction results. When set to `true`, the batch prediction output changes based on the `predictions_format` field of the BatchPredictionJob.output_config object: * `bigquery`: output includes a column named `explanation`. The value is a struct that conforms to the Explanation object. * `jsonl`: The JSON objects on each line include an additional entry keyed `explanation`. The value of the entry is a JSON object that conforms to the Explanation object. * `csv`: Generating explanations for CSV format is not supported. If this field is set to true, either the Model.explanation_spec or explanation_spec must be populated.
         */
        generateExplanation?: boolean | null;
        /**
         * Required. Input configuration of the instances on which predictions are performed. The schema of any single instance may be specified via the Model's PredictSchemata's instance_schema_uri.
         */
        inputConfig?: Schema$GoogleCloudAiplatformV1BatchPredictionJobInputConfig;
        /**
         * Configuration for how to convert batch prediction input instances to the prediction instances that are sent to the Model.
         */
        instanceConfig?: Schema$GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig;
        /**
         * The labels with user-defined metadata to organize BatchPredictionJobs. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Immutable. Parameters configuring the batch behavior. Currently only applicable when dedicated_resources are used (in other cases Vertex AI does the tuning itself).
         */
        manualBatchTuningParameters?: Schema$GoogleCloudAiplatformV1ManualBatchTuningParameters;
        /**
         * The name of the Model resource that produces the predictions via this job, must share the same ancestor Location. Starting this job has no impact on any existing deployments of the Model and their resources. Exactly one of model and unmanaged_container_model must be set. The model resource name may contain version id or version alias to specify the version. Example: `projects/{project\}/locations/{location\}/models/{model\}@2` or `projects/{project\}/locations/{location\}/models/{model\}@golden` if no version is specified, the default version will be deployed. The model resource could also be a publisher model. Example: `publishers/{publisher\}/models/{model\}` or `projects/{project\}/locations/{location\}/publishers/{publisher\}/models/{model\}`
         */
        model?: string | null;
        /**
         * The parameters that govern the predictions. The schema of the parameters may be specified via the Model's PredictSchemata's parameters_schema_uri.
         */
        modelParameters?: any | null;
        /**
         * Output only. The version ID of the Model that produces the predictions via this job.
         */
        modelVersionId?: string | null;
        /**
         * Output only. Resource name of the BatchPredictionJob.
         */
        name?: string | null;
        /**
         * Required. The Configuration specifying where output predictions should be written. The schema of any single prediction may be specified as a concatenation of Model's PredictSchemata's instance_schema_uri and prediction_schema_uri.
         */
        outputConfig?: Schema$GoogleCloudAiplatformV1BatchPredictionJobOutputConfig;
        /**
         * Output only. Information further describing the output of this job.
         */
        outputInfo?: Schema$GoogleCloudAiplatformV1BatchPredictionJobOutputInfo;
        /**
         * Output only. Partial failures encountered. For example, single files that can't be read. This field never exceeds 20 entries. Status details fields contain standard Google Cloud error details.
         */
        partialFailures?: Schema$GoogleRpcStatus[];
        /**
         * Output only. Information about resources that had been consumed by this job. Provided in real time at best effort basis, as well as a final value once the job completes. Note: This field currently may be not populated for batch predictions that use AutoML Models.
         */
        resourcesConsumed?: Schema$GoogleCloudAiplatformV1ResourcesConsumed;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * The service account that the DeployedModel's container runs as. If not specified, a system generated one will be used, which has minimal permissions and the custom container, if used, may not have enough permission to access other Google Cloud resources. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
         */
        serviceAccount?: string | null;
        /**
         * Output only. Time when the BatchPredictionJob for the first time entered the `JOB_STATE_RUNNING` state.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the job.
         */
        state?: string | null;
        /**
         * Contains model information necessary to perform batch prediction without requiring uploading to model registry. Exactly one of model and unmanaged_container_model must be set.
         */
        unmanagedContainerModel?: Schema$GoogleCloudAiplatformV1UnmanagedContainerModel;
        /**
         * Output only. Time when the BatchPredictionJob was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configures the input to BatchPredictionJob. See Model.supported_input_storage_formats for Model's supported input formats, and how instances should be expressed via any of them.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchPredictionJobInputConfig {
        /**
         * The BigQuery location of the input table. The schema of the table should be in the format described by the given context OpenAPI Schema, if one is provided. The table may contain additional columns that are not described by the schema, and they will be ignored.
         */
        bigquerySource?: Schema$GoogleCloudAiplatformV1BigQuerySource;
        /**
         * The Cloud Storage location for the input instances.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
        /**
         * Required. The format in which instances are given, must be one of the Model's supported_input_storage_formats.
         */
        instancesFormat?: string | null;
    }
    /**
     * Configuration defining how to transform batch prediction input instances to the instances that the Model accepts.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig {
        /**
         * Fields that will be excluded in the prediction instance that is sent to the Model. Excluded will be attached to the batch prediction output if key_field is not specified. When excluded_fields is populated, included_fields must be empty. The input must be JSONL with objects at each line, BigQuery or TfRecord.
         */
        excludedFields?: string[] | null;
        /**
         * Fields that will be included in the prediction instance that is sent to the Model. If instance_type is `array`, the order of field names in included_fields also determines the order of the values in the array. When included_fields is populated, excluded_fields must be empty. The input must be JSONL with objects at each line, BigQuery or TfRecord.
         */
        includedFields?: string[] | null;
        /**
         * The format of the instance that the Model accepts. Vertex AI will convert compatible batch prediction input instance formats to the specified format. Supported values are: * `object`: Each input is converted to JSON object format. * For `bigquery`, each row is converted to an object. * For `jsonl`, each line of the JSONL input must be an object. * Does not apply to `csv`, `file-list`, `tf-record`, or `tf-record-gzip`. * `array`: Each input is converted to JSON array format. * For `bigquery`, each row is converted to an array. The order of columns is determined by the BigQuery column order, unless included_fields is populated. included_fields must be populated for specifying field orders. * For `jsonl`, if each line of the JSONL input is an object, included_fields must be populated for specifying field orders. * Does not apply to `csv`, `file-list`, `tf-record`, or `tf-record-gzip`. If not specified, Vertex AI converts the batch prediction input as follows: * For `bigquery` and `csv`, the behavior is the same as `array`. The order of columns is the same as defined in the file or table, unless included_fields is populated. * For `jsonl`, the prediction instance format is determined by each line of the input. * For `tf-record`/`tf-record-gzip`, each record will be converted to an object in the format of `{"b64": \}`, where `` is the Base64-encoded string of the content of the record. * For `file-list`, each file in the list will be converted to an object in the format of `{"b64": \}`, where `` is the Base64-encoded string of the content of the file.
         */
        instanceType?: string | null;
        /**
         * The name of the field that is considered as a key. The values identified by the key field is not included in the transformed instances that is sent to the Model. This is similar to specifying this name of the field in excluded_fields. In addition, the batch prediction output will not include the instances. Instead the output will only include the value of the key field, in a field named `key` in the output: * For `jsonl` output format, the output will have a `key` field instead of the `instance` field. * For `csv`/`bigquery` output format, the output will have have a `key` column instead of the instance feature columns. The input must be JSONL with objects at each line, CSV, BigQuery or TfRecord.
         */
        keyField?: string | null;
    }
    /**
     * Configures the output of BatchPredictionJob. See Model.supported_output_storage_formats for supported output formats, and how predictions are expressed via any of them.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchPredictionJobOutputConfig {
        /**
         * The BigQuery project or dataset location where the output is to be written to. If project is provided, a new dataset is created with name `prediction__` where is made BigQuery-dataset-name compatible (for example, most special characters become underscores), and timestamp is in YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset two tables will be created, `predictions`, and `errors`. If the Model has both instance and prediction schemata defined then the tables have columns as follows: The `predictions` table contains instances for which the prediction succeeded, it has columns as per a concatenation of the Model's instance and prediction schemata. The `errors` table contains rows for which the prediction has failed, it has instance columns, as per the instance schema, followed by a single "errors" column, which as values has google.rpc.Status represented as a STRUCT, and containing only `code` and `message`.
         */
        bigqueryDestination?: Schema$GoogleCloudAiplatformV1BigQueryDestination;
        /**
         * The Cloud Storage location of the directory where the output is to be written to. In the given directory a new directory is created. Its name is `prediction--`, where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. Inside of it files `predictions_0001.`, `predictions_0002.`, ..., `predictions_N.` are created where `` depends on chosen predictions_format, and N may equal 0001 and depends on the total number of successfully predicted instances. If the Model has both instance and prediction schemata defined then each such file contains predictions as per the predictions_format. If prediction for any instance failed (partially or completely), then an additional `errors_0001.`, `errors_0002.`,..., `errors_N.` files are created (N depends on total number of failed predictions). These files contain the failed instances, as per their schema, followed by an additional `error` field which as value has google.rpc.Status containing only `code` and `message` fields.
         */
        gcsDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * Required. The format in which Vertex AI gives the predictions, must be one of the Model's supported_output_storage_formats.
         */
        predictionsFormat?: string | null;
    }
    /**
     * Further describes this job's output. Supplements output_config.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchPredictionJobOutputInfo {
        /**
         * Output only. The path of the BigQuery dataset created, in `bq://projectId.bqDatasetId` format, into which the prediction output is written.
         */
        bigqueryOutputDataset?: string | null;
        /**
         * Output only. The name of the BigQuery table created, in `predictions_` format, into which the prediction output is written. Can be used by UI to generate the BigQuery output path, for example.
         */
        bigqueryOutputTable?: string | null;
        /**
         * Output only. The full path of the Cloud Storage directory created, into which the prediction output is written.
         */
        gcsOutputDirectory?: string | null;
    }
    /**
     * Details of operations that batch reads Feature values.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata {
        /**
         * Operation metadata for Featurestore batch read Features values.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for FeaturestoreService.BatchReadFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchReadFeatureValuesRequest {
        /**
         * Similar to csv_read_instances, but from BigQuery source.
         */
        bigqueryReadInstances?: Schema$GoogleCloudAiplatformV1BigQuerySource;
        /**
         * Each read instance consists of exactly one read timestamp and one or more entity IDs identifying entities of the corresponding EntityTypes whose Features are requested. Each output instance contains Feature values of requested entities concatenated together as of the read time. An example read instance may be `foo_entity_id, bar_entity_id, 2020-01-01T10:00:00.123Z`. An example output instance may be `foo_entity_id, bar_entity_id, 2020-01-01T10:00:00.123Z, foo_entity_feature1_value, bar_entity_feature2_value`. Timestamp in each read instance must be millisecond-aligned. `csv_read_instances` are read instances stored in a plain-text CSV file. The header should be: [ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp The columns can be in any order. Values in the timestamp column must use the RFC 3339 format, e.g. `2012-07-30T10:43:17.123Z`.
         */
        csvReadInstances?: Schema$GoogleCloudAiplatformV1CsvSource;
        /**
         * Required. Specifies output location and format.
         */
        destination?: Schema$GoogleCloudAiplatformV1FeatureValueDestination;
        /**
         * Required. Specifies EntityType grouping Features to read values of and settings.
         */
        entityTypeSpecs?: Schema$GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec[];
        /**
         * When not empty, the specified fields in the *_read_instances source will be joined as-is in the output, in addition to those fields from the Featurestore Entity. For BigQuery source, the type of the pass-through values will be automatically inferred. For CSV source, the pass-through values will be passed as opaque bytes.
         */
        passThroughFields?: Schema$GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField[];
        /**
         * Optional. Excludes Feature values with feature generation timestamp before this timestamp. If not set, retrieve oldest values kept in Feature Store. Timestamp, if present, must not have higher than millisecond precision.
         */
        startTime?: string | null;
    }
    /**
     * Selects Features of an EntityType to read values of and specifies read settings.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec {
        /**
         * Required. ID of the EntityType to select Features. The EntityType id is the entity_type_id specified during EntityType creation.
         */
        entityTypeId?: string | null;
        /**
         * Required. Selectors choosing which Feature values to read from the EntityType.
         */
        featureSelector?: Schema$GoogleCloudAiplatformV1FeatureSelector;
        /**
         * Per-Feature settings for the batch read.
         */
        settings?: Schema$GoogleCloudAiplatformV1DestinationFeatureSetting[];
    }
    /**
     * Describe pass-through fields in read_instance source.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField {
        /**
         * Required. The name of the field in the CSV header or the name of the column in BigQuery table. The naming restriction is the same as Feature.name.
         */
        fieldName?: string | null;
    }
    /**
     * Response message for FeaturestoreService.BatchReadFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchReadFeatureValuesResponse {
    }
    /**
     * Response message for TensorboardService.BatchReadTensorboardTimeSeriesData.
     */
    export interface Schema$GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse {
        /**
         * The returned time series data.
         */
        timeSeriesData?: Schema$GoogleCloudAiplatformV1TimeSeriesData[];
    }
    /**
     * The BigQuery location for the output content.
     */
    export interface Schema$GoogleCloudAiplatformV1BigQueryDestination {
        /**
         * Required. BigQuery URI to a project or table, up to 2000 characters long. When only the project is specified, the Dataset and Table is created. When the full table reference is specified, the Dataset must exist and table must not exist. Accepted forms: * BigQuery path. For example: `bq://projectId` or `bq://projectId.bqDatasetId` or `bq://projectId.bqDatasetId.bqTableId`.
         */
        outputUri?: string | null;
    }
    /**
     * The BigQuery location for the input content.
     */
    export interface Schema$GoogleCloudAiplatformV1BigQuerySource {
        /**
         * Required. BigQuery URI to a table, up to 2000 characters long. Accepted forms: * BigQuery path. For example: `bq://projectId.bqDatasetId.bqTableId`.
         */
        inputUri?: string | null;
    }
    /**
     * Input for bleu metric.
     */
    export interface Schema$GoogleCloudAiplatformV1BleuInput {
        /**
         * Required. Repeated bleu instances.
         */
        instances?: Schema$GoogleCloudAiplatformV1BleuInstance[];
        /**
         * Required. Spec for bleu score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1BleuSpec;
    }
    /**
     * Spec for bleu instance.
     */
    export interface Schema$GoogleCloudAiplatformV1BleuInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Required. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Bleu metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1BleuMetricValue {
        /**
         * Output only. Bleu score.
         */
        score?: number | null;
    }
    /**
     * Results for bleu metric.
     */
    export interface Schema$GoogleCloudAiplatformV1BleuResults {
        /**
         * Output only. Bleu metric values.
         */
        bleuMetricValues?: Schema$GoogleCloudAiplatformV1BleuMetricValue[];
    }
    /**
     * Spec for bleu score metric - calculates the precision of n-grams in the prediction as compared to reference - returns a score ranging between 0 to 1.
     */
    export interface Schema$GoogleCloudAiplatformV1BleuSpec {
        /**
         * Optional. Whether to use_effective_order to compute bleu score.
         */
        useEffectiveOrder?: boolean | null;
    }
    /**
     * Content blob.
     */
    export interface Schema$GoogleCloudAiplatformV1Blob {
        /**
         * Required. Raw bytes.
         */
        data?: string | null;
        /**
         * Optional. Display name of the blob. Used to provide a label or filename to distinguish blobs. This field is only returned in PromptMessage for prompt management. It is not currently used in the Gemini GenerateContent calls.
         */
        displayName?: string | null;
        /**
         * Required. The IANA standard MIME type of the source data.
         */
        mimeType?: string | null;
    }
    /**
     * Config for blur baseline. When enabled, a linear path from the maximally blurred image to the input image is created. Using a blurred baseline instead of zero (black image) is motivated by the BlurIG approach explained here: https://arxiv.org/abs/2004.03383
     */
    export interface Schema$GoogleCloudAiplatformV1BlurBaselineConfig {
        /**
         * The standard deviation of the blur kernel for the blurred baseline. The same blurring parameter is used for both the height and the width dimension. If not set, the method defaults to the zero (i.e. black for images) baseline.
         */
        maxBlurSigma?: number | null;
    }
    /**
     * A list of boolean values.
     */
    export interface Schema$GoogleCloudAiplatformV1BoolArray {
        /**
         * A list of bool values.
         */
        values?: boolean[] | null;
    }
    /**
     * Config of GenAI caching features. This is a singleton resource.
     */
    export interface Schema$GoogleCloudAiplatformV1CacheConfig {
        /**
         * If set to true, disables GenAI caching. Otherwise caching is enabled.
         */
        disableCache?: boolean | null;
        /**
         * Identifier. Name of the cache config. Format: - `projects/{project\}/cacheConfig`.
         */
        name?: string | null;
    }
    /**
     * A resource used in LLM queries for users to explicitly specify what to cache and how to cache.
     */
    export interface Schema$GoogleCloudAiplatformV1CachedContent {
        /**
         * Optional. Input only. Immutable. The content to cache
         */
        contents?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Output only. Creation time of the cache entry.
         */
        createTime?: string | null;
        /**
         * Optional. Immutable. The user-generated meaningful display name of the cached content.
         */
        displayName?: string | null;
        /**
         * Timestamp of when this resource is considered expired. This is *always* provided on output, regardless of what was sent on input.
         */
        expireTime?: string | null;
        /**
         * Immutable. The name of the `Model` to use for cached content. Currently, only the published Gemini base models are supported, in form of projects/{PROJECT\}/locations/{LOCATION\}/publishers/google/models/{MODEL\}
         */
        model?: string | null;
        /**
         * Immutable. Identifier. The server-generated resource name of the cached content Format: projects/{project\}/locations/{location\}/cachedContents/{cached_content\}
         */
        name?: string | null;
        /**
         * Optional. Input only. Immutable. Developer set system instruction. Currently, text only
         */
        systemInstruction?: Schema$GoogleCloudAiplatformV1Content;
        /**
         * Optional. Input only. Immutable. Tool config. This config is shared for all tools
         */
        toolConfig?: Schema$GoogleCloudAiplatformV1ToolConfig;
        /**
         * Optional. Input only. Immutable. A list of `Tools` the model may use to generate the next response
         */
        tools?: Schema$GoogleCloudAiplatformV1Tool[];
        /**
         * Input only. The TTL for this resource. The expiration time is computed: now + TTL.
         */
        ttl?: string | null;
        /**
         * Output only. When the cache entry was last updated in UTC time.
         */
        updateTime?: string | null;
        /**
         * Output only. Metadata on the usage of the cached content.
         */
        usageMetadata?: Schema$GoogleCloudAiplatformV1CachedContentUsageMetadata;
    }
    /**
     * Metadata on the usage of the cached content.
     */
    export interface Schema$GoogleCloudAiplatformV1CachedContentUsageMetadata {
        /**
         * Duration of audio in seconds.
         */
        audioDurationSeconds?: number | null;
        /**
         * Number of images.
         */
        imageCount?: number | null;
        /**
         * Number of text characters.
         */
        textCount?: number | null;
        /**
         * Total number of tokens that the cached content consumes.
         */
        totalTokenCount?: number | null;
        /**
         * Duration of video in seconds.
         */
        videoDurationSeconds?: number | null;
    }
    /**
     * Request message for JobService.CancelBatchPredictionJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelBatchPredictionJobRequest {
    }
    /**
     * Request message for JobService.CancelCustomJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelCustomJobRequest {
    }
    /**
     * Request message for JobService.CancelDataLabelingJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelDataLabelingJobRequest {
    }
    /**
     * Request message for JobService.CancelHyperparameterTuningJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest {
    }
    /**
     * Request message for JobService.CancelNasJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelNasJobRequest {
    }
    /**
     * Request message for PipelineService.CancelPipelineJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelPipelineJobRequest {
    }
    /**
     * Request message for PipelineService.CancelTrainingPipeline.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelTrainingPipelineRequest {
    }
    /**
     * Request message for GenAiTuningService.CancelTuningJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CancelTuningJobRequest {
    }
    /**
     * A response candidate generated from the model.
     */
    export interface Schema$GoogleCloudAiplatformV1Candidate {
        /**
         * Output only. Average log probability score of the candidate.
         */
        avgLogprobs?: number | null;
        /**
         * Output only. Source attribution of the generated content.
         */
        citationMetadata?: Schema$GoogleCloudAiplatformV1CitationMetadata;
        /**
         * Output only. Content parts of the candidate.
         */
        content?: Schema$GoogleCloudAiplatformV1Content;
        /**
         * Output only. Describes the reason the mode stopped generating tokens in more detail. This is only filled when `finish_reason` is set.
         */
        finishMessage?: string | null;
        /**
         * Output only. The reason why the model stopped generating tokens. If empty, the model has not stopped generating the tokens.
         */
        finishReason?: string | null;
        /**
         * Output only. Metadata specifies sources used to ground generated content.
         */
        groundingMetadata?: Schema$GoogleCloudAiplatformV1GroundingMetadata;
        /**
         * Output only. Index of the candidate.
         */
        index?: number | null;
        /**
         * Output only. Log-likelihood scores for the response tokens and top tokens
         */
        logprobsResult?: Schema$GoogleCloudAiplatformV1LogprobsResult;
        /**
         * Output only. List of ratings for the safety of a response candidate. There is at most one rating per category.
         */
        safetyRatings?: Schema$GoogleCloudAiplatformV1SafetyRating[];
    }
    /**
     * This message will be placed in the metadata field of a google.longrunning.Operation associated with a CheckTrialEarlyStoppingState request.
     */
    export interface Schema$GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata {
        /**
         * Operation metadata for suggesting Trials.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * The name of the Study that the Trial belongs to.
         */
        study?: string | null;
        /**
         * The Trial name.
         */
        trial?: string | null;
    }
    /**
     * Request message for VizierService.CheckTrialEarlyStoppingState.
     */
    export interface Schema$GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest {
    }
    /**
     * Response message for VizierService.CheckTrialEarlyStoppingState.
     */
    export interface Schema$GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse {
        /**
         * True if the Trial should stop.
         */
        shouldStop?: boolean | null;
    }
    /**
     * Source attributions for content.
     */
    export interface Schema$GoogleCloudAiplatformV1Citation {
        /**
         * Output only. End index into the content.
         */
        endIndex?: number | null;
        /**
         * Output only. License of the attribution.
         */
        license?: string | null;
        /**
         * Output only. Publication date of the attribution.
         */
        publicationDate?: Schema$GoogleTypeDate;
        /**
         * Output only. Start index into the content.
         */
        startIndex?: number | null;
        /**
         * Output only. Title of the attribution.
         */
        title?: string | null;
        /**
         * Output only. Url reference of the attribution.
         */
        uri?: string | null;
    }
    /**
     * A collection of source attributions for a piece of content.
     */
    export interface Schema$GoogleCloudAiplatformV1CitationMetadata {
        /**
         * Output only. List of citations.
         */
        citations?: Schema$GoogleCloudAiplatformV1Citation[];
    }
    /**
     * Claim that is extracted from the input text and facts that support it.
     */
    export interface Schema$GoogleCloudAiplatformV1Claim {
        /**
         * Index in the input text where the claim ends (exclusive).
         */
        endIndex?: number | null;
        /**
         * Indexes of the facts supporting this claim.
         */
        factIndexes?: number[] | null;
        /**
         * Confidence score of this corroboration.
         */
        score?: number | null;
        /**
         * Index in the input text where the claim starts (inclusive).
         */
        startIndex?: number | null;
    }
    /**
     * Configurations (e.g. inference timeout) that are applied on your endpoints.
     */
    export interface Schema$GoogleCloudAiplatformV1ClientConnectionConfig {
        /**
         * Customizable online prediction request timeout.
         */
        inferenceTimeout?: string | null;
    }
    /**
     * Result of executing the [ExecutableCode]. Always follows a `part` containing the [ExecutableCode].
     */
    export interface Schema$GoogleCloudAiplatformV1CodeExecutionResult {
        /**
         * Required. Outcome of the code execution.
         */
        outcome?: string | null;
        /**
         * Optional. Contains stdout when code execution is successful, stderr or other description otherwise.
         */
        output?: string | null;
    }
    /**
     * Input for coherence metric.
     */
    export interface Schema$GoogleCloudAiplatformV1CoherenceInput {
        /**
         * Required. Coherence instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1CoherenceInstance;
        /**
         * Required. Spec for coherence score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1CoherenceSpec;
    }
    /**
     * Spec for coherence instance.
     */
    export interface Schema$GoogleCloudAiplatformV1CoherenceInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
    }
    /**
     * Spec for coherence result.
     */
    export interface Schema$GoogleCloudAiplatformV1CoherenceResult {
        /**
         * Output only. Confidence for coherence score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for coherence score.
         */
        explanation?: string | null;
        /**
         * Output only. Coherence score.
         */
        score?: number | null;
    }
    /**
     * Spec for coherence score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1CoherenceSpec {
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Input for Comet metric.
     */
    export interface Schema$GoogleCloudAiplatformV1CometInput {
        /**
         * Required. Comet instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1CometInstance;
        /**
         * Required. Spec for comet metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1CometSpec;
    }
    /**
     * Spec for Comet instance - The fields used for evaluation are dependent on the comet version.
     */
    export interface Schema$GoogleCloudAiplatformV1CometInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
        /**
         * Optional. Source text in original language.
         */
        source?: string | null;
    }
    /**
     * Spec for Comet result - calculates the comet score for the given instance using the version specified in the spec.
     */
    export interface Schema$GoogleCloudAiplatformV1CometResult {
        /**
         * Output only. Comet score. Range depends on version.
         */
        score?: number | null;
    }
    /**
     * Spec for Comet metric.
     */
    export interface Schema$GoogleCloudAiplatformV1CometSpec {
        /**
         * Optional. Source language in BCP-47 format.
         */
        sourceLanguage?: string | null;
        /**
         * Optional. Target language in BCP-47 format. Covers both prediction and reference.
         */
        targetLanguage?: string | null;
        /**
         * Required. Which version to use for evaluation.
         */
        version?: string | null;
    }
    /**
     * Request message for VizierService.CompleteTrial.
     */
    export interface Schema$GoogleCloudAiplatformV1CompleteTrialRequest {
        /**
         * Optional. If provided, it will be used as the completed Trial's final_measurement; Otherwise, the service will auto-select a previously reported measurement as the final-measurement
         */
        finalMeasurement?: Schema$GoogleCloudAiplatformV1Measurement;
        /**
         * Optional. A human readable reason why the trial was infeasible. This should only be provided if `trial_infeasible` is true.
         */
        infeasibleReason?: string | null;
        /**
         * Optional. True if the Trial cannot be run with the given Parameter, and final_measurement will be ignored.
         */
        trialInfeasible?: boolean | null;
    }
    /**
     * Success and error statistics of processing multiple entities (for example, DataItems or structured data rows) in batch.
     */
    export interface Schema$GoogleCloudAiplatformV1CompletionStats {
        /**
         * Output only. The number of entities for which any error was encountered.
         */
        failedCount?: string | null;
        /**
         * Output only. In cases when enough errors are encountered a job, pipeline, or operation may be failed as a whole. Below is the number of entities for which the processing had not been finished (either in successful or failed state). Set to -1 if the number is unknown (for example, the operation failed before the total entity number could be collected).
         */
        incompleteCount?: string | null;
        /**
         * Output only. The number of entities that had been processed successfully.
         */
        successfulCount?: string | null;
        /**
         * Output only. The number of the successful forecast points that are generated by the forecasting model. This is ONLY used by the forecasting batch prediction.
         */
        successfulForecastPointCount?: string | null;
    }
    /**
     * Request message for ComputeTokens RPC call.
     */
    export interface Schema$GoogleCloudAiplatformV1ComputeTokensRequest {
        /**
         * Optional. Input content.
         */
        contents?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Optional. The instances that are the input to token computing API call. Schema is identical to the prediction schema of the text model, even for the non-text models, like chat models, or Codey models.
         */
        instances?: any[] | null;
        /**
         * Optional. The name of the publisher model requested to serve the prediction. Format: projects/{project\}/locations/{location\}/publishers/x/models/x
         */
        model?: string | null;
    }
    /**
     * Response message for ComputeTokens RPC call.
     */
    export interface Schema$GoogleCloudAiplatformV1ComputeTokensResponse {
        /**
         * Lists of tokens info from the input. A ComputeTokensRequest could have multiple instances with a prompt in each instance. We also need to return lists of tokens info for the request with multiple instances.
         */
        tokensInfo?: Schema$GoogleCloudAiplatformV1TokensInfo[];
    }
    /**
     * The Container Registry location for the container image.
     */
    export interface Schema$GoogleCloudAiplatformV1ContainerRegistryDestination {
        /**
         * Required. Container Registry URI of a container image. Only Google Container Registry and Artifact Registry are supported now. Accepted forms: * Google Container Registry path. For example: `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For example: `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a tag is not specified, "latest" will be used as the default tag.
         */
        outputUri?: string | null;
    }
    /**
     * The spec of a Container.
     */
    export interface Schema$GoogleCloudAiplatformV1ContainerSpec {
        /**
         * The arguments to be passed when starting the container.
         */
        args?: string[] | null;
        /**
         * The command to be invoked when the container is started. It overrides the entrypoint instruction in Dockerfile when provided.
         */
        command?: string[] | null;
        /**
         * Environment variables to be passed to the container. Maximum limit is 100.
         */
        env?: Schema$GoogleCloudAiplatformV1EnvVar[];
        /**
         * Required. The URI of a container image in the Container Registry that is to be run on each worker replica.
         */
        imageUri?: string | null;
    }
    /**
     * The base structured datatype containing multi-part content of a message. A `Content` includes a `role` field designating the producer of the `Content` and a `parts` field containing multi-part data that contains the content of the message turn.
     */
    export interface Schema$GoogleCloudAiplatformV1Content {
        /**
         * Required. Ordered `Parts` that constitute a single message. Parts may have different IANA MIME types.
         */
        parts?: Schema$GoogleCloudAiplatformV1Part[];
        /**
         * Optional. The producer of the content. Must be either 'user' or 'model'. Useful to set for multi-turn conversations, otherwise can be left blank or unset.
         */
        role?: string | null;
    }
    /**
     * Map of placeholder in metric prompt template to contents of model input.
     */
    export interface Schema$GoogleCloudAiplatformV1ContentMap {
        /**
         * Optional. Map of placeholder to contents.
         */
        values?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ContentMapContents;
        } | null;
    }
    /**
     * Repeated Content type.
     */
    export interface Schema$GoogleCloudAiplatformV1ContentMapContents {
        /**
         * Optional. Repeated contents.
         */
        contents?: Schema$GoogleCloudAiplatformV1Content[];
    }
    /**
     * Instance of a general context.
     */
    export interface Schema$GoogleCloudAiplatformV1Context {
        /**
         * Output only. Timestamp when this Context was created.
         */
        createTime?: string | null;
        /**
         * Description of the Context
         */
        description?: string | null;
        /**
         * User provided display name of the Context. May be up to 128 Unicode characters.
         */
        displayName?: string | null;
        /**
         * An eTag used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The labels with user-defined metadata to organize your Contexts. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Context (System labels are excluded).
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Properties of the Context. Top level metadata keys' heading and trailing spaces will be trimmed. The size of this field should not exceed 200KB.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * Immutable. The resource name of the Context.
         */
        name?: string | null;
        /**
         * Output only. A list of resource names of Contexts that are parents of this Context. A Context may have at most 10 parent_contexts.
         */
        parentContexts?: string[] | null;
        /**
         * The title of the schema describing the metadata. Schema title and version is expected to be registered in earlier Create Schema calls. And both are used together as unique identifiers to identify schemas within the local metadata store.
         */
        schemaTitle?: string | null;
        /**
         * The version of the schema in schema_name to use. Schema title and version is expected to be registered in earlier Create Schema calls. And both are used together as unique identifiers to identify schemas within the local metadata store.
         */
        schemaVersion?: string | null;
        /**
         * Output only. Timestamp when this Context was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Details of ModelService.CopyModel operation.
     */
    export interface Schema$GoogleCloudAiplatformV1CopyModelOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for ModelService.CopyModel.
     */
    export interface Schema$GoogleCloudAiplatformV1CopyModelRequest {
        /**
         * Customer-managed encryption key options. If this is set, then the Model copy will be encrypted with the provided encryption key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Optional. Copy source_model into a new Model with this ID. The ID will become the final component of the model resource name. This value may be up to 63 characters, and valid characters are `[a-z0-9_-]`. The first character cannot be a number or hyphen.
         */
        modelId?: string | null;
        /**
         * Optional. Specify this field to copy source_model into this existing Model as a new version. Format: `projects/{project\}/locations/{location\}/models/{model\}`
         */
        parentModel?: string | null;
        /**
         * Required. The resource name of the Model to copy. That Model must be in the same Project. Format: `projects/{project\}/locations/{location\}/models/{model\}`
         */
        sourceModel?: string | null;
    }
    /**
     * Response message of ModelService.CopyModel operation.
     */
    export interface Schema$GoogleCloudAiplatformV1CopyModelResponse {
        /**
         * The name of the copied Model resource. Format: `projects/{project\}/locations/{location\}/models/{model\}`
         */
        model?: string | null;
        /**
         * Output only. The version ID of the model that is copied.
         */
        modelVersionId?: string | null;
    }
    /**
     * RagCorpus status.
     */
    export interface Schema$GoogleCloudAiplatformV1CorpusStatus {
        /**
         * Output only. Only when the `state` field is ERROR.
         */
        errorStatus?: string | null;
        /**
         * Output only. RagCorpus life state.
         */
        state?: string | null;
    }
    /**
     * Request message for CorroborateContent.
     */
    export interface Schema$GoogleCloudAiplatformV1CorroborateContentRequest {
        /**
         * Optional. Input content to corroborate, only text format is supported for now.
         */
        content?: Schema$GoogleCloudAiplatformV1Content;
        /**
         * Optional. Facts used to generate the text can also be used to corroborate the text.
         */
        facts?: Schema$GoogleCloudAiplatformV1Fact[];
        /**
         * Optional. Parameters that can be set to override default settings per request.
         */
        parameters?: Schema$GoogleCloudAiplatformV1CorroborateContentRequestParameters;
    }
    /**
     * Parameters that can be overrided per request.
     */
    export interface Schema$GoogleCloudAiplatformV1CorroborateContentRequestParameters {
        /**
         * Optional. Only return claims with citation score larger than the threshold.
         */
        citationThreshold?: number | null;
    }
    /**
     * Response message for CorroborateContent.
     */
    export interface Schema$GoogleCloudAiplatformV1CorroborateContentResponse {
        /**
         * Claims that are extracted from the input content and facts that support the claims.
         */
        claims?: Schema$GoogleCloudAiplatformV1Claim[];
        /**
         * Confidence score of corroborating content. Value is [0,1] with 1 is the most confidence.
         */
        corroborationScore?: number | null;
    }
    /**
     * Request message for PredictionService.CountTokens.
     */
    export interface Schema$GoogleCloudAiplatformV1CountTokensRequest {
        /**
         * Optional. Input content.
         */
        contents?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Optional. Generation config that the model will use to generate the response.
         */
        generationConfig?: Schema$GoogleCloudAiplatformV1GenerationConfig;
        /**
         * Optional. The instances that are the input to token counting call. Schema is identical to the prediction schema of the underlying model.
         */
        instances?: any[] | null;
        /**
         * Optional. The name of the publisher model requested to serve the prediction. Format: `projects/{project\}/locations/{location\}/publishers/x/models/x`
         */
        model?: string | null;
        /**
         * Optional. The user provided system instructions for the model. Note: only text should be used in parts and content in each part will be in a separate paragraph.
         */
        systemInstruction?: Schema$GoogleCloudAiplatformV1Content;
        /**
         * Optional. A list of `Tools` the model may use to generate the next response. A `Tool` is a piece of code that enables the system to interact with external systems to perform an action, or set of actions, outside of knowledge and scope of the model.
         */
        tools?: Schema$GoogleCloudAiplatformV1Tool[];
    }
    /**
     * Response message for PredictionService.CountTokens.
     */
    export interface Schema$GoogleCloudAiplatformV1CountTokensResponse {
        /**
         * Output only. List of modalities that were processed in the request input.
         */
        promptTokensDetails?: Schema$GoogleCloudAiplatformV1ModalityTokenCount[];
        /**
         * The total number of billable characters counted across all instances from the request.
         */
        totalBillableCharacters?: number | null;
        /**
         * The total number of tokens counted across all instances from the request.
         */
        totalTokens?: number | null;
    }
    /**
     * Runtime operation information for DatasetService.CreateDataset.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateDatasetOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Runtime operation information for DatasetService.CreateDatasetVersion.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Runtime operation information for CreateDeploymentResourcePool method.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for CreateDeploymentResourcePool method.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest {
        /**
         * Required. The DeploymentResourcePool to create.
         */
        deploymentResourcePool?: Schema$GoogleCloudAiplatformV1DeploymentResourcePool;
        /**
         * Required. The ID to use for the DeploymentResourcePool, which will become the final component of the DeploymentResourcePool's resource name. The maximum length is 63 characters, and valid characters are `/^[a-z]([a-z0-9-]{0,61\}[a-z0-9])?$/`.
         */
        deploymentResourcePoolId?: string | null;
    }
    /**
     * Runtime operation information for EndpointService.CreateEndpoint.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateEndpointOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform create EntityType.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata {
        /**
         * Operation metadata for EntityType.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform create FeatureGroup.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata {
        /**
         * Operation metadata for FeatureGroup.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform create FeatureOnlineStore.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata {
        /**
         * Operation metadata for FeatureOnlineStore.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform create Feature.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateFeatureOperationMetadata {
        /**
         * Operation metadata for Feature.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for FeaturestoreService.CreateFeature. Request message for FeatureRegistryService.CreateFeature.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateFeatureRequest {
        /**
         * Required. The Feature to create.
         */
        feature?: Schema$GoogleCloudAiplatformV1Feature;
        /**
         * Required. The ID to use for the Feature, which will become the final component of the Feature's resource name. This value may be up to 128 characters, and valid characters are `[a-z0-9_]`. The first character cannot be a number. The value must be unique within an EntityType/FeatureGroup.
         */
        featureId?: string | null;
        /**
         * Required. The resource name of the EntityType or FeatureGroup to create a Feature. Format for entity_type as parent: `projects/{project\}/locations/{location\}/featurestores/{featurestore\}/entityTypes/{entity_type\}` Format for feature_group as parent: `projects/{project\}/locations/{location\}/featureGroups/{feature_group\}`
         */
        parent?: string | null;
    }
    /**
     * Details of operations that perform create Featurestore.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata {
        /**
         * Operation metadata for Featurestore.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform create FeatureView.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata {
        /**
         * Operation metadata for FeatureView Create.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Runtime operation information for IndexEndpointService.CreateIndexEndpoint.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Runtime operation information for IndexService.CreateIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateIndexOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * The operation metadata with regard to Matching Engine Index operation.
         */
        nearestNeighborSearchOperationMetadata?: Schema$GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata;
    }
    /**
     * Details of operations that perform MetadataService.CreateMetadataStore.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata {
        /**
         * Operation metadata for creating a MetadataStore.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Metadata information for NotebookService.CreateNotebookExecutionJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateNotebookExecutionJobOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * A human-readable message that shows the intermediate progress details of NotebookRuntime.
         */
        progressMessage?: string | null;
    }
    /**
     * Request message for [NotebookService.CreateNotebookExecutionJob]
     */
    export interface Schema$GoogleCloudAiplatformV1CreateNotebookExecutionJobRequest {
        /**
         * Required. The NotebookExecutionJob to create.
         */
        notebookExecutionJob?: Schema$GoogleCloudAiplatformV1NotebookExecutionJob;
        /**
         * Optional. User specified ID for the NotebookExecutionJob.
         */
        notebookExecutionJobId?: string | null;
        /**
         * Required. The resource name of the Location to create the NotebookExecutionJob. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string | null;
    }
    /**
     * Metadata information for NotebookService.CreateNotebookRuntimeTemplate.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform create PersistentResource.
     */
    export interface Schema$GoogleCloudAiplatformV1CreatePersistentResourceOperationMetadata {
        /**
         * Operation metadata for PersistentResource.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * Progress Message for Create LRO
         */
        progressMessage?: string | null;
    }
    /**
     * Request message for PipelineService.CreatePipelineJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CreatePipelineJobRequest {
        /**
         * Required. The resource name of the Location to create the PipelineJob in. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string | null;
        /**
         * Required. The PipelineJob to create.
         */
        pipelineJob?: Schema$GoogleCloudAiplatformV1PipelineJob;
        /**
         * The ID to use for the PipelineJob, which will become the final component of the PipelineJob name. If not provided, an ID will be automatically generated. This value should be less than 128 characters, and valid characters are `/a-z-/`.
         */
        pipelineJobId?: string | null;
    }
    /**
     * Details of operations that perform create FeatureGroup.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata {
        /**
         * Operation metadata for Feature.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Runtime operation information for SpecialistPoolService.CreateSpecialistPool.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform create Tensorboard.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateTensorboardOperationMetadata {
        /**
         * Operation metadata for Tensorboard.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for TensorboardService.CreateTensorboardRun.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateTensorboardRunRequest {
        /**
         * Required. The resource name of the TensorboardExperiment to create the TensorboardRun in. Format: `projects/{project\}/locations/{location\}/tensorboards/{tensorboard\}/experiments/{experiment\}`
         */
        parent?: string | null;
        /**
         * Required. The TensorboardRun to create.
         */
        tensorboardRun?: Schema$GoogleCloudAiplatformV1TensorboardRun;
        /**
         * Required. The ID to use for the Tensorboard run, which becomes the final component of the Tensorboard run's resource name. This value should be 1-128 characters, and valid characters are `/a-z-/`.
         */
        tensorboardRunId?: string | null;
    }
    /**
     * Request message for TensorboardService.CreateTensorboardTimeSeries.
     */
    export interface Schema$GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest {
        /**
         * Required. The resource name of the TensorboardRun to create the TensorboardTimeSeries in. Format: `projects/{project\}/locations/{location\}/tensorboards/{tensorboard\}/experiments/{experiment\}/runs/{run\}`
         */
        parent?: string | null;
        /**
         * Required. The TensorboardTimeSeries to create.
         */
        tensorboardTimeSeries?: Schema$GoogleCloudAiplatformV1TensorboardTimeSeries;
        /**
         * Optional. The user specified unique ID to use for the TensorboardTimeSeries, which becomes the final component of the TensorboardTimeSeries's resource name. This value should match "a-z0-9{0, 127\}"
         */
        tensorboardTimeSeriesId?: string | null;
    }
    /**
     * The storage details for CSV output content.
     */
    export interface Schema$GoogleCloudAiplatformV1CsvDestination {
        /**
         * Required. Google Cloud Storage location.
         */
        gcsDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
    }
    /**
     * The storage details for CSV input content.
     */
    export interface Schema$GoogleCloudAiplatformV1CsvSource {
        /**
         * Required. Google Cloud Storage location.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
    }
    /**
     * Represents a job that runs custom workloads such as a Docker container or a Python package. A CustomJob can have multiple worker pools and each worker pool can have its own machine and input spec. A CustomJob will be cleaned up once the job enters terminal state (failed or succeeded).
     */
    export interface Schema$GoogleCloudAiplatformV1CustomJob {
        /**
         * Output only. Time when the CustomJob was created.
         */
        createTime?: string | null;
        /**
         * Required. The display name of the CustomJob. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key options for a CustomJob. If this is set, then all resources created by the CustomJob will be encrypted with the provided encryption key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Time when the CustomJob entered any of the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
         */
        endTime?: string | null;
        /**
         * Output only. Only populated when job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Required. Job spec.
         */
        jobSpec?: Schema$GoogleCloudAiplatformV1CustomJobSpec;
        /**
         * The labels with user-defined metadata to organize CustomJobs. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Resource name of a CustomJob.
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Time when the CustomJob for the first time entered the `JOB_STATE_RUNNING` state.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the job.
         */
        state?: string | null;
        /**
         * Output only. Time when the CustomJob was most recently updated.
         */
        updateTime?: string | null;
        /**
         * Output only. URIs for accessing [interactive shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell) (one URI for each training node). Only available if job_spec.enable_web_access is `true`. The keys are names of each node in the training job; for example, `workerpool0-0` for the primary node, `workerpool1-0` for the first node in the second worker pool, and `workerpool1-1` for the second node in the second worker pool. The values are the URIs for each node's interactive shell.
         */
        webAccessUris?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Represents the spec of a CustomJob.
     */
    export interface Schema$GoogleCloudAiplatformV1CustomJobSpec {
        /**
         * The Cloud Storage location to store the output of this CustomJob or HyperparameterTuningJob. For HyperparameterTuningJob, the baseOutputDirectory of each child CustomJob backing a Trial is set to a subdirectory of name id under its parent HyperparameterTuningJob's baseOutputDirectory. The following Vertex AI environment variables will be passed to containers or python modules when this field is set: For CustomJob: * AIP_MODEL_DIR = `/model/` * AIP_CHECKPOINT_DIR = `/checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `/logs/` For CustomJob backing a Trial of HyperparameterTuningJob: * AIP_MODEL_DIR = `//model/` * AIP_CHECKPOINT_DIR = `//checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `//logs/`
         */
        baseOutputDirectory?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * Optional. Whether you want Vertex AI to enable access to the customized dashboard in training chief container. If set to `true`, you can access the dashboard at the URIs given by CustomJob.web_access_uris or Trial.web_access_uris (within HyperparameterTuningJob.trials).
         */
        enableDashboardAccess?: boolean | null;
        /**
         * Optional. Whether you want Vertex AI to enable [interactive shell access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell) to training containers. If set to `true`, you can access interactive shells at the URIs given by CustomJob.web_access_uris or Trial.web_access_uris (within HyperparameterTuningJob.trials).
         */
        enableWebAccess?: boolean | null;
        /**
         * Optional. The Experiment associated with this job. Format: `projects/{project\}/locations/{location\}/metadataStores/{metadataStores\}/contexts/{experiment-name\}`
         */
        experiment?: string | null;
        /**
         * Optional. The Experiment Run associated with this job. Format: `projects/{project\}/locations/{location\}/metadataStores/{metadataStores\}/contexts/{experiment-name\}-{experiment-run-name\}`
         */
        experimentRun?: string | null;
        /**
         * Optional. The name of the Model resources for which to generate a mapping to artifact URIs. Applicable only to some of the Google-provided custom jobs. Format: `projects/{project\}/locations/{location\}/models/{model\}` In order to retrieve a specific version of the model, also provide the version ID or version alias. Example: `projects/{project\}/locations/{location\}/models/{model\}@2` or `projects/{project\}/locations/{location\}/models/{model\}@golden` If no version ID or alias is specified, the "default" version will be returned. The "default" version alias is created for the first version of the model, and can be moved to other versions later on. There will be exactly one default version.
         */
        models?: string[] | null;
        /**
         * Optional. The full name of the Compute Engine [network](/compute/docs/networks-and-firewalls#networks) to which the Job should be peered. For example, `projects/12345/global/networks/myVPC`. [Format](/compute/docs/reference/rest/v1/networks/insert) is of the form `projects/{project\}/global/networks/{network\}`. Where {project\} is a project number, as in `12345`, and {network\} is a network name. To specify this field, you must have already [configured VPC Network Peering for Vertex AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering). If this field is left unspecified, the job is not peered with any network.
         */
        network?: string | null;
        /**
         * Optional. The ID of the PersistentResource in the same Project and Location which to run If this is specified, the job will be run on existing machines held by the PersistentResource instead of on-demand short-live machines. The network and CMEK configs on the job should be consistent with those on the PersistentResource, otherwise, the job will be rejected.
         */
        persistentResourceId?: string | null;
        /**
         * The ID of the location to store protected artifacts. e.g. us-central1. Populate only when the location is different than CustomJob location. List of supported locations: https://cloud.google.com/vertex-ai/docs/general/locations
         */
        protectedArtifactLocationId?: string | null;
        /**
         * Optional. A list of names for the reserved ip ranges under the VPC network that can be used for this job. If set, we will deploy the job within the provided ip ranges. Otherwise, the job will be deployed to any ip ranges under the provided VPC network. Example: ['vertex-ai-ip-range'].
         */
        reservedIpRanges?: string[] | null;
        /**
         * Scheduling options for a CustomJob.
         */
        scheduling?: Schema$GoogleCloudAiplatformV1Scheduling;
        /**
         * Specifies the service account for workload run-as account. Users submitting jobs must have act-as permission on this run-as account. If unspecified, the [Vertex AI Custom Code Service Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents) for the CustomJob's project is used.
         */
        serviceAccount?: string | null;
        /**
         * Optional. The name of a Vertex AI Tensorboard resource to which this CustomJob will upload Tensorboard logs. Format: `projects/{project\}/locations/{location\}/tensorboards/{tensorboard\}`
         */
        tensorboard?: string | null;
        /**
         * Required. The spec of the worker pools including machine type and Docker image. All worker pools except the first one are optional and can be skipped by providing an empty value.
         */
        workerPoolSpecs?: Schema$GoogleCloudAiplatformV1WorkerPoolSpec[];
    }
    /**
     * Spec for custom output.
     */
    export interface Schema$GoogleCloudAiplatformV1CustomOutput {
        /**
         * Output only. List of raw output strings.
         */
        rawOutputs?: Schema$GoogleCloudAiplatformV1RawOutput;
    }
    /**
     * Spec for custom output format configuration.
     */
    export interface Schema$GoogleCloudAiplatformV1CustomOutputFormatConfig {
        /**
         * Optional. Whether to return raw output.
         */
        returnRawOutput?: boolean | null;
    }
    /**
     * A piece of data in a Dataset. Could be an image, a video, a document or plain text.
     */
    export interface Schema$GoogleCloudAiplatformV1DataItem {
        /**
         * Output only. Timestamp when this DataItem was created.
         */
        createTime?: string | null;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize your DataItems. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one DataItem(System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. The resource name of the DataItem.
         */
        name?: string | null;
        /**
         * Required. The data that the DataItem represents (for example, an image or a text snippet). The schema of the payload is stored in the parent Dataset's metadata schema's dataItemSchemaUri field.
         */
        payload?: any | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Timestamp when this DataItem was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * A container for a single DataItem and Annotations on it.
     */
    export interface Schema$GoogleCloudAiplatformV1DataItemView {
        /**
         * The Annotations on the DataItem. If too many Annotations should be returned for the DataItem, this field will be truncated per annotations_limit in request. If it was, then the has_truncated_annotations will be set to true.
         */
        annotations?: Schema$GoogleCloudAiplatformV1Annotation[];
        /**
         * The DataItem.
         */
        dataItem?: Schema$GoogleCloudAiplatformV1DataItem;
        /**
         * True if and only if the Annotations field has been truncated. It happens if more Annotations for this DataItem met the request's annotation_filter than are allowed to be returned by annotations_limit. Note that if Annotations field is not being returned due to field mask, then this field will not be set to true no matter how many Annotations are there.
         */
        hasTruncatedAnnotations?: boolean | null;
    }
    /**
     * DataLabelingJob is used to trigger a human labeling job on unlabeled data from the following Dataset:
     */
    export interface Schema$GoogleCloudAiplatformV1DataLabelingJob {
        /**
         * Parameters that configure the active learning pipeline. Active learning will label the data incrementally via several iterations. For every iteration, it will select a batch of data based on the sampling strategy.
         */
        activeLearningConfig?: Schema$GoogleCloudAiplatformV1ActiveLearningConfig;
        /**
         * Labels to assign to annotations generated by this DataLabelingJob. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        annotationLabels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Timestamp when this DataLabelingJob was created.
         */
        createTime?: string | null;
        /**
         * Output only. Estimated cost(in US dollars) that the DataLabelingJob has incurred to date.
         */
        currentSpend?: Schema$GoogleTypeMoney;
        /**
         * Required. Dataset resource names. Right now we only support labeling from a single Dataset. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`
         */
        datasets?: string[] | null;
        /**
         * Required. The user-defined name of the DataLabelingJob. The name can be up to 128 characters long and can consist of any UTF-8 characters. Display name of a DataLabelingJob.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for a DataLabelingJob. If set, this DataLabelingJob will be secured by this key. Note: Annotations created in the DataLabelingJob are associated with the EncryptionSpec of the Dataset they are exported to.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. DataLabelingJob errors. It is only populated when job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Required. Input config parameters for the DataLabelingJob.
         */
        inputs?: any | null;
        /**
         * Required. Points to a YAML file stored on Google Cloud Storage describing the config for a specific type of DataLabelingJob. The schema files that can be used here are found in the https://storage.googleapis.com/google-cloud-aiplatform bucket in the /schema/datalabelingjob/inputs/ folder.
         */
        inputsSchemaUri?: string | null;
        /**
         * Required. The Google Cloud Storage location of the instruction pdf. This pdf is shared with labelers, and provides detailed description on how to label DataItems in Datasets.
         */
        instructionUri?: string | null;
        /**
         * Required. Number of labelers to work on each DataItem.
         */
        labelerCount?: number | null;
        /**
         * Output only. Current labeling job progress percentage scaled in interval [0, 100], indicating the percentage of DataItems that has been finished.
         */
        labelingProgress?: number | null;
        /**
         * The labels with user-defined metadata to organize your DataLabelingJobs. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable. Following system labels exist for each DataLabelingJob: * "aiplatform.googleapis.com/schema": output only, its value is the inputs_schema's title.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Resource name of the DataLabelingJob.
         */
        name?: string | null;
        /**
         * The SpecialistPools' resource names associated with this job.
         */
        specialistPools?: string[] | null;
        /**
         * Output only. The detailed state of the job.
         */
        state?: string | null;
        /**
         * Output only. Timestamp when this DataLabelingJob was updated most recently.
         */
        updateTime?: string | null;
    }
    /**
     * A collection of DataItems and Annotations on them.
     */
    export interface Schema$GoogleCloudAiplatformV1Dataset {
        /**
         * Output only. Timestamp when this Dataset was created.
         */
        createTime?: string | null;
        /**
         * Output only. The number of DataItems in this Dataset. Only apply for non-structured Dataset.
         */
        dataItemCount?: string | null;
        /**
         * The description of the Dataset.
         */
        description?: string | null;
        /**
         * Required. The user-defined name of the Dataset. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for a Dataset. If set, this Dataset and all sub-resources of this Dataset will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The labels with user-defined metadata to organize your Datasets. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Dataset (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable. Following system labels exist for each Dataset: * "aiplatform.googleapis.com/dataset_metadata_schema": output only, its value is the metadata_schema's title.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Required. Additional information about the Dataset.
         */
        metadata?: any | null;
        /**
         * Output only. The resource name of the Artifact that was created in MetadataStore when creating the Dataset. The Artifact resource name pattern is `projects/{project\}/locations/{location\}/metadataStores/{metadata_store\}/artifacts/{artifact\}`.
         */
        metadataArtifact?: string | null;
        /**
         * Required. Points to a YAML file stored on Google Cloud Storage describing additional information about the Dataset. The schema is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can be used here are found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
         */
        metadataSchemaUri?: string | null;
        /**
         * Optional. Reference to the public base model last used by the dataset. Only set for prompt datasets.
         */
        modelReference?: string | null;
        /**
         * Output only. Identifier. The resource name of the Dataset. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * All SavedQueries belong to the Dataset will be returned in List/Get Dataset response. The annotation_specs field will not be populated except for UI cases which will only use annotation_spec_count. In CreateDataset request, a SavedQuery is created together if this field is set, up to one SavedQuery can be set in CreateDatasetRequest. The SavedQuery should not contain any AnnotationSpec.
         */
        savedQueries?: Schema$GoogleCloudAiplatformV1SavedQuery[];
        /**
         * Output only. Timestamp when this Dataset was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Describes the dataset version.
     */
    export interface Schema$GoogleCloudAiplatformV1DatasetVersion {
        /**
         * Output only. Name of the associated BigQuery dataset.
         */
        bigQueryDatasetName?: string | null;
        /**
         * Output only. Timestamp when this DatasetVersion was created.
         */
        createTime?: string | null;
        /**
         * The user-defined name of the DatasetVersion. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Required. Output only. Additional information about the DatasetVersion.
         */
        metadata?: any | null;
        /**
         * Output only. Reference to the public base model last used by the dataset version. Only set for prompt dataset versions.
         */
        modelReference?: string | null;
        /**
         * Output only. Identifier. The resource name of the DatasetVersion. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}/datasetVersions/{dataset_version\}`
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Timestamp when this DatasetVersion was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * A description of resources that are dedicated to a DeployedModel or DeployedIndex, and that need a higher degree of manual configuration.
     */
    export interface Schema$GoogleCloudAiplatformV1DedicatedResources {
        /**
         * Immutable. The metric specifications that overrides a resource utilization metric (CPU utilization, accelerator's duty cycle, and so on) target value (default to 60 if not set). At most one entry is allowed per metric. If machine_spec.accelerator_count is above 0, the autoscaling will be based on both CPU utilization and accelerator's duty cycle metrics and scale up when either metrics exceeds its target value while scale down if both metrics are under their target value. The default target value is 60 for both metrics. If machine_spec.accelerator_count is 0, the autoscaling will be based on CPU utilization metric only with default target value 60 if not explicitly set. For example, in the case of Online Prediction, if you want to override target CPU utilization to 80, you should set autoscaling_metric_specs.metric_name to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and autoscaling_metric_specs.target to `80`.
         */
        autoscalingMetricSpecs?: Schema$GoogleCloudAiplatformV1AutoscalingMetricSpec[];
        /**
         * Required. Immutable. The specification of a single machine being used.
         */
        machineSpec?: Schema$GoogleCloudAiplatformV1MachineSpec;
        /**
         * Immutable. The maximum number of replicas that may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale to that many replicas is guaranteed (barring service outages). If traffic increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, will use min_replica_count as the default value. The value of this field impacts the charge against Vertex CPU and GPU quotas. Specifically, you will be charged for (max_replica_count * number of cores in the selected machine type) and (max_replica_count * number of GPUs per replica in the selected machine type).
         */
        maxReplicaCount?: number | null;
        /**
         * Required. Immutable. The minimum number of machine replicas that will be always deployed on. This value must be greater than or equal to 1. If traffic increases, it may dynamically be deployed onto more replicas, and as traffic decreases, some of these extra replicas may be freed.
         */
        minReplicaCount?: number | null;
        /**
         * Optional. Number of required available replicas for the deployment to succeed. This field is only needed when partial deployment/mutation is desired. If set, the deploy/mutate operation will succeed once available_replica_count reaches required_replica_count, and the rest of the replicas will be retried. If not set, the default required_replica_count will be min_replica_count.
         */
        requiredReplicaCount?: number | null;
        /**
         * Optional. If true, schedule the deployment workload on [spot VMs](https://cloud.google.com/kubernetes-engine/docs/concepts/spot-vms).
         */
        spot?: boolean | null;
    }
    /**
     * Details of operations that delete Feature values.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata {
        /**
         * Operation metadata for Featurestore delete Features values.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for FeaturestoreService.DeleteFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteFeatureValuesRequest {
        /**
         * Select feature values to be deleted by specifying entities.
         */
        selectEntity?: Schema$GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity;
        /**
         * Select feature values to be deleted by specifying time range and features.
         */
        selectTimeRangeAndFeature?: Schema$GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature;
    }
    /**
     * Message to select entity. If an entity id is selected, all the feature values corresponding to the entity id will be deleted, including the entityId.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity {
        /**
         * Required. Selectors choosing feature values of which entity id to be deleted from the EntityType.
         */
        entityIdSelector?: Schema$GoogleCloudAiplatformV1EntityIdSelector;
    }
    /**
     * Message to select time range and feature. Values of the selected feature generated within an inclusive time range will be deleted. Using this option permanently deletes the feature values from the specified feature IDs within the specified time range. This might include data from the online storage. If you want to retain any deleted historical data in the online storage, you must re-ingest it.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature {
        /**
         * Required. Selectors choosing which feature values to be deleted from the EntityType.
         */
        featureSelector?: Schema$GoogleCloudAiplatformV1FeatureSelector;
        /**
         * If set, data will not be deleted from online storage. When time range is older than the data in online storage, setting this to be true will make the deletion have no impact on online serving.
         */
        skipOnlineStorageDelete?: boolean | null;
        /**
         * Required. Select feature generated within a half-inclusive time range. The time range is lower inclusive and upper exclusive.
         */
        timeRange?: Schema$GoogleTypeInterval;
    }
    /**
     * Response message for FeaturestoreService.DeleteFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteFeatureValuesResponse {
        /**
         * Response for request specifying the entities to delete
         */
        selectEntity?: Schema$GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity;
        /**
         * Response for request specifying time range and feature
         */
        selectTimeRangeAndFeature?: Schema$GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature;
    }
    /**
     * Response message if the request uses the SelectEntity option.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity {
        /**
         * The count of deleted entity rows in the offline storage. Each row corresponds to the combination of an entity ID and a timestamp. One entity ID can have multiple rows in the offline storage.
         */
        offlineStorageDeletedEntityRowCount?: string | null;
        /**
         * The count of deleted entities in the online storage. Each entity ID corresponds to one entity.
         */
        onlineStorageDeletedEntityCount?: string | null;
    }
    /**
     * Response message if the request uses the SelectTimeRangeAndFeature option.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature {
        /**
         * The count of the features or columns impacted. This is the same as the feature count in the request.
         */
        impactedFeatureCount?: string | null;
        /**
         * The count of modified entity rows in the offline storage. Each row corresponds to the combination of an entity ID and a timestamp. One entity ID can have multiple rows in the offline storage. Within each row, only the features specified in the request are deleted.
         */
        offlineStorageModifiedEntityRowCount?: string | null;
        /**
         * The count of modified entities in the online storage. Each entity ID corresponds to one entity. Within each entity, only the features specified in the request are deleted.
         */
        onlineStorageModifiedEntityCount?: string | null;
    }
    /**
     * Details of operations that perform MetadataService.DeleteMetadataStore.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata {
        /**
         * Operation metadata for deleting a MetadataStore.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform deletes of any entities.
     */
    export interface Schema$GoogleCloudAiplatformV1DeleteOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * A deployment of an Index. IndexEndpoints contain one or more DeployedIndexes.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployedIndex {
        /**
         * Optional. A description of resources that the DeployedIndex uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration. If min_replica_count is not set, the default value is 2 (we don't provide SLA when min_replica_count=1). If max_replica_count is not set, the default value is min_replica_count. The max allowed replica count is 1000.
         */
        automaticResources?: Schema$GoogleCloudAiplatformV1AutomaticResources;
        /**
         * Output only. Timestamp when the DeployedIndex was created.
         */
        createTime?: string | null;
        /**
         * Optional. A description of resources that are dedicated to the DeployedIndex, and that need a higher degree of manual configuration. The field min_replica_count must be set to a value strictly greater than 0, or else validation will fail. We don't provide SLA when min_replica_count=1. If max_replica_count is not set, the default value is min_replica_count. The max allowed replica count is 1000. Available machine types for SMALL shard: e2-standard-2 and all machine types available for MEDIUM and LARGE shard. Available machine types for MEDIUM shard: e2-standard-16 and all machine types available for LARGE shard. Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32. n1-standard-16 and n1-standard-32 are still available, but we recommend e2-standard-16 and e2-highmem-16 for cost efficiency.
         */
        dedicatedResources?: Schema$GoogleCloudAiplatformV1DedicatedResources;
        /**
         * Optional. If set, the authentication is enabled for the private endpoint.
         */
        deployedIndexAuthConfig?: Schema$GoogleCloudAiplatformV1DeployedIndexAuthConfig;
        /**
         * Optional. The deployment group can be no longer than 64 characters (eg: 'test', 'prod'). If not set, we will use the 'default' deployment group. Creating `deployment_groups` with `reserved_ip_ranges` is a recommended practice when the peered network has multiple peering ranges. This creates your deployments from predictable IP spaces for easier traffic administration. Also, one deployment_group (except 'default') can only be used with the same reserved_ip_ranges which means if the deployment_group has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or [d, e] is disallowed. Note: we only support up to 5 deployment groups(not including 'default').
         */
        deploymentGroup?: string | null;
        /**
         * The display name of the DeployedIndex. If not provided upon creation, the Index's display_name is used.
         */
        displayName?: string | null;
        /**
         * Optional. If true, private endpoint's access logs are sent to Cloud Logging. These logs are like standard server access logs, containing information like timestamp and latency for each MatchRequest. Note that logs may incur a cost, especially if the deployed index receives a high queries per second rate (QPS). Estimate your costs before enabling this option.
         */
        enableAccessLogging?: boolean | null;
        /**
         * Required. The user specified ID of the DeployedIndex. The ID can be up to 128 characters long and must start with a letter and only contain letters, numbers, and underscores. The ID must be unique within the project it is created in.
         */
        id?: string | null;
        /**
         * Required. The name of the Index this is the deployment of. We may refer to this Index as the DeployedIndex's "original" Index.
         */
        index?: string | null;
        /**
         * Output only. The DeployedIndex may depend on various data on its original Index. Additionally when certain changes to the original Index are being done (e.g. when what the Index contains is being changed) the DeployedIndex may be asynchronously updated in the background to reflect these changes. If this timestamp's value is at least the Index.update_time of the original Index, it means that this DeployedIndex and the original Index are in sync. If this timestamp is older, then to see which updates this DeployedIndex already contains (and which it does not), one must list the operations that are running on the original Index. Only the successfully completed Operations with update_time equal or before this sync time are contained in this DeployedIndex.
         */
        indexSyncTime?: string | null;
        /**
         * Output only. Provides paths for users to send requests directly to the deployed index services running on Cloud via private services access. This field is populated if network is configured.
         */
        privateEndpoints?: Schema$GoogleCloudAiplatformV1IndexPrivateEndpoints;
        /**
         * Optional. If set for PSC deployed index, PSC connection will be automatically created after deployment is done and the endpoint information is populated in private_endpoints.psc_automated_endpoints.
         */
        pscAutomationConfigs?: Schema$GoogleCloudAiplatformV1PSCAutomationConfig[];
        /**
         * Optional. A list of reserved ip ranges under the VPC network that can be used for this DeployedIndex. If set, we will deploy the index within the provided ip ranges. Otherwise, the index might be deployed to any ip ranges under the provided VPC network. The value should be the name of the address (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example: ['vertex-ai-ip-range']. For more information about subnets and network IP ranges, please see https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
         */
        reservedIpRanges?: string[] | null;
    }
    /**
     * Used to set up the auth on the DeployedIndex's private endpoint.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployedIndexAuthConfig {
        /**
         * Defines the authentication provider that the DeployedIndex uses.
         */
        authProvider?: Schema$GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider;
    }
    /**
     * Configuration for an authentication provider, including support for [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
     */
    export interface Schema$GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider {
        /**
         * A list of allowed JWT issuers. Each entry must be a valid Google service account, in the following format: `service-account-name@project-id.iam.gserviceaccount.com`
         */
        allowedIssuers?: string[] | null;
        /**
         * The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted.
         */
        audiences?: string[] | null;
    }
    /**
     * Points to a DeployedIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployedIndexRef {
        /**
         * Immutable. The ID of the DeployedIndex in the above IndexEndpoint.
         */
        deployedIndexId?: string | null;
        /**
         * Output only. The display name of the DeployedIndex.
         */
        displayName?: string | null;
        /**
         * Immutable. A resource name of the IndexEndpoint.
         */
        indexEndpoint?: string | null;
    }
    /**
     * A deployment of a Model. Endpoints contain one or more DeployedModels.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployedModel {
        /**
         * A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
         */
        automaticResources?: Schema$GoogleCloudAiplatformV1AutomaticResources;
        /**
         * Output only. Timestamp when the DeployedModel was created.
         */
        createTime?: string | null;
        /**
         * A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
         */
        dedicatedResources?: Schema$GoogleCloudAiplatformV1DedicatedResources;
        /**
         * For custom-trained Models and AutoML Tabular Models, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Cloud Logging by default. Please note that the logs incur cost, which are subject to [Cloud Logging pricing](https://cloud.google.com/logging/pricing). User can disable container logging by setting this flag to true.
         */
        disableContainerLogging?: boolean | null;
        /**
         * If true, deploy the model without explainable feature, regardless the existence of Model.explanation_spec or explanation_spec.
         */
        disableExplanations?: boolean | null;
        /**
         * The display name of the DeployedModel. If not provided upon creation, the Model's display_name is used.
         */
        displayName?: string | null;
        /**
         * If true, online prediction access logs are sent to Cloud Logging. These logs are like standard server access logs, containing information like timestamp and latency for each prediction request. Note that logs may incur a cost, especially if your project receives prediction requests at a high queries per second rate (QPS). Estimate your costs before enabling this option.
         */
        enableAccessLogging?: boolean | null;
        /**
         * Explanation configuration for this DeployedModel. When deploying a Model using EndpointService.DeployModel, this value overrides the value of Model.explanation_spec. All fields of explanation_spec are optional in the request. If a field of explanation_spec is not populated, the value of the same field of Model.explanation_spec is inherited. If the corresponding Model.explanation_spec is not populated, all fields of the explanation_spec will be used for the explanation configuration.
         */
        explanationSpec?: Schema$GoogleCloudAiplatformV1ExplanationSpec;
        /**
         * Configuration for faster model deployment.
         */
        fasterDeploymentConfig?: Schema$GoogleCloudAiplatformV1FasterDeploymentConfig;
        /**
         * Immutable. The ID of the DeployedModel. If not provided upon deployment, Vertex AI will generate a value for this ID. This value should be 1-10 characters, and valid characters are `/[0-9]/`.
         */
        id?: string | null;
        /**
         * Required. The resource name of the Model that this is the deployment of. Note that the Model may be in a different location than the DeployedModel's Endpoint. The resource name may contain version id or version alias to specify the version. Example: `projects/{project\}/locations/{location\}/models/{model\}@2` or `projects/{project\}/locations/{location\}/models/{model\}@golden` if no version is specified, the default version will be deployed.
         */
        model?: string | null;
        /**
         * Output only. The version ID of the model that is deployed.
         */
        modelVersionId?: string | null;
        /**
         * Output only. Provide paths for users to send predict/explain/health requests directly to the deployed model services running on Cloud via private services access. This field is populated if network is configured.
         */
        privateEndpoints?: Schema$GoogleCloudAiplatformV1PrivateEndpoints;
        /**
         * The service account that the DeployedModel's container runs as. Specify the email address of the service account. If this service account is not specified, the container runs as a service account that doesn't have access to the resource project. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
         */
        serviceAccount?: string | null;
        /**
         * The resource name of the shared DeploymentResourcePool to deploy on. Format: `projects/{project\}/locations/{location\}/deploymentResourcePools/{deployment_resource_pool\}`
         */
        sharedResources?: string | null;
        /**
         * Optional. Spec for configuring speculative decoding.
         */
        speculativeDecodingSpec?: Schema$GoogleCloudAiplatformV1SpeculativeDecodingSpec;
        /**
         * Output only. Runtime status of the deployed model.
         */
        status?: Schema$GoogleCloudAiplatformV1DeployedModelStatus;
        /**
         * System labels to apply to Model Garden deployments. System labels are managed by Google for internal use only.
         */
        systemLabels?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Points to a DeployedModel.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployedModelRef {
        /**
         * Immutable. An ID of a DeployedModel in the above Endpoint.
         */
        deployedModelId?: string | null;
        /**
         * Immutable. A resource name of an Endpoint.
         */
        endpoint?: string | null;
    }
    /**
     * Runtime status of the deployed model.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployedModelStatus {
        /**
         * Output only. The number of available replicas of the deployed model.
         */
        availableReplicaCount?: number | null;
        /**
         * Output only. The time at which the status was last updated.
         */
        lastUpdateTime?: string | null;
        /**
         * Output only. The latest deployed model's status message (if any).
         */
        message?: string | null;
    }
    /**
     * Runtime operation information for IndexEndpointService.DeployIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployIndexOperationMetadata {
        /**
         * The unique index id specified by user
         */
        deployedIndexId?: string | null;
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for IndexEndpointService.DeployIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployIndexRequest {
        /**
         * Required. The DeployedIndex to be created within the IndexEndpoint.
         */
        deployedIndex?: Schema$GoogleCloudAiplatformV1DeployedIndex;
    }
    /**
     * Response message for IndexEndpointService.DeployIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployIndexResponse {
        /**
         * The DeployedIndex that had been deployed in the IndexEndpoint.
         */
        deployedIndex?: Schema$GoogleCloudAiplatformV1DeployedIndex;
    }
    /**
     * A description of resources that can be shared by multiple DeployedModels, whose underlying specification consists of a DedicatedResources.
     */
    export interface Schema$GoogleCloudAiplatformV1DeploymentResourcePool {
        /**
         * Output only. Timestamp when this DeploymentResourcePool was created.
         */
        createTime?: string | null;
        /**
         * Required. The underlying DedicatedResources that the DeploymentResourcePool uses.
         */
        dedicatedResources?: Schema$GoogleCloudAiplatformV1DedicatedResources;
        /**
         * If the DeploymentResourcePool is deployed with custom-trained Models or AutoML Tabular Models, the container(s) of the DeploymentResourcePool will send `stderr` and `stdout` streams to Cloud Logging by default. Please note that the logs incur cost, which are subject to [Cloud Logging pricing](https://cloud.google.com/logging/pricing). User can disable container logging by setting this flag to true.
         */
        disableContainerLogging?: boolean | null;
        /**
         * Customer-managed encryption key spec for a DeploymentResourcePool. If set, this DeploymentResourcePool will be secured by this key. Endpoints and the DeploymentResourcePool they deploy in need to have the same EncryptionSpec.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Immutable. The resource name of the DeploymentResourcePool. Format: `projects/{project\}/locations/{location\}/deploymentResourcePools/{deployment_resource_pool\}`
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * The service account that the DeploymentResourcePool's container(s) run as. Specify the email address of the service account. If this service account is not specified, the container(s) run as a service account that doesn't have access to the resource project. Users deploying the Models to this DeploymentResourcePool must have the `iam.serviceAccounts.actAs` permission on this service account.
         */
        serviceAccount?: string | null;
    }
    /**
     * Runtime operation information for EndpointService.DeployModel.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployModelOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for EndpointService.DeployModel.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployModelRequest {
        /**
         * Required. The DeployedModel to be created within the Endpoint. Note that Endpoint.traffic_split must be updated for the DeployedModel to start receiving traffic, either as part of this call, or via EndpointService.UpdateEndpoint.
         */
        deployedModel?: Schema$GoogleCloudAiplatformV1DeployedModel;
        /**
         * A map from a DeployedModel's ID to the percentage of this Endpoint's traffic that should be forwarded to that DeployedModel. If this field is non-empty, then the Endpoint's traffic_split will be overwritten with it. To refer to the ID of the just being deployed Model, a "0" should be used, and the actual ID of the new DeployedModel will be filled in its place by this method. The traffic percentage values must add up to 100. If this field is empty, then the Endpoint's traffic_split is not updated.
         */
        trafficSplit?: {
            [key: string]: number;
        } | null;
    }
    /**
     * Response message for EndpointService.DeployModel.
     */
    export interface Schema$GoogleCloudAiplatformV1DeployModelResponse {
        /**
         * The DeployedModel that had been deployed in the Endpoint.
         */
        deployedModel?: Schema$GoogleCloudAiplatformV1DeployedModel;
    }
    export interface Schema$GoogleCloudAiplatformV1DestinationFeatureSetting {
        /**
         * Specify the field name in the export destination. If not specified, Feature ID is used.
         */
        destinationField?: string | null;
        /**
         * Required. The ID of the Feature to apply the setting to.
         */
        featureId?: string | null;
    }
    /**
     * Request message for PredictionService.DirectPredict.
     */
    export interface Schema$GoogleCloudAiplatformV1DirectPredictRequest {
        /**
         * The prediction input.
         */
        inputs?: Schema$GoogleCloudAiplatformV1Tensor[];
        /**
         * The parameters that govern the prediction.
         */
        parameters?: Schema$GoogleCloudAiplatformV1Tensor;
    }
    /**
     * Response message for PredictionService.DirectPredict.
     */
    export interface Schema$GoogleCloudAiplatformV1DirectPredictResponse {
        /**
         * The prediction output.
         */
        outputs?: Schema$GoogleCloudAiplatformV1Tensor[];
        /**
         * The parameters that govern the prediction.
         */
        parameters?: Schema$GoogleCloudAiplatformV1Tensor;
    }
    /**
     * Request message for PredictionService.DirectRawPredict.
     */
    export interface Schema$GoogleCloudAiplatformV1DirectRawPredictRequest {
        /**
         * The prediction input.
         */
        input?: string | null;
        /**
         * Fully qualified name of the API method being invoked to perform predictions. Format: `/namespace.Service/Method/` Example: `/tensorflow.serving.PredictionService/Predict`
         */
        methodName?: string | null;
    }
    /**
     * Response message for PredictionService.DirectRawPredict.
     */
    export interface Schema$GoogleCloudAiplatformV1DirectRawPredictResponse {
        /**
         * The prediction output.
         */
        output?: string | null;
    }
    /**
     * The input content is encapsulated and uploaded in the request.
     */
    export interface Schema$GoogleCloudAiplatformV1DirectUploadSource {
    }
    /**
     * Represents the spec of disk options.
     */
    export interface Schema$GoogleCloudAiplatformV1DiskSpec {
        /**
         * Size in GB of the boot disk (default is 100GB).
         */
        bootDiskSizeGb?: number | null;
        /**
         * Type of the boot disk. For non-A3U machines, the default value is "pd-ssd", for A3U machines, the default value is "hyperdisk-balanced". Valid values: "pd-ssd" (Persistent Disk Solid State Drive), "pd-standard" (Persistent Disk Hard Disk Drive) or "hyperdisk-balanced".
         */
        bootDiskType?: string | null;
    }
    /**
     * A list of double values.
     */
    export interface Schema$GoogleCloudAiplatformV1DoubleArray {
        /**
         * A list of double values.
         */
        values?: number[] | null;
    }
    /**
     * Describes the options to customize dynamic retrieval.
     */
    export interface Schema$GoogleCloudAiplatformV1DynamicRetrievalConfig {
        /**
         * Optional. The threshold to be used in dynamic retrieval. If not set, a system default value is used.
         */
        dynamicThreshold?: number | null;
        /**
         * The mode of the predictor to be used in dynamic retrieval.
         */
        mode?: string | null;
    }
    /**
     * Represents a customer-managed encryption key spec that can be applied to a top-level resource.
     */
    export interface Schema$GoogleCloudAiplatformV1EncryptionSpec {
        /**
         * Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`. The key needs to be in the same region as where the compute resource is created.
         */
        kmsKeyName?: string | null;
    }
    /**
     * Models are deployed into it, and afterwards Endpoint is called to obtain predictions and explanations.
     */
    export interface Schema$GoogleCloudAiplatformV1Endpoint {
        /**
         * Configurations that are applied to the endpoint for online prediction.
         */
        clientConnectionConfig?: Schema$GoogleCloudAiplatformV1ClientConnectionConfig;
        /**
         * Output only. Timestamp when this Endpoint was created.
         */
        createTime?: string | null;
        /**
         * Output only. DNS of the dedicated endpoint. Will only be populated if dedicated_endpoint_enabled is true. Depending on the features enabled, uid might be a random number or a string. For example, if fast_tryout is enabled, uid will be fasttryout. Format: `https://{endpoint_id\}.{region\}-{uid\}.prediction.vertexai.goog`.
         */
        dedicatedEndpointDns?: string | null;
        /**
         * If true, the endpoint will be exposed through a dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to the dedicated DNS will be isolated from other users' traffic and will have better performance and reliability. Note: Once you enabled dedicated endpoint, you won't be able to send request to the shared DNS {region\}-aiplatform.googleapis.com. The limitation will be removed soon.
         */
        dedicatedEndpointEnabled?: boolean | null;
        /**
         * Output only. The models deployed in this Endpoint. To add or remove DeployedModels use EndpointService.DeployModel and EndpointService.UndeployModel respectively.
         */
        deployedModels?: Schema$GoogleCloudAiplatformV1DeployedModel[];
        /**
         * The description of the Endpoint.
         */
        description?: string | null;
        /**
         * Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Deprecated: If true, expose the Endpoint via private service connect. Only one of the fields, network or enable_private_service_connect, can be set.
         */
        enablePrivateServiceConnect?: boolean | null;
        /**
         * Customer-managed encryption key spec for an Endpoint. If set, this Endpoint and all sub-resources of this Endpoint will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. Configuration for GenAiAdvancedFeatures. If the endpoint is serving GenAI models, advanced features like native RAG integration can be configured. Currently, only Model Garden models are supported.
         */
        genAiAdvancedFeaturesConfig?: Schema$GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfig;
        /**
         * The labels with user-defined metadata to organize your Endpoints. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Resource name of the Model Monitoring job associated with this Endpoint if monitoring is enabled by JobService.CreateModelDeploymentMonitoringJob. Format: `projects/{project\}/locations/{location\}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job\}`
         */
        modelDeploymentMonitoringJob?: string | null;
        /**
         * Output only. The resource name of the Endpoint.
         */
        name?: string | null;
        /**
         * Optional. The full name of the Google Compute Engine [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks) to which the Endpoint should be peered. Private services access must already be configured for the network. If left unspecified, the Endpoint is not peered with any network. Only one of the fields, network or enable_private_service_connect, can be set. [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert): `projects/{project\}/global/networks/{network\}`. Where `{project\}` is a project number, as in `12345`, and `{network\}` is network name.
         */
        network?: string | null;
        /**
         * Configures the request-response logging for online prediction.
         */
        predictRequestResponseLoggingConfig?: Schema$GoogleCloudAiplatformV1PredictRequestResponseLoggingConfig;
        /**
         * Optional. Configuration for private service connect. network and private_service_connect_config are mutually exclusive.
         */
        privateServiceConnectConfig?: Schema$GoogleCloudAiplatformV1PrivateServiceConnectConfig;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * A map from a DeployedModel's ID to the percentage of this Endpoint's traffic that should be forwarded to that DeployedModel. If a DeployedModel's ID is not listed in this map, then it receives no traffic. The traffic percentage values must add up to 100, or map must be empty if the Endpoint is to not accept any traffic at a moment.
         */
        trafficSplit?: {
            [key: string]: number;
        } | null;
        /**
         * Output only. Timestamp when this Endpoint was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Tool to search public web data, powered by Vertex AI Search and Sec4 compliance.
     */
    export interface Schema$GoogleCloudAiplatformV1EnterpriseWebSearch {
    }
    /**
     * Selector for entityId. Getting ids from the given source.
     */
    export interface Schema$GoogleCloudAiplatformV1EntityIdSelector {
        /**
         * Source of Csv
         */
        csvSource?: Schema$GoogleCloudAiplatformV1CsvSource;
        /**
         * Source column that holds entity IDs. If not provided, entity IDs are extracted from the column named entity_id.
         */
        entityIdField?: string | null;
    }
    /**
     * An entity type is a type of object in a system that needs to be modeled and have stored information about. For example, driver is an entity type, and driver0 is an instance of an entity type driver.
     */
    export interface Schema$GoogleCloudAiplatformV1EntityType {
        /**
         * Output only. Timestamp when this EntityType was created.
         */
        createTime?: string | null;
        /**
         * Optional. Description of the EntityType.
         */
        description?: string | null;
        /**
         * Optional. Used to perform a consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize your EntityTypes. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information on and examples of labels. No more than 64 user labels can be associated with one EntityType (System labels are excluded)." System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. The default monitoring configuration for all Features with value type (Feature.ValueType) BOOL, STRING, DOUBLE or INT64 under this EntityType. If this is populated with [FeaturestoreMonitoringConfig.monitoring_interval] specified, snapshot analysis monitoring is enabled. Otherwise, snapshot analysis monitoring is disabled.
         */
        monitoringConfig?: Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfig;
        /**
         * Immutable. Name of the EntityType. Format: `projects/{project\}/locations/{location\}/featurestores/{featurestore\}/entityTypes/{entity_type\}` The last part entity_type is assigned by the client. The entity_type can be up to 64 characters long and can consist only of ASCII Latin letters A-Z and a-z and underscore(_), and ASCII digits 0-9 starting with a letter. The value will be unique given a featurestore.
         */
        name?: string | null;
        /**
         * Optional. Config for data retention policy in offline storage. TTL in days for feature values that will be stored in offline storage. The Feature Store offline storage periodically removes obsolete feature values older than `offline_storage_ttl_days` since the feature generation time. If unset (or explicitly set to 0), default to 4000 days TTL.
         */
        offlineStorageTtlDays?: number | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Timestamp when this EntityType was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * Represents an environment variable present in a Container or Python Module.
     */
    export interface Schema$GoogleCloudAiplatformV1EnvVar {
        /**
         * Required. Name of the environment variable. Must be a valid C identifier.
         */
        name?: string | null;
        /**
         * Required. Variables that reference a $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not.
         */
        value?: string | null;
    }
    /**
     * Model error analysis for each annotation.
     */
    export interface Schema$GoogleCloudAiplatformV1ErrorAnalysisAnnotation {
        /**
         * Attributed items for a given annotation, typically representing neighbors from the training sets constrained by the query type.
         */
        attributedItems?: Schema$GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem[];
        /**
         * The outlier score of this annotated item. Usually defined as the min of all distances from attributed items.
         */
        outlierScore?: number | null;
        /**
         * The threshold used to determine if this annotation is an outlier or not.
         */
        outlierThreshold?: number | null;
        /**
         * The query type used for finding the attributed items.
         */
        queryType?: string | null;
    }
    /**
     * Attributed items for a given annotation, typically representing neighbors from the training sets constrained by the query type.
     */
    export interface Schema$GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem {
        /**
         * The unique ID for each annotation. Used by FE to allocate the annotation in DB.
         */
        annotationResourceName?: string | null;
        /**
         * The distance of this item to the annotation.
         */
        distance?: number | null;
    }
    /**
     * True positive, false positive, or false negative. EvaluatedAnnotation is only available under ModelEvaluationSlice with slice of `annotationSpec` dimension.
     */
    export interface Schema$GoogleCloudAiplatformV1EvaluatedAnnotation {
        /**
         * Output only. The data item payload that the Model predicted this EvaluatedAnnotation on.
         */
        dataItemPayload?: any | null;
        /**
         * Annotations of model error analysis results.
         */
        errorAnalysisAnnotations?: Schema$GoogleCloudAiplatformV1ErrorAnalysisAnnotation[];
        /**
         * Output only. ID of the EvaluatedDataItemView under the same ancestor ModelEvaluation. The EvaluatedDataItemView consists of all ground truths and predictions on data_item_payload.
         */
        evaluatedDataItemViewId?: string | null;
        /**
         * Explanations of predictions. Each element of the explanations indicates the explanation for one explanation Method. The attributions list in the EvaluatedAnnotationExplanation.explanation object corresponds to the predictions list. For example, the second element in the attributions list explains the second element in the predictions list.
         */
        explanations?: Schema$GoogleCloudAiplatformV1EvaluatedAnnotationExplanation[];
        /**
         * Output only. The ground truth Annotations, i.e. the Annotations that exist in the test data the Model is evaluated on. For true positive, there is one and only one ground truth annotation, which matches the only prediction in predictions. For false positive, there are zero or more ground truth annotations that are similar to the only prediction in predictions, but not enough for a match. For false negative, there is one and only one ground truth annotation, which doesn't match any predictions created by the model. The schema of the ground truth is stored in ModelEvaluation.annotation_schema_uri
         */
        groundTruths?: any[] | null;
        /**
         * Output only. The model predicted annotations. For true positive, there is one and only one prediction, which matches the only one ground truth annotation in ground_truths. For false positive, there is one and only one prediction, which doesn't match any ground truth annotation of the corresponding data_item_view_id. For false negative, there are zero or more predictions which are similar to the only ground truth annotation in ground_truths but not enough for a match. The schema of the prediction is stored in ModelEvaluation.annotation_schema_uri
         */
        predictions?: any[] | null;
        /**
         * Output only. Type of the EvaluatedAnnotation.
         */
        type?: string | null;
    }
    /**
     * Explanation result of the prediction produced by the Model.
     */
    export interface Schema$GoogleCloudAiplatformV1EvaluatedAnnotationExplanation {
        /**
         * Explanation attribution response details.
         */
        explanation?: Schema$GoogleCloudAiplatformV1Explanation;
        /**
         * Explanation type. For AutoML Image Classification models, possible values are: * `image-integrated-gradients` * `image-xrai`
         */
        explanationType?: string | null;
    }
    /**
     * Request message for EvaluationService.EvaluateDataset.
     */
    export interface Schema$GoogleCloudAiplatformV1EvaluateDatasetRequest {
        /**
         * Optional. Autorater config used for evaluation. Currently only publisher Gemini models are supported. Format: `projects/{PROJECT\}/locations/{LOCATION\}/publishers/google/models/{MODEL\}.`
         */
        autoraterConfig?: Schema$GoogleCloudAiplatformV1AutoraterConfig;
        /**
         * Required. The dataset used for evaluation.
         */
        dataset?: Schema$GoogleCloudAiplatformV1EvaluationDataset;
        /**
         * Required. The metrics used for evaluation.
         */
        metrics?: Schema$GoogleCloudAiplatformV1Metric[];
        /**
         * Required. Config for evaluation output.
         */
        outputConfig?: Schema$GoogleCloudAiplatformV1OutputConfig;
    }
    /**
     * Request message for EvaluationService.EvaluateInstances.
     */
    export interface Schema$GoogleCloudAiplatformV1EvaluateInstancesRequest {
        /**
         * Optional. Autorater config used for evaluation.
         */
        autoraterConfig?: Schema$GoogleCloudAiplatformV1AutoraterConfig;
        /**
         * Instances and metric spec for bleu metric.
         */
        bleuInput?: Schema$GoogleCloudAiplatformV1BleuInput;
        /**
         * Input for coherence metric.
         */
        coherenceInput?: Schema$GoogleCloudAiplatformV1CoherenceInput;
        /**
         * Translation metrics. Input for Comet metric.
         */
        cometInput?: Schema$GoogleCloudAiplatformV1CometInput;
        /**
         * Auto metric instances. Instances and metric spec for exact match metric.
         */
        exactMatchInput?: Schema$GoogleCloudAiplatformV1ExactMatchInput;
        /**
         * LLM-based metric instance. General text generation metrics, applicable to other categories. Input for fluency metric.
         */
        fluencyInput?: Schema$GoogleCloudAiplatformV1FluencyInput;
        /**
         * Input for fulfillment metric.
         */
        fulfillmentInput?: Schema$GoogleCloudAiplatformV1FulfillmentInput;
        /**
         * Input for groundedness metric.
         */
        groundednessInput?: Schema$GoogleCloudAiplatformV1GroundednessInput;
        /**
         * Input for Metricx metric.
         */
        metricxInput?: Schema$GoogleCloudAiplatformV1MetricxInput;
        /**
         * Input for pairwise metric.
         */
        pairwiseMetricInput?: Schema$GoogleCloudAiplatformV1PairwiseMetricInput;
        /**
         * Input for pairwise question answering quality metric.
         */
        pairwiseQuestionAnsweringQualityInput?: Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityInput;
        /**
         * Input for pairwise summarization quality metric.
         */
        pairwiseSummarizationQualityInput?: Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualityInput;
        /**
         * Input for pointwise metric.
         */
        pointwiseMetricInput?: Schema$GoogleCloudAiplatformV1PointwiseMetricInput;
        /**
         * Input for question answering correctness metric.
         */
        questionAnsweringCorrectnessInput?: Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessInput;
        /**
         * Input for question answering helpfulness metric.
         */
        questionAnsweringHelpfulnessInput?: Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessInput;
        /**
         * Input for question answering quality metric.
         */
        questionAnsweringQualityInput?: Schema$GoogleCloudAiplatformV1QuestionAnsweringQualityInput;
        /**
         * Input for question answering relevance metric.
         */
        questionAnsweringRelevanceInput?: Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceInput;
        /**
         * Instances and metric spec for rouge metric.
         */
        rougeInput?: Schema$GoogleCloudAiplatformV1RougeInput;
        /**
         * Rubric Based Instruction Following metric.
         */
        rubricBasedInstructionFollowingInput?: Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingInput;
        /**
         * Input for safety metric.
         */
        safetyInput?: Schema$GoogleCloudAiplatformV1SafetyInput;
        /**
         * Input for summarization helpfulness metric.
         */
        summarizationHelpfulnessInput?: Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessInput;
        /**
         * Input for summarization quality metric.
         */
        summarizationQualityInput?: Schema$GoogleCloudAiplatformV1SummarizationQualityInput;
        /**
         * Input for summarization verbosity metric.
         */
        summarizationVerbosityInput?: Schema$GoogleCloudAiplatformV1SummarizationVerbosityInput;
        /**
         * Tool call metric instances. Input for tool call valid metric.
         */
        toolCallValidInput?: Schema$GoogleCloudAiplatformV1ToolCallValidInput;
        /**
         * Input for tool name match metric.
         */
        toolNameMatchInput?: Schema$GoogleCloudAiplatformV1ToolNameMatchInput;
        /**
         * Input for tool parameter key match metric.
         */
        toolParameterKeyMatchInput?: Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchInput;
        /**
         * Input for tool parameter key value match metric.
         */
        toolParameterKvMatchInput?: Schema$GoogleCloudAiplatformV1ToolParameterKVMatchInput;
        /**
         * Input for trajectory match any order metric.
         */
        trajectoryAnyOrderMatchInput?: Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchInput;
        /**
         * Input for trajectory exact match metric.
         */
        trajectoryExactMatchInput?: Schema$GoogleCloudAiplatformV1TrajectoryExactMatchInput;
        /**
         * Input for trajectory in order match metric.
         */
        trajectoryInOrderMatchInput?: Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchInput;
        /**
         * Input for trajectory precision metric.
         */
        trajectoryPrecisionInput?: Schema$GoogleCloudAiplatformV1TrajectoryPrecisionInput;
        /**
         * Input for trajectory recall metric.
         */
        trajectoryRecallInput?: Schema$GoogleCloudAiplatformV1TrajectoryRecallInput;
        /**
         * Input for trajectory single tool use metric.
         */
        trajectorySingleToolUseInput?: Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseInput;
    }
    /**
     * Response message for EvaluationService.EvaluateInstances.
     */
    export interface Schema$GoogleCloudAiplatformV1EvaluateInstancesResponse {
        /**
         * Results for bleu metric.
         */
        bleuResults?: Schema$GoogleCloudAiplatformV1BleuResults;
        /**
         * Result for coherence metric.
         */
        coherenceResult?: Schema$GoogleCloudAiplatformV1CoherenceResult;
        /**
         * Translation metrics. Result for Comet metric.
         */
        cometResult?: Schema$GoogleCloudAiplatformV1CometResult;
        /**
         * Auto metric evaluation results. Results for exact match metric.
         */
        exactMatchResults?: Schema$GoogleCloudAiplatformV1ExactMatchResults;
        /**
         * LLM-based metric evaluation result. General text generation metrics, applicable to other categories. Result for fluency metric.
         */
        fluencyResult?: Schema$GoogleCloudAiplatformV1FluencyResult;
        /**
         * Result for fulfillment metric.
         */
        fulfillmentResult?: Schema$GoogleCloudAiplatformV1FulfillmentResult;
        /**
         * Result for groundedness metric.
         */
        groundednessResult?: Schema$GoogleCloudAiplatformV1GroundednessResult;
        /**
         * Result for Metricx metric.
         */
        metricxResult?: Schema$GoogleCloudAiplatformV1MetricxResult;
        /**
         * Result for pairwise metric.
         */
        pairwiseMetricResult?: Schema$GoogleCloudAiplatformV1PairwiseMetricResult;
        /**
         * Result for pairwise question answering quality metric.
         */
        pairwiseQuestionAnsweringQualityResult?: Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityResult;
        /**
         * Result for pairwise summarization quality metric.
         */
        pairwiseSummarizationQualityResult?: Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualityResult;
        /**
         * Generic metrics. Result for pointwise metric.
         */
        pointwiseMetricResult?: Schema$GoogleCloudAiplatformV1PointwiseMetricResult;
        /**
         * Result for question answering correctness metric.
         */
        questionAnsweringCorrectnessResult?: Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessResult;
        /**
         * Result for question answering helpfulness metric.
         */
        questionAnsweringHelpfulnessResult?: Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessResult;
        /**
         * Question answering only metrics. Result for question answering quality metric.
         */
        questionAnsweringQualityResult?: Schema$GoogleCloudAiplatformV1QuestionAnsweringQualityResult;
        /**
         * Result for question answering relevance metric.
         */
        questionAnsweringRelevanceResult?: Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceResult;
        /**
         * Results for rouge metric.
         */
        rougeResults?: Schema$GoogleCloudAiplatformV1RougeResults;
        /**
         * Result for rubric based instruction following metric.
         */
        rubricBasedInstructionFollowingResult?: Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingResult;
        /**
         * Result for safety metric.
         */
        safetyResult?: Schema$GoogleCloudAiplatformV1SafetyResult;
        /**
         * Result for summarization helpfulness metric.
         */
        summarizationHelpfulnessResult?: Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessResult;
        /**
         * Summarization only metrics. Result for summarization quality metric.
         */
        summarizationQualityResult?: Schema$GoogleCloudAiplatformV1SummarizationQualityResult;
        /**
         * Result for summarization verbosity metric.
         */
        summarizationVerbosityResult?: Schema$GoogleCloudAiplatformV1SummarizationVerbosityResult;
        /**
         * Tool call metrics. Results for tool call valid metric.
         */
        toolCallValidResults?: Schema$GoogleCloudAiplatformV1ToolCallValidResults;
        /**
         * Results for tool name match metric.
         */
        toolNameMatchResults?: Schema$GoogleCloudAiplatformV1ToolNameMatchResults;
        /**
         * Results for tool parameter key match metric.
         */
        toolParameterKeyMatchResults?: Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchResults;
        /**
         * Results for tool parameter key value match metric.
         */
        toolParameterKvMatchResults?: Schema$GoogleCloudAiplatformV1ToolParameterKVMatchResults;
        /**
         * Result for trajectory any order match metric.
         */
        trajectoryAnyOrderMatchResults?: Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchResults;
        /**
         * Result for trajectory exact match metric.
         */
        trajectoryExactMatchResults?: Schema$GoogleCloudAiplatformV1TrajectoryExactMatchResults;
        /**
         * Result for trajectory in order match metric.
         */
        trajectoryInOrderMatchResults?: Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchResults;
        /**
         * Result for trajectory precision metric.
         */
        trajectoryPrecisionResults?: Schema$GoogleCloudAiplatformV1TrajectoryPrecisionResults;
        /**
         * Results for trajectory recall metric.
         */
        trajectoryRecallResults?: Schema$GoogleCloudAiplatformV1TrajectoryRecallResults;
        /**
         * Results for trajectory single tool use metric.
         */
        trajectorySingleToolUseResults?: Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseResults;
    }
    /**
     * The dataset used for evaluation.
     */
    export interface Schema$GoogleCloudAiplatformV1EvaluationDataset {
        /**
         * BigQuery source holds the dataset.
         */
        bigquerySource?: Schema$GoogleCloudAiplatformV1BigQuerySource;
        /**
         * Cloud storage source holds the dataset. Currently only one Cloud Storage file path is supported.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
    }
    /**
     * An edge describing the relationship between an Artifact and an Execution in a lineage graph.
     */
    export interface Schema$GoogleCloudAiplatformV1Event {
        /**
         * Required. The relative resource name of the Artifact in the Event.
         */
        artifact?: string | null;
        /**
         * Output only. Time the Event occurred.
         */
        eventTime?: string | null;
        /**
         * Output only. The relative resource name of the Execution in the Event.
         */
        execution?: string | null;
        /**
         * The labels with user-defined metadata to annotate Events. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Event (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Required. The type of the Event.
         */
        type?: string | null;
    }
    /**
     * Input for exact match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ExactMatchInput {
        /**
         * Required. Repeated exact match instances.
         */
        instances?: Schema$GoogleCloudAiplatformV1ExactMatchInstance[];
        /**
         * Required. Spec for exact match metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1ExactMatchSpec;
    }
    /**
     * Spec for exact match instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ExactMatchInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Required. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Exact match metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ExactMatchMetricValue {
        /**
         * Output only. Exact match score.
         */
        score?: number | null;
    }
    /**
     * Results for exact match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ExactMatchResults {
        /**
         * Output only. Exact match metric values.
         */
        exactMatchMetricValues?: Schema$GoogleCloudAiplatformV1ExactMatchMetricValue[];
    }
    /**
     * Spec for exact match metric - returns 1 if prediction and reference exactly matches, otherwise 0.
     */
    export interface Schema$GoogleCloudAiplatformV1ExactMatchSpec {
    }
    /**
     * Example-based explainability that returns the nearest neighbors from the provided dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1Examples {
        /**
         * The Cloud Storage input instances.
         */
        exampleGcsSource?: Schema$GoogleCloudAiplatformV1ExamplesExampleGcsSource;
        /**
         * The full configuration for the generated index, the semantics are the same as metadata and should match [NearestNeighborSearchConfig](https://cloud.google.com/vertex-ai/docs/explainable-ai/configuring-explanations-example-based#nearest-neighbor-search-config).
         */
        nearestNeighborSearchConfig?: any | null;
        /**
         * The number of neighbors to return when querying for examples.
         */
        neighborCount?: number | null;
        /**
         * Simplified preset configuration, which automatically sets configuration values based on the desired query speed-precision trade-off and modality.
         */
        presets?: Schema$GoogleCloudAiplatformV1Presets;
    }
    /**
     * The Cloud Storage input instances.
     */
    export interface Schema$GoogleCloudAiplatformV1ExamplesExampleGcsSource {
        /**
         * The format in which instances are given, if not specified, assume it's JSONL format. Currently only JSONL format is supported.
         */
        dataFormat?: string | null;
        /**
         * The Cloud Storage location for the input instances.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
    }
    /**
     * Overrides for example-based explanations.
     */
    export interface Schema$GoogleCloudAiplatformV1ExamplesOverride {
        /**
         * The number of neighbors to return that have the same crowding tag.
         */
        crowdingCount?: number | null;
        /**
         * The format of the data being provided with each call.
         */
        dataFormat?: string | null;
        /**
         * The number of neighbors to return.
         */
        neighborCount?: number | null;
        /**
         * Restrict the resulting nearest neighbors to respect these constraints.
         */
        restrictions?: Schema$GoogleCloudAiplatformV1ExamplesRestrictionsNamespace[];
        /**
         * If true, return the embeddings instead of neighbors.
         */
        returnEmbeddings?: boolean | null;
    }
    /**
     * Restrictions namespace for example-based explanations overrides.
     */
    export interface Schema$GoogleCloudAiplatformV1ExamplesRestrictionsNamespace {
        /**
         * The list of allowed tags.
         */
        allow?: string[] | null;
        /**
         * The list of deny tags.
         */
        deny?: string[] | null;
        /**
         * The namespace name.
         */
        namespaceName?: string | null;
    }
    /**
     * Code generated by the model that is meant to be executed, and the result returned to the model. Generated when using the [FunctionDeclaration] tool and [FunctionCallingConfig] mode is set to [Mode.CODE].
     */
    export interface Schema$GoogleCloudAiplatformV1ExecutableCode {
        /**
         * Required. The code to be executed.
         */
        code?: string | null;
        /**
         * Required. Programming language of the `code`.
         */
        language?: string | null;
    }
    /**
     * Instance of a general execution.
     */
    export interface Schema$GoogleCloudAiplatformV1Execution {
        /**
         * Output only. Timestamp when this Execution was created.
         */
        createTime?: string | null;
        /**
         * Description of the Execution
         */
        description?: string | null;
        /**
         * User provided display name of the Execution. May be up to 128 Unicode characters.
         */
        displayName?: string | null;
        /**
         * An eTag used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The labels with user-defined metadata to organize your Executions. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Execution (System labels are excluded).
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Properties of the Execution. Top level metadata keys' heading and trailing spaces will be trimmed. The size of this field should not exceed 200KB.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * Output only. The resource name of the Execution.
         */
        name?: string | null;
        /**
         * The title of the schema describing the metadata. Schema title and version is expected to be registered in earlier Create Schema calls. And both are used together as unique identifiers to identify schemas within the local metadata store.
         */
        schemaTitle?: string | null;
        /**
         * The version of the schema in `schema_title` to use. Schema title and version is expected to be registered in earlier Create Schema calls. And both are used together as unique identifiers to identify schemas within the local metadata store.
         */
        schemaVersion?: string | null;
        /**
         * The state of this Execution. This is a property of the Execution, and does not imply or capture any ongoing process. This property is managed by clients (such as Vertex AI Pipelines) and the system does not prescribe or check the validity of state transitions.
         */
        state?: string | null;
        /**
         * Output only. Timestamp when this Execution was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for PredictionService.Explain.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplainRequest {
        /**
         * If specified, this ExplainRequest will be served by the chosen DeployedModel, overriding Endpoint.traffic_split.
         */
        deployedModelId?: string | null;
        /**
         * If specified, overrides the explanation_spec of the DeployedModel. Can be used for explaining prediction results with different configurations, such as: - Explaining top-5 predictions results as opposed to top-1; - Increasing path count or step count of the attribution methods to reduce approximate errors; - Using different baselines for explaining the prediction results.
         */
        explanationSpecOverride?: Schema$GoogleCloudAiplatformV1ExplanationSpecOverride;
        /**
         * Required. The instances that are the input to the explanation call. A DeployedModel may have an upper limit on the number of instances it supports per request, and when it is exceeded the explanation call errors in case of AutoML Models, or, in case of customer created Models, the behaviour is as documented by that Model. The schema of any single instance may be specified via Endpoint's DeployedModels' Model's PredictSchemata's instance_schema_uri.
         */
        instances?: any[] | null;
        /**
         * The parameters that govern the prediction. The schema of the parameters may be specified via Endpoint's DeployedModels' Model's PredictSchemata's parameters_schema_uri.
         */
        parameters?: any | null;
    }
    /**
     * Response message for PredictionService.Explain.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplainResponse {
        /**
         * ID of the Endpoint's DeployedModel that served this explanation.
         */
        deployedModelId?: string | null;
        /**
         * The explanations of the Model's PredictResponse.predictions. It has the same number of elements as instances to be explained.
         */
        explanations?: Schema$GoogleCloudAiplatformV1Explanation[];
        /**
         * The predictions that are the output of the predictions call. Same as PredictResponse.predictions.
         */
        predictions?: any[] | null;
    }
    /**
     * Explanation of a prediction (provided in PredictResponse.predictions) produced by the Model on a given instance.
     */
    export interface Schema$GoogleCloudAiplatformV1Explanation {
        /**
         * Output only. Feature attributions grouped by predicted outputs. For Models that predict only one output, such as regression Models that predict only one score, there is only one attibution that explains the predicted output. For Models that predict multiple outputs, such as multiclass Models that predict multiple classes, each element explains one specific item. Attribution.output_index can be used to identify which output this attribution is explaining. By default, we provide Shapley values for the predicted class. However, you can configure the explanation request to generate Shapley values for any other classes too. For example, if a model predicts a probability of `0.4` for approving a loan application, the model's decision is to reject the application since `p(reject) = 0.6 \> p(approve) = 0.4`, and the default Shapley values would be computed for rejection decision and not approval, even though the latter might be the positive class. If users set ExplanationParameters.top_k, the attributions are sorted by instance_output_value in descending order. If ExplanationParameters.output_indices is specified, the attributions are stored by Attribution.output_index in the same order as they appear in the output_indices.
         */
        attributions?: Schema$GoogleCloudAiplatformV1Attribution[];
        /**
         * Output only. List of the nearest neighbors for example-based explanations. For models deployed with the examples explanations feature enabled, the attributions field is empty and instead the neighbors field is populated.
         */
        neighbors?: Schema$GoogleCloudAiplatformV1Neighbor[];
    }
    /**
     * Metadata describing the Model's input and output for explanation.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationMetadata {
        /**
         * Points to a YAML file stored on Google Cloud Storage describing the format of the feature attributions. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML tabular Models always have this field populated by Vertex AI. Note: The URI given on output may be different, including the URI scheme, than the one given on input. The output URI will point to a location where the user only has a read access.
         */
        featureAttributionsSchemaUri?: string | null;
        /**
         * Required. Map from feature names to feature input metadata. Keys are the name of the features. Values are the specification of the feature. An empty InputMetadata is valid. It describes a text feature which has the name specified as the key in ExplanationMetadata.inputs. The baseline of the empty feature is chosen by Vertex AI. For Vertex AI-provided Tensorflow images, the key can be any friendly name of the feature. Once specified, featureAttributions are keyed by this key (if not grouped with another feature). For custom images, the key must match with the key in instance.
         */
        inputs?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ExplanationMetadataInputMetadata;
        } | null;
        /**
         * Name of the source to generate embeddings for example based explanations.
         */
        latentSpaceSource?: string | null;
        /**
         * Required. Map from output names to output metadata. For Vertex AI-provided Tensorflow images, keys can be any user defined string that consists of any UTF-8 characters. For custom images, keys are the name of the output field in the prediction to be explained. Currently only one key is allowed.
         */
        outputs?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata;
        } | null;
    }
    /**
     * Metadata of the input of a feature. Fields other than InputMetadata.input_baselines are applicable only for Models that are using Vertex AI-provided images for Tensorflow.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationMetadataInputMetadata {
        /**
         * Specifies the shape of the values of the input if the input is a sparse representation. Refer to Tensorflow documentation for more details: https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
         */
        denseShapeTensorName?: string | null;
        /**
         * A list of baselines for the encoded tensor. The shape of each baseline should match the shape of the encoded tensor. If a scalar is provided, Vertex AI broadcasts to the same shape as the encoded tensor.
         */
        encodedBaselines?: any[] | null;
        /**
         * Encoded tensor is a transformation of the input tensor. Must be provided if choosing Integrated Gradients attribution or XRAI attribution and the input tensor is not differentiable. An encoded tensor is generated if the input tensor is encoded by a lookup table.
         */
        encodedTensorName?: string | null;
        /**
         * Defines how the feature is encoded into the input tensor. Defaults to IDENTITY.
         */
        encoding?: string | null;
        /**
         * The domain details of the input feature value. Like min/max, original mean or standard deviation if normalized.
         */
        featureValueDomain?: Schema$GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain;
        /**
         * Name of the group that the input belongs to. Features with the same group name will be treated as one feature when computing attributions. Features grouped together can have different shapes in value. If provided, there will be one single attribution generated in Attribution.feature_attributions, keyed by the group name.
         */
        groupName?: string | null;
        /**
         * A list of feature names for each index in the input tensor. Required when the input InputMetadata.encoding is BAG_OF_FEATURES, BAG_OF_FEATURES_SPARSE, INDICATOR.
         */
        indexFeatureMapping?: string[] | null;
        /**
         * Specifies the index of the values of the input tensor. Required when the input tensor is a sparse representation. Refer to Tensorflow documentation for more details: https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
         */
        indicesTensorName?: string | null;
        /**
         * Baseline inputs for this feature. If no baseline is specified, Vertex AI chooses the baseline for this feature. If multiple baselines are specified, Vertex AI returns the average attributions across them in Attribution.feature_attributions. For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape of each baseline must match the shape of the input tensor. If a scalar is provided, we broadcast to the same shape as the input tensor. For custom images, the element of the baselines must be in the same format as the feature's input in the instance[]. The schema of any single instance may be specified via Endpoint's DeployedModels' Model's PredictSchemata's instance_schema_uri.
         */
        inputBaselines?: any[] | null;
        /**
         * Name of the input tensor for this feature. Required and is only applicable to Vertex AI-provided images for Tensorflow.
         */
        inputTensorName?: string | null;
        /**
         * Modality of the feature. Valid values are: numeric, image. Defaults to numeric.
         */
        modality?: string | null;
        /**
         * Visualization configurations for image explanation.
         */
        visualization?: Schema$GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization;
    }
    /**
     * Domain details of the input feature value. Provides numeric information about the feature, such as its range (min, max). If the feature has been pre-processed, for example with z-scoring, then it provides information about how to recover the original feature. For example, if the input feature is an image and it has been pre-processed to obtain 0-mean and stddev = 1 values, then original_mean, and original_stddev refer to the mean and stddev of the original feature (e.g. image tensor) from which input feature (with mean = 0 and stddev = 1) was obtained.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain {
        /**
         * The maximum permissible value for this feature.
         */
        maxValue?: number | null;
        /**
         * The minimum permissible value for this feature.
         */
        minValue?: number | null;
        /**
         * If this input feature has been normalized to a mean value of 0, the original_mean specifies the mean value of the domain prior to normalization.
         */
        originalMean?: number | null;
        /**
         * If this input feature has been normalized to a standard deviation of 1.0, the original_stddev specifies the standard deviation of the domain prior to normalization.
         */
        originalStddev?: number | null;
    }
    /**
     * Visualization configurations for image explanation.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization {
        /**
         * Excludes attributions below the specified percentile, from the highlighted areas. Defaults to 62.
         */
        clipPercentLowerbound?: number | null;
        /**
         * Excludes attributions above the specified percentile from the highlighted areas. Using the clip_percent_upperbound and clip_percent_lowerbound together can be useful for filtering out noise and making it easier to see areas of strong attribution. Defaults to 99.9.
         */
        clipPercentUpperbound?: number | null;
        /**
         * The color scheme used for the highlighted areas. Defaults to PINK_GREEN for Integrated Gradients attribution, which shows positive attributions in green and negative in pink. Defaults to VIRIDIS for XRAI attribution, which highlights the most influential regions in yellow and the least influential in blue.
         */
        colorMap?: string | null;
        /**
         * How the original image is displayed in the visualization. Adjusting the overlay can help increase visual clarity if the original image makes it difficult to view the visualization. Defaults to NONE.
         */
        overlayType?: string | null;
        /**
         * Whether to only highlight pixels with positive contributions, negative or both. Defaults to POSITIVE.
         */
        polarity?: string | null;
        /**
         * Type of the image visualization. Only applicable to Integrated Gradients attribution. OUTLINES shows regions of attribution, while PIXELS shows per-pixel attribution. Defaults to OUTLINES.
         */
        type?: string | null;
    }
    /**
     * Metadata of the prediction output to be explained.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata {
        /**
         * Specify a field name in the prediction to look for the display name. Use this if the prediction contains the display names for the outputs. The display names in the prediction must have the same shape of the outputs, so that it can be located by Attribution.output_index for a specific output.
         */
        displayNameMappingKey?: string | null;
        /**
         * Static mapping between the index and display name. Use this if the outputs are a deterministic n-dimensional array, e.g. a list of scores of all the classes in a pre-defined order for a multi-classification Model. It's not feasible if the outputs are non-deterministic, e.g. the Model produces top-k classes or sort the outputs by their values. The shape of the value must be an n-dimensional array of strings. The number of dimensions must match that of the outputs to be explained. The Attribution.output_display_name is populated by locating in the mapping with Attribution.output_index.
         */
        indexDisplayNameMapping?: any | null;
        /**
         * Name of the output tensor. Required and is only applicable to Vertex AI provided images for Tensorflow.
         */
        outputTensorName?: string | null;
    }
    /**
     * The ExplanationMetadata entries that can be overridden at online explanation time.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationMetadataOverride {
        /**
         * Required. Overrides the input metadata of the features. The key is the name of the feature to be overridden. The keys specified here must exist in the input metadata to be overridden. If a feature is not specified here, the corresponding feature's input metadata is not overridden.
         */
        inputs?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride;
        } | null;
    }
    /**
     * The input metadata entries to be overridden.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride {
        /**
         * Baseline inputs for this feature. This overrides the `input_baseline` field of the ExplanationMetadata.InputMetadata object of the corresponding feature's input metadata. If it's not specified, the original baselines are not overridden.
         */
        inputBaselines?: any[] | null;
    }
    /**
     * Parameters to configure explaining for Model's predictions.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationParameters {
        /**
         * Example-based explanations that returns the nearest neighbors from the provided dataset.
         */
        examples?: Schema$GoogleCloudAiplatformV1Examples;
        /**
         * An attribution method that computes Aumann-Shapley values taking advantage of the model's fully differentiable structure. Refer to this paper for more details: https://arxiv.org/abs/1703.01365
         */
        integratedGradientsAttribution?: Schema$GoogleCloudAiplatformV1IntegratedGradientsAttribution;
        /**
         * If populated, only returns attributions that have output_index contained in output_indices. It must be an ndarray of integers, with the same shape of the output it's explaining. If not populated, returns attributions for top_k indices of outputs. If neither top_k nor output_indices is populated, returns the argmax index of the outputs. Only applicable to Models that predict multiple outputs (e,g, multi-class Models that predict multiple classes).
         */
        outputIndices?: any[] | null;
        /**
         * An attribution method that approximates Shapley values for features that contribute to the label being predicted. A sampling strategy is used to approximate the value rather than considering all subsets of features. Refer to this paper for model details: https://arxiv.org/abs/1306.4265.
         */
        sampledShapleyAttribution?: Schema$GoogleCloudAiplatformV1SampledShapleyAttribution;
        /**
         * If populated, returns attributions for top K indices of outputs (defaults to 1). Only applies to Models that predicts more than one outputs (e,g, multi-class Models). When set to -1, returns explanations for all outputs.
         */
        topK?: number | null;
        /**
         * An attribution method that redistributes Integrated Gradients attribution to segmented regions, taking advantage of the model's fully differentiable structure. Refer to this paper for more details: https://arxiv.org/abs/1906.02825 XRAI currently performs better on natural images, like a picture of a house or an animal. If the images are taken in artificial environments, like a lab or manufacturing line, or from diagnostic equipment, like x-rays or quality-control cameras, use Integrated Gradients instead.
         */
        xraiAttribution?: Schema$GoogleCloudAiplatformV1XraiAttribution;
    }
    /**
     * Specification of Model explanation.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationSpec {
        /**
         * Optional. Metadata describing the Model's input and output for explanation.
         */
        metadata?: Schema$GoogleCloudAiplatformV1ExplanationMetadata;
        /**
         * Required. Parameters that configure explaining of the Model's predictions.
         */
        parameters?: Schema$GoogleCloudAiplatformV1ExplanationParameters;
    }
    /**
     * The ExplanationSpec entries that can be overridden at online explanation time.
     */
    export interface Schema$GoogleCloudAiplatformV1ExplanationSpecOverride {
        /**
         * The example-based explanations parameter overrides.
         */
        examplesOverride?: Schema$GoogleCloudAiplatformV1ExamplesOverride;
        /**
         * The metadata to be overridden. If not specified, no metadata is overridden.
         */
        metadata?: Schema$GoogleCloudAiplatformV1ExplanationMetadataOverride;
        /**
         * The parameters to be overridden. Note that the attribution method cannot be changed. If not specified, no parameter is overridden.
         */
        parameters?: Schema$GoogleCloudAiplatformV1ExplanationParameters;
    }
    /**
     * Describes what part of the Dataset is to be exported, the destination of the export and how to export.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportDataConfig {
        /**
         * The Cloud Storage URI that points to a YAML file describing the annotation schema. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). The schema files that can be used here are found in gs://google-cloud-aiplatform/schema/dataset/annotation/, note that the chosen schema must be consistent with metadata of the Dataset specified by ExportDataRequest.name. Only used for custom training data export use cases. Only applicable to Datasets that have DataItems and Annotations. Only Annotations that both match this schema and belong to DataItems not ignored by the split method are used in respectively training, validation or test role, depending on the role of the DataItem they are on. When used in conjunction with annotations_filter, the Annotations used for training are filtered by both annotations_filter and annotation_schema_uri.
         */
        annotationSchemaUri?: string | null;
        /**
         * An expression for filtering what part of the Dataset is to be exported. Only Annotations that match this filter will be exported. The filter syntax is the same as in ListAnnotations.
         */
        annotationsFilter?: string | null;
        /**
         * Indicates the usage of the exported files.
         */
        exportUse?: string | null;
        /**
         * Split based on the provided filters for each set.
         */
        filterSplit?: Schema$GoogleCloudAiplatformV1ExportFilterSplit;
        /**
         * Split based on fractions defining the size of each set.
         */
        fractionSplit?: Schema$GoogleCloudAiplatformV1ExportFractionSplit;
        /**
         * The Google Cloud Storage location where the output is to be written to. In the given directory a new directory will be created with name: `export-data--` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export output will be written into that directory. Inside that directory, annotations with the same schema will be grouped into sub directories which are named with the corresponding annotations' schema title. Inside these sub directories, a schema.yaml will be created to describe the output format.
         */
        gcsDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * The ID of a SavedQuery (annotation set) under the Dataset specified by ExportDataRequest.name used for filtering Annotations for training. Only used for custom training data export use cases. Only applicable to Datasets that have SavedQueries. Only Annotations that are associated with this SavedQuery are used in respectively training. When used in conjunction with annotations_filter, the Annotations used for training are filtered by both saved_query_id and annotations_filter. Only one of saved_query_id and annotation_schema_uri should be specified as both of them represent the same thing: problem type.
         */
        savedQueryId?: string | null;
    }
    /**
     * Runtime operation information for DatasetService.ExportData.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportDataOperationMetadata {
        /**
         * A Google Cloud Storage directory which path ends with '/'. The exported data is stored in the directory.
         */
        gcsOutputDirectory?: string | null;
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for DatasetService.ExportData.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportDataRequest {
        /**
         * Required. The desired output location.
         */
        exportConfig?: Schema$GoogleCloudAiplatformV1ExportDataConfig;
    }
    /**
     * Response message for DatasetService.ExportData.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportDataResponse {
        /**
         * Only present for custom code training export use case. Records data stats, i.e., train/validation/test item/annotation counts calculated during the export operation.
         */
        dataStats?: Schema$GoogleCloudAiplatformV1ModelDataStats;
        /**
         * All of the files that are exported in this export operation. For custom code training export, only three (training, validation and test) Cloud Storage paths in wildcard format are populated (for example, gs://.../training-*).
         */
        exportedFiles?: string[] | null;
    }
    /**
     * Details of operations that exports Features values.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata {
        /**
         * Operation metadata for Featurestore export Feature values.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for FeaturestoreService.ExportFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportFeatureValuesRequest {
        /**
         * Required. Specifies destination location and format.
         */
        destination?: Schema$GoogleCloudAiplatformV1FeatureValueDestination;
        /**
         * Required. Selects Features to export values of.
         */
        featureSelector?: Schema$GoogleCloudAiplatformV1FeatureSelector;
        /**
         * Exports all historical values of all entities of the EntityType within a time range
         */
        fullExport?: Schema$GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport;
        /**
         * Per-Feature export settings.
         */
        settings?: Schema$GoogleCloudAiplatformV1DestinationFeatureSetting[];
        /**
         * Exports the latest Feature values of all entities of the EntityType within a time range.
         */
        snapshotExport?: Schema$GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport;
    }
    /**
     * Describes exporting all historical Feature values of all entities of the EntityType between [start_time, end_time].
     */
    export interface Schema$GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport {
        /**
         * Exports Feature values as of this timestamp. If not set, retrieve values as of now. Timestamp, if present, must not have higher than millisecond precision.
         */
        endTime?: string | null;
        /**
         * Excludes Feature values with feature generation timestamp before this timestamp. If not set, retrieve oldest values kept in Feature Store. Timestamp, if present, must not have higher than millisecond precision.
         */
        startTime?: string | null;
    }
    /**
     * Describes exporting the latest Feature values of all entities of the EntityType between [start_time, snapshot_time].
     */
    export interface Schema$GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport {
        /**
         * Exports Feature values as of this timestamp. If not set, retrieve values as of now. Timestamp, if present, must not have higher than millisecond precision.
         */
        snapshotTime?: string | null;
        /**
         * Excludes Feature values with feature generation timestamp before this timestamp. If not set, retrieve oldest values kept in Feature Store. Timestamp, if present, must not have higher than millisecond precision.
         */
        startTime?: string | null;
    }
    /**
     * Response message for FeaturestoreService.ExportFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportFeatureValuesResponse {
    }
    /**
     * Assigns input data to training, validation, and test sets based on the given filters, data pieces not matched by any filter are ignored. Currently only supported for Datasets containing DataItems. If any of the filters in this message are to match nothing, then they can be set as '-' (the minus sign). Supported only for unstructured Datasets.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportFilterSplit {
        /**
         * Required. A filter on DataItems of the Dataset. DataItems that match this filter are used to test the Model. A filter with same syntax as the one used in DatasetService.ListDataItems may be used. If a single DataItem is matched by more than one of the FilterSplit filters, then it is assigned to the first set that applies to it in the training, validation, test order.
         */
        testFilter?: string | null;
        /**
         * Required. A filter on DataItems of the Dataset. DataItems that match this filter are used to train the Model. A filter with same syntax as the one used in DatasetService.ListDataItems may be used. If a single DataItem is matched by more than one of the FilterSplit filters, then it is assigned to the first set that applies to it in the training, validation, test order.
         */
        trainingFilter?: string | null;
        /**
         * Required. A filter on DataItems of the Dataset. DataItems that match this filter are used to validate the Model. A filter with same syntax as the one used in DatasetService.ListDataItems may be used. If a single DataItem is matched by more than one of the FilterSplit filters, then it is assigned to the first set that applies to it in the training, validation, test order.
         */
        validationFilter?: string | null;
    }
    /**
     * Assigns the input data to training, validation, and test sets as per the given fractions. Any of `training_fraction`, `validation_fraction` and `test_fraction` may optionally be provided, they must sum to up to 1. If the provided ones sum to less than 1, the remainder is assigned to sets as decided by Vertex AI. If none of the fractions are set, by default roughly 80% of data is used for training, 10% for validation, and 10% for test.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportFractionSplit {
        /**
         * The fraction of the input data that is to be used to evaluate the Model.
         */
        testFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to train the Model.
         */
        trainingFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to validate the Model.
         */
        validationFraction?: number | null;
    }
    /**
     * Details of ModelService.ExportModel operation.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportModelOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * Output only. Information further describing the output of this Model export.
         */
        outputInfo?: Schema$GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo;
    }
    /**
     * Further describes the output of the ExportModel. Supplements ExportModelRequest.OutputConfig.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo {
        /**
         * Output only. If the Model artifact is being exported to Google Cloud Storage this is the full path of the directory created, into which the Model files are being written to.
         */
        artifactOutputUri?: string | null;
        /**
         * Output only. If the Model image is being exported to Google Container Registry or Artifact Registry this is the full path of the image created.
         */
        imageOutputUri?: string | null;
    }
    /**
     * Request message for ModelService.ExportModel.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportModelRequest {
        /**
         * Required. The desired output location and configuration.
         */
        outputConfig?: Schema$GoogleCloudAiplatformV1ExportModelRequestOutputConfig;
    }
    /**
     * Output configuration for the Model export.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportModelRequestOutputConfig {
        /**
         * The Cloud Storage location where the Model artifact is to be written to. Under the directory given as the destination a new one with name "`model-export--`", where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format, will be created. Inside, the Model and any of its supporting files will be written. This field should only be set when the `exportableContent` field of the [Model.supported_export_formats] object contains `ARTIFACT`.
         */
        artifactDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * The ID of the format in which the Model must be exported. Each Model lists the export formats it supports. If no value is provided here, then the first from the list of the Model's supported formats is used by default.
         */
        exportFormatId?: string | null;
        /**
         * The Google Container Registry or Artifact Registry uri where the Model container image will be copied to. This field should only be set when the `exportableContent` field of the [Model.supported_export_formats] object contains `IMAGE`.
         */
        imageDestination?: Schema$GoogleCloudAiplatformV1ContainerRegistryDestination;
    }
    /**
     * Response message of ModelService.ExportModel operation.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportModelResponse {
    }
    /**
     * Request message for TensorboardService.ExportTensorboardTimeSeriesData.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest {
        /**
         * Exports the TensorboardTimeSeries' data that match the filter expression.
         */
        filter?: string | null;
        /**
         * Field to use to sort the TensorboardTimeSeries' data. By default, TensorboardTimeSeries' data is returned in a pseudo random order.
         */
        orderBy?: string | null;
        /**
         * The maximum number of data points to return per page. The default page_size is 1000. Values must be between 1 and 10000. Values above 10000 are coerced to 10000.
         */
        pageSize?: number | null;
        /**
         * A page token, received from a previous ExportTensorboardTimeSeriesData call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ExportTensorboardTimeSeriesData must match the call that provided the page token.
         */
        pageToken?: string | null;
    }
    /**
     * Response message for TensorboardService.ExportTensorboardTimeSeriesData.
     */
    export interface Schema$GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse {
        /**
         * A token, which can be sent as page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The returned time series data points.
         */
        timeSeriesDataPoints?: Schema$GoogleCloudAiplatformV1TimeSeriesDataPoint[];
    }
    /**
     * The fact used in grounding.
     */
    export interface Schema$GoogleCloudAiplatformV1Fact {
        /**
         * If present, chunk properties.
         */
        chunk?: Schema$GoogleCloudAiplatformV1RagChunk;
        /**
         * Query that is used to retrieve this fact.
         */
        query?: string | null;
        /**
         * If present, according to the underlying Vector DB and the selected metric type, the score can be either the distance or the similarity between the query and the fact and its range depends on the metric type. For example, if the metric type is COSINE_DISTANCE, it represents the distance between the query and the fact. The larger the distance, the less relevant the fact is to the query. The range is [0, 2], while 0 means the most relevant and 2 means the least relevant.
         */
        score?: number | null;
        /**
         * If present, the summary/snippet of the fact.
         */
        summary?: string | null;
        /**
         * If present, it refers to the title of this fact.
         */
        title?: string | null;
        /**
         * If present, this uri links to the source of the fact.
         */
        uri?: string | null;
        /**
         * If present, the distance between the query vector and this fact vector.
         */
        vectorDistance?: number | null;
    }
    /**
     * Configuration for faster model deployment.
     */
    export interface Schema$GoogleCloudAiplatformV1FasterDeploymentConfig {
        /**
         * If true, enable fast tryout feature for this deployed model.
         */
        fastTryoutEnabled?: boolean | null;
    }
    /**
     * Feature Metadata information. For example, color is a feature that describes an apple.
     */
    export interface Schema$GoogleCloudAiplatformV1Feature {
        /**
         * Output only. Only applicable for Vertex AI Feature Store (Legacy). Timestamp when this EntityType was created.
         */
        createTime?: string | null;
        /**
         * Description of the Feature.
         */
        description?: string | null;
        /**
         * Optional. Only applicable for Vertex AI Feature Store (Legacy). If not set, use the monitoring_config defined for the EntityType this Feature belongs to. Only Features with type (Feature.ValueType) BOOL, STRING, DOUBLE or INT64 can enable monitoring. If set to true, all types of data monitoring are disabled despite the config on EntityType.
         */
        disableMonitoring?: boolean | null;
        /**
         * Used to perform a consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize your Features. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information on and examples of labels. No more than 64 user labels can be associated with one Feature (System labels are excluded)." System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Only applicable for Vertex AI Feature Store (Legacy). The list of historical stats and anomalies with specified objectives.
         */
        monitoringStatsAnomalies?: Schema$GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly[];
        /**
         * Immutable. Name of the Feature. Format: `projects/{project\}/locations/{location\}/featurestores/{featurestore\}/entityTypes/{entity_type\}/features/{feature\}` `projects/{project\}/locations/{location\}/featureGroups/{feature_group\}/features/{feature\}` The last part feature is assigned by the client. The feature can be up to 64 characters long and can consist only of ASCII Latin letters A-Z and a-z, underscore(_), and ASCII digits 0-9 starting with a letter. The value will be unique given an entity type.
         */
        name?: string | null;
        /**
         * Entity responsible for maintaining this feature. Can be comma separated list of email addresses or URIs.
         */
        pointOfContact?: string | null;
        /**
         * Output only. Only applicable for Vertex AI Feature Store (Legacy). Timestamp when this EntityType was most recently updated.
         */
        updateTime?: string | null;
        /**
         * Immutable. Only applicable for Vertex AI Feature Store (Legacy). Type of Feature value.
         */
        valueType?: string | null;
        /**
         * Only applicable for Vertex AI Feature Store. The name of the BigQuery Table/View column hosting data for this version. If no value is provided, will use feature_id.
         */
        versionColumnName?: string | null;
    }
    /**
     * Vertex AI Feature Group.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureGroup {
        /**
         * Indicates that features for this group come from BigQuery Table/View. By default treats the source as a sparse time series source. The BigQuery source table or view must have at least one entity ID column and a column named `feature_timestamp`.
         */
        bigQuery?: Schema$GoogleCloudAiplatformV1FeatureGroupBigQuery;
        /**
         * Output only. Timestamp when this FeatureGroup was created.
         */
        createTime?: string | null;
        /**
         * Optional. Description of the FeatureGroup.
         */
        description?: string | null;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize your FeatureGroup. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information on and examples of labels. No more than 64 user labels can be associated with one FeatureGroup(System labels are excluded)." System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Identifier. Name of the FeatureGroup. Format: `projects/{project\}/locations/{location\}/featureGroups/{featureGroup\}`
         */
        name?: string | null;
        /**
         * Output only. A Service Account unique to this FeatureGroup. The role bigquery.dataViewer should be granted to this service account to allow Vertex AI Feature Store to access source data while running jobs under this FeatureGroup.
         */
        serviceAccountEmail?: string | null;
        /**
         * Optional. Service agent type used during jobs under a FeatureGroup. By default, the Vertex AI Service Agent is used. When using an IAM Policy to isolate this FeatureGroup within a project, a separate service account should be provisioned by setting this field to `SERVICE_AGENT_TYPE_FEATURE_GROUP`. This will generate a separate service account to access the BigQuery source table.
         */
        serviceAgentType?: string | null;
        /**
         * Output only. Timestamp when this FeatureGroup was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Input source type for BigQuery Tables and Views.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureGroupBigQuery {
        /**
         * Required. Immutable. The BigQuery source URI that points to either a BigQuery Table or View.
         */
        bigQuerySource?: Schema$GoogleCloudAiplatformV1BigQuerySource;
        /**
         * Optional. If set, all feature values will be fetched from a single row per unique entityId including nulls. If not set, will collapse all rows for each unique entityId into a singe row with any non-null values if present, if no non-null values are present will sync null. ex: If source has schema `(entity_id, feature_timestamp, f0, f1)` and the following rows: `(e1, 2020-01-01T10:00:00.123Z, 10, 15)` `(e1, 2020-02-01T10:00:00.123Z, 20, null)` If dense is set, `(e1, 20, null)` is synced to online stores. If dense is not set, `(e1, 20, 15)` is synced to online stores.
         */
        dense?: boolean | null;
        /**
         * Optional. Columns to construct entity_id / row keys. If not provided defaults to `entity_id`.
         */
        entityIdColumns?: string[] | null;
        /**
         * Optional. Set if the data source is not a time-series.
         */
        staticDataSource?: boolean | null;
        /**
         * Optional. If the source is a time-series source, this can be set to control how downstream sources (ex: FeatureView ) will treat time-series sources. If not set, will treat the source as a time-series source with `feature_timestamp` as timestamp column and no scan boundary.
         */
        timeSeries?: Schema$GoogleCloudAiplatformV1FeatureGroupBigQueryTimeSeries;
    }
    export interface Schema$GoogleCloudAiplatformV1FeatureGroupBigQueryTimeSeries {
        /**
         * Optional. Column hosting timestamp values for a time-series source. Will be used to determine the latest `feature_values` for each entity. Optional. If not provided, column named `feature_timestamp` of type `TIMESTAMP` will be used.
         */
        timestampColumn?: string | null;
    }
    /**
     * A list of historical SnapshotAnalysis or ImportFeaturesAnalysis stats requested by user, sorted by FeatureStatsAnomaly.start_time descending.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly {
        /**
         * Output only. The stats and anomalies generated at specific timestamp.
         */
        featureStatsAnomaly?: Schema$GoogleCloudAiplatformV1FeatureStatsAnomaly;
        /**
         * Output only. The objective for each stats.
         */
        objective?: string | null;
    }
    /**
     * Noise sigma by features. Noise sigma represents the standard deviation of the gaussian kernel that will be used to add noise to interpolated inputs prior to computing gradients.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureNoiseSigma {
        /**
         * Noise sigma per feature. No noise is added to features that are not set.
         */
        noiseSigma?: Schema$GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature[];
    }
    /**
     * Noise sigma for a single feature.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature {
        /**
         * The name of the input feature for which noise sigma is provided. The features are defined in explanation metadata inputs.
         */
        name?: string | null;
        /**
         * This represents the standard deviation of the Gaussian kernel that will be used to add noise to the feature prior to computing gradients. Similar to noise_sigma but represents the noise added to the current feature. Defaults to 0.1.
         */
        sigma?: number | null;
    }
    /**
     * Vertex AI Feature Online Store provides a centralized repository for serving ML features and embedding indexes at low latency. The Feature Online Store is a top-level container.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureOnlineStore {
        /**
         * Contains settings for the Cloud Bigtable instance that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore.
         */
        bigtable?: Schema$GoogleCloudAiplatformV1FeatureOnlineStoreBigtable;
        /**
         * Output only. Timestamp when this FeatureOnlineStore was created.
         */
        createTime?: string | null;
        /**
         * Optional. The dedicated serving endpoint for this FeatureOnlineStore, which is different from common Vertex service endpoint.
         */
        dedicatedServingEndpoint?: Schema$GoogleCloudAiplatformV1FeatureOnlineStoreDedicatedServingEndpoint;
        /**
         * Optional. Customer-managed encryption key spec for data storage. If set, online store will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize your FeatureOnlineStore. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information on and examples of labels. No more than 64 user labels can be associated with one FeatureOnlineStore(System labels are excluded)." System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Identifier. Name of the FeatureOnlineStore. Format: `projects/{project\}/locations/{location\}/featureOnlineStores/{featureOnlineStore\}`
         */
        name?: string | null;
        /**
         * Contains settings for the Optimized store that will be created to serve featureValues for all FeatureViews under this FeatureOnlineStore. When choose Optimized storage type, need to set PrivateServiceConnectConfig.enable_private_service_connect to use private endpoint. Otherwise will use public endpoint by default.
         */
        optimized?: Schema$GoogleCloudAiplatformV1FeatureOnlineStoreOptimized;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. State of the featureOnlineStore.
         */
        state?: string | null;
        /**
         * Output only. Timestamp when this FeatureOnlineStore was last updated.
         */
        updateTime?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1FeatureOnlineStoreBigtable {
        /**
         * Required. Autoscaling config applied to Bigtable Instance.
         */
        autoScaling?: Schema$GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling;
    }
    export interface Schema$GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling {
        /**
         * Optional. A percentage of the cluster's CPU capacity. Can be from 10% to 80%. When a cluster's CPU utilization exceeds the target that you have set, Bigtable immediately adds nodes to the cluster. When CPU utilization is substantially lower than the target, Bigtable removes nodes. If not set will default to 50%.
         */
        cpuUtilizationTarget?: number | null;
        /**
         * Required. The maximum number of nodes to scale up to. Must be greater than or equal to min_node_count, and less than or equal to 10 times of 'min_node_count'.
         */
        maxNodeCount?: number | null;
        /**
         * Required. The minimum number of nodes to scale down to. Must be greater than or equal to 1.
         */
        minNodeCount?: number | null;
    }
    /**
     * The dedicated serving endpoint for this FeatureOnlineStore. Only need to set when you choose Optimized storage type. Public endpoint is provisioned by default.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureOnlineStoreDedicatedServingEndpoint {
        /**
         * Optional. Private service connect config. The private service connection is available only for Optimized storage type, not for embedding management now. If PrivateServiceConnectConfig.enable_private_service_connect set to true, customers will use private service connection to send request. Otherwise, the connection will set to public endpoint.
         */
        privateServiceConnectConfig?: Schema$GoogleCloudAiplatformV1PrivateServiceConnectConfig;
        /**
         * Output only. This field will be populated with the domain name to use for this FeatureOnlineStore
         */
        publicEndpointDomainName?: string | null;
        /**
         * Output only. The name of the service attachment resource. Populated if private service connect is enabled and after FeatureViewSync is created.
         */
        serviceAttachment?: string | null;
    }
    /**
     * Optimized storage type
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureOnlineStoreOptimized {
    }
    /**
     * Selector for Features of an EntityType.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureSelector {
        /**
         * Required. Matches Features based on ID.
         */
        idMatcher?: Schema$GoogleCloudAiplatformV1IdMatcher;
    }
    /**
     * Stats and Anomaly generated at specific timestamp for specific Feature. The start_time and end_time are used to define the time range of the dataset that current stats belongs to, e.g. prediction traffic is bucketed into prediction datasets by time window. If the Dataset is not defined by time window, start_time = end_time. Timestamp of the stats and anomalies always refers to end_time. Raw stats and anomalies are stored in stats_uri or anomaly_uri in the tensorflow defined protos. Field data_stats contains almost identical information with the raw stats in Vertex AI defined proto, for UI to display.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureStatsAnomaly {
        /**
         * This is the threshold used when detecting anomalies. The threshold can be changed by user, so this one might be different from ThresholdConfig.value.
         */
        anomalyDetectionThreshold?: number | null;
        /**
         * Path of the anomaly file for current feature values in Cloud Storage bucket. Format: gs:////anomalies. Example: gs://monitoring_bucket/feature_name/anomalies. Stats are stored as binary format with Protobuf message Anoamlies are stored as binary format with Protobuf message [tensorflow.metadata.v0.AnomalyInfo] (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
         */
        anomalyUri?: string | null;
        /**
         * Deviation from the current stats to baseline stats. 1. For categorical feature, the distribution distance is calculated by L-inifinity norm. 2. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence.
         */
        distributionDeviation?: number | null;
        /**
         * The end timestamp of window where stats were generated. For objectives where time window doesn't make sense (e.g. Featurestore Snapshot Monitoring), end_time indicates the timestamp of the data used to generate stats (e.g. timestamp we take snapshots for feature values).
         */
        endTime?: string | null;
        /**
         * Feature importance score, only populated when cross-feature monitoring is enabled. For now only used to represent feature attribution score within range [0, 1] for ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW and ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT.
         */
        score?: number | null;
        /**
         * The start timestamp of window where stats were generated. For objectives where time window doesn't make sense (e.g. Featurestore Snapshot Monitoring), start_time is only used to indicate the monitoring intervals, so it always equals to (end_time - monitoring_interval).
         */
        startTime?: string | null;
        /**
         * Path of the stats file for current feature values in Cloud Storage bucket. Format: gs:////stats. Example: gs://monitoring_bucket/feature_name/stats. Stats are stored as binary format with Protobuf message [tensorflow.metadata.v0.FeatureNameStatistics](https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
         */
        statsUri?: string | null;
    }
    /**
     * Vertex AI Feature Store provides a centralized repository for organizing, storing, and serving ML features. The Featurestore is a top-level container for your features and their values.
     */
    export interface Schema$GoogleCloudAiplatformV1Featurestore {
        /**
         * Output only. Timestamp when this Featurestore was created.
         */
        createTime?: string | null;
        /**
         * Optional. Customer-managed encryption key spec for data storage. If set, both of the online and offline data storage will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize your Featurestore. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information on and examples of labels. No more than 64 user labels can be associated with one Featurestore(System labels are excluded)." System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Name of the Featurestore. Format: `projects/{project\}/locations/{location\}/featurestores/{featurestore\}`
         */
        name?: string | null;
        /**
         * Optional. Config for online storage resources. The field should not co-exist with the field of `OnlineStoreReplicationConfig`. If both of it and OnlineStoreReplicationConfig are unset, the feature store will not have an online store and cannot be used for online serving.
         */
        onlineServingConfig?: Schema$GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig;
        /**
         * Optional. TTL in days for feature values that will be stored in online serving storage. The Feature Store online storage periodically removes obsolete feature values older than `online_storage_ttl_days` since the feature generation time. Note that `online_storage_ttl_days` should be less than or equal to `offline_storage_ttl_days` for each EntityType under a featurestore. If not set, default to 4000 days
         */
        onlineStorageTtlDays?: number | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. State of the featurestore.
         */
        state?: string | null;
        /**
         * Output only. Timestamp when this Featurestore was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configuration of how features in Featurestore are monitored.
     */
    export interface Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfig {
        /**
         * Threshold for categorical features of anomaly detection. This is shared by all types of Featurestore Monitoring for categorical features (i.e. Features with type (Feature.ValueType) BOOL or STRING).
         */
        categoricalThresholdConfig?: Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig;
        /**
         * The config for ImportFeatures Analysis Based Feature Monitoring.
         */
        importFeaturesAnalysis?: Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis;
        /**
         * Threshold for numerical features of anomaly detection. This is shared by all objectives of Featurestore Monitoring for numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or INT64).
         */
        numericalThresholdConfig?: Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig;
        /**
         * The config for Snapshot Analysis Based Feature Monitoring.
         */
        snapshotAnalysis?: Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis;
    }
    /**
     * Configuration of the Featurestore's ImportFeature Analysis Based Monitoring. This type of analysis generates statistics for values of each Feature imported by every ImportFeatureValues operation.
     */
    export interface Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis {
        /**
         * The baseline used to do anomaly detection for the statistics generated by import features analysis.
         */
        anomalyDetectionBaseline?: string | null;
        /**
         * Whether to enable / disable / inherite default hebavior for import features analysis.
         */
        state?: string | null;
    }
    /**
     * Configuration of the Featurestore's Snapshot Analysis Based Monitoring. This type of analysis generates statistics for each Feature based on a snapshot of the latest feature value of each entities every monitoring_interval.
     */
    export interface Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis {
        /**
         * The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoring_interval for Features under it. Feature-level config: disabled = true indicates disabled regardless of the EntityType-level config; unset monitoring_interval indicates going with EntityType-level config; otherwise run snapshot analysis monitoring with monitoring_interval regardless of the EntityType-level config. Explicitly Disable the snapshot analysis based monitoring.
         */
        disabled?: boolean | null;
        /**
         * Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days.
         */
        monitoringIntervalDays?: number | null;
        /**
         * Customized export features time window for snapshot analysis. Unit is one day. Default value is 3 weeks. Minimum value is 1 day. Maximum value is 4000 days.
         */
        stalenessDays?: number | null;
    }
    /**
     * The config for Featurestore Monitoring threshold.
     */
    export interface Schema$GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig {
        /**
         * Specify a threshold value that can trigger the alert. 1. For categorical feature, the distribution distance is calculated by L-inifinity norm. 2. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature.
         */
        value?: number | null;
    }
    /**
     * OnlineServingConfig specifies the details for provisioning online serving resources.
     */
    export interface Schema$GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig {
        /**
         * The number of nodes for the online store. The number of nodes doesn't scale automatically, but you can manually update the number of nodes. If set to 0, the featurestore will not have an online store and cannot be used for online serving.
         */
        fixedNodeCount?: number | null;
        /**
         * Online serving scaling configuration. Only one of `fixed_node_count` and `scaling` can be set. Setting one will reset the other.
         */
        scaling?: Schema$GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling;
    }
    /**
     * Online serving scaling configuration. If min_node_count and max_node_count are set to the same value, the cluster will be configured with the fixed number of node (no auto-scaling).
     */
    export interface Schema$GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling {
        /**
         * Optional. The cpu utilization that the Autoscaler should be trying to achieve. This number is on a scale from 0 (no utilization) to 100 (total utilization), and is limited between 10 and 80. When a cluster's CPU utilization exceeds the target that you have set, Bigtable immediately adds nodes to the cluster. When CPU utilization is substantially lower than the target, Bigtable removes nodes. If not set or set to 0, default to 50.
         */
        cpuUtilizationTarget?: number | null;
        /**
         * The maximum number of nodes to scale up to. Must be greater than min_node_count, and less than or equal to 10 times of 'min_node_count'.
         */
        maxNodeCount?: number | null;
        /**
         * Required. The minimum number of nodes to scale down to. Must be greater than or equal to 1.
         */
        minNodeCount?: number | null;
    }
    /**
     * Value for a feature.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureValue {
        /**
         * A list of bool type feature value.
         */
        boolArrayValue?: Schema$GoogleCloudAiplatformV1BoolArray;
        /**
         * Bool type feature value.
         */
        boolValue?: boolean | null;
        /**
         * Bytes feature value.
         */
        bytesValue?: string | null;
        /**
         * A list of double type feature value.
         */
        doubleArrayValue?: Schema$GoogleCloudAiplatformV1DoubleArray;
        /**
         * Double type feature value.
         */
        doubleValue?: number | null;
        /**
         * A list of int64 type feature value.
         */
        int64ArrayValue?: Schema$GoogleCloudAiplatformV1Int64Array;
        /**
         * Int64 feature value.
         */
        int64Value?: string | null;
        /**
         * Metadata of feature value.
         */
        metadata?: Schema$GoogleCloudAiplatformV1FeatureValueMetadata;
        /**
         * A list of string type feature value.
         */
        stringArrayValue?: Schema$GoogleCloudAiplatformV1StringArray;
        /**
         * String feature value.
         */
        stringValue?: string | null;
        /**
         * A struct type feature value.
         */
        structValue?: Schema$GoogleCloudAiplatformV1StructValue;
    }
    /**
     * A destination location for Feature values and format.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureValueDestination {
        /**
         * Output in BigQuery format. BigQueryDestination.output_uri in FeatureValueDestination.bigquery_destination must refer to a table.
         */
        bigqueryDestination?: Schema$GoogleCloudAiplatformV1BigQueryDestination;
        /**
         * Output in CSV format. Array Feature value types are not allowed in CSV format.
         */
        csvDestination?: Schema$GoogleCloudAiplatformV1CsvDestination;
        /**
         * Output in TFRecord format. Below are the mapping from Feature value type in Featurestore to Feature value type in TFRecord: Value type in Featurestore | Value type in TFRecord DOUBLE, DOUBLE_ARRAY | FLOAT_LIST INT64, INT64_ARRAY | INT64_LIST STRING, STRING_ARRAY, BYTES | BYTES_LIST true -\> byte_string("true"), false -\> byte_string("false") BOOL, BOOL_ARRAY (true, false) | BYTES_LIST
         */
        tfrecordDestination?: Schema$GoogleCloudAiplatformV1TFRecordDestination;
    }
    /**
     * Container for list of values.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureValueList {
        /**
         * A list of feature values. All of them should be the same data type.
         */
        values?: Schema$GoogleCloudAiplatformV1FeatureValue[];
    }
    /**
     * Metadata of feature value.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureValueMetadata {
        /**
         * Feature generation timestamp. Typically, it is provided by user at feature ingestion time. If not, feature store will use the system timestamp when the data is ingested into feature store. For streaming ingestion, the time, aligned by days, must be no older than five years (1825 days) and no later than one year (366 days) in the future.
         */
        generateTime?: string | null;
    }
    /**
     * FeatureView is representation of values that the FeatureOnlineStore will serve based on its syncConfig.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureView {
        /**
         * Optional. Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
         */
        bigQuerySource?: Schema$GoogleCloudAiplatformV1FeatureViewBigQuerySource;
        /**
         * Output only. Timestamp when this FeatureView was created.
         */
        createTime?: string | null;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Optional. Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
         */
        featureRegistrySource?: Schema$GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource;
        /**
         * Optional. Configuration for index preparation for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
         */
        indexConfig?: Schema$GoogleCloudAiplatformV1FeatureViewIndexConfig;
        /**
         * Optional. The labels with user-defined metadata to organize your FeatureViews. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information on and examples of labels. No more than 64 user labels can be associated with one FeatureOnlineStore(System labels are excluded)." System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Identifier. Name of the FeatureView. Format: `projects/{project\}/locations/{location\}/featureOnlineStores/{feature_online_store\}/featureViews/{feature_view\}`
         */
        name?: string | null;
        /**
         * Optional. Configuration for FeatureView created under Optimized FeatureOnlineStore.
         */
        optimizedConfig?: Schema$GoogleCloudAiplatformV1FeatureViewOptimizedConfig;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. A Service Account unique to this FeatureView. The role bigquery.dataViewer should be granted to this service account to allow Vertex AI Feature Store to sync data to the online store.
         */
        serviceAccountEmail?: string | null;
        /**
         * Optional. Service agent type used during data sync. By default, the Vertex AI Service Agent is used. When using an IAM Policy to isolate this FeatureView within a project, a separate service account should be provisioned by setting this field to `SERVICE_AGENT_TYPE_FEATURE_VIEW`. This will generate a separate service account to access the BigQuery source table.
         */
        serviceAgentType?: string | null;
        /**
         * Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
         */
        syncConfig?: Schema$GoogleCloudAiplatformV1FeatureViewSyncConfig;
        /**
         * Output only. Timestamp when this FeatureView was last updated.
         */
        updateTime?: string | null;
        /**
         * Optional. The Vertex RAG Source that the FeatureView is linked to.
         */
        vertexRagSource?: Schema$GoogleCloudAiplatformV1FeatureViewVertexRagSource;
    }
    export interface Schema$GoogleCloudAiplatformV1FeatureViewBigQuerySource {
        /**
         * Required. Columns to construct entity_id / row keys.
         */
        entityIdColumns?: string[] | null;
        /**
         * Required. The BigQuery view URI that will be materialized on each sync trigger based on FeatureView.SyncConfig.
         */
        uri?: string | null;
    }
    /**
     * Lookup key for a feature view.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewDataKey {
        /**
         * The actual Entity ID will be composed from this struct. This should match with the way ID is defined in the FeatureView spec.
         */
        compositeKey?: Schema$GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey;
        /**
         * String key to use for lookup.
         */
        key?: string | null;
    }
    /**
     * ID that is comprised from several parts (columns).
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey {
        /**
         * Parts to construct Entity ID. Should match with the same ID columns as defined in FeatureView in the same order.
         */
        parts?: string[] | null;
    }
    /**
     * A Feature Registry source for features that need to be synced to Online Store.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource {
        /**
         * Required. List of features that need to be synced to Online Store.
         */
        featureGroups?: Schema$GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup[];
        /**
         * Optional. The project number of the parent project of the Feature Groups.
         */
        projectNumber?: string | null;
    }
    /**
     * Features belonging to a single feature group that will be synced to Online Store.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup {
        /**
         * Required. Identifier of the feature group.
         */
        featureGroupId?: string | null;
        /**
         * Required. Identifiers of features under the feature group.
         */
        featureIds?: string[] | null;
    }
    /**
     * Configuration for vector indexing.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewIndexConfig {
        /**
         * Optional. Configuration options for using brute force search, which simply implements the standard linear search in the database for each query. It is primarily meant for benchmarking and to generate the ground truth for approximate search.
         */
        bruteForceConfig?: Schema$GoogleCloudAiplatformV1FeatureViewIndexConfigBruteForceConfig;
        /**
         * Optional. Column of crowding. This column contains crowding attribute which is a constraint on a neighbor list produced by FeatureOnlineStoreService.SearchNearestEntities to diversify search results. If NearestNeighborQuery.per_crowding_attribute_neighbor_count is set to K in SearchNearestEntitiesRequest, it's guaranteed that no more than K entities of the same crowding attribute are returned in the response.
         */
        crowdingColumn?: string | null;
        /**
         * Optional. The distance measure used in nearest neighbor search.
         */
        distanceMeasureType?: string | null;
        /**
         * Optional. Column of embedding. This column contains the source data to create index for vector search. embedding_column must be set when using vector search.
         */
        embeddingColumn?: string | null;
        /**
         * Optional. The number of dimensions of the input embedding.
         */
        embeddingDimension?: number | null;
        /**
         * Optional. Columns of features that're used to filter vector search results.
         */
        filterColumns?: string[] | null;
        /**
         * Optional. Configuration options for the tree-AH algorithm (Shallow tree + Asymmetric Hashing). Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
         */
        treeAhConfig?: Schema$GoogleCloudAiplatformV1FeatureViewIndexConfigTreeAHConfig;
    }
    /**
     * Configuration options for using brute force search.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewIndexConfigBruteForceConfig {
    }
    /**
     * Configuration options for the tree-AH algorithm.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewIndexConfigTreeAHConfig {
        /**
         * Optional. Number of embeddings on each leaf node. The default value is 1000 if not set.
         */
        leafNodeEmbeddingCount?: string | null;
    }
    /**
     * Configuration for FeatureViews created in Optimized FeatureOnlineStore.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewOptimizedConfig {
        /**
         * Optional. A description of resources that the FeatureView uses, which to large degree are decided by Vertex AI, and optionally allows only a modest additional configuration. If min_replica_count is not set, the default value is 2. If max_replica_count is not set, the default value is 6. The max allowed replica count is 1000.
         */
        automaticResources?: Schema$GoogleCloudAiplatformV1AutomaticResources;
    }
    /**
     * FeatureViewSync is a representation of sync operation which copies data from data source to Feature View in Online Store.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewSync {
        /**
         * Output only. Time when this FeatureViewSync is created. Creation of a FeatureViewSync means that the job is pending / waiting for sufficient resources but may not have started the actual data transfer yet.
         */
        createTime?: string | null;
        /**
         * Output only. Final status of the FeatureViewSync.
         */
        finalStatus?: Schema$GoogleRpcStatus;
        /**
         * Identifier. Name of the FeatureViewSync. Format: `projects/{project\}/locations/{location\}/featureOnlineStores/{feature_online_store\}/featureViews/{feature_view\}/featureViewSyncs/{feature_view_sync\}`
         */
        name?: string | null;
        /**
         * Output only. Time when this FeatureViewSync is finished.
         */
        runTime?: Schema$GoogleTypeInterval;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Summary of the sync job.
         */
        syncSummary?: Schema$GoogleCloudAiplatformV1FeatureViewSyncSyncSummary;
    }
    /**
     * Configuration for Sync. Only one option is set.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewSyncConfig {
        /**
         * Optional. If true, syncs the FeatureView in a continuous manner to Online Store.
         */
        continuous?: boolean | null;
        /**
         * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE\}" or "TZ=${IANA_TIME_ZONE\}". The ${IANA_TIME_ZONE\} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
         */
        cron?: string | null;
    }
    /**
     * Summary from the Sync job. For continuous syncs, the summary is updated periodically. For batch syncs, it gets updated on completion of the sync.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewSyncSyncSummary {
        /**
         * Output only. Total number of rows synced.
         */
        rowSynced?: string | null;
        /**
         * Lower bound of the system time watermark for the sync job. This is only set for continuously syncing feature views.
         */
        systemWatermarkTime?: string | null;
        /**
         * Output only. BigQuery slot milliseconds consumed for the sync job.
         */
        totalSlot?: string | null;
    }
    /**
     * A Vertex Rag source for features that need to be synced to Online Store.
     */
    export interface Schema$GoogleCloudAiplatformV1FeatureViewVertexRagSource {
        /**
         * Optional. The RAG corpus id corresponding to this FeatureView.
         */
        ragCorpusId?: string | null;
        /**
         * Required. The BigQuery view/table URI that will be materialized on each manual sync trigger. The table/view is expected to have the following columns and types at least: - `corpus_id` (STRING, NULLABLE/REQUIRED) - `file_id` (STRING, NULLABLE/REQUIRED) - `chunk_id` (STRING, NULLABLE/REQUIRED) - `chunk_data_type` (STRING, NULLABLE/REQUIRED) - `chunk_data` (STRING, NULLABLE/REQUIRED) - `embeddings` (FLOAT, REPEATED) - `file_original_uri` (STRING, NULLABLE/REQUIRED)
         */
        uri?: string | null;
    }
    /**
     * Request message for FeatureOnlineStoreService.FetchFeatureValues. All the features under the requested feature view will be returned.
     */
    export interface Schema$GoogleCloudAiplatformV1FetchFeatureValuesRequest {
        /**
         * Optional. Response data format. If not set, FeatureViewDataFormat.KEY_VALUE will be used.
         */
        dataFormat?: string | null;
        /**
         * Optional. The request key to fetch feature values for.
         */
        dataKey?: Schema$GoogleCloudAiplatformV1FeatureViewDataKey;
    }
    /**
     * Response message for FeatureOnlineStoreService.FetchFeatureValues
     */
    export interface Schema$GoogleCloudAiplatformV1FetchFeatureValuesResponse {
        /**
         * The data key associated with this response. Will only be populated for FeatureOnlineStoreService.StreamingFetchFeatureValues RPCs.
         */
        dataKey?: Schema$GoogleCloudAiplatformV1FeatureViewDataKey;
        /**
         * Feature values in KeyValue format.
         */
        keyValues?: Schema$GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList;
        /**
         * Feature values in proto Struct format.
         */
        protoStruct?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Response structure in the format of key (feature name) and (feature) value pair.
     */
    export interface Schema$GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList {
        /**
         * List of feature names and values.
         */
        features?: Schema$GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair[];
    }
    /**
     * Feature name & value pair.
     */
    export interface Schema$GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair {
        /**
         * Feature short name.
         */
        name?: string | null;
        /**
         * Feature value.
         */
        value?: Schema$GoogleCloudAiplatformV1FeatureValue;
    }
    /**
     * Request message for PredictionService.FetchPredictOperation.
     */
    export interface Schema$GoogleCloudAiplatformV1FetchPredictOperationRequest {
        /**
         * Required. The server-assigned name for the operation.
         */
        operationName?: string | null;
    }
    /**
     * URI based data.
     */
    export interface Schema$GoogleCloudAiplatformV1FileData {
        /**
         * Optional. Display name of the file data. Used to provide a label or filename to distinguish file datas. This field is only returned in PromptMessage for prompt management. It is not currently used in the Gemini GenerateContent calls.
         */
        displayName?: string | null;
        /**
         * Required. URI.
         */
        fileUri?: string | null;
        /**
         * Required. The IANA standard MIME type of the source data.
         */
        mimeType?: string | null;
    }
    /**
     * RagFile status.
     */
    export interface Schema$GoogleCloudAiplatformV1FileStatus {
        /**
         * Output only. Only when the `state` field is ERROR.
         */
        errorStatus?: string | null;
        /**
         * Output only. RagFile state.
         */
        state?: string | null;
    }
    /**
     * Assigns input data to training, validation, and test sets based on the given filters, data pieces not matched by any filter are ignored. Currently only supported for Datasets containing DataItems. If any of the filters in this message are to match nothing, then they can be set as '-' (the minus sign). Supported only for unstructured Datasets.
     */
    export interface Schema$GoogleCloudAiplatformV1FilterSplit {
        /**
         * Required. A filter on DataItems of the Dataset. DataItems that match this filter are used to test the Model. A filter with same syntax as the one used in DatasetService.ListDataItems may be used. If a single DataItem is matched by more than one of the FilterSplit filters, then it is assigned to the first set that applies to it in the training, validation, test order.
         */
        testFilter?: string | null;
        /**
         * Required. A filter on DataItems of the Dataset. DataItems that match this filter are used to train the Model. A filter with same syntax as the one used in DatasetService.ListDataItems may be used. If a single DataItem is matched by more than one of the FilterSplit filters, then it is assigned to the first set that applies to it in the training, validation, test order.
         */
        trainingFilter?: string | null;
        /**
         * Required. A filter on DataItems of the Dataset. DataItems that match this filter are used to validate the Model. A filter with same syntax as the one used in DatasetService.ListDataItems may be used. If a single DataItem is matched by more than one of the FilterSplit filters, then it is assigned to the first set that applies to it in the training, validation, test order.
         */
        validationFilter?: string | null;
    }
    /**
     * The request message for MatchService.FindNeighbors.
     */
    export interface Schema$GoogleCloudAiplatformV1FindNeighborsRequest {
        /**
         * The ID of the DeployedIndex that will serve the request. This request is sent to a specific IndexEndpoint, as per the IndexEndpoint.network. That IndexEndpoint also has IndexEndpoint.deployed_indexes, and each such index has a DeployedIndex.id field. The value of the field below must equal one of the DeployedIndex.id fields of the IndexEndpoint that is being called for this request.
         */
        deployedIndexId?: string | null;
        /**
         * The list of queries.
         */
        queries?: Schema$GoogleCloudAiplatformV1FindNeighborsRequestQuery[];
        /**
         * If set to true, the full datapoints (including all vector values and restricts) of the nearest neighbors are returned. Note that returning full datapoint will significantly increase the latency and cost of the query.
         */
        returnFullDatapoint?: boolean | null;
    }
    /**
     * A query to find a number of the nearest neighbors (most similar vectors) of a vector.
     */
    export interface Schema$GoogleCloudAiplatformV1FindNeighborsRequestQuery {
        /**
         * The number of neighbors to find via approximate search before exact reordering is performed. If not set, the default value from scam config is used; if set, this value must be \> 0.
         */
        approximateNeighborCount?: number | null;
        /**
         * Required. The datapoint/vector whose nearest neighbors should be searched for.
         */
        datapoint?: Schema$GoogleCloudAiplatformV1IndexDatapoint;
        /**
         * The fraction of the number of leaves to search, set at query time allows user to tune search performance. This value increase result in both search accuracy and latency increase. The value should be between 0.0 and 1.0. If not set or set to 0.0, query uses the default value specified in NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
         */
        fractionLeafNodesToSearchOverride?: number | null;
        /**
         * The number of nearest neighbors to be retrieved from database for each query. If not set, will use the default from the service configuration (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
         */
        neighborCount?: number | null;
        /**
         * Crowding is a constraint on a neighbor list produced by nearest neighbor search requiring that no more than some value k' of the k neighbors returned have the same value of crowding_attribute. It's used for improving result diversity. This field is the maximum number of matches with the same crowding tag.
         */
        perCrowdingAttributeNeighborCount?: number | null;
        /**
         * Optional. Represents RRF algorithm that combines search results.
         */
        rrf?: Schema$GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF;
    }
    /**
     * Parameters for RRF algorithm that combines search results.
     */
    export interface Schema$GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF {
        /**
         * Required. Users can provide an alpha value to give more weight to dense vs sparse results. For example, if the alpha is 0, we only return sparse and if the alpha is 1, we only return dense.
         */
        alpha?: number | null;
    }
    /**
     * The response message for MatchService.FindNeighbors.
     */
    export interface Schema$GoogleCloudAiplatformV1FindNeighborsResponse {
        /**
         * The nearest neighbors of the query datapoints.
         */
        nearestNeighbors?: Schema$GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors[];
    }
    /**
     * Nearest neighbors for one query.
     */
    export interface Schema$GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors {
        /**
         * The ID of the query datapoint.
         */
        id?: string | null;
        /**
         * All its neighbors.
         */
        neighbors?: Schema$GoogleCloudAiplatformV1FindNeighborsResponseNeighbor[];
    }
    /**
     * A neighbor of the query vector.
     */
    export interface Schema$GoogleCloudAiplatformV1FindNeighborsResponseNeighbor {
        /**
         * The datapoint of the neighbor. Note that full datapoints are returned only when "return_full_datapoint" is set to true. Otherwise, only the "datapoint_id" and "crowding_tag" fields are populated.
         */
        datapoint?: Schema$GoogleCloudAiplatformV1IndexDatapoint;
        /**
         * The distance between the neighbor and the dense embedding query.
         */
        distance?: number | null;
        /**
         * The distance between the neighbor and the query sparse_embedding.
         */
        sparseDistance?: number | null;
    }
    /**
     * Input for fluency metric.
     */
    export interface Schema$GoogleCloudAiplatformV1FluencyInput {
        /**
         * Required. Fluency instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1FluencyInstance;
        /**
         * Required. Spec for fluency score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1FluencySpec;
    }
    /**
     * Spec for fluency instance.
     */
    export interface Schema$GoogleCloudAiplatformV1FluencyInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
    }
    /**
     * Spec for fluency result.
     */
    export interface Schema$GoogleCloudAiplatformV1FluencyResult {
        /**
         * Output only. Confidence for fluency score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for fluency score.
         */
        explanation?: string | null;
        /**
         * Output only. Fluency score.
         */
        score?: number | null;
    }
    /**
     * Spec for fluency score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1FluencySpec {
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Assigns the input data to training, validation, and test sets as per the given fractions. Any of `training_fraction`, `validation_fraction` and `test_fraction` may optionally be provided, they must sum to up to 1. If the provided ones sum to less than 1, the remainder is assigned to sets as decided by Vertex AI. If none of the fractions are set, by default roughly 80% of data is used for training, 10% for validation, and 10% for test.
     */
    export interface Schema$GoogleCloudAiplatformV1FractionSplit {
        /**
         * The fraction of the input data that is to be used to evaluate the Model.
         */
        testFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to train the Model.
         */
        trainingFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to validate the Model.
         */
        validationFraction?: number | null;
    }
    /**
     * Input for fulfillment metric.
     */
    export interface Schema$GoogleCloudAiplatformV1FulfillmentInput {
        /**
         * Required. Fulfillment instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1FulfillmentInstance;
        /**
         * Required. Spec for fulfillment score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1FulfillmentSpec;
    }
    /**
     * Spec for fulfillment instance.
     */
    export interface Schema$GoogleCloudAiplatformV1FulfillmentInstance {
        /**
         * Required. Inference instruction prompt to compare prediction with.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
    }
    /**
     * Spec for fulfillment result.
     */
    export interface Schema$GoogleCloudAiplatformV1FulfillmentResult {
        /**
         * Output only. Confidence for fulfillment score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for fulfillment score.
         */
        explanation?: string | null;
        /**
         * Output only. Fulfillment score.
         */
        score?: number | null;
    }
    /**
     * Spec for fulfillment metric.
     */
    export interface Schema$GoogleCloudAiplatformV1FulfillmentSpec {
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * A predicted [FunctionCall] returned from the model that contains a string representing the [FunctionDeclaration.name] and a structured JSON object containing the parameters and their values.
     */
    export interface Schema$GoogleCloudAiplatformV1FunctionCall {
        /**
         * Optional. The function parameters and values in JSON object format. See [FunctionDeclaration.parameters] for parameter details.
         */
        args?: {
            [key: string]: any;
        } | null;
        /**
         * Required. The name of the function to call. Matches [FunctionDeclaration.name].
         */
        name?: string | null;
    }
    /**
     * Function calling config.
     */
    export interface Schema$GoogleCloudAiplatformV1FunctionCallingConfig {
        /**
         * Optional. Function names to call. Only set when the Mode is ANY. Function names should match [FunctionDeclaration.name]. With mode set to ANY, model will predict a function call from the set of function names provided.
         */
        allowedFunctionNames?: string[] | null;
        /**
         * Optional. Function calling mode.
         */
        mode?: string | null;
    }
    /**
     * Structured representation of a function declaration as defined by the [OpenAPI 3.0 specification](https://spec.openapis.org/oas/v3.0.3). Included in this declaration are the function name, description, parameters and response type. This FunctionDeclaration is a representation of a block of code that can be used as a `Tool` by the model and executed by the client.
     */
    export interface Schema$GoogleCloudAiplatformV1FunctionDeclaration {
        /**
         * Optional. Description and purpose of the function. Model uses it to decide how and whether to call the function.
         */
        description?: string | null;
        /**
         * Required. The name of the function to call. Must start with a letter or an underscore. Must be a-z, A-Z, 0-9, or contain underscores, dots and dashes, with a maximum length of 64.
         */
        name?: string | null;
        /**
         * Optional. Describes the parameters to this function in JSON Schema Object format. Reflects the Open API 3.03 Parameter Object. string Key: the name of the parameter. Parameter names are case sensitive. Schema Value: the Schema defining the type used for the parameter. For function with no parameters, this can be left unset. Parameter names must start with a letter or an underscore and must only contain chars a-z, A-Z, 0-9, or underscores with a maximum length of 64. Example with 1 required and 1 optional parameter: type: OBJECT properties: param1: type: STRING param2: type: INTEGER required: - param1
         */
        parameters?: Schema$GoogleCloudAiplatformV1Schema;
        /**
         * Optional. Describes the output from this function in JSON Schema format. Reflects the Open API 3.03 Response Object. The Schema defines the type used for the response value of the function.
         */
        response?: Schema$GoogleCloudAiplatformV1Schema;
    }
    /**
     * The result output from a [FunctionCall] that contains a string representing the [FunctionDeclaration.name] and a structured JSON object containing any output from the function is used as context to the model. This should contain the result of a [FunctionCall] made based on model prediction.
     */
    export interface Schema$GoogleCloudAiplatformV1FunctionResponse {
        /**
         * Required. The name of the function to call. Matches [FunctionDeclaration.name] and [FunctionCall.name].
         */
        name?: string | null;
        /**
         * Required. The function response in JSON object format. Use "output" key to specify function output and "error" key to specify error details (if any). If "output" and "error" keys are not specified, then whole "response" is treated as function output.
         */
        response?: {
            [key: string]: any;
        } | null;
    }
    /**
     * The Google Cloud Storage location where the output is to be written to.
     */
    export interface Schema$GoogleCloudAiplatformV1GcsDestination {
        /**
         * Required. Google Cloud Storage URI to output directory. If the uri doesn't end with '/', a '/' will be automatically appended. The directory is created if it doesn't exist.
         */
        outputUriPrefix?: string | null;
    }
    /**
     * The Google Cloud Storage location for the input content.
     */
    export interface Schema$GoogleCloudAiplatformV1GcsSource {
        /**
         * Required. Google Cloud Storage URI(-s) to the input file(s). May contain wildcards. For more information on wildcards, see https://cloud.google.com/storage/docs/wildcards.
         */
        uris?: string[] | null;
    }
    /**
     * Configuration for GenAiAdvancedFeatures.
     */
    export interface Schema$GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfig {
        /**
         * Configuration for Retrieval Augmented Generation feature.
         */
        ragConfig?: Schema$GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfigRagConfig;
    }
    /**
     * Configuration for Retrieval Augmented Generation feature.
     */
    export interface Schema$GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfigRagConfig {
        /**
         * If true, enable Retrieval Augmented Generation in ChatCompletion request. Once enabled, the endpoint will be identified as GenAI endpoint and Arthedain router will be used.
         */
        enableRag?: boolean | null;
    }
    /**
     * Request message for [PredictionService.GenerateContent].
     */
    export interface Schema$GoogleCloudAiplatformV1GenerateContentRequest {
        /**
         * Optional. The name of the cached content used as context to serve the prediction. Note: only used in explicit caching, where users can have control over caching (e.g. what content to cache) and enjoy guaranteed cost savings. Format: `projects/{project\}/locations/{location\}/cachedContents/{cachedContent\}`
         */
        cachedContent?: string | null;
        /**
         * Required. The content of the current conversation with the model. For single-turn queries, this is a single instance. For multi-turn queries, this is a repeated field that contains conversation history + latest request.
         */
        contents?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Optional. Generation config.
         */
        generationConfig?: Schema$GoogleCloudAiplatformV1GenerationConfig;
        /**
         * Optional. The labels with user-defined metadata for the request. It is used for billing and reporting only. Label keys and values can be no longer than 63 characters (Unicode codepoints) and can only contain lowercase letters, numeric characters, underscores, and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. Per request settings for blocking unsafe content. Enforced on GenerateContentResponse.candidates.
         */
        safetySettings?: Schema$GoogleCloudAiplatformV1SafetySetting[];
        /**
         * Optional. The user provided system instructions for the model. Note: only text should be used in parts and content in each part will be in a separate paragraph.
         */
        systemInstruction?: Schema$GoogleCloudAiplatformV1Content;
        /**
         * Optional. Tool config. This config is shared for all tools provided in the request.
         */
        toolConfig?: Schema$GoogleCloudAiplatformV1ToolConfig;
        /**
         * Optional. A list of `Tools` the model may use to generate the next response. A `Tool` is a piece of code that enables the system to interact with external systems to perform an action, or set of actions, outside of knowledge and scope of the model.
         */
        tools?: Schema$GoogleCloudAiplatformV1Tool[];
    }
    /**
     * Response message for [PredictionService.GenerateContent].
     */
    export interface Schema$GoogleCloudAiplatformV1GenerateContentResponse {
        /**
         * Output only. Generated candidates.
         */
        candidates?: Schema$GoogleCloudAiplatformV1Candidate[];
        /**
         * Output only. Timestamp when the request is made to the server.
         */
        createTime?: string | null;
        /**
         * Output only. The model version used to generate the response.
         */
        modelVersion?: string | null;
        /**
         * Output only. Content filter results for a prompt sent in the request. Note: Sent only in the first stream chunk. Only happens when no candidates were generated due to content violations.
         */
        promptFeedback?: Schema$GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback;
        /**
         * Output only. response_id is used to identify each response. It is the encoding of the event_id.
         */
        responseId?: string | null;
        /**
         * Usage metadata about the response(s).
         */
        usageMetadata?: Schema$GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata;
    }
    /**
     * Content filter results for a prompt sent in the request.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback {
        /**
         * Output only. Blocked reason.
         */
        blockReason?: string | null;
        /**
         * Output only. A readable block reason message.
         */
        blockReasonMessage?: string | null;
        /**
         * Output only. Safety ratings.
         */
        safetyRatings?: Schema$GoogleCloudAiplatformV1SafetyRating[];
    }
    /**
     * Usage metadata about response(s).
     */
    export interface Schema$GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata {
        /**
         * Output only. Number of tokens in the cached part in the input (the cached content).
         */
        cachedContentTokenCount?: number | null;
        /**
         * Output only. List of modalities of the cached content in the request input.
         */
        cacheTokensDetails?: Schema$GoogleCloudAiplatformV1ModalityTokenCount[];
        /**
         * Number of tokens in the response(s).
         */
        candidatesTokenCount?: number | null;
        /**
         * Output only. List of modalities that were returned in the response.
         */
        candidatesTokensDetails?: Schema$GoogleCloudAiplatformV1ModalityTokenCount[];
        /**
         * Number of tokens in the request. When `cached_content` is set, this is still the total effective prompt size meaning this includes the number of tokens in the cached content.
         */
        promptTokenCount?: number | null;
        /**
         * Output only. List of modalities that were processed in the request input.
         */
        promptTokensDetails?: Schema$GoogleCloudAiplatformV1ModalityTokenCount[];
        /**
         * Output only. Number of tokens present in thoughts output.
         */
        thoughtsTokenCount?: number | null;
        /**
         * Output only. Number of tokens present in tool-use prompt(s).
         */
        toolUsePromptTokenCount?: number | null;
        /**
         * Output only. List of modalities that were processed for tool-use request inputs.
         */
        toolUsePromptTokensDetails?: Schema$GoogleCloudAiplatformV1ModalityTokenCount[];
        /**
         * Total token count for prompt, response candidates, and tool-use prompts (if present).
         */
        totalTokenCount?: number | null;
        /**
         * Output only. Traffic type. This shows whether a request consumes Pay-As-You-Go or Provisioned Throughput quota.
         */
        trafficType?: string | null;
    }
    /**
     * Generate video response.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerateVideoResponse {
        /**
         * The cloud storage uris of the generated videos.
         */
        generatedSamples?: string[] | null;
        /**
         * Returns if any videos were filtered due to RAI policies.
         */
        raiMediaFilteredCount?: number | null;
        /**
         * Returns rai failure reasons if any.
         */
        raiMediaFilteredReasons?: string[] | null;
        /**
         * List of video bytes or Cloud Storage URIs of the generated videos.
         */
        videos?: Schema$GoogleCloudAiplatformV1GenerateVideoResponseVideo[];
    }
    /**
     * A generated video.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerateVideoResponseVideo {
        /**
         * Base64 encoded bytes string representing the video.
         */
        bytesBase64Encoded?: string | null;
        /**
         * Cloud Storage URI where the generated video is written.
         */
        gcsUri?: string | null;
        /**
         * The MIME type of the content of the video. - video/mp4
         */
        mimeType?: string | null;
    }
    /**
     * Generation config.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerationConfig {
        /**
         * Optional. If enabled, audio timestamp will be included in the request to the model.
         */
        audioTimestamp?: boolean | null;
        /**
         * Optional. Number of candidates to generate.
         */
        candidateCount?: number | null;
        /**
         * Optional. Frequency penalties.
         */
        frequencyPenalty?: number | null;
        /**
         * Optional. Logit probabilities.
         */
        logprobs?: number | null;
        /**
         * Optional. The maximum number of output tokens to generate per message.
         */
        maxOutputTokens?: number | null;
        /**
         * Optional. If specified, the media resolution specified will be used.
         */
        mediaResolution?: string | null;
        /**
         * Optional. Positive penalties.
         */
        presencePenalty?: number | null;
        /**
         * Optional. If true, export the logprobs results in response.
         */
        responseLogprobs?: boolean | null;
        /**
         * Optional. Output response mimetype of the generated candidate text. Supported mimetype: - `text/plain`: (default) Text output. - `application/json`: JSON response in the candidates. The model needs to be prompted to output the appropriate response type, otherwise the behavior is undefined. This is a preview feature.
         */
        responseMimeType?: string | null;
        /**
         * Optional. The modalities of the response.
         */
        responseModalities?: string[] | null;
        /**
         * Optional. The `Schema` object allows the definition of input and output data types. These types can be objects, but also primitives and arrays. Represents a select subset of an [OpenAPI 3.0 schema object](https://spec.openapis.org/oas/v3.0.3#schema). If set, a compatible response_mime_type must also be set. Compatible mimetypes: `application/json`: Schema for JSON response.
         */
        responseSchema?: Schema$GoogleCloudAiplatformV1Schema;
        /**
         * Optional. Routing configuration.
         */
        routingConfig?: Schema$GoogleCloudAiplatformV1GenerationConfigRoutingConfig;
        /**
         * Optional. Seed.
         */
        seed?: number | null;
        /**
         * Optional. The speech generation config.
         */
        speechConfig?: Schema$GoogleCloudAiplatformV1SpeechConfig;
        /**
         * Optional. Stop sequences.
         */
        stopSequences?: string[] | null;
        /**
         * Optional. Controls the randomness of predictions.
         */
        temperature?: number | null;
        /**
         * Optional. Config for thinking features. An error will be returned if this field is set for models that don't support thinking.
         */
        thinkingConfig?: Schema$GoogleCloudAiplatformV1GenerationConfigThinkingConfig;
        /**
         * Optional. If specified, top-k sampling will be used.
         */
        topK?: number | null;
        /**
         * Optional. If specified, nucleus sampling will be used.
         */
        topP?: number | null;
    }
    /**
     * The configuration for routing the request to a specific model.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerationConfigRoutingConfig {
        /**
         * Automated routing.
         */
        autoMode?: Schema$GoogleCloudAiplatformV1GenerationConfigRoutingConfigAutoRoutingMode;
        /**
         * Manual routing.
         */
        manualMode?: Schema$GoogleCloudAiplatformV1GenerationConfigRoutingConfigManualRoutingMode;
    }
    /**
     * When automated routing is specified, the routing will be determined by the pretrained routing model and customer provided model routing preference.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerationConfigRoutingConfigAutoRoutingMode {
        /**
         * The model routing preference.
         */
        modelRoutingPreference?: string | null;
    }
    /**
     * When manual routing is set, the specified model will be used directly.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerationConfigRoutingConfigManualRoutingMode {
        /**
         * The model name to use. Only the public LLM models are accepted. See [Supported models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/inference#supported-models).
         */
        modelName?: string | null;
    }
    /**
     * Config for thinking features.
     */
    export interface Schema$GoogleCloudAiplatformV1GenerationConfigThinkingConfig {
        /**
         * Optional. Indicates the thinking budget in tokens. This is only applied when enable_thinking is true.
         */
        thinkingBudget?: number | null;
    }
    /**
     * Generic Metadata shared by all operations.
     */
    export interface Schema$GoogleCloudAiplatformV1GenericOperationMetadata {
        /**
         * Output only. Time when the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. Partial failures encountered. E.g. single files that couldn't be read. This field should never exceed 20 entries. Status details field will contain standard Google Cloud error details.
         */
        partialFailures?: Schema$GoogleRpcStatus[];
        /**
         * Output only. Time when the operation was updated for the last time. If the operation has finished (successfully or not), this is the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Contains information about the source of the models generated from Generative AI Studio.
     */
    export interface Schema$GoogleCloudAiplatformV1GenieSource {
        /**
         * Required. The public base model URI.
         */
        baseModelUri?: string | null;
    }
    /**
     * The Google Drive location for the input content.
     */
    export interface Schema$GoogleCloudAiplatformV1GoogleDriveSource {
        /**
         * Required. Google Drive resource IDs.
         */
        resourceIds?: Schema$GoogleCloudAiplatformV1GoogleDriveSourceResourceId[];
    }
    /**
     * The type and ID of the Google Drive resource.
     */
    export interface Schema$GoogleCloudAiplatformV1GoogleDriveSourceResourceId {
        /**
         * Required. The ID of the Google Drive resource.
         */
        resourceId?: string | null;
        /**
         * Required. The type of the Google Drive resource.
         */
        resourceType?: string | null;
    }
    /**
     * Tool to retrieve public web data for grounding, powered by Google.
     */
    export interface Schema$GoogleCloudAiplatformV1GoogleSearchRetrieval {
        /**
         * Specifies the dynamic retrieval configuration for the given source.
         */
        dynamicRetrievalConfig?: Schema$GoogleCloudAiplatformV1DynamicRetrievalConfig;
    }
    /**
     * Input for groundedness metric.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundednessInput {
        /**
         * Required. Groundedness instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1GroundednessInstance;
        /**
         * Required. Spec for groundedness metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1GroundednessSpec;
    }
    /**
     * Spec for groundedness instance.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundednessInstance {
        /**
         * Required. Background information provided in context used to compare against the prediction.
         */
        context?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
    }
    /**
     * Spec for groundedness result.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundednessResult {
        /**
         * Output only. Confidence for groundedness score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for groundedness score.
         */
        explanation?: string | null;
        /**
         * Output only. Groundedness score.
         */
        score?: number | null;
    }
    /**
     * Spec for groundedness metric.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundednessSpec {
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Grounding chunk.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundingChunk {
        /**
         * Grounding chunk from context retrieved by the retrieval tools.
         */
        retrievedContext?: Schema$GoogleCloudAiplatformV1GroundingChunkRetrievedContext;
        /**
         * Grounding chunk from the web.
         */
        web?: Schema$GoogleCloudAiplatformV1GroundingChunkWeb;
    }
    /**
     * Chunk from context retrieved by the retrieval tools.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundingChunkRetrievedContext {
        /**
         * Additional context for the RAG retrieval result. This is only populated when using the RAG retrieval tool.
         */
        ragChunk?: Schema$GoogleCloudAiplatformV1RagChunk;
        /**
         * Text of the attribution.
         */
        text?: string | null;
        /**
         * Title of the attribution.
         */
        title?: string | null;
        /**
         * URI reference of the attribution.
         */
        uri?: string | null;
    }
    /**
     * Chunk from the web.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundingChunkWeb {
        /**
         * Domain of the (original) URI.
         */
        domain?: string | null;
        /**
         * Title of the chunk.
         */
        title?: string | null;
        /**
         * URI reference of the chunk.
         */
        uri?: string | null;
    }
    /**
     * Metadata returned to client when grounding is enabled.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundingMetadata {
        /**
         * List of supporting references retrieved from specified grounding source.
         */
        groundingChunks?: Schema$GoogleCloudAiplatformV1GroundingChunk[];
        /**
         * Optional. List of grounding support.
         */
        groundingSupports?: Schema$GoogleCloudAiplatformV1GroundingSupport[];
        /**
         * Optional. Output only. Retrieval metadata.
         */
        retrievalMetadata?: Schema$GoogleCloudAiplatformV1RetrievalMetadata;
        /**
         * Optional. Google search entry for the following-up web searches.
         */
        searchEntryPoint?: Schema$GoogleCloudAiplatformV1SearchEntryPoint;
        /**
         * Optional. Web search queries for the following-up web search.
         */
        webSearchQueries?: string[] | null;
    }
    /**
     * Grounding support.
     */
    export interface Schema$GoogleCloudAiplatformV1GroundingSupport {
        /**
         * Confidence score of the support references. Ranges from 0 to 1. 1 is the most confident. This list must have the same size as the grounding_chunk_indices.
         */
        confidenceScores?: number[] | null;
        /**
         * A list of indices (into 'grounding_chunk') specifying the citations associated with the claim. For instance [1,3,4] means that grounding_chunk[1], grounding_chunk[3], grounding_chunk[4] are the retrieved content attributed to the claim.
         */
        groundingChunkIndices?: number[] | null;
        /**
         * Segment of the content this support belongs to.
         */
        segment?: Schema$GoogleCloudAiplatformV1Segment;
    }
    /**
     * Represents a HyperparameterTuningJob. A HyperparameterTuningJob has a Study specification and multiple CustomJobs with identical CustomJob specification.
     */
    export interface Schema$GoogleCloudAiplatformV1HyperparameterTuningJob {
        /**
         * Output only. Time when the HyperparameterTuningJob was created.
         */
        createTime?: string | null;
        /**
         * Required. The display name of the HyperparameterTuningJob. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key options for a HyperparameterTuningJob. If this is set, then all resources created by the HyperparameterTuningJob will be encrypted with the provided encryption key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Time when the HyperparameterTuningJob entered any of the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
         */
        endTime?: string | null;
        /**
         * Output only. Only populated when job's state is JOB_STATE_FAILED or JOB_STATE_CANCELLED.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The labels with user-defined metadata to organize HyperparameterTuningJobs. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The number of failed Trials that need to be seen before failing the HyperparameterTuningJob. If set to 0, Vertex AI decides how many Trials must fail before the whole job fails.
         */
        maxFailedTrialCount?: number | null;
        /**
         * Required. The desired total number of Trials.
         */
        maxTrialCount?: number | null;
        /**
         * Output only. Resource name of the HyperparameterTuningJob.
         */
        name?: string | null;
        /**
         * Required. The desired number of Trials to run in parallel.
         */
        parallelTrialCount?: number | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Time when the HyperparameterTuningJob for the first time entered the `JOB_STATE_RUNNING` state.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the job.
         */
        state?: string | null;
        /**
         * Required. Study configuration of the HyperparameterTuningJob.
         */
        studySpec?: Schema$GoogleCloudAiplatformV1StudySpec;
        /**
         * Required. The spec of a trial job. The same spec applies to the CustomJobs created in all the trials.
         */
        trialJobSpec?: Schema$GoogleCloudAiplatformV1CustomJobSpec;
        /**
         * Output only. Trials of the HyperparameterTuningJob.
         */
        trials?: Schema$GoogleCloudAiplatformV1Trial[];
        /**
         * Output only. Time when the HyperparameterTuningJob was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * Matcher for Features of an EntityType by Feature ID.
     */
    export interface Schema$GoogleCloudAiplatformV1IdMatcher {
        /**
         * Required. The following are accepted as `ids`: * A single-element list containing only `*`, which selects all Features in the target EntityType, or * A list containing only Feature IDs, which selects only Features with those IDs in the target EntityType.
         */
        ids?: string[] | null;
    }
    /**
     * Describes the location from where we import data into a Dataset, together with the labels that will be applied to the DataItems and the Annotations.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportDataConfig {
        /**
         * Labels that will be applied to newly imported Annotations. If two Annotations are identical, one of them will be deduped. Two Annotations are considered identical if their payload, payload_schema_uri and all of their labels are the same. These labels will be overridden by Annotation labels specified inside index file referenced by import_schema_uri, e.g. jsonl file.
         */
        annotationLabels?: {
            [key: string]: string;
        } | null;
        /**
         * Labels that will be applied to newly imported DataItems. If an identical DataItem as one being imported already exists in the Dataset, then these labels will be appended to these of the already existing one, and if labels with identical key is imported before, the old label value will be overwritten. If two DataItems are identical in the same import data operation, the labels will be combined and if key collision happens in this case, one of the values will be picked randomly. Two DataItems are considered identical if their content bytes are identical (e.g. image bytes or pdf bytes). These labels will be overridden by Annotation labels specified inside index file referenced by import_schema_uri, e.g. jsonl file.
         */
        dataItemLabels?: {
            [key: string]: string;
        } | null;
        /**
         * The Google Cloud Storage location for the input content.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
        /**
         * Required. Points to a YAML file stored on Google Cloud Storage describing the import format. Validation will be done against the schema. The schema is defined as an [OpenAPI 3.0.2 Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
         */
        importSchemaUri?: string | null;
    }
    /**
     * Runtime operation information for DatasetService.ImportData.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportDataOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for DatasetService.ImportData.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportDataRequest {
        /**
         * Required. The desired input locations. The contents of all input locations will be imported in one batch.
         */
        importConfigs?: Schema$GoogleCloudAiplatformV1ImportDataConfig[];
    }
    /**
     * Response message for DatasetService.ImportData.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportDataResponse {
    }
    /**
     * Details of operations that perform import Feature values.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata {
        /**
         * List of ImportFeatureValues operations running under a single EntityType that are blocking this operation.
         */
        blockingOperationIds?: string[] | null;
        /**
         * Operation metadata for Featurestore import Feature values.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * Number of entities that have been imported by the operation.
         */
        importedEntityCount?: string | null;
        /**
         * Number of Feature values that have been imported by the operation.
         */
        importedFeatureValueCount?: string | null;
        /**
         * The number of rows in input source that weren't imported due to either * Not having any featureValues. * Having a null entityId. * Having a null timestamp. * Not being parsable (applicable for CSV sources).
         */
        invalidRowCount?: string | null;
        /**
         * The source URI from where Feature values are imported.
         */
        sourceUris?: string[] | null;
        /**
         * The number rows that weren't ingested due to having timestamps outside the retention boundary.
         */
        timestampOutsideRetentionRowsCount?: string | null;
    }
    /**
     * Request message for FeaturestoreService.ImportFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportFeatureValuesRequest {
        avroSource?: Schema$GoogleCloudAiplatformV1AvroSource;
        bigquerySource?: Schema$GoogleCloudAiplatformV1BigQuerySource;
        csvSource?: Schema$GoogleCloudAiplatformV1CsvSource;
        /**
         * If true, API doesn't start ingestion analysis pipeline.
         */
        disableIngestionAnalysis?: boolean | null;
        /**
         * If set, data will not be imported for online serving. This is typically used for backfilling, where Feature generation timestamps are not in the timestamp range needed for online serving.
         */
        disableOnlineServing?: boolean | null;
        /**
         * Source column that holds entity IDs. If not provided, entity IDs are extracted from the column named entity_id.
         */
        entityIdField?: string | null;
        /**
         * Required. Specifications defining which Feature values to import from the entity. The request fails if no feature_specs are provided, and having multiple feature_specs for one Feature is not allowed.
         */
        featureSpecs?: Schema$GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec[];
        /**
         * Single Feature timestamp for all entities being imported. The timestamp must not have higher than millisecond precision.
         */
        featureTime?: string | null;
        /**
         * Source column that holds the Feature timestamp for all Feature values in each entity.
         */
        featureTimeField?: string | null;
        /**
         * Specifies the number of workers that are used to write data to the Featurestore. Consider the online serving capacity that you require to achieve the desired import throughput without interfering with online serving. The value must be positive, and less than or equal to 100. If not set, defaults to using 1 worker. The low count ensures minimal impact on online serving performance.
         */
        workerCount?: number | null;
    }
    /**
     * Defines the Feature value(s) to import.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec {
        /**
         * Required. ID of the Feature to import values of. This Feature must exist in the target EntityType, or the request will fail.
         */
        id?: string | null;
        /**
         * Source column to get the Feature values from. If not set, uses the column with the same name as the Feature ID.
         */
        sourceField?: string | null;
    }
    /**
     * Response message for FeaturestoreService.ImportFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportFeatureValuesResponse {
        /**
         * Number of entities that have been imported by the operation.
         */
        importedEntityCount?: string | null;
        /**
         * Number of Feature values that have been imported by the operation.
         */
        importedFeatureValueCount?: string | null;
        /**
         * The number of rows in input source that weren't imported due to either * Not having any featureValues. * Having a null entityId. * Having a null timestamp. * Not being parsable (applicable for CSV sources).
         */
        invalidRowCount?: string | null;
        /**
         * The number rows that weren't ingested due to having feature timestamps outside the retention boundary.
         */
        timestampOutsideRetentionRowsCount?: string | null;
    }
    /**
     * Request message for ModelService.ImportModelEvaluation
     */
    export interface Schema$GoogleCloudAiplatformV1ImportModelEvaluationRequest {
        /**
         * Required. Model evaluation resource to be imported.
         */
        modelEvaluation?: Schema$GoogleCloudAiplatformV1ModelEvaluation;
    }
    /**
     * Config for importing RagFiles.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportRagFilesConfig {
        /**
         * Google Cloud Storage location. Supports importing individual files as well as entire Google Cloud Storage directories. Sample formats: - `gs://bucket_name/my_directory/object_name/my_file.txt` - `gs://bucket_name/my_directory`
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
        /**
         * Google Drive location. Supports importing individual files as well as Google Drive folders.
         */
        googleDriveSource?: Schema$GoogleCloudAiplatformV1GoogleDriveSource;
        /**
         * The BigQuery destination to write import result to. It should be a bigquery table resource name (e.g. "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the table does not exist, it will be created with the expected schema. If the table exists, the schema will be validated and data will be added to this existing table.
         */
        importResultBigquerySink?: Schema$GoogleCloudAiplatformV1BigQueryDestination;
        /**
         * The Cloud Storage path to write import result to.
         */
        importResultGcsSink?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * Jira queries with their corresponding authentication.
         */
        jiraSource?: Schema$GoogleCloudAiplatformV1JiraSource;
        /**
         * Optional. The max number of queries per minute that this job is allowed to make to the embedding model specified on the corpus. This value is specific to this job and not shared across other import jobs. Consult the Quotas page on the project to set an appropriate value here. If unspecified, a default value of 1,000 QPM would be used.
         */
        maxEmbeddingRequestsPerMin?: number | null;
        /**
         * The BigQuery destination to write partial failures to. It should be a bigquery table resource name (e.g. "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the table does not exist, it will be created with the expected schema. If the table exists, the schema will be validated and data will be added to this existing table. Deprecated. Prefer to use `import_result_bq_sink`.
         */
        partialFailureBigquerySink?: Schema$GoogleCloudAiplatformV1BigQueryDestination;
        /**
         * The Cloud Storage path to write partial failures to. Deprecated. Prefer to use `import_result_gcs_sink`.
         */
        partialFailureGcsSink?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * Optional. Specifies the parsing config for RagFiles. RAG will use the default parser if this field is not set.
         */
        ragFileParsingConfig?: Schema$GoogleCloudAiplatformV1RagFileParsingConfig;
        /**
         * Specifies the transformation config for RagFiles.
         */
        ragFileTransformationConfig?: Schema$GoogleCloudAiplatformV1RagFileTransformationConfig;
        /**
         * SharePoint sources.
         */
        sharePointSources?: Schema$GoogleCloudAiplatformV1SharePointSources;
        /**
         * Slack channels with their corresponding access tokens.
         */
        slackSource?: Schema$GoogleCloudAiplatformV1SlackSource;
    }
    /**
     * Request message for VertexRagDataService.ImportRagFiles.
     */
    export interface Schema$GoogleCloudAiplatformV1ImportRagFilesRequest {
        /**
         * Required. The config for the RagFiles to be synced and imported into the RagCorpus. VertexRagDataService.ImportRagFiles.
         */
        importRagFilesConfig?: Schema$GoogleCloudAiplatformV1ImportRagFilesConfig;
    }
    /**
     * A representation of a collection of database items organized in a way that allows for approximate nearest neighbor (a.k.a ANN) algorithms search.
     */
    export interface Schema$GoogleCloudAiplatformV1Index {
        /**
         * Output only. Timestamp when this Index was created.
         */
        createTime?: string | null;
        /**
         * Output only. The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
         */
        deployedIndexes?: Schema$GoogleCloudAiplatformV1DeployedIndexRef[];
        /**
         * The description of the Index.
         */
        description?: string | null;
        /**
         * Required. The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Immutable. Customer-managed encryption key spec for an Index. If set, this Index and all sub-resources of this Index will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Output only. Stats of the index resource.
         */
        indexStats?: Schema$GoogleCloudAiplatformV1IndexStats;
        /**
         * Immutable. The update method to use with this Index. If not set, BATCH_UPDATE will be used by default.
         */
        indexUpdateMethod?: string | null;
        /**
         * The labels with user-defined metadata to organize your Indexes. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * An additional information about the Index; the schema of the metadata can be found in metadata_schema.
         */
        metadata?: any | null;
        /**
         * Immutable. Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). Note: The URI given on output will be immutable and probably different, including the URI scheme, than the one given on input. The output URI will point to a location where the user only has a read access.
         */
        metadataSchemaUri?: string | null;
        /**
         * Output only. The resource name of the Index.
         */
        name?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Timestamp when this Index was most recently updated. This also includes any update to the contents of the Index. Note that Operations working on this Index may have their Operations.metadata.generic_metadata.update_time a little after the value of this timestamp, yet that does not mean their results are not already reflected in the Index. Result of any successfully completed Operation on the Index is reflected in it.
         */
        updateTime?: string | null;
    }
    /**
     * A datapoint of Index.
     */
    export interface Schema$GoogleCloudAiplatformV1IndexDatapoint {
        /**
         * Optional. CrowdingTag of the datapoint, the number of neighbors to return in each crowding can be configured during query.
         */
        crowdingTag?: Schema$GoogleCloudAiplatformV1IndexDatapointCrowdingTag;
        /**
         * Required. Unique identifier of the datapoint.
         */
        datapointId?: string | null;
        /**
         * Required. Feature embedding vector for dense index. An array of numbers with the length of [NearestNeighborSearchConfig.dimensions].
         */
        featureVector?: number[] | null;
        /**
         * Optional. List of Restrict of the datapoint, used to perform "restricted searches" where boolean rule are used to filter the subset of the database eligible for matching. This uses numeric comparisons.
         */
        numericRestricts?: Schema$GoogleCloudAiplatformV1IndexDatapointNumericRestriction[];
        /**
         * Optional. List of Restrict of the datapoint, used to perform "restricted searches" where boolean rule are used to filter the subset of the database eligible for matching. This uses categorical tokens. See: https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
         */
        restricts?: Schema$GoogleCloudAiplatformV1IndexDatapointRestriction[];
        /**
         * Optional. Feature embedding vector for sparse index.
         */
        sparseEmbedding?: Schema$GoogleCloudAiplatformV1IndexDatapointSparseEmbedding;
    }
    /**
     * Crowding tag is a constraint on a neighbor list produced by nearest neighbor search requiring that no more than some value k' of the k neighbors returned have the same value of crowding_attribute.
     */
    export interface Schema$GoogleCloudAiplatformV1IndexDatapointCrowdingTag {
        /**
         * The attribute value used for crowding. The maximum number of neighbors to return per crowding attribute value (per_crowding_attribute_num_neighbors) is configured per-query. This field is ignored if per_crowding_attribute_num_neighbors is larger than the total number of neighbors to return for a given query.
         */
        crowdingAttribute?: string | null;
    }
    /**
     * This field allows restricts to be based on numeric comparisons rather than categorical tokens.
     */
    export interface Schema$GoogleCloudAiplatformV1IndexDatapointNumericRestriction {
        /**
         * The namespace of this restriction. e.g.: cost.
         */
        namespace?: string | null;
        /**
         * This MUST be specified for queries and must NOT be specified for datapoints.
         */
        op?: string | null;
        /**
         * Represents 64 bit float.
         */
        valueDouble?: number | null;
        /**
         * Represents 32 bit float.
         */
        valueFloat?: number | null;
        /**
         * Represents 64 bit integer.
         */
        valueInt?: string | null;
    }
    /**
     * Restriction of a datapoint which describe its attributes(tokens) from each of several attribute categories(namespaces).
     */
    export interface Schema$GoogleCloudAiplatformV1IndexDatapointRestriction {
        /**
         * The attributes to allow in this namespace. e.g.: 'red'
         */
        allowList?: string[] | null;
        /**
         * The attributes to deny in this namespace. e.g.: 'blue'
         */
        denyList?: string[] | null;
        /**
         * The namespace of this restriction. e.g.: color.
         */
        namespace?: string | null;
    }
    /**
     * Feature embedding vector for sparse index. An array of numbers whose values are located in the specified dimensions.
     */
    export interface Schema$GoogleCloudAiplatformV1IndexDatapointSparseEmbedding {
        /**
         * Required. The list of indexes for the embedding values of the sparse vector.
         */
        dimensions?: string[] | null;
        /**
         * Required. The list of embedding values of the sparse vector.
         */
        values?: number[] | null;
    }
    /**
     * Indexes are deployed into it. An IndexEndpoint can have multiple DeployedIndexes.
     */
    export interface Schema$GoogleCloudAiplatformV1IndexEndpoint {
        /**
         * Output only. Timestamp when this IndexEndpoint was created.
         */
        createTime?: string | null;
        /**
         * Output only. The indexes deployed in this endpoint.
         */
        deployedIndexes?: Schema$GoogleCloudAiplatformV1DeployedIndex[];
        /**
         * The description of the IndexEndpoint.
         */
        description?: string | null;
        /**
         * Required. The display name of the IndexEndpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Deprecated: If true, expose the IndexEndpoint via private service connect. Only one of the fields, network or enable_private_service_connect, can be set.
         */
        enablePrivateServiceConnect?: boolean | null;
        /**
         * Immutable. Customer-managed encryption key spec for an IndexEndpoint. If set, this IndexEndpoint and all sub-resources of this IndexEndpoint will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The labels with user-defined metadata to organize your IndexEndpoints. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. The resource name of the IndexEndpoint.
         */
        name?: string | null;
        /**
         * Optional. The full name of the Google Compute Engine [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the IndexEndpoint should be peered. Private services access must already be configured for the network. If left unspecified, the Endpoint is not peered with any network. network and private_service_connect_config are mutually exclusive. [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert): `projects/{project\}/global/networks/{network\}`. Where {project\} is a project number, as in '12345', and {network\} is network name.
         */
        network?: string | null;
        /**
         * Optional. Configuration for private service connect. network and private_service_connect_config are mutually exclusive.
         */
        privateServiceConnectConfig?: Schema$GoogleCloudAiplatformV1PrivateServiceConnectConfig;
        /**
         * Output only. If public_endpoint_enabled is true, this field will be populated with the domain name to use for this index endpoint.
         */
        publicEndpointDomainName?: string | null;
        /**
         * Optional. If true, the deployed index will be accessible through public endpoint.
         */
        publicEndpointEnabled?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Timestamp when this IndexEndpoint was last updated. This timestamp is not updated when the endpoint's DeployedIndexes are updated, e.g. due to updates of the original Indexes they are the deployments of.
         */
        updateTime?: string | null;
    }
    /**
     * IndexPrivateEndpoints proto is used to provide paths for users to send requests via private endpoints (e.g. private service access, private service connect). To send request via private service access, use match_grpc_address. To send request via private service connect, use service_attachment.
     */
    export interface Schema$GoogleCloudAiplatformV1IndexPrivateEndpoints {
        /**
         * Output only. The ip address used to send match gRPC requests.
         */
        matchGrpcAddress?: string | null;
        /**
         * Output only. PscAutomatedEndpoints is populated if private service connect is enabled if PscAutomatedConfig is set.
         */
        pscAutomatedEndpoints?: Schema$GoogleCloudAiplatformV1PscAutomatedEndpoints[];
        /**
         * Output only. The name of the service attachment resource. Populated if private service connect is enabled.
         */
        serviceAttachment?: string | null;
    }
    /**
     * Stats of the Index.
     */
    export interface Schema$GoogleCloudAiplatformV1IndexStats {
        /**
         * Output only. The number of shards in the Index.
         */
        shardsCount?: number | null;
        /**
         * Output only. The number of sparse vectors in the Index.
         */
        sparseVectorsCount?: string | null;
        /**
         * Output only. The number of dense vectors in the Index.
         */
        vectorsCount?: string | null;
    }
    /**
     * Specifies Vertex AI owned input data to be used for training, and possibly evaluating, the Model.
     */
    export interface Schema$GoogleCloudAiplatformV1InputDataConfig {
        /**
         * Applicable only to custom training with Datasets that have DataItems and Annotations. Cloud Storage URI that points to a YAML file describing the annotation schema. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). The schema files that can be used here are found in gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the chosen schema must be consistent with metadata of the Dataset specified by dataset_id. Only Annotations that both match this schema and belong to DataItems not ignored by the split method are used in respectively training, validation or test role, depending on the role of the DataItem they are on. When used in conjunction with annotations_filter, the Annotations used for training are filtered by both annotations_filter and annotation_schema_uri.
         */
        annotationSchemaUri?: string | null;
        /**
         * Applicable only to Datasets that have DataItems and Annotations. A filter on Annotations of the Dataset. Only Annotations that both match this filter and belong to DataItems not ignored by the split method are used in respectively training, validation or test role, depending on the role of the DataItem they are on (for the auto-assigned that role is decided by Vertex AI). A filter with same syntax as the one used in ListAnnotations may be used, but note here it filters across all Annotations of the Dataset, and not just within a single DataItem.
         */
        annotationsFilter?: string | null;
        /**
         * Only applicable to custom training with tabular Dataset with BigQuery source. The BigQuery project location where the training data is to be written to. In the given project a new dataset is created with name `dataset___` where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All training input data is written into that dataset. In the dataset three tables are created, `training`, `validation` and `test`. * AIP_DATA_FORMAT = "bigquery". * AIP_TRAINING_DATA_URI = "bigquery_destination.dataset___.training" * AIP_VALIDATION_DATA_URI = "bigquery_destination.dataset___.validation" * AIP_TEST_DATA_URI = "bigquery_destination.dataset___.test"
         */
        bigqueryDestination?: Schema$GoogleCloudAiplatformV1BigQueryDestination;
        /**
         * Required. The ID of the Dataset in the same Project and Location which data will be used to train the Model. The Dataset must use schema compatible with Model being trained, and what is compatible should be described in the used TrainingPipeline's training_task_definition. For tabular Datasets, all their data is exported to training, to pick and choose from.
         */
        datasetId?: string | null;
        /**
         * Split based on the provided filters for each set.
         */
        filterSplit?: Schema$GoogleCloudAiplatformV1FilterSplit;
        /**
         * Split based on fractions defining the size of each set.
         */
        fractionSplit?: Schema$GoogleCloudAiplatformV1FractionSplit;
        /**
         * The Cloud Storage location where the training data is to be written to. In the given directory a new directory is created with name: `dataset---` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All training input data is written into that directory. The Vertex AI environment variables representing Cloud Storage data URIs are represented in the Cloud Storage wildcard format to support sharded data. e.g.: "gs://.../training-*.jsonl" * AIP_DATA_FORMAT = "jsonl" for non-tabular data, "csv" for tabular data * AIP_TRAINING_DATA_URI = "gcs_destination/dataset---/training-*.${AIP_DATA_FORMAT\}" * AIP_VALIDATION_DATA_URI = "gcs_destination/dataset---/validation-*.${AIP_DATA_FORMAT\}" * AIP_TEST_DATA_URI = "gcs_destination/dataset---/test-*.${AIP_DATA_FORMAT\}"
         */
        gcsDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * Whether to persist the ML use assignment to data item system labels.
         */
        persistMlUseAssignment?: boolean | null;
        /**
         * Supported only for tabular Datasets. Split based on a predefined key.
         */
        predefinedSplit?: Schema$GoogleCloudAiplatformV1PredefinedSplit;
        /**
         * Only applicable to Datasets that have SavedQueries. The ID of a SavedQuery (annotation set) under the Dataset specified by dataset_id used for filtering Annotations for training. Only Annotations that are associated with this SavedQuery are used in respectively training. When used in conjunction with annotations_filter, the Annotations used for training are filtered by both saved_query_id and annotations_filter. Only one of saved_query_id and annotation_schema_uri should be specified as both of them represent the same thing: problem type.
         */
        savedQueryId?: string | null;
        /**
         * Supported only for tabular Datasets. Split based on the distribution of the specified column.
         */
        stratifiedSplit?: Schema$GoogleCloudAiplatformV1StratifiedSplit;
        /**
         * Supported only for tabular Datasets. Split based on the timestamp of the input data pieces.
         */
        timestampSplit?: Schema$GoogleCloudAiplatformV1TimestampSplit;
    }
    /**
     * A list of int64 values.
     */
    export interface Schema$GoogleCloudAiplatformV1Int64Array {
        /**
         * A list of int64 values.
         */
        values?: string[] | null;
    }
    /**
     * An attribution method that computes the Aumann-Shapley value taking advantage of the model's fully differentiable structure. Refer to this paper for more details: https://arxiv.org/abs/1703.01365
     */
    export interface Schema$GoogleCloudAiplatformV1IntegratedGradientsAttribution {
        /**
         * Config for IG with blur baseline. When enabled, a linear path from the maximally blurred image to the input image is created. Using a blurred baseline instead of zero (black image) is motivated by the BlurIG approach explained here: https://arxiv.org/abs/2004.03383
         */
        blurBaselineConfig?: Schema$GoogleCloudAiplatformV1BlurBaselineConfig;
        /**
         * Config for SmoothGrad approximation of gradients. When enabled, the gradients are approximated by averaging the gradients from noisy samples in the vicinity of the inputs. Adding noise can help improve the computed gradients. Refer to this paper for more details: https://arxiv.org/pdf/1706.03825.pdf
         */
        smoothGradConfig?: Schema$GoogleCloudAiplatformV1SmoothGradConfig;
        /**
         * Required. The number of steps for approximating the path integral. A good value to start is 50 and gradually increase until the sum to diff property is within the desired error range. Valid range of its value is [1, 100], inclusively.
         */
        stepCount?: number | null;
    }
    /**
     * The Jira source for the ImportRagFilesRequest.
     */
    export interface Schema$GoogleCloudAiplatformV1JiraSource {
        /**
         * Required. The Jira queries.
         */
        jiraQueries?: Schema$GoogleCloudAiplatformV1JiraSourceJiraQueries[];
    }
    /**
     * JiraQueries contains the Jira queries and corresponding authentication.
     */
    export interface Schema$GoogleCloudAiplatformV1JiraSourceJiraQueries {
        /**
         * Required. The SecretManager secret version resource name (e.g. projects/{project\}/secrets/{secret\}/versions/{version\}) storing the Jira API key. See [Manage API tokens for your Atlassian account](https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
         */
        apiKeyConfig?: Schema$GoogleCloudAiplatformV1ApiAuthApiKeyConfig;
        /**
         * A list of custom Jira queries to import. For information about JQL (Jira Query Language), see https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
         */
        customQueries?: string[] | null;
        /**
         * Required. The Jira email address.
         */
        email?: string | null;
        /**
         * A list of Jira projects to import in their entirety.
         */
        projects?: string[] | null;
        /**
         * Required. The Jira server URI.
         */
        serverUri?: string | null;
    }
    /**
     * Contains information about the Large Model.
     */
    export interface Schema$GoogleCloudAiplatformV1LargeModelReference {
        /**
         * Required. The unique name of the large Foundation or pre-built model. Like "chat-bison", "text-bison". Or model name with version ID, like "chat-bison@001", "text-bison@005", etc.
         */
        name?: string | null;
    }
    /**
     * A subgraph of the overall lineage graph. Event edges connect Artifact and Execution nodes.
     */
    export interface Schema$GoogleCloudAiplatformV1LineageSubgraph {
        /**
         * The Artifact nodes in the subgraph.
         */
        artifacts?: Schema$GoogleCloudAiplatformV1Artifact[];
        /**
         * The Event edges between Artifacts and Executions in the subgraph.
         */
        events?: Schema$GoogleCloudAiplatformV1Event[];
        /**
         * The Execution nodes in the subgraph.
         */
        executions?: Schema$GoogleCloudAiplatformV1Execution[];
    }
    /**
     * Response message for DatasetService.ListAnnotations.
     */
    export interface Schema$GoogleCloudAiplatformV1ListAnnotationsResponse {
        /**
         * A list of Annotations that matches the specified filter in the request.
         */
        annotations?: Schema$GoogleCloudAiplatformV1Annotation[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for MetadataService.ListArtifacts.
     */
    export interface Schema$GoogleCloudAiplatformV1ListArtifactsResponse {
        /**
         * The Artifacts retrieved from the MetadataStore.
         */
        artifacts?: Schema$GoogleCloudAiplatformV1Artifact[];
        /**
         * A token, which can be sent as ListArtifactsRequest.page_token to retrieve the next page. If this field is not populated, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for JobService.ListBatchPredictionJobs
     */
    export interface Schema$GoogleCloudAiplatformV1ListBatchPredictionJobsResponse {
        /**
         * List of BatchPredictionJobs in the requested page.
         */
        batchPredictionJobs?: Schema$GoogleCloudAiplatformV1BatchPredictionJob[];
        /**
         * A token to retrieve the next page of results. Pass to ListBatchPredictionJobsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response with a list of CachedContents.
     */
    export interface Schema$GoogleCloudAiplatformV1ListCachedContentsResponse {
        /**
         * List of cached contents.
         */
        cachedContents?: Schema$GoogleCloudAiplatformV1CachedContent[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for MetadataService.ListContexts.
     */
    export interface Schema$GoogleCloudAiplatformV1ListContextsResponse {
        /**
         * The Contexts retrieved from the MetadataStore.
         */
        contexts?: Schema$GoogleCloudAiplatformV1Context[];
        /**
         * A token, which can be sent as ListContextsRequest.page_token to retrieve the next page. If this field is not populated, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for JobService.ListCustomJobs
     */
    export interface Schema$GoogleCloudAiplatformV1ListCustomJobsResponse {
        /**
         * List of CustomJobs in the requested page.
         */
        customJobs?: Schema$GoogleCloudAiplatformV1CustomJob[];
        /**
         * A token to retrieve the next page of results. Pass to ListCustomJobsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for DatasetService.ListDataItems.
     */
    export interface Schema$GoogleCloudAiplatformV1ListDataItemsResponse {
        /**
         * A list of DataItems that matches the specified filter in the request.
         */
        dataItems?: Schema$GoogleCloudAiplatformV1DataItem[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for JobService.ListDataLabelingJobs.
     */
    export interface Schema$GoogleCloudAiplatformV1ListDataLabelingJobsResponse {
        /**
         * A list of DataLabelingJobs that matches the specified filter in the request.
         */
        dataLabelingJobs?: Schema$GoogleCloudAiplatformV1DataLabelingJob[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for DatasetService.ListDatasets.
     */
    export interface Schema$GoogleCloudAiplatformV1ListDatasetsResponse {
        /**
         * A list of Datasets that matches the specified filter in the request.
         */
        datasets?: Schema$GoogleCloudAiplatformV1Dataset[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for DatasetService.ListDatasetVersions.
     */
    export interface Schema$GoogleCloudAiplatformV1ListDatasetVersionsResponse {
        /**
         * A list of DatasetVersions that matches the specified filter in the request.
         */
        datasetVersions?: Schema$GoogleCloudAiplatformV1DatasetVersion[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for ListDeploymentResourcePools method.
     */
    export interface Schema$GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse {
        /**
         * The DeploymentResourcePools from the specified location.
         */
        deploymentResourcePools?: Schema$GoogleCloudAiplatformV1DeploymentResourcePool[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for EndpointService.ListEndpoints.
     */
    export interface Schema$GoogleCloudAiplatformV1ListEndpointsResponse {
        /**
         * List of Endpoints in the requested page.
         */
        endpoints?: Schema$GoogleCloudAiplatformV1Endpoint[];
        /**
         * A token to retrieve the next page of results. Pass to ListEndpointsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for FeaturestoreService.ListEntityTypes.
     */
    export interface Schema$GoogleCloudAiplatformV1ListEntityTypesResponse {
        /**
         * The EntityTypes matching the request.
         */
        entityTypes?: Schema$GoogleCloudAiplatformV1EntityType[];
        /**
         * A token, which can be sent as ListEntityTypesRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for MetadataService.ListExecutions.
     */
    export interface Schema$GoogleCloudAiplatformV1ListExecutionsResponse {
        /**
         * The Executions retrieved from the MetadataStore.
         */
        executions?: Schema$GoogleCloudAiplatformV1Execution[];
        /**
         * A token, which can be sent as ListExecutionsRequest.page_token to retrieve the next page. If this field is not populated, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for FeatureRegistryService.ListFeatureGroups.
     */
    export interface Schema$GoogleCloudAiplatformV1ListFeatureGroupsResponse {
        /**
         * The FeatureGroups matching the request.
         */
        featureGroups?: Schema$GoogleCloudAiplatformV1FeatureGroup[];
        /**
         * A token, which can be sent as ListFeatureGroupsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for FeatureOnlineStoreAdminService.ListFeatureOnlineStores.
     */
    export interface Schema$GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse {
        /**
         * The FeatureOnlineStores matching the request.
         */
        featureOnlineStores?: Schema$GoogleCloudAiplatformV1FeatureOnlineStore[];
        /**
         * A token, which can be sent as ListFeatureOnlineStoresRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for FeaturestoreService.ListFeatures. Response message for FeatureRegistryService.ListFeatures.
     */
    export interface Schema$GoogleCloudAiplatformV1ListFeaturesResponse {
        /**
         * The Features matching the request.
         */
        features?: Schema$GoogleCloudAiplatformV1Feature[];
        /**
         * A token, which can be sent as ListFeaturesRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for FeaturestoreService.ListFeaturestores.
     */
    export interface Schema$GoogleCloudAiplatformV1ListFeaturestoresResponse {
        /**
         * The Featurestores matching the request.
         */
        featurestores?: Schema$GoogleCloudAiplatformV1Featurestore[];
        /**
         * A token, which can be sent as ListFeaturestoresRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for FeatureOnlineStoreAdminService.ListFeatureViews.
     */
    export interface Schema$GoogleCloudAiplatformV1ListFeatureViewsResponse {
        /**
         * The FeatureViews matching the request.
         */
        featureViews?: Schema$GoogleCloudAiplatformV1FeatureView[];
        /**
         * A token, which can be sent as ListFeatureViewsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for FeatureOnlineStoreAdminService.ListFeatureViewSyncs.
     */
    export interface Schema$GoogleCloudAiplatformV1ListFeatureViewSyncsResponse {
        /**
         * The FeatureViewSyncs matching the request.
         */
        featureViewSyncs?: Schema$GoogleCloudAiplatformV1FeatureViewSync[];
        /**
         * A token, which can be sent as ListFeatureViewSyncsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for JobService.ListHyperparameterTuningJobs
     */
    export interface Schema$GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse {
        /**
         * List of HyperparameterTuningJobs in the requested page. HyperparameterTuningJob.trials of the jobs will be not be returned.
         */
        hyperparameterTuningJobs?: Schema$GoogleCloudAiplatformV1HyperparameterTuningJob[];
        /**
         * A token to retrieve the next page of results. Pass to ListHyperparameterTuningJobsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for IndexEndpointService.ListIndexEndpoints.
     */
    export interface Schema$GoogleCloudAiplatformV1ListIndexEndpointsResponse {
        /**
         * List of IndexEndpoints in the requested page.
         */
        indexEndpoints?: Schema$GoogleCloudAiplatformV1IndexEndpoint[];
        /**
         * A token to retrieve next page of results. Pass to ListIndexEndpointsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for IndexService.ListIndexes.
     */
    export interface Schema$GoogleCloudAiplatformV1ListIndexesResponse {
        /**
         * List of indexes in the requested page.
         */
        indexes?: Schema$GoogleCloudAiplatformV1Index[];
        /**
         * A token to retrieve next page of results. Pass to ListIndexesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for MetadataService.ListMetadataSchemas.
     */
    export interface Schema$GoogleCloudAiplatformV1ListMetadataSchemasResponse {
        /**
         * The MetadataSchemas found for the MetadataStore.
         */
        metadataSchemas?: Schema$GoogleCloudAiplatformV1MetadataSchema[];
        /**
         * A token, which can be sent as ListMetadataSchemasRequest.page_token to retrieve the next page. If this field is not populated, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for MetadataService.ListMetadataStores.
     */
    export interface Schema$GoogleCloudAiplatformV1ListMetadataStoresResponse {
        /**
         * The MetadataStores found for the Location.
         */
        metadataStores?: Schema$GoogleCloudAiplatformV1MetadataStore[];
        /**
         * A token, which can be sent as ListMetadataStoresRequest.page_token to retrieve the next page. If this field is not populated, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for JobService.ListModelDeploymentMonitoringJobs.
     */
    export interface Schema$GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse {
        /**
         * A list of ModelDeploymentMonitoringJobs that matches the specified filter in the request.
         */
        modelDeploymentMonitoringJobs?: Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringJob[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for ModelService.ListModelEvaluationSlices.
     */
    export interface Schema$GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse {
        /**
         * List of ModelEvaluations in the requested page.
         */
        modelEvaluationSlices?: Schema$GoogleCloudAiplatformV1ModelEvaluationSlice[];
        /**
         * A token to retrieve next page of results. Pass to ListModelEvaluationSlicesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for ModelService.ListModelEvaluations.
     */
    export interface Schema$GoogleCloudAiplatformV1ListModelEvaluationsResponse {
        /**
         * List of ModelEvaluations in the requested page.
         */
        modelEvaluations?: Schema$GoogleCloudAiplatformV1ModelEvaluation[];
        /**
         * A token to retrieve next page of results. Pass to ListModelEvaluationsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for ModelService.ListModels
     */
    export interface Schema$GoogleCloudAiplatformV1ListModelsResponse {
        /**
         * List of Models in the requested page.
         */
        models?: Schema$GoogleCloudAiplatformV1Model[];
        /**
         * A token to retrieve next page of results. Pass to ListModelsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for ModelService.ListModelVersionCheckpoints
     */
    export interface Schema$GoogleCloudAiplatformV1ListModelVersionCheckpointsResponse {
        /**
         * List of Model Version checkpoints.
         */
        checkpoints?: Schema$GoogleCloudAiplatformV1ModelVersionCheckpoint[];
        /**
         * A token to retrieve the next page of results. Pass to ListModelVersionCheckpointsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for ModelService.ListModelVersions
     */
    export interface Schema$GoogleCloudAiplatformV1ListModelVersionsResponse {
        /**
         * List of Model versions in the requested page. In the returned Model name field, version ID instead of regvision tag will be included.
         */
        models?: Schema$GoogleCloudAiplatformV1Model[];
        /**
         * A token to retrieve the next page of results. Pass to ListModelVersionsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for JobService.ListNasJobs
     */
    export interface Schema$GoogleCloudAiplatformV1ListNasJobsResponse {
        /**
         * List of NasJobs in the requested page. NasJob.nas_job_output of the jobs will not be returned.
         */
        nasJobs?: Schema$GoogleCloudAiplatformV1NasJob[];
        /**
         * A token to retrieve the next page of results. Pass to ListNasJobsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for JobService.ListNasTrialDetails
     */
    export interface Schema$GoogleCloudAiplatformV1ListNasTrialDetailsResponse {
        /**
         * List of top NasTrials in the requested page.
         */
        nasTrialDetails?: Schema$GoogleCloudAiplatformV1NasTrialDetail[];
        /**
         * A token to retrieve the next page of results. Pass to ListNasTrialDetailsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for [NotebookService.CreateNotebookExecutionJob]
     */
    export interface Schema$GoogleCloudAiplatformV1ListNotebookExecutionJobsResponse {
        /**
         * A token to retrieve next page of results. Pass to ListNotebookExecutionJobsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of NotebookExecutionJobs in the requested page.
         */
        notebookExecutionJobs?: Schema$GoogleCloudAiplatformV1NotebookExecutionJob[];
    }
    /**
     * Response message for NotebookService.ListNotebookRuntimes.
     */
    export interface Schema$GoogleCloudAiplatformV1ListNotebookRuntimesResponse {
        /**
         * A token to retrieve next page of results. Pass to ListNotebookRuntimesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of NotebookRuntimes in the requested page.
         */
        notebookRuntimes?: Schema$GoogleCloudAiplatformV1NotebookRuntime[];
    }
    /**
     * Response message for NotebookService.ListNotebookRuntimeTemplates.
     */
    export interface Schema$GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse {
        /**
         * A token to retrieve next page of results. Pass to ListNotebookRuntimeTemplatesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of NotebookRuntimeTemplates in the requested page.
         */
        notebookRuntimeTemplates?: Schema$GoogleCloudAiplatformV1NotebookRuntimeTemplate[];
    }
    /**
     * Request message for VizierService.ListOptimalTrials.
     */
    export interface Schema$GoogleCloudAiplatformV1ListOptimalTrialsRequest {
    }
    /**
     * Response message for VizierService.ListOptimalTrials.
     */
    export interface Schema$GoogleCloudAiplatformV1ListOptimalTrialsResponse {
        /**
         * The pareto-optimal Trials for multiple objective Study or the optimal trial for single objective Study. The definition of pareto-optimal can be checked in wiki page. https://en.wikipedia.org/wiki/Pareto_efficiency
         */
        optimalTrials?: Schema$GoogleCloudAiplatformV1Trial[];
    }
    /**
     * Response message for PersistentResourceService.ListPersistentResources
     */
    export interface Schema$GoogleCloudAiplatformV1ListPersistentResourcesResponse {
        /**
         * A token to retrieve next page of results. Pass to ListPersistentResourcesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        persistentResources?: Schema$GoogleCloudAiplatformV1PersistentResource[];
    }
    /**
     * Response message for PipelineService.ListPipelineJobs
     */
    export interface Schema$GoogleCloudAiplatformV1ListPipelineJobsResponse {
        /**
         * A token to retrieve the next page of results. Pass to ListPipelineJobsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of PipelineJobs in the requested page.
         */
        pipelineJobs?: Schema$GoogleCloudAiplatformV1PipelineJob[];
    }
    /**
     * Response message for VertexRagDataService.ListRagCorpora.
     */
    export interface Schema$GoogleCloudAiplatformV1ListRagCorporaResponse {
        /**
         * A token to retrieve the next page of results. Pass to ListRagCorporaRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of RagCorpora in the requested page.
         */
        ragCorpora?: Schema$GoogleCloudAiplatformV1RagCorpus[];
    }
    /**
     * Response message for VertexRagDataService.ListRagFiles.
     */
    export interface Schema$GoogleCloudAiplatformV1ListRagFilesResponse {
        /**
         * A token to retrieve the next page of results. Pass to ListRagFilesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of RagFiles in the requested page.
         */
        ragFiles?: Schema$GoogleCloudAiplatformV1RagFile[];
    }
    /**
     * Response message for ReasoningEngineService.ListReasoningEngines
     */
    export interface Schema$GoogleCloudAiplatformV1ListReasoningEnginesResponse {
        /**
         * A token to retrieve the next page of results. Pass to ListReasoningEnginesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of ReasoningEngines in the requested page.
         */
        reasoningEngines?: Schema$GoogleCloudAiplatformV1ReasoningEngine[];
    }
    /**
     * Response message for DatasetService.ListSavedQueries.
     */
    export interface Schema$GoogleCloudAiplatformV1ListSavedQueriesResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
        /**
         * A list of SavedQueries that match the specified filter in the request.
         */
        savedQueries?: Schema$GoogleCloudAiplatformV1SavedQuery[];
    }
    /**
     * Response message for ScheduleService.ListSchedules
     */
    export interface Schema$GoogleCloudAiplatformV1ListSchedulesResponse {
        /**
         * A token to retrieve the next page of results. Pass to ListSchedulesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of Schedules in the requested page.
         */
        schedules?: Schema$GoogleCloudAiplatformV1Schedule[];
    }
    /**
     * Response message for SpecialistPoolService.ListSpecialistPools.
     */
    export interface Schema$GoogleCloudAiplatformV1ListSpecialistPoolsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
        /**
         * A list of SpecialistPools that matches the specified filter in the request.
         */
        specialistPools?: Schema$GoogleCloudAiplatformV1SpecialistPool[];
    }
    /**
     * Response message for VizierService.ListStudies.
     */
    export interface Schema$GoogleCloudAiplatformV1ListStudiesResponse {
        /**
         * Passes this token as the `page_token` field of the request for a subsequent call. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The studies associated with the project.
         */
        studies?: Schema$GoogleCloudAiplatformV1Study[];
    }
    /**
     * Response message for TensorboardService.ListTensorboardExperiments.
     */
    export interface Schema$GoogleCloudAiplatformV1ListTensorboardExperimentsResponse {
        /**
         * A token, which can be sent as ListTensorboardExperimentsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The TensorboardExperiments mathching the request.
         */
        tensorboardExperiments?: Schema$GoogleCloudAiplatformV1TensorboardExperiment[];
    }
    /**
     * Response message for TensorboardService.ListTensorboardRuns.
     */
    export interface Schema$GoogleCloudAiplatformV1ListTensorboardRunsResponse {
        /**
         * A token, which can be sent as ListTensorboardRunsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The TensorboardRuns mathching the request.
         */
        tensorboardRuns?: Schema$GoogleCloudAiplatformV1TensorboardRun[];
    }
    /**
     * Response message for TensorboardService.ListTensorboards.
     */
    export interface Schema$GoogleCloudAiplatformV1ListTensorboardsResponse {
        /**
         * A token, which can be sent as ListTensorboardsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The Tensorboards mathching the request.
         */
        tensorboards?: Schema$GoogleCloudAiplatformV1Tensorboard[];
    }
    /**
     * Response message for TensorboardService.ListTensorboardTimeSeries.
     */
    export interface Schema$GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse {
        /**
         * A token, which can be sent as ListTensorboardTimeSeriesRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The TensorboardTimeSeries mathching the request.
         */
        tensorboardTimeSeries?: Schema$GoogleCloudAiplatformV1TensorboardTimeSeries[];
    }
    /**
     * Response message for PipelineService.ListTrainingPipelines
     */
    export interface Schema$GoogleCloudAiplatformV1ListTrainingPipelinesResponse {
        /**
         * A token to retrieve the next page of results. Pass to ListTrainingPipelinesRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of TrainingPipelines in the requested page.
         */
        trainingPipelines?: Schema$GoogleCloudAiplatformV1TrainingPipeline[];
    }
    /**
     * Response message for VizierService.ListTrials.
     */
    export interface Schema$GoogleCloudAiplatformV1ListTrialsResponse {
        /**
         * Pass this token as the `page_token` field of the request for a subsequent call. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The Trials associated with the Study.
         */
        trials?: Schema$GoogleCloudAiplatformV1Trial[];
    }
    /**
     * Response message for GenAiTuningService.ListTuningJobs
     */
    export interface Schema$GoogleCloudAiplatformV1ListTuningJobsResponse {
        /**
         * A token to retrieve the next page of results. Pass to ListTuningJobsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
        /**
         * List of TuningJobs in the requested page.
         */
        tuningJobs?: Schema$GoogleCloudAiplatformV1TuningJob[];
    }
    /**
     * Logprobs Result
     */
    export interface Schema$GoogleCloudAiplatformV1LogprobsResult {
        /**
         * Length = total number of decoding steps. The chosen candidates may or may not be in top_candidates.
         */
        chosenCandidates?: Schema$GoogleCloudAiplatformV1LogprobsResultCandidate[];
        /**
         * Length = total number of decoding steps.
         */
        topCandidates?: Schema$GoogleCloudAiplatformV1LogprobsResultTopCandidates[];
    }
    /**
     * Candidate for the logprobs token and score.
     */
    export interface Schema$GoogleCloudAiplatformV1LogprobsResultCandidate {
        /**
         * The candidate's log probability.
         */
        logProbability?: number | null;
        /**
         * The candidate's token string value.
         */
        token?: string | null;
        /**
         * The candidate's token id value.
         */
        tokenId?: number | null;
    }
    /**
     * Candidates with top log probabilities at each decoding step.
     */
    export interface Schema$GoogleCloudAiplatformV1LogprobsResultTopCandidates {
        /**
         * Sorted by log probability in descending order.
         */
        candidates?: Schema$GoogleCloudAiplatformV1LogprobsResultCandidate[];
    }
    /**
     * Request message for VizierService.LookupStudy.
     */
    export interface Schema$GoogleCloudAiplatformV1LookupStudyRequest {
        /**
         * Required. The user-defined display name of the Study
         */
        displayName?: string | null;
    }
    /**
     * Specification of a single machine.
     */
    export interface Schema$GoogleCloudAiplatformV1MachineSpec {
        /**
         * The number of accelerators to attach to the machine.
         */
        acceleratorCount?: number | null;
        /**
         * Immutable. The type of accelerator(s) that may be attached to the machine as per accelerator_count.
         */
        acceleratorType?: string | null;
        /**
         * Immutable. The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types) See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types). For DeployedModel this field is optional, and the default value is `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec this field is required.
         */
        machineType?: string | null;
        /**
         * Optional. Immutable. Configuration controlling how this resource pool consumes reservation.
         */
        reservationAffinity?: Schema$GoogleCloudAiplatformV1ReservationAffinity;
        /**
         * Immutable. The topology of the TPUs. Corresponds to the TPU topologies available from GKE. (Example: tpu_topology: "2x2x1").
         */
        tpuTopology?: string | null;
    }
    /**
     * Manual batch tuning parameters.
     */
    export interface Schema$GoogleCloudAiplatformV1ManualBatchTuningParameters {
        /**
         * Immutable. The number of the records (e.g. instances) of the operation given in each batch to a machine replica. Machine type, and size of a single record should be considered when setting this parameter, higher value speeds up the batch operation's execution, but too high value will result in a whole batch not fitting in a machine's memory, and the whole operation will fail. The default value is 64.
         */
        batchSize?: number | null;
    }
    /**
     * A message representing a Measurement of a Trial. A Measurement contains the Metrics got by executing a Trial using suggested hyperparameter values.
     */
    export interface Schema$GoogleCloudAiplatformV1Measurement {
        /**
         * Output only. Time that the Trial has been running at the point of this Measurement.
         */
        elapsedDuration?: string | null;
        /**
         * Output only. A list of metrics got by evaluating the objective functions using suggested Parameter values.
         */
        metrics?: Schema$GoogleCloudAiplatformV1MeasurementMetric[];
        /**
         * Output only. The number of steps the machine learning model has been trained for. Must be non-negative.
         */
        stepCount?: string | null;
    }
    /**
     * A message representing a metric in the measurement.
     */
    export interface Schema$GoogleCloudAiplatformV1MeasurementMetric {
        /**
         * Output only. The ID of the Metric. The Metric should be defined in StudySpec's Metrics.
         */
        metricId?: string | null;
        /**
         * Output only. The value for this metric.
         */
        value?: number | null;
    }
    /**
     * Request message for ModelService.MergeVersionAliases.
     */
    export interface Schema$GoogleCloudAiplatformV1MergeVersionAliasesRequest {
        /**
         * Required. The set of version aliases to merge. The alias should be at most 128 characters, and match `a-z{0,126\}[a-z-0-9]`. Add the `-` prefix to an alias means removing that alias from the version. `-` is NOT counted in the 128 characters. Example: `-golden` means removing the `golden` alias from the version. There is NO ordering in aliases, which means 1) The aliases returned from GetModel API might not have the exactly same order from this MergeVersionAliases API. 2) Adding and deleting the same alias in the request is not recommended, and the 2 operations will be cancelled out.
         */
        versionAliases?: string[] | null;
    }
    /**
     * Instance of a general MetadataSchema.
     */
    export interface Schema$GoogleCloudAiplatformV1MetadataSchema {
        /**
         * Output only. Timestamp when this MetadataSchema was created.
         */
        createTime?: string | null;
        /**
         * Description of the Metadata Schema
         */
        description?: string | null;
        /**
         * Output only. The resource name of the MetadataSchema.
         */
        name?: string | null;
        /**
         * Required. The raw YAML string representation of the MetadataSchema. The combination of [MetadataSchema.version] and the schema name given by `title` in [MetadataSchema.schema] must be unique within a MetadataStore. The schema is defined as an OpenAPI 3.0.2 [MetadataSchema Object](https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.2.md#schemaObject)
         */
        schema?: string | null;
        /**
         * The type of the MetadataSchema. This is a property that identifies which metadata types will use the MetadataSchema.
         */
        schemaType?: string | null;
        /**
         * The version of the MetadataSchema. The version's format must match the following regular expression: `^[0-9]+.+.+$`, which would allow to order/compare different versions. Example: 1.0.0, 1.0.1, etc.
         */
        schemaVersion?: string | null;
    }
    /**
     * Instance of a metadata store. Contains a set of metadata that can be queried.
     */
    export interface Schema$GoogleCloudAiplatformV1MetadataStore {
        /**
         * Output only. Timestamp when this MetadataStore was created.
         */
        createTime?: string | null;
        /**
         * Optional. Dataplex integration settings.
         */
        dataplexConfig?: Schema$GoogleCloudAiplatformV1MetadataStoreDataplexConfig;
        /**
         * Description of the MetadataStore.
         */
        description?: string | null;
        /**
         * Customer-managed encryption key spec for a Metadata Store. If set, this Metadata Store and all sub-resources of this Metadata Store are secured using this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. The resource name of the MetadataStore instance.
         */
        name?: string | null;
        /**
         * Output only. State information of the MetadataStore.
         */
        state?: Schema$GoogleCloudAiplatformV1MetadataStoreMetadataStoreState;
        /**
         * Output only. Timestamp when this MetadataStore was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Represents Dataplex integration settings.
     */
    export interface Schema$GoogleCloudAiplatformV1MetadataStoreDataplexConfig {
        /**
         * Optional. Whether or not Data Lineage synchronization is enabled for Vertex Pipelines.
         */
        enabledPipelinesLineage?: boolean | null;
    }
    /**
     * Represents state information for a MetadataStore.
     */
    export interface Schema$GoogleCloudAiplatformV1MetadataStoreMetadataStoreState {
        /**
         * The disk utilization of the MetadataStore in bytes.
         */
        diskUtilizationBytes?: string | null;
    }
    /**
     * The metric used for dataset level evaluation.
     */
    export interface Schema$GoogleCloudAiplatformV1Metric {
        /**
         * Optional. The aggregation metrics to use.
         */
        aggregationMetrics?: string[] | null;
        /**
         * Spec for bleu metric.
         */
        bleuSpec?: Schema$GoogleCloudAiplatformV1BleuSpec;
        /**
         * Spec for exact match metric.
         */
        exactMatchSpec?: Schema$GoogleCloudAiplatformV1ExactMatchSpec;
        /**
         * Spec for pairwise metric.
         */
        pairwiseMetricSpec?: Schema$GoogleCloudAiplatformV1PairwiseMetricSpec;
        /**
         * Spec for pointwise metric.
         */
        pointwiseMetricSpec?: Schema$GoogleCloudAiplatformV1PointwiseMetricSpec;
        /**
         * Spec for rouge metric.
         */
        rougeSpec?: Schema$GoogleCloudAiplatformV1RougeSpec;
    }
    /**
     * Input for MetricX metric.
     */
    export interface Schema$GoogleCloudAiplatformV1MetricxInput {
        /**
         * Required. Metricx instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1MetricxInstance;
        /**
         * Required. Spec for Metricx metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1MetricxSpec;
    }
    /**
     * Spec for MetricX instance - The fields used for evaluation are dependent on the MetricX version.
     */
    export interface Schema$GoogleCloudAiplatformV1MetricxInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
        /**
         * Optional. Source text in original language.
         */
        source?: string | null;
    }
    /**
     * Spec for MetricX result - calculates the MetricX score for the given instance using the version specified in the spec.
     */
    export interface Schema$GoogleCloudAiplatformV1MetricxResult {
        /**
         * Output only. MetricX score. Range depends on version.
         */
        score?: number | null;
    }
    /**
     * Spec for MetricX metric.
     */
    export interface Schema$GoogleCloudAiplatformV1MetricxSpec {
        /**
         * Optional. Source language in BCP-47 format.
         */
        sourceLanguage?: string | null;
        /**
         * Optional. Target language in BCP-47 format. Covers both prediction and reference.
         */
        targetLanguage?: string | null;
        /**
         * Required. Which version to use for evaluation.
         */
        version?: string | null;
    }
    /**
     * Represents one resource that exists in automl.googleapis.com, datalabeling.googleapis.com or ml.googleapis.com.
     */
    export interface Schema$GoogleCloudAiplatformV1MigratableResource {
        /**
         * Output only. Represents one Dataset in automl.googleapis.com.
         */
        automlDataset?: Schema$GoogleCloudAiplatformV1MigratableResourceAutomlDataset;
        /**
         * Output only. Represents one Model in automl.googleapis.com.
         */
        automlModel?: Schema$GoogleCloudAiplatformV1MigratableResourceAutomlModel;
        /**
         * Output only. Represents one Dataset in datalabeling.googleapis.com.
         */
        dataLabelingDataset?: Schema$GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset;
        /**
         * Output only. Timestamp when the last migration attempt on this MigratableResource started. Will not be set if there's no migration attempt on this MigratableResource.
         */
        lastMigrateTime?: string | null;
        /**
         * Output only. Timestamp when this MigratableResource was last updated.
         */
        lastUpdateTime?: string | null;
        /**
         * Output only. Represents one Version in ml.googleapis.com.
         */
        mlEngineModelVersion?: Schema$GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion;
    }
    /**
     * Represents one Dataset in automl.googleapis.com.
     */
    export interface Schema$GoogleCloudAiplatformV1MigratableResourceAutomlDataset {
        /**
         * Full resource name of automl Dataset. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`.
         */
        dataset?: string | null;
        /**
         * The Dataset's display name in automl.googleapis.com.
         */
        datasetDisplayName?: string | null;
    }
    /**
     * Represents one Model in automl.googleapis.com.
     */
    export interface Schema$GoogleCloudAiplatformV1MigratableResourceAutomlModel {
        /**
         * Full resource name of automl Model. Format: `projects/{project\}/locations/{location\}/models/{model\}`.
         */
        model?: string | null;
        /**
         * The Model's display name in automl.googleapis.com.
         */
        modelDisplayName?: string | null;
    }
    /**
     * Represents one Dataset in datalabeling.googleapis.com.
     */
    export interface Schema$GoogleCloudAiplatformV1MigratableResourceDataLabelingDataset {
        /**
         * The migratable AnnotatedDataset in datalabeling.googleapis.com belongs to the data labeling Dataset.
         */
        dataLabelingAnnotatedDatasets?: Schema$GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset[];
        /**
         * Full resource name of data labeling Dataset. Format: `projects/{project\}/datasets/{dataset\}`.
         */
        dataset?: string | null;
        /**
         * The Dataset's display name in datalabeling.googleapis.com.
         */
        datasetDisplayName?: string | null;
    }
    /**
     * Represents one AnnotatedDataset in datalabeling.googleapis.com.
     */
    export interface Schema$GoogleCloudAiplatformV1MigratableResourceDataLabelingDatasetDataLabelingAnnotatedDataset {
        /**
         * Full resource name of data labeling AnnotatedDataset. Format: `projects/{project\}/datasets/{dataset\}/annotatedDatasets/{annotated_dataset\}`.
         */
        annotatedDataset?: string | null;
        /**
         * The AnnotatedDataset's display name in datalabeling.googleapis.com.
         */
        annotatedDatasetDisplayName?: string | null;
    }
    /**
     * Represents one model Version in ml.googleapis.com.
     */
    export interface Schema$GoogleCloudAiplatformV1MigratableResourceMlEngineModelVersion {
        /**
         * The ml.googleapis.com endpoint that this model Version currently lives in. Example values: * ml.googleapis.com * us-centrall-ml.googleapis.com * europe-west4-ml.googleapis.com * asia-east1-ml.googleapis.com
         */
        endpoint?: string | null;
        /**
         * Full resource name of ml engine model Version. Format: `projects/{project\}/models/{model\}/versions/{version\}`.
         */
        version?: string | null;
    }
    /**
     * Config of migrating one resource from automl.googleapis.com, datalabeling.googleapis.com and ml.googleapis.com to Vertex AI.
     */
    export interface Schema$GoogleCloudAiplatformV1MigrateResourceRequest {
        /**
         * Config for migrating Dataset in automl.googleapis.com to Vertex AI's Dataset.
         */
        migrateAutomlDatasetConfig?: Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig;
        /**
         * Config for migrating Model in automl.googleapis.com to Vertex AI's Model.
         */
        migrateAutomlModelConfig?: Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig;
        /**
         * Config for migrating Dataset in datalabeling.googleapis.com to Vertex AI's Dataset.
         */
        migrateDataLabelingDatasetConfig?: Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig;
        /**
         * Config for migrating Version in ml.googleapis.com to Vertex AI's Model.
         */
        migrateMlEngineModelVersionConfig?: Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig;
    }
    /**
     * Config for migrating Dataset in automl.googleapis.com to Vertex AI's Dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlDatasetConfig {
        /**
         * Required. Full resource name of automl Dataset. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`.
         */
        dataset?: string | null;
        /**
         * Required. Display name of the Dataset in Vertex AI. System will pick a display name if unspecified.
         */
        datasetDisplayName?: string | null;
    }
    /**
     * Config for migrating Model in automl.googleapis.com to Vertex AI's Model.
     */
    export interface Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateAutomlModelConfig {
        /**
         * Required. Full resource name of automl Model. Format: `projects/{project\}/locations/{location\}/models/{model\}`.
         */
        model?: string | null;
        /**
         * Optional. Display name of the model in Vertex AI. System will pick a display name if unspecified.
         */
        modelDisplayName?: string | null;
    }
    /**
     * Config for migrating Dataset in datalabeling.googleapis.com to Vertex AI's Dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfig {
        /**
         * Required. Full resource name of data labeling Dataset. Format: `projects/{project\}/datasets/{dataset\}`.
         */
        dataset?: string | null;
        /**
         * Optional. Display name of the Dataset in Vertex AI. System will pick a display name if unspecified.
         */
        datasetDisplayName?: string | null;
        /**
         * Optional. Configs for migrating AnnotatedDataset in datalabeling.googleapis.com to Vertex AI's SavedQuery. The specified AnnotatedDatasets have to belong to the datalabeling Dataset.
         */
        migrateDataLabelingAnnotatedDatasetConfigs?: Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig[];
    }
    /**
     * Config for migrating AnnotatedDataset in datalabeling.googleapis.com to Vertex AI's SavedQuery.
     */
    export interface Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateDataLabelingDatasetConfigMigrateDataLabelingAnnotatedDatasetConfig {
        /**
         * Required. Full resource name of data labeling AnnotatedDataset. Format: `projects/{project\}/datasets/{dataset\}/annotatedDatasets/{annotated_dataset\}`.
         */
        annotatedDataset?: string | null;
    }
    /**
     * Config for migrating version in ml.googleapis.com to Vertex AI's Model.
     */
    export interface Schema$GoogleCloudAiplatformV1MigrateResourceRequestMigrateMlEngineModelVersionConfig {
        /**
         * Required. The ml.googleapis.com endpoint that this model version should be migrated from. Example values: * ml.googleapis.com * us-centrall-ml.googleapis.com * europe-west4-ml.googleapis.com * asia-east1-ml.googleapis.com
         */
        endpoint?: string | null;
        /**
         * Required. Display name of the model in Vertex AI. System will pick a display name if unspecified.
         */
        modelDisplayName?: string | null;
        /**
         * Required. Full resource name of ml engine model version. Format: `projects/{project\}/models/{model\}/versions/{version\}`.
         */
        modelVersion?: string | null;
    }
    /**
     * Describes a successfully migrated resource.
     */
    export interface Schema$GoogleCloudAiplatformV1MigrateResourceResponse {
        /**
         * Migrated Dataset's resource name.
         */
        dataset?: string | null;
        /**
         * Before migration, the identifier in ml.googleapis.com, automl.googleapis.com or datalabeling.googleapis.com.
         */
        migratableResource?: Schema$GoogleCloudAiplatformV1MigratableResource;
        /**
         * Migrated Model's resource name.
         */
        model?: string | null;
    }
    /**
     * Represents token counting info for a single modality.
     */
    export interface Schema$GoogleCloudAiplatformV1ModalityTokenCount {
        /**
         * The modality associated with this token count.
         */
        modality?: string | null;
        /**
         * Number of tokens.
         */
        tokenCount?: number | null;
    }
    /**
     * A trained machine learning Model.
     */
    export interface Schema$GoogleCloudAiplatformV1Model {
        /**
         * Immutable. The path to the directory containing the Model artifact and any of its supporting files. Not required for AutoML Models.
         */
        artifactUri?: string | null;
        /**
         * Optional. User input field to specify the base model source. Currently it only supports specifing the Model Garden models and Genie models.
         */
        baseModelSource?: Schema$GoogleCloudAiplatformV1ModelBaseModelSource;
        /**
         * Input only. The specification of the container that is to be used when deploying this Model. The specification is ingested upon ModelService.UploadModel, and all binaries it contains are copied and stored internally by Vertex AI. Not required for AutoML Models.
         */
        containerSpec?: Schema$GoogleCloudAiplatformV1ModelContainerSpec;
        /**
         * Output only. Timestamp when this Model was uploaded into Vertex AI.
         */
        createTime?: string | null;
        /**
         * Stats of data used for training or evaluating the Model. Only populated when the Model is trained by a TrainingPipeline with data_input_config.
         */
        dataStats?: Schema$GoogleCloudAiplatformV1ModelDataStats;
        /**
         * The default checkpoint id of a model version.
         */
        defaultCheckpointId?: string | null;
        /**
         * Output only. The pointers to DeployedModels created from this Model. Note that Model could have been deployed to Endpoints in different Locations.
         */
        deployedModels?: Schema$GoogleCloudAiplatformV1DeployedModelRef[];
        /**
         * The description of the Model.
         */
        description?: string | null;
        /**
         * Required. The display name of the Model. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for a Model. If set, this Model and all sub-resources of this Model will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The default explanation specification for this Model. The Model can be used for requesting explanation after being deployed if it is populated. The Model can be used for batch explanation if it is populated. All fields of the explanation_spec can be overridden by explanation_spec of DeployModelRequest.deployed_model, or explanation_spec of BatchPredictionJob. If the default explanation specification is not set for this Model, this Model can still be used for requesting explanation by setting explanation_spec of DeployModelRequest.deployed_model and for batch explanation by setting explanation_spec of BatchPredictionJob.
         */
        explanationSpec?: Schema$GoogleCloudAiplatformV1ExplanationSpec;
        /**
         * The labels with user-defined metadata to organize your Models. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Immutable. An additional information about the Model; the schema of the metadata can be found in metadata_schema. Unset if the Model does not have any additional information.
         */
        metadata?: any | null;
        /**
         * Output only. The resource name of the Artifact that was created in MetadataStore when creating the Model. The Artifact resource name pattern is `projects/{project\}/locations/{location\}/metadataStores/{metadata_store\}/artifacts/{artifact\}`.
         */
        metadataArtifact?: string | null;
        /**
         * Immutable. Points to a YAML file stored on Google Cloud Storage describing additional information about the Model, that is specific to it. Unset if the Model does not have any additional information. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models always have this field populated by Vertex AI, if no additional metadata is needed, this field is set to an empty string. Note: The URI given on output will be immutable and probably different, including the URI scheme, than the one given on input. The output URI will point to a location where the user only has a read access.
         */
        metadataSchemaUri?: string | null;
        /**
         * Output only. Source of a model. It can either be automl training pipeline, custom training pipeline, BigQuery ML, or saved and tuned from Genie or Model Garden.
         */
        modelSourceInfo?: Schema$GoogleCloudAiplatformV1ModelSourceInfo;
        /**
         * The resource name of the Model.
         */
        name?: string | null;
        /**
         * Output only. If this Model is a copy of another Model, this contains info about the original.
         */
        originalModelInfo?: Schema$GoogleCloudAiplatformV1ModelOriginalModelInfo;
        /**
         * Optional. This field is populated if the model is produced by a pipeline job.
         */
        pipelineJob?: string | null;
        /**
         * The schemata that describe formats of the Model's predictions and explanations as given and returned via PredictionService.Predict and PredictionService.Explain.
         */
        predictSchemata?: Schema$GoogleCloudAiplatformV1PredictSchemata;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. When this Model is deployed, its prediction resources are described by the `prediction_resources` field of the Endpoint.deployed_models object. Because not all Models support all resource configuration types, the configuration types this Model supports are listed here. If no configuration types are listed, the Model cannot be deployed to an Endpoint and does not support online predictions (PredictionService.Predict or PredictionService.Explain). Such a Model can serve predictions by using a BatchPredictionJob, if it has at least one entry each in supported_input_storage_formats and supported_output_storage_formats.
         */
        supportedDeploymentResourcesTypes?: string[] | null;
        /**
         * Output only. The formats in which this Model may be exported. If empty, this Model is not available for export.
         */
        supportedExportFormats?: Schema$GoogleCloudAiplatformV1ModelExportFormat[];
        /**
         * Output only. The formats this Model supports in BatchPredictionJob.input_config. If PredictSchemata.instance_schema_uri exists, the instances should be given as per that schema. The possible formats are: * `jsonl` The JSON Lines format, where each instance is a single line. Uses GcsSource. * `csv` The CSV format, where each instance is a single comma-separated line. The first line in the file is the header, containing comma-separated field names. Uses GcsSource. * `tf-record` The TFRecord format, where each instance is a single record in tfrecord syntax. Uses GcsSource. * `tf-record-gzip` Similar to `tf-record`, but the file is gzipped. Uses GcsSource. * `bigquery` Each instance is a single row in BigQuery. Uses BigQuerySource. * `file-list` Each line of the file is the location of an instance to process, uses `gcs_source` field of the InputConfig object. If this Model doesn't support any of these formats it means it cannot be used with a BatchPredictionJob. However, if it has supported_deployment_resources_types, it could serve online predictions by using PredictionService.Predict or PredictionService.Explain.
         */
        supportedInputStorageFormats?: string[] | null;
        /**
         * Output only. The formats this Model supports in BatchPredictionJob.output_config. If both PredictSchemata.instance_schema_uri and PredictSchemata.prediction_schema_uri exist, the predictions are returned together with their instances. In other words, the prediction has the original instance data first, followed by the actual prediction content (as per the schema). The possible formats are: * `jsonl` The JSON Lines format, where each prediction is a single line. Uses GcsDestination. * `csv` The CSV format, where each prediction is a single comma-separated line. The first line in the file is the header, containing comma-separated field names. Uses GcsDestination. * `bigquery` Each prediction is a single row in a BigQuery table, uses BigQueryDestination . If this Model doesn't support any of these formats it means it cannot be used with a BatchPredictionJob. However, if it has supported_deployment_resources_types, it could serve online predictions by using PredictionService.Predict or PredictionService.Explain.
         */
        supportedOutputStorageFormats?: string[] | null;
        /**
         * Output only. The resource name of the TrainingPipeline that uploaded this Model, if any.
         */
        trainingPipeline?: string | null;
        /**
         * Output only. Timestamp when this Model was most recently updated.
         */
        updateTime?: string | null;
        /**
         * User provided version aliases so that a model version can be referenced via alias (i.e. `projects/{project\}/locations/{location\}/models/{model_id\}@{version_alias\}` instead of auto-generated version id (i.e. `projects/{project\}/locations/{location\}/models/{model_id\}@{version_id\})`. The format is a-z{0,126\}[a-z0-9] to distinguish from version_id. A default version alias will be created for the first version of the model, and there must be exactly one default version alias for a model.
         */
        versionAliases?: string[] | null;
        /**
         * Output only. Timestamp when this version was created.
         */
        versionCreateTime?: string | null;
        /**
         * The description of this version.
         */
        versionDescription?: string | null;
        /**
         * Output only. Immutable. The version ID of the model. A new version is committed when a new model version is uploaded or trained under an existing model id. It is an auto-incrementing decimal number in string representation.
         */
        versionId?: string | null;
        /**
         * Output only. Timestamp when this version was most recently updated.
         */
        versionUpdateTime?: string | null;
    }
    /**
     * User input field to specify the base model source. Currently it only supports specifing the Model Garden models and Genie models.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelBaseModelSource {
        /**
         * Information about the base model of Genie models.
         */
        genieSource?: Schema$GoogleCloudAiplatformV1GenieSource;
        /**
         * Source information of Model Garden models.
         */
        modelGardenSource?: Schema$GoogleCloudAiplatformV1ModelGardenSource;
    }
    /**
     * Specification of a container for serving predictions. Some fields in this message correspond to fields in the [Kubernetes Container v1 core specification](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
     */
    export interface Schema$GoogleCloudAiplatformV1ModelContainerSpec {
        /**
         * Immutable. Specifies arguments for the command that runs when the container starts. This overrides the container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd). Specify this field as an array of executable and arguments, similar to a Docker `CMD`'s "default parameters" form. If you don't specify this field but do specify the command field, then the command from the `command` field runs without any additional arguments. See the [Kubernetes documentation about how the `command` and `args` fields interact with a container's `ENTRYPOINT` and `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes). If you don't specify this field and don't specify the `command` field, then the container's [`ENTRYPOINT`](https://docs.docker.com/engine/reference/builder/#cmd) and `CMD` determine what runs based on their default behavior. See the Docker documentation about [how `CMD` and `ENTRYPOINT` interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact). In this field, you can reference [environment variables set by Vertex AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables) and environment variables set in the env field. You cannot reference environment variables set in the Docker image. In order for environment variables to be expanded, reference them by using the following syntax: $( VARIABLE_NAME) Note that this differs from Bash variable expansion, which does not use parentheses. If a variable cannot be resolved, the reference in the input string is used unchanged. To avoid variable expansion, you can escape this syntax with `$$`; for example: $$(VARIABLE_NAME) This field corresponds to the `args` field of the Kubernetes Containers [v1 core API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
         */
        args?: string[] | null;
        /**
         * Immutable. Specifies the command that runs when the container starts. This overrides the container's [ENTRYPOINT](https://docs.docker.com/engine/reference/builder/#entrypoint). Specify this field as an array of executable and arguments, similar to a Docker `ENTRYPOINT`'s "exec" form, not its "shell" form. If you do not specify this field, then the container's `ENTRYPOINT` runs, in conjunction with the args field or the container's [`CMD`](https://docs.docker.com/engine/reference/builder/#cmd), if either exists. If this field is not specified and the container does not have an `ENTRYPOINT`, then refer to the Docker documentation about [how `CMD` and `ENTRYPOINT` interact](https://docs.docker.com/engine/reference/builder/#understand-how-cmd-and-entrypoint-interact). If you specify this field, then you can also specify the `args` field to provide additional arguments for this command. However, if you specify this field, then the container's `CMD` is ignored. See the [Kubernetes documentation about how the `command` and `args` fields interact with a container's `ENTRYPOINT` and `CMD`](https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#notes). In this field, you can reference [environment variables set by Vertex AI](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables) and environment variables set in the env field. You cannot reference environment variables set in the Docker image. In order for environment variables to be expanded, reference them by using the following syntax: $( VARIABLE_NAME) Note that this differs from Bash variable expansion, which does not use parentheses. If a variable cannot be resolved, the reference in the input string is used unchanged. To avoid variable expansion, you can escape this syntax with `$$`; for example: $$(VARIABLE_NAME) This field corresponds to the `command` field of the Kubernetes Containers [v1 core API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
         */
        command?: string[] | null;
        /**
         * Immutable. Deployment timeout. Limit for deployment timeout is 2 hours.
         */
        deploymentTimeout?: string | null;
        /**
         * Immutable. List of environment variables to set in the container. After the container starts running, code running in the container can read these environment variables. Additionally, the command and args fields can reference these variables. Later entries in this list can also reference earlier entries. For example, the following example sets the variable `VAR_2` to have the value `foo bar`: ```json [ { "name": "VAR_1", "value": "foo" \}, { "name": "VAR_2", "value": "$(VAR_1) bar" \} ] ``` If you switch the order of the variables in the example, then the expansion does not occur. This field corresponds to the `env` field of the Kubernetes Containers [v1 core API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
         */
        env?: Schema$GoogleCloudAiplatformV1EnvVar[];
        /**
         * Immutable. List of ports to expose from the container. Vertex AI sends gRPC prediction requests that it receives to the first port on this list. Vertex AI also sends liveness and health checks to this port. If you do not specify this field, gRPC requests to the container will be disabled. Vertex AI does not use ports other than the first one listed. This field corresponds to the `ports` field of the Kubernetes Containers v1 core API.
         */
        grpcPorts?: Schema$GoogleCloudAiplatformV1Port[];
        /**
         * Immutable. Specification for Kubernetes readiness probe.
         */
        healthProbe?: Schema$GoogleCloudAiplatformV1Probe;
        /**
         * Immutable. HTTP path on the container to send health checks to. Vertex AI intermittently sends GET requests to this path on the container's IP address and port to check that the container is healthy. Read more about [health checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#health). For example, if you set this field to `/bar`, then Vertex AI intermittently sends a GET request to the `/bar` path on the port of your container specified by the first value of this `ModelContainerSpec`'s ports field. If you don't specify this field, it defaults to the following value when you deploy this Model to an Endpoint: /v1/endpoints/ENDPOINT/deployedModels/ DEPLOYED_MODEL:predict The placeholders in this value are replaced as follows: * ENDPOINT: The last segment (following `endpoints/`)of the Endpoint.name][] field of the Endpoint where this Model has been deployed. (Vertex AI makes this value available to your container code as the [`AIP_ENDPOINT_ID` environment variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).) * DEPLOYED_MODEL: DeployedModel.id of the `DeployedModel`. (Vertex AI makes this value available to your container code as the [`AIP_DEPLOYED_MODEL_ID` environment variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
         */
        healthRoute?: string | null;
        /**
         * Required. Immutable. URI of the Docker image to be used as the custom container for serving predictions. This URI must identify an image in Artifact Registry or Container Registry. Learn more about the [container publishing requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#publishing), including permissions requirements for the Vertex AI Service Agent. The container image is ingested upon ModelService.UploadModel, stored internally, and this original path is afterwards not used. To learn about the requirements for the Docker image itself, see [Custom container requirements](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#). You can use the URI to one of Vertex AI's [pre-built container images for prediction](https://cloud.google.com/vertex-ai/docs/predictions/pre-built-containers) in this field.
         */
        imageUri?: string | null;
        /**
         * Immutable. Specification for Kubernetes liveness probe.
         */
        livenessProbe?: Schema$GoogleCloudAiplatformV1Probe;
        /**
         * Immutable. List of ports to expose from the container. Vertex AI sends any prediction requests that it receives to the first port on this list. Vertex AI also sends [liveness and health checks](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#liveness) to this port. If you do not specify this field, it defaults to following value: ```json [ { "containerPort": 8080 \} ] ``` Vertex AI does not use ports other than the first one listed. This field corresponds to the `ports` field of the Kubernetes Containers [v1 core API](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.23/#container-v1-core).
         */
        ports?: Schema$GoogleCloudAiplatformV1Port[];
        /**
         * Immutable. HTTP path on the container to send prediction requests to. Vertex AI forwards requests sent using projects.locations.endpoints.predict to this path on the container's IP address and port. Vertex AI then returns the container's response in the API response. For example, if you set this field to `/foo`, then when Vertex AI receives a prediction request, it forwards the request body in a POST request to the `/foo` path on the port of your container specified by the first value of this `ModelContainerSpec`'s ports field. If you don't specify this field, it defaults to the following value when you deploy this Model to an Endpoint: /v1/endpoints/ENDPOINT/deployedModels/DEPLOYED_MODEL:predict The placeholders in this value are replaced as follows: * ENDPOINT: The last segment (following `endpoints/`)of the Endpoint.name][] field of the Endpoint where this Model has been deployed. (Vertex AI makes this value available to your container code as the [`AIP_ENDPOINT_ID` environment variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).) * DEPLOYED_MODEL: DeployedModel.id of the `DeployedModel`. (Vertex AI makes this value available to your container code as the [`AIP_DEPLOYED_MODEL_ID` environment variable](https://cloud.google.com/vertex-ai/docs/predictions/custom-container-requirements#aip-variables).)
         */
        predictRoute?: string | null;
        /**
         * Immutable. The amount of the VM memory to reserve as the shared memory for the model in megabytes.
         */
        sharedMemorySizeMb?: string | null;
        /**
         * Immutable. Specification for Kubernetes startup probe.
         */
        startupProbe?: Schema$GoogleCloudAiplatformV1Probe;
    }
    /**
     * Stats of data used for train or evaluate the Model.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelDataStats {
        /**
         * Number of Annotations that are used for evaluating this Model. If the Model is evaluated multiple times, this will be the number of test Annotations used by the first evaluation. If the Model is not evaluated, the number is 0.
         */
        testAnnotationsCount?: string | null;
        /**
         * Number of DataItems that were used for evaluating this Model. If the Model is evaluated multiple times, this will be the number of test DataItems used by the first evaluation. If the Model is not evaluated, the number is 0.
         */
        testDataItemsCount?: string | null;
        /**
         * Number of Annotations that are used for training this Model.
         */
        trainingAnnotationsCount?: string | null;
        /**
         * Number of DataItems that were used for training this Model.
         */
        trainingDataItemsCount?: string | null;
        /**
         * Number of Annotations that are used for validating this Model during training.
         */
        validationAnnotationsCount?: string | null;
        /**
         * Number of DataItems that were used for validating this Model during training.
         */
        validationDataItemsCount?: string | null;
    }
    /**
     * ModelDeploymentMonitoringBigQueryTable specifies the BigQuery table name as well as some information of the logs stored in this table.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable {
        /**
         * The created BigQuery table to store logs. Customer could do their own query & analysis. Format: `bq://.model_deployment_monitoring_._`
         */
        bigqueryTablePath?: string | null;
        /**
         * The source of log.
         */
        logSource?: string | null;
        /**
         * The type of log.
         */
        logType?: string | null;
        /**
         * Output only. The schema version of the request/response logging BigQuery table. Default to v1 if unset.
         */
        requestResponseLoggingSchemaVersion?: string | null;
    }
    /**
     * Represents a job that runs periodically to monitor the deployed models in an endpoint. It will analyze the logged training & prediction data to detect any abnormal behaviors.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringJob {
        /**
         * YAML schema file uri describing the format of a single instance that you want Tensorflow Data Validation (TFDV) to analyze. If this field is empty, all the feature data types are inferred from predict_instance_schema_uri, meaning that TFDV will use the data in the exact format(data type) as prediction request/response. If there are any data type differences between predict instance and TFDV instance, this field can be used to override the schema. For models trained with Vertex AI, this field must be set as all the fields in predict instance formatted as string.
         */
        analysisInstanceSchemaUri?: string | null;
        /**
         * Output only. The created bigquery tables for the job under customer project. Customer could do their own query & analysis. There could be 4 log tables in maximum: 1. Training data logging predict request/response 2. Serving data logging predict request/response
         */
        bigqueryTables?: Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringBigQueryTable[];
        /**
         * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
         */
        createTime?: string | null;
        /**
         * Required. The user-defined name of the ModelDeploymentMonitoringJob. The name can be up to 128 characters long and can consist of any UTF-8 characters. Display name of a ModelDeploymentMonitoringJob.
         */
        displayName?: string | null;
        /**
         * If true, the scheduled monitoring pipeline logs are sent to Google Cloud Logging, including pipeline status and anomalies detected. Please note the logs incur cost, which are subject to [Cloud Logging pricing](https://cloud.google.com/logging#pricing).
         */
        enableMonitoringPipelineLogs?: boolean | null;
        /**
         * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If set, this ModelDeploymentMonitoringJob and all sub-resources of this ModelDeploymentMonitoringJob will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Required. Endpoint resource name. Format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        endpoint?: string | null;
        /**
         * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The labels with user-defined metadata to organize your ModelDeploymentMonitoringJob. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Latest triggered monitoring pipeline metadata.
         */
        latestMonitoringPipelineMetadata?: Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata;
        /**
         * Required. Sample Strategy for logging.
         */
        loggingSamplingStrategy?: Schema$GoogleCloudAiplatformV1SamplingStrategy;
        /**
         * The TTL of BigQuery tables in user projects which stores logs. A day is the basic unit of the TTL and we take the ceil of TTL/86400(a day). e.g. { second: 3600\} indicates ttl = 1 day.
         */
        logTtl?: string | null;
        /**
         * Required. The config for monitoring objectives. This is a per DeployedModel config. Each DeployedModel needs to be configured separately.
         */
        modelDeploymentMonitoringObjectiveConfigs?: Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig[];
        /**
         * Required. Schedule config for running the monitoring job.
         */
        modelDeploymentMonitoringScheduleConfig?: Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig;
        /**
         * Alert config for model monitoring.
         */
        modelMonitoringAlertConfig?: Schema$GoogleCloudAiplatformV1ModelMonitoringAlertConfig;
        /**
         * Output only. Resource name of a ModelDeploymentMonitoringJob.
         */
        name?: string | null;
        /**
         * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the next round.
         */
        nextScheduleTime?: string | null;
        /**
         * YAML schema file uri describing the format of a single instance, which are given to format this Endpoint's prediction (and explanation). If not set, we will generate predict schema from collected predict requests.
         */
        predictInstanceSchemaUri?: string | null;
        /**
         * Sample Predict instance, same format as PredictRequest.instances, this can be set as a replacement of ModelDeploymentMonitoringJob.predict_instance_schema_uri. If not set, we will generate predict schema from collected predict requests.
         */
        samplePredictInstance?: any | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Schedule state when the monitoring job is in Running state.
         */
        scheduleState?: string | null;
        /**
         * Output only. The detailed state of the monitoring job. When the job is still creating, the state will be 'PENDING'. Once the job is successfully created, the state will be 'RUNNING'. Pause the job, the state will be 'PAUSED'. Resume the job, the state will return to 'RUNNING'.
         */
        state?: string | null;
        /**
         * Stats anomalies base folder path.
         */
        statsAnomaliesBaseDirectory?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
         */
        updateTime?: string | null;
    }
    /**
     * All metadata of most recent monitoring pipelines.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringJobLatestMonitoringPipelineMetadata {
        /**
         * The time that most recent monitoring pipelines that is related to this run.
         */
        runTime?: string | null;
        /**
         * The status of the most recent monitoring pipeline.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * ModelDeploymentMonitoringObjectiveConfig contains the pair of deployed_model_id to ModelMonitoringObjectiveConfig.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringObjectiveConfig {
        /**
         * The DeployedModel ID of the objective config.
         */
        deployedModelId?: string | null;
        /**
         * The objective config of for the modelmonitoring job of this deployed model.
         */
        objectiveConfig?: Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig;
    }
    /**
     * The config for scheduling monitoring job.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelDeploymentMonitoringScheduleConfig {
        /**
         * Required. The model monitoring job scheduling interval. It will be rounded up to next full hour. This defines how often the monitoring jobs are triggered.
         */
        monitorInterval?: string | null;
        /**
         * The time window of the prediction data being included in each prediction dataset. This window specifies how long the data should be collected from historical model results for each run. If not set, ModelDeploymentMonitoringScheduleConfig.monitor_interval will be used. e.g. If currently the cutoff time is 2022-01-08 14:30:00 and the monitor_window is set to be 3600, then data from 2022-01-08 13:30:00 to 2022-01-08 14:30:00 will be retrieved and aggregated to calculate the monitoring statistics.
         */
        monitorWindow?: string | null;
    }
    /**
     * A collection of metrics calculated by comparing Model's predictions on all of the test data against annotations from the test data.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluation {
        /**
         * Points to a YAML file stored on Google Cloud Storage describing EvaluatedDataItemView.predictions, EvaluatedDataItemView.ground_truths, EvaluatedAnnotation.predictions, and EvaluatedAnnotation.ground_truths. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). This field is not populated if there are neither EvaluatedDataItemViews nor EvaluatedAnnotations under this ModelEvaluation.
         */
        annotationSchemaUri?: string | null;
        /**
         * Output only. Timestamp when this ModelEvaluation was created.
         */
        createTime?: string | null;
        /**
         * Points to a YAML file stored on Google Cloud Storage describing EvaluatedDataItemView.data_item_payload and EvaluatedAnnotation.data_item_payload. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). This field is not populated if there are neither EvaluatedDataItemViews nor EvaluatedAnnotations under this ModelEvaluation.
         */
        dataItemSchemaUri?: string | null;
        /**
         * The display name of the ModelEvaluation.
         */
        displayName?: string | null;
        /**
         * Describes the values of ExplanationSpec that are used for explaining the predicted values on the evaluated data.
         */
        explanationSpecs?: Schema$GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec[];
        /**
         * The metadata of the ModelEvaluation. For the ModelEvaluation uploaded from Managed Pipeline, metadata contains a structured value with keys of "pipeline_job_id", "evaluation_dataset_type", "evaluation_dataset_path", "row_based_metrics_path".
         */
        metadata?: any | null;
        /**
         * Evaluation metrics of the Model. The schema of the metrics is stored in metrics_schema_uri
         */
        metrics?: any | null;
        /**
         * Points to a YAML file stored on Google Cloud Storage describing the metrics of this ModelEvaluation. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
         */
        metricsSchemaUri?: string | null;
        /**
         * Aggregated explanation metrics for the Model's prediction output over the data this ModelEvaluation uses. This field is populated only if the Model is evaluated with explanations, and only for AutoML tabular Models.
         */
        modelExplanation?: Schema$GoogleCloudAiplatformV1ModelExplanation;
        /**
         * Output only. The resource name of the ModelEvaluation.
         */
        name?: string | null;
        /**
         * All possible dimensions of ModelEvaluationSlices. The dimensions can be used as the filter of the ModelService.ListModelEvaluationSlices request, in the form of `slice.dimension = `.
         */
        sliceDimensions?: string[] | null;
    }
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluationModelEvaluationExplanationSpec {
        /**
         * Explanation spec details.
         */
        explanationSpec?: Schema$GoogleCloudAiplatformV1ExplanationSpec;
        /**
         * Explanation type. For AutoML Image Classification models, possible values are: * `image-integrated-gradients` * `image-xrai`
         */
        explanationType?: string | null;
    }
    /**
     * A collection of metrics calculated by comparing Model's predictions on a slice of the test data against ground truth annotations.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluationSlice {
        /**
         * Output only. Timestamp when this ModelEvaluationSlice was created.
         */
        createTime?: string | null;
        /**
         * Output only. Sliced evaluation metrics of the Model. The schema of the metrics is stored in metrics_schema_uri
         */
        metrics?: any | null;
        /**
         * Output only. Points to a YAML file stored on Google Cloud Storage describing the metrics of this ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
         */
        metricsSchemaUri?: string | null;
        /**
         * Output only. Aggregated explanation metrics for the Model's prediction output over the data this ModelEvaluation uses. This field is populated only if the Model is evaluated with explanations, and only for tabular Models.
         */
        modelExplanation?: Schema$GoogleCloudAiplatformV1ModelExplanation;
        /**
         * Output only. The resource name of the ModelEvaluationSlice.
         */
        name?: string | null;
        /**
         * Output only. The slice of the test data that is used to evaluate the Model.
         */
        slice?: Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSlice;
    }
    /**
     * Definition of a slice.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSlice {
        /**
         * Output only. The dimension of the slice. Well-known dimensions are: * `annotationSpec`: This slice is on the test data that has either ground truth or prediction with AnnotationSpec.display_name equals to value. * `slice`: This slice is a user customized slice defined by its SliceSpec.
         */
        dimension?: string | null;
        /**
         * Output only. Specification for how the data was sliced.
         */
        sliceSpec?: Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec;
        /**
         * Output only. The value of the dimension in this slice.
         */
        value?: string | null;
    }
    /**
     * Specification for how the data should be sliced.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpec {
        /**
         * Mapping configuration for this SliceSpec. The key is the name of the feature. By default, the key will be prefixed by "instance" as a dictionary prefix for Vertex Batch Predictions output format.
         */
        configs?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig;
        } | null;
    }
    /**
     * A range of values for slice(s). `low` is inclusive, `high` is exclusive.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange {
        /**
         * Exclusive high value for the range.
         */
        high?: number | null;
        /**
         * Inclusive low value for the range.
         */
        low?: number | null;
    }
    /**
     * Specification message containing the config for this SliceSpec. When `kind` is selected as `value` and/or `range`, only a single slice will be computed. When `all_values` is present, a separate slice will be computed for each possible label/value for the corresponding key in `config`. Examples, with feature zip_code with values 12345, 23334, 88888 and feature country with values "US", "Canada", "Mexico" in the dataset: Example 1: { "zip_code": { "value": { "float_value": 12345.0 \} \} \} A single slice for any data with zip_code 12345 in the dataset. Example 2: { "zip_code": { "range": { "low": 12345, "high": 20000 \} \} \} A single slice containing data where the zip_codes between 12345 and 20000 For this example, data with the zip_code of 12345 will be in this slice. Example 3: { "zip_code": { "range": { "low": 10000, "high": 20000 \} \}, "country": { "value": { "string_value": "US" \} \} \} A single slice containing data where the zip_codes between 10000 and 20000 has the country "US". For this example, data with the zip_code of 12345 and country "US" will be in this slice. Example 4: { "country": {"all_values": { "value": true \} \} \} Three slices are computed, one for each unique country in the dataset. Example 5: { "country": { "all_values": { "value": true \} \}, "zip_code": { "value": { "float_value": 12345.0 \} \} \} Three slices are computed, one for each unique country in the dataset where the zip_code is also 12345. For this example, data with zip_code 12345 and country "US" will be in one slice, zip_code 12345 and country "Canada" in another slice, and zip_code 12345 and country "Mexico" in another slice, totaling 3 slices.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecSliceConfig {
        /**
         * If all_values is set to true, then all possible labels of the keyed feature will have another slice computed. Example: `{"all_values":{"value":true\}\}`
         */
        allValues?: boolean | null;
        /**
         * A range of values for a numerical feature. Example: `{"range":{"low":10000.0,"high":50000.0\}\}` will capture 12345 and 23334 in the slice.
         */
        range?: Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecRange;
        /**
         * A unique specific value for a given feature. Example: `{ "value": { "string_value": "12345" \} \}`
         */
        value?: Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue;
    }
    /**
     * Single value that supports strings and floats.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelEvaluationSliceSliceSliceSpecValue {
        /**
         * Float type.
         */
        floatValue?: number | null;
        /**
         * String type.
         */
        stringValue?: string | null;
    }
    /**
     * Aggregated explanation metrics for a Model over a set of instances.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelExplanation {
        /**
         * Output only. Aggregated attributions explaining the Model's prediction outputs over the set of instances. The attributions are grouped by outputs. For Models that predict only one output, such as regression Models that predict only one score, there is only one attibution that explains the predicted output. For Models that predict multiple outputs, such as multiclass Models that predict multiple classes, each element explains one specific item. Attribution.output_index can be used to identify which output this attribution is explaining. The baselineOutputValue, instanceOutputValue and featureAttributions fields are averaged over the test data. NOTE: Currently AutoML tabular classification Models produce only one attribution, which averages attributions over all the classes it predicts. Attribution.approximation_error is not populated.
         */
        meanAttributions?: Schema$GoogleCloudAiplatformV1Attribution[];
    }
    /**
     * Represents export format supported by the Model. All formats export to Google Cloud Storage.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelExportFormat {
        /**
         * Output only. The content of this Model that may be exported.
         */
        exportableContents?: string[] | null;
        /**
         * Output only. The ID of the export format. The possible format IDs are: * `tflite` Used for Android mobile devices. * `edgetpu-tflite` Used for [Edge TPU](https://cloud.google.com/edge-tpu/) devices. * `tf-saved-model` A tensorflow model in SavedModel format. * `tf-js` A [TensorFlow.js](https://www.tensorflow.org/js) model that can be used in the browser and in Node.js using JavaScript. * `core-ml` Used for iOS mobile devices. * `custom-trained` A Model that was uploaded or trained by custom code. * `genie` A tuned Model Garden model.
         */
        id?: string | null;
    }
    /**
     * Contains information about the source of the models generated from Model Garden.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelGardenSource {
        /**
         * Required. The model garden source model resource name.
         */
        publicModelName?: string | null;
        /**
         * Optional. Whether to avoid pulling the model from the HF cache.
         */
        skipHfModelCache?: boolean | null;
        /**
         * Optional. The model garden source model version ID.
         */
        versionId?: string | null;
    }
    /**
     * The alert config for model monitoring.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringAlertConfig {
        /**
         * Email alert config.
         */
        emailAlertConfig?: Schema$GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig;
        /**
         * Dump the anomalies to Cloud Logging. The anomalies will be put to json payload encoded from proto ModelMonitoringStatsAnomalies. This can be further synced to Pub/Sub or any other services supported by Cloud Logging.
         */
        enableLogging?: boolean | null;
        /**
         * Resource names of the NotificationChannels to send alert. Must be of the format `projects//notificationChannels/`
         */
        notificationChannels?: string[] | null;
    }
    /**
     * The config for email alert.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringAlertConfigEmailAlertConfig {
        /**
         * The email addresses to send the alert.
         */
        userEmails?: string[] | null;
    }
    /**
     * The objective configuration for model monitoring, including the information needed to detect anomalies for one particular model.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfig {
        /**
         * The config for integrating with Vertex Explainable AI.
         */
        explanationConfig?: Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig;
        /**
         * The config for drift of prediction data.
         */
        predictionDriftDetectionConfig?: Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig;
        /**
         * Training dataset for models. This field has to be set only if TrainingPredictionSkewDetectionConfig is specified.
         */
        trainingDataset?: Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset;
        /**
         * The config for skew between training data and prediction data.
         */
        trainingPredictionSkewDetectionConfig?: Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig;
    }
    /**
     * The config for integrating with Vertex Explainable AI. Only applicable if the Model has explanation_spec populated.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfig {
        /**
         * If want to analyze the Vertex Explainable AI feature attribute scores or not. If set to true, Vertex AI will log the feature attributions from explain response and do the skew/drift detection for them.
         */
        enableFeatureAttributes?: boolean | null;
        /**
         * Predictions generated by the BatchPredictionJob using baseline dataset.
         */
        explanationBaseline?: Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline;
    }
    /**
     * Output from BatchPredictionJob for Model Monitoring baseline dataset, which can be used to generate baseline attribution scores.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigExplanationConfigExplanationBaseline {
        /**
         * BigQuery location for BatchExplain output.
         */
        bigquery?: Schema$GoogleCloudAiplatformV1BigQueryDestination;
        /**
         * Cloud Storage location for BatchExplain output.
         */
        gcs?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * The storage format of the predictions generated BatchPrediction job.
         */
        predictionFormat?: string | null;
    }
    /**
     * The config for Prediction data drift detection.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig {
        /**
         * Key is the feature name and value is the threshold. The threshold here is against attribution score distance between different time windows.
         */
        attributionScoreDriftThresholds?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ThresholdConfig;
        } | null;
        /**
         * Drift anomaly detection threshold used by all features. When the per-feature thresholds are not set, this field can be used to specify a threshold for all features.
         */
        defaultDriftThreshold?: Schema$GoogleCloudAiplatformV1ThresholdConfig;
        /**
         * Key is the feature name and value is the threshold. If a feature needs to be monitored for drift, a value threshold must be configured for that feature. The threshold here is against feature distribution distance between different time windws.
         */
        driftThresholds?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ThresholdConfig;
        } | null;
    }
    /**
     * Training Dataset information.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingDataset {
        /**
         * The BigQuery table of the unmanaged Dataset used to train this Model.
         */
        bigquerySource?: Schema$GoogleCloudAiplatformV1BigQuerySource;
        /**
         * Data format of the dataset, only applicable if the input is from Google Cloud Storage. The possible formats are: "tf-record" The source file is a TFRecord file. "csv" The source file is a CSV file. "jsonl" The source file is a JSONL file.
         */
        dataFormat?: string | null;
        /**
         * The resource name of the Dataset used to train this Model.
         */
        dataset?: string | null;
        /**
         * The Google Cloud Storage uri of the unmanaged Dataset used to train this Model.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
        /**
         * Strategy to sample data from Training Dataset. If not set, we process the whole dataset.
         */
        loggingSamplingStrategy?: Schema$GoogleCloudAiplatformV1SamplingStrategy;
        /**
         * The target field name the model is to predict. This field will be excluded when doing Predict and (or) Explain for the training data.
         */
        targetField?: string | null;
    }
    /**
     * The config for Training & Prediction data skew detection. It specifies the training dataset sources and the skew detection parameters.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigTrainingPredictionSkewDetectionConfig {
        /**
         * Key is the feature name and value is the threshold. The threshold here is against attribution score distance between the training and prediction feature.
         */
        attributionScoreSkewThresholds?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ThresholdConfig;
        } | null;
        /**
         * Skew anomaly detection threshold used by all features. When the per-feature thresholds are not set, this field can be used to specify a threshold for all features.
         */
        defaultSkewThreshold?: Schema$GoogleCloudAiplatformV1ThresholdConfig;
        /**
         * Key is the feature name and value is the threshold. If a feature needs to be monitored for skew, a value threshold must be configured for that feature. The threshold here is against feature distribution distance between the training and prediction feature.
         */
        skewThresholds?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ThresholdConfig;
        } | null;
    }
    /**
     * Statistics and anomalies generated by Model Monitoring.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies {
        /**
         * Number of anomalies within all stats.
         */
        anomalyCount?: number | null;
        /**
         * Deployed Model ID.
         */
        deployedModelId?: string | null;
        /**
         * A list of historical Stats and Anomalies generated for all Features.
         */
        featureStats?: Schema$GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies[];
        /**
         * Model Monitoring Objective those stats and anomalies belonging to.
         */
        objective?: string | null;
    }
    /**
     * Historical Stats (and Anomalies) for a specific Feature.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelMonitoringStatsAnomaliesFeatureHistoricStatsAnomalies {
        /**
         * Display Name of the Feature.
         */
        featureDisplayName?: string | null;
        /**
         * A list of historical stats generated by different time window's Prediction Dataset.
         */
        predictionStats?: Schema$GoogleCloudAiplatformV1FeatureStatsAnomaly[];
        /**
         * Threshold for anomaly detection.
         */
        threshold?: Schema$GoogleCloudAiplatformV1ThresholdConfig;
        /**
         * Stats calculated for the Training Dataset.
         */
        trainingStats?: Schema$GoogleCloudAiplatformV1FeatureStatsAnomaly;
    }
    /**
     * Contains information about the original Model if this Model is a copy.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelOriginalModelInfo {
        /**
         * Output only. The resource name of the Model this Model is a copy of, including the revision. Format: `projects/{project\}/locations/{location\}/models/{model_id\}@{version_id\}`
         */
        model?: string | null;
    }
    /**
     * Detail description of the source information of the model.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelSourceInfo {
        /**
         * If this Model is copy of another Model. If true then source_type pertains to the original.
         */
        copy?: boolean | null;
        /**
         * Type of the model source.
         */
        sourceType?: string | null;
    }
    /**
     * Describes the machine learning model version checkpoint.
     */
    export interface Schema$GoogleCloudAiplatformV1ModelVersionCheckpoint {
        /**
         * The ID of the checkpoint.
         */
        checkpointId?: string | null;
        /**
         * The epoch of the checkpoint.
         */
        epoch?: string | null;
        /**
         * The step of the checkpoint.
         */
        step?: string | null;
    }
    /**
     * Runtime operation information for IndexEndpointService.MutateDeployedIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1MutateDeployedIndexOperationMetadata {
        /**
         * The unique index id specified by user
         */
        deployedIndexId?: string | null;
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Response message for IndexEndpointService.MutateDeployedIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1MutateDeployedIndexResponse {
        /**
         * The DeployedIndex that had been updated in the IndexEndpoint.
         */
        deployedIndex?: Schema$GoogleCloudAiplatformV1DeployedIndex;
    }
    /**
     * Runtime operation information for EndpointService.MutateDeployedModel.
     */
    export interface Schema$GoogleCloudAiplatformV1MutateDeployedModelOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for EndpointService.MutateDeployedModel.
     */
    export interface Schema$GoogleCloudAiplatformV1MutateDeployedModelRequest {
        /**
         * Required. The DeployedModel to be mutated within the Endpoint. Only the following fields can be mutated: * `min_replica_count` in either DedicatedResources or AutomaticResources * `max_replica_count` in either DedicatedResources or AutomaticResources * autoscaling_metric_specs * `disable_container_logging` (v1 only) * `enable_container_logging` (v1beta1 only)
         */
        deployedModel?: Schema$GoogleCloudAiplatformV1DeployedModel;
        /**
         * Required. The update mask applies to the resource. See google.protobuf.FieldMask.
         */
        updateMask?: string | null;
    }
    /**
     * Response message for EndpointService.MutateDeployedModel.
     */
    export interface Schema$GoogleCloudAiplatformV1MutateDeployedModelResponse {
        /**
         * The DeployedModel that's being mutated.
         */
        deployedModel?: Schema$GoogleCloudAiplatformV1DeployedModel;
    }
    /**
     * Represents a Neural Architecture Search (NAS) job.
     */
    export interface Schema$GoogleCloudAiplatformV1NasJob {
        /**
         * Output only. Time when the NasJob was created.
         */
        createTime?: string | null;
        /**
         * Required. The display name of the NasJob. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Enable a separation of Custom model training and restricted image training for tenant project.
         */
        enableRestrictedImageTraining?: boolean | null;
        /**
         * Customer-managed encryption key options for a NasJob. If this is set, then all resources created by the NasJob will be encrypted with the provided encryption key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Time when the NasJob entered any of the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
         */
        endTime?: string | null;
        /**
         * Output only. Only populated when job's state is JOB_STATE_FAILED or JOB_STATE_CANCELLED.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The labels with user-defined metadata to organize NasJobs. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Resource name of the NasJob.
         */
        name?: string | null;
        /**
         * Output only. Output of the NasJob.
         */
        nasJobOutput?: Schema$GoogleCloudAiplatformV1NasJobOutput;
        /**
         * Required. The specification of a NasJob.
         */
        nasJobSpec?: Schema$GoogleCloudAiplatformV1NasJobSpec;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Time when the NasJob for the first time entered the `JOB_STATE_RUNNING` state.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the job.
         */
        state?: string | null;
        /**
         * Output only. Time when the NasJob was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * Represents a uCAIP NasJob output.
     */
    export interface Schema$GoogleCloudAiplatformV1NasJobOutput {
        /**
         * Output only. The output of this multi-trial Neural Architecture Search (NAS) job.
         */
        multiTrialJobOutput?: Schema$GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput;
    }
    /**
     * The output of a multi-trial Neural Architecture Search (NAS) jobs.
     */
    export interface Schema$GoogleCloudAiplatformV1NasJobOutputMultiTrialJobOutput {
        /**
         * Output only. List of NasTrials that were started as part of search stage.
         */
        searchTrials?: Schema$GoogleCloudAiplatformV1NasTrial[];
        /**
         * Output only. List of NasTrials that were started as part of train stage.
         */
        trainTrials?: Schema$GoogleCloudAiplatformV1NasTrial[];
    }
    /**
     * Represents the spec of a NasJob.
     */
    export interface Schema$GoogleCloudAiplatformV1NasJobSpec {
        /**
         * The spec of multi-trial algorithms.
         */
        multiTrialAlgorithmSpec?: Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec;
        /**
         * The ID of the existing NasJob in the same Project and Location which will be used to resume search. search_space_spec and nas_algorithm_spec are obtained from previous NasJob hence should not provide them again for this NasJob.
         */
        resumeNasJobId?: string | null;
        /**
         * It defines the search space for Neural Architecture Search (NAS).
         */
        searchSpaceSpec?: string | null;
    }
    /**
     * The spec of multi-trial Neural Architecture Search (NAS).
     */
    export interface Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpec {
        /**
         * Metric specs for the NAS job. Validation for this field is done at `multi_trial_algorithm_spec` field.
         */
        metric?: Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec;
        /**
         * The multi-trial Neural Architecture Search (NAS) algorithm type. Defaults to `REINFORCEMENT_LEARNING`.
         */
        multiTrialAlgorithm?: string | null;
        /**
         * Required. Spec for search trials.
         */
        searchTrialSpec?: Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec;
        /**
         * Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count] search trials will be trained for every M [TrainTrialSpec.frequency] trials searched.
         */
        trainTrialSpec?: Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec;
    }
    /**
     * Represents a metric to optimize.
     */
    export interface Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecMetricSpec {
        /**
         * Required. The optimization goal of the metric.
         */
        goal?: string | null;
        /**
         * Required. The ID of the metric. Must not contain whitespaces.
         */
        metricId?: string | null;
    }
    /**
     * Represent spec for search trials.
     */
    export interface Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecSearchTrialSpec {
        /**
         * The number of failed trials that need to be seen before failing the NasJob. If set to 0, Vertex AI decides how many trials must fail before the whole job fails.
         */
        maxFailedTrialCount?: number | null;
        /**
         * Required. The maximum number of trials to run in parallel.
         */
        maxParallelTrialCount?: number | null;
        /**
         * Required. The maximum number of Neural Architecture Search (NAS) trials to run.
         */
        maxTrialCount?: number | null;
        /**
         * Required. The spec of a search trial job. The same spec applies to all search trials.
         */
        searchTrialJobSpec?: Schema$GoogleCloudAiplatformV1CustomJobSpec;
    }
    /**
     * Represent spec for train trials.
     */
    export interface Schema$GoogleCloudAiplatformV1NasJobSpecMultiTrialAlgorithmSpecTrainTrialSpec {
        /**
         * Required. Frequency of search trials to start train stage. Top N [TrainTrialSpec.max_parallel_trial_count] search trials will be trained for every M [TrainTrialSpec.frequency] trials searched.
         */
        frequency?: number | null;
        /**
         * Required. The maximum number of trials to run in parallel.
         */
        maxParallelTrialCount?: number | null;
        /**
         * Required. The spec of a train trial job. The same spec applies to all train trials.
         */
        trainTrialJobSpec?: Schema$GoogleCloudAiplatformV1CustomJobSpec;
    }
    /**
     * Represents a uCAIP NasJob trial.
     */
    export interface Schema$GoogleCloudAiplatformV1NasTrial {
        /**
         * Output only. Time when the NasTrial's status changed to `SUCCEEDED` or `INFEASIBLE`.
         */
        endTime?: string | null;
        /**
         * Output only. The final measurement containing the objective value.
         */
        finalMeasurement?: Schema$GoogleCloudAiplatformV1Measurement;
        /**
         * Output only. The identifier of the NasTrial assigned by the service.
         */
        id?: string | null;
        /**
         * Output only. Time when the NasTrial was started.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the NasTrial.
         */
        state?: string | null;
    }
    /**
     * Represents a NasTrial details along with its parameters. If there is a corresponding train NasTrial, the train NasTrial is also returned.
     */
    export interface Schema$GoogleCloudAiplatformV1NasTrialDetail {
        /**
         * Output only. Resource name of the NasTrialDetail.
         */
        name?: string | null;
        /**
         * The parameters for the NasJob NasTrial.
         */
        parameters?: string | null;
        /**
         * The requested search NasTrial.
         */
        searchTrial?: Schema$GoogleCloudAiplatformV1NasTrial;
        /**
         * The train NasTrial corresponding to search_trial. Only populated if search_trial is used for training.
         */
        trainTrial?: Schema$GoogleCloudAiplatformV1NasTrial;
    }
    /**
     * A query to find a number of similar entities.
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborQuery {
        /**
         * Optional. The embedding vector that be used for similar search.
         */
        embedding?: Schema$GoogleCloudAiplatformV1NearestNeighborQueryEmbedding;
        /**
         * Optional. The entity id whose similar entities should be searched for. If embedding is set, search will use embedding instead of entity_id.
         */
        entityId?: string | null;
        /**
         * Optional. The number of similar entities to be retrieved from feature view for each query.
         */
        neighborCount?: number | null;
        /**
         * Optional. The list of numeric filters.
         */
        numericFilters?: Schema$GoogleCloudAiplatformV1NearestNeighborQueryNumericFilter[];
        /**
         * Optional. Parameters that can be set to tune query on the fly.
         */
        parameters?: Schema$GoogleCloudAiplatformV1NearestNeighborQueryParameters;
        /**
         * Optional. Crowding is a constraint on a neighbor list produced by nearest neighbor search requiring that no more than sper_crowding_attribute_neighbor_count of the k neighbors returned have the same value of crowding_attribute. It's used for improving result diversity.
         */
        perCrowdingAttributeNeighborCount?: number | null;
        /**
         * Optional. The list of string filters.
         */
        stringFilters?: Schema$GoogleCloudAiplatformV1NearestNeighborQueryStringFilter[];
    }
    /**
     * The embedding vector.
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborQueryEmbedding {
        /**
         * Optional. Individual value in the embedding.
         */
        value?: number[] | null;
    }
    /**
     * Numeric filter is used to search a subset of the entities by using boolean rules on numeric columns. For example: Database Point 0: {name: "a" value_int: 42\} {name: "b" value_float: 1.0\} Database Point 1: {name: "a" value_int: 10\} {name: "b" value_float: 2.0\} Database Point 2: {name: "a" value_int: -1\} {name: "b" value_float: 3.0\} Query: {name: "a" value_int: 12 operator: LESS\} // Matches Point 1, 2 {name: "b" value_float: 2.0 operator: EQUAL\} // Matches Point 1
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborQueryNumericFilter {
        /**
         * Required. Column name in BigQuery that used as filters.
         */
        name?: string | null;
        /**
         * Optional. This MUST be specified for queries and must NOT be specified for database points.
         */
        op?: string | null;
        /**
         * double value type.
         */
        valueDouble?: number | null;
        /**
         * float value type.
         */
        valueFloat?: number | null;
        /**
         * int value type.
         */
        valueInt?: string | null;
    }
    /**
     * Parameters that can be overrided in each query to tune query latency and recall.
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborQueryParameters {
        /**
         * Optional. The number of neighbors to find via approximate search before exact reordering is performed; if set, this value must be \> neighbor_count.
         */
        approximateNeighborCandidates?: number | null;
        /**
         * Optional. The fraction of the number of leaves to search, set at query time allows user to tune search performance. This value increase result in both search accuracy and latency increase. The value should be between 0.0 and 1.0.
         */
        leafNodesSearchFraction?: number | null;
    }
    /**
     * String filter is used to search a subset of the entities by using boolean rules on string columns. For example: if a query specifies string filter with 'name = color, allow_tokens = {red, blue\}, deny_tokens = {purple\}',' then that query will match entities that are red or blue, but if those points are also purple, then they will be excluded even if they are red/blue. Only string filter is supported for now, numeric filter will be supported in the near future.
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborQueryStringFilter {
        /**
         * Optional. The allowed tokens.
         */
        allowTokens?: string[] | null;
        /**
         * Optional. The denied tokens.
         */
        denyTokens?: string[] | null;
        /**
         * Required. Column names in BigQuery that used as filters.
         */
        name?: string | null;
    }
    /**
     * Nearest neighbors for one query.
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighbors {
        /**
         * All its neighbors.
         */
        neighbors?: Schema$GoogleCloudAiplatformV1NearestNeighborsNeighbor[];
    }
    /**
     * Runtime operation metadata with regard to Matching Engine Index.
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata {
        /**
         * The validation stats of the content (per file) to be inserted or updated on the Matching Engine Index resource. Populated if contentsDeltaUri is provided as part of Index.metadata. Please note that, currently for those files that are broken or has unsupported file format, we will not have the stats for those files.
         */
        contentValidationStats?: Schema$GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats[];
        /**
         * The ingested data size in bytes.
         */
        dataBytesCount?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataContentValidationStats {
        /**
         * Number of records in this file we skipped due to validate errors.
         */
        invalidRecordCount?: string | null;
        /**
         * Number of sparse records in this file we skipped due to validate errors.
         */
        invalidSparseRecordCount?: string | null;
        /**
         * The detail information of the partial failures encountered for those invalid records that couldn't be parsed. Up to 50 partial errors will be reported.
         */
        partialErrors?: Schema$GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError[];
        /**
         * Cloud Storage URI pointing to the original file in user's bucket.
         */
        sourceGcsUri?: string | null;
        /**
         * Number of records in this file that were successfully processed.
         */
        validRecordCount?: string | null;
        /**
         * Number of sparse records in this file that were successfully processed.
         */
        validSparseRecordCount?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadataRecordError {
        /**
         * Empty if the embedding id is failed to parse.
         */
        embeddingId?: string | null;
        /**
         * A human-readable message that is shown to the user to help them fix the error. Note that this message may change from time to time, your code should check against error_type as the source of truth.
         */
        errorMessage?: string | null;
        /**
         * The error type of this record.
         */
        errorType?: string | null;
        /**
         * The original content of this record.
         */
        rawRecord?: string | null;
        /**
         * Cloud Storage URI pointing to the original file in user's bucket.
         */
        sourceGcsUri?: string | null;
    }
    /**
     * A neighbor of the query vector.
     */
    export interface Schema$GoogleCloudAiplatformV1NearestNeighborsNeighbor {
        /**
         * The distance between the neighbor and the query vector.
         */
        distance?: number | null;
        /**
         * The id of the similar entity.
         */
        entityId?: string | null;
        /**
         * The attributes of the neighbor, e.g. filters, crowding and metadata Note that full entities are returned only when "return_full_entity" is set to true. Otherwise, only the "entity_id" and "distance" fields are populated.
         */
        entityKeyValues?: Schema$GoogleCloudAiplatformV1FetchFeatureValuesResponse;
    }
    /**
     * Neighbors for example-based explanations.
     */
    export interface Schema$GoogleCloudAiplatformV1Neighbor {
        /**
         * Output only. The neighbor distance.
         */
        neighborDistance?: number | null;
        /**
         * Output only. The neighbor id.
         */
        neighborId?: string | null;
    }
    /**
     * Network spec.
     */
    export interface Schema$GoogleCloudAiplatformV1NetworkSpec {
        /**
         * Whether to enable public internet access. Default false.
         */
        enableInternetAccess?: boolean | null;
        /**
         * The full name of the Google Compute Engine [network](https://cloud.google.com//compute/docs/networks-and-firewalls#networks)
         */
        network?: string | null;
        /**
         * The name of the subnet that this instance is in. Format: `projects/{project_id_or_number\}/regions/{region\}/subnetworks/{subnetwork_id\}`
         */
        subnetwork?: string | null;
    }
    /**
     * Represents a mount configuration for Network File System (NFS) to mount.
     */
    export interface Schema$GoogleCloudAiplatformV1NfsMount {
        /**
         * Required. Destination mount path. The NFS will be mounted for the user under /mnt/nfs/
         */
        mountPoint?: string | null;
        /**
         * Required. Source path exported from NFS server. Has to start with '/', and combined with the ip address, it indicates the source mount path in the form of `server:path`
         */
        path?: string | null;
        /**
         * Required. IP address of the NFS server.
         */
        server?: string | null;
    }
    /**
     * The euc configuration of NotebookRuntimeTemplate.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookEucConfig {
        /**
         * Output only. Whether ActAs check is bypassed for service account attached to the VM. If false, we need ActAs check for the default Compute Engine Service account. When a Runtime is created, a VM is allocated using Default Compute Engine Service Account. Any user requesting to use this Runtime requires Service Account User (ActAs) permission over this SA. If true, Runtime owner is using EUC and does not require the above permission as VM no longer use default Compute Engine SA, but a P4SA.
         */
        bypassActasCheck?: boolean | null;
        /**
         * Input only. Whether EUC is disabled in this NotebookRuntimeTemplate. In proto3, the default value of a boolean is false. In this way, by default EUC will be enabled for NotebookRuntimeTemplate.
         */
        eucDisabled?: boolean | null;
    }
    /**
     * NotebookExecutionJob represents an instance of a notebook execution.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookExecutionJob {
        /**
         * Output only. Timestamp when this NotebookExecutionJob was created.
         */
        createTime?: string | null;
        /**
         * The custom compute configuration for an execution job.
         */
        customEnvironmentSpec?: Schema$GoogleCloudAiplatformV1NotebookExecutionJobCustomEnvironmentSpec;
        /**
         * The Dataform Repository pointing to a single file notebook repository.
         */
        dataformRepositorySource?: Schema$GoogleCloudAiplatformV1NotebookExecutionJobDataformRepositorySource;
        /**
         * The contents of an input notebook file.
         */
        directNotebookSource?: Schema$GoogleCloudAiplatformV1NotebookExecutionJobDirectNotebookSource;
        /**
         * The display name of the NotebookExecutionJob. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for the notebook execution job. This field is auto-populated if the NotebookRuntimeTemplate has an encryption spec.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Max running time of the execution job in seconds (default 86400s / 24 hrs).
         */
        executionTimeout?: string | null;
        /**
         * The user email to run the execution as. Only supported by Colab runtimes.
         */
        executionUser?: string | null;
        /**
         * The Cloud Storage url pointing to the ipynb file. Format: `gs://bucket/notebook_file.ipynb`
         */
        gcsNotebookSource?: Schema$GoogleCloudAiplatformV1NotebookExecutionJobGcsNotebookSource;
        /**
         * The Cloud Storage location to upload the result to. Format: `gs://bucket-name`
         */
        gcsOutputUri?: string | null;
        /**
         * Output only. The state of the NotebookExecutionJob.
         */
        jobState?: string | null;
        /**
         * The name of the kernel to use during notebook execution. If unset, the default kernel is used.
         */
        kernelName?: string | null;
        /**
         * The labels with user-defined metadata to organize NotebookExecutionJobs. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. The resource name of this NotebookExecutionJob. Format: `projects/{project_id\}/locations/{location\}/notebookExecutionJobs/{job_id\}`
         */
        name?: string | null;
        /**
         * The NotebookRuntimeTemplate to source compute configuration from.
         */
        notebookRuntimeTemplateResourceName?: string | null;
        /**
         * The Schedule resource name if this job is triggered by one. Format: `projects/{project_id\}/locations/{location\}/schedules/{schedule_id\}`
         */
        scheduleResourceName?: string | null;
        /**
         * The service account to run the execution as.
         */
        serviceAccount?: string | null;
        /**
         * Output only. Populated when the NotebookExecutionJob is completed. When there is an error during notebook execution, the error details are populated.
         */
        status?: Schema$GoogleRpcStatus;
        /**
         * Output only. Timestamp when this NotebookExecutionJob was most recently updated.
         */
        updateTime?: string | null;
        /**
         * The Workbench runtime configuration to use for the notebook execution.
         */
        workbenchRuntime?: Schema$GoogleCloudAiplatformV1NotebookExecutionJobWorkbenchRuntime;
    }
    /**
     * Compute configuration to use for an execution job.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookExecutionJobCustomEnvironmentSpec {
        /**
         * The specification of a single machine for the execution job.
         */
        machineSpec?: Schema$GoogleCloudAiplatformV1MachineSpec;
        /**
         * The network configuration to use for the execution job.
         */
        networkSpec?: Schema$GoogleCloudAiplatformV1NetworkSpec;
        /**
         * The specification of a persistent disk to attach for the execution job.
         */
        persistentDiskSpec?: Schema$GoogleCloudAiplatformV1PersistentDiskSpec;
    }
    /**
     * The Dataform Repository containing the input notebook.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookExecutionJobDataformRepositorySource {
        /**
         * The commit SHA to read repository with. If unset, the file will be read at HEAD.
         */
        commitSha?: string | null;
        /**
         * The resource name of the Dataform Repository. Format: `projects/{project_id\}/locations/{location\}/repositories/{repository_id\}`
         */
        dataformRepositoryResourceName?: string | null;
    }
    /**
     * The content of the input notebook in ipynb format.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookExecutionJobDirectNotebookSource {
        /**
         * The base64-encoded contents of the input notebook file.
         */
        content?: string | null;
    }
    /**
     * The Cloud Storage uri for the input notebook.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookExecutionJobGcsNotebookSource {
        /**
         * The version of the Cloud Storage object to read. If unset, the current version of the object is read. See https://cloud.google.com/storage/docs/metadata#generation-number.
         */
        generation?: string | null;
        /**
         * The Cloud Storage uri pointing to the ipynb file. Format: `gs://bucket/notebook_file.ipynb`
         */
        uri?: string | null;
    }
    /**
     * Configuration for a Workbench Instances-based environment.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookExecutionJobWorkbenchRuntime {
    }
    /**
     * The idle shutdown configuration of NotebookRuntimeTemplate, which contains the idle_timeout as required field.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookIdleShutdownConfig {
        /**
         * Whether Idle Shutdown is disabled in this NotebookRuntimeTemplate.
         */
        idleShutdownDisabled?: boolean | null;
        /**
         * Required. Duration is accurate to the second. In Notebook, Idle Timeout is accurate to minute so the range of idle_timeout (second) is: 10 * 60 ~ 1440 * 60.
         */
        idleTimeout?: string | null;
    }
    /**
     * Notebook Reservation Affinity for consuming Zonal reservation.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookReservationAffinity {
        /**
         * Required. Specifies the type of reservation from which this instance can consume resources: RESERVATION_ANY (default), RESERVATION_SPECIFIC, or RESERVATION_NONE. See Consuming reserved instances for examples.
         */
        consumeReservationType?: string | null;
        /**
         * Optional. Corresponds to the label key of a reservation resource. To target a RESERVATION_SPECIFIC by name, use compute.googleapis.com/reservation-name as the key and specify the name of your reservation as its value.
         */
        key?: string | null;
        /**
         * Optional. Corresponds to the label values of a reservation resource. This must be the full path name of Reservation.
         */
        values?: string[] | null;
    }
    /**
     * A runtime is a virtual machine allocated to a particular user for a particular Notebook file on temporary basis with lifetime limited to 24 hours.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookRuntime {
        /**
         * Output only. Timestamp when this NotebookRuntime was created.
         */
        createTime?: string | null;
        /**
         * Output only. The specification of persistent disk attached to the notebook runtime as data disk storage.
         */
        dataPersistentDiskSpec?: Schema$GoogleCloudAiplatformV1PersistentDiskSpec;
        /**
         * The description of the NotebookRuntime.
         */
        description?: string | null;
        /**
         * Required. The display name of the NotebookRuntime. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Output only. Customer-managed encryption key spec for the notebook runtime.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. EUC configuration of the notebook runtime.
         */
        eucConfig?: Schema$GoogleCloudAiplatformV1NotebookEucConfig;
        /**
         * Output only. Timestamp when this NotebookRuntime will be expired: 1. System Predefined NotebookRuntime: 24 hours after creation. After expiration, system predifined runtime will be deleted. 2. User created NotebookRuntime: 6 months after last upgrade. After expiration, user created runtime will be stopped and allowed for upgrade.
         */
        expirationTime?: string | null;
        /**
         * Output only. The health state of the NotebookRuntime.
         */
        healthState?: string | null;
        /**
         * Output only. The idle shutdown configuration of the notebook runtime.
         */
        idleShutdownConfig?: Schema$GoogleCloudAiplatformV1NotebookIdleShutdownConfig;
        /**
         * Output only. Whether NotebookRuntime is upgradable.
         */
        isUpgradable?: boolean | null;
        /**
         * The labels with user-defined metadata to organize your NotebookRuntime. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one NotebookRuntime (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable. Following system labels exist for NotebookRuntime: * "aiplatform.googleapis.com/notebook_runtime_gce_instance_id": output only, its value is the Compute Engine instance id. * "aiplatform.googleapis.com/colab_enterprise_entry_service": its value is either "bigquery" or "vertex"; if absent, it should be "vertex". This is to describe the entry service, either BigQuery or Vertex.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. The specification of a single machine used by the notebook runtime.
         */
        machineSpec?: Schema$GoogleCloudAiplatformV1MachineSpec;
        /**
         * Output only. The resource name of the NotebookRuntime.
         */
        name?: string | null;
        /**
         * Output only. Network spec of the notebook runtime.
         */
        networkSpec?: Schema$GoogleCloudAiplatformV1NetworkSpec;
        /**
         * Optional. The Compute Engine tags to add to runtime (see [Tagging instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
         */
        networkTags?: string[] | null;
        /**
         * Output only. The pointer to NotebookRuntimeTemplate this NotebookRuntime is created from.
         */
        notebookRuntimeTemplateRef?: Schema$GoogleCloudAiplatformV1NotebookRuntimeTemplateRef;
        /**
         * Output only. The type of the notebook runtime.
         */
        notebookRuntimeType?: string | null;
        /**
         * Output only. The proxy endpoint used to access the NotebookRuntime.
         */
        proxyUri?: string | null;
        /**
         * Output only. Reservation Affinity of the notebook runtime.
         */
        reservationAffinity?: Schema$GoogleCloudAiplatformV1NotebookReservationAffinity;
        /**
         * Output only. The runtime (instance) state of the NotebookRuntime.
         */
        runtimeState?: string | null;
        /**
         * Required. The user email of the NotebookRuntime.
         */
        runtimeUser?: string | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Deprecated: This field is no longer used and the "Vertex AI Notebook Service Account" (service-PROJECT_NUMBER@gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is used for the runtime workload identity. See https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account for more details. The service account that the NotebookRuntime workload runs as.
         */
        serviceAccount?: string | null;
        /**
         * Output only. Runtime Shielded VM spec.
         */
        shieldedVmConfig?: Schema$GoogleCloudAiplatformV1ShieldedVmConfig;
        /**
         * Output only. Software config of the notebook runtime.
         */
        softwareConfig?: Schema$GoogleCloudAiplatformV1NotebookSoftwareConfig;
        /**
         * Output only. Timestamp when this NotebookRuntime was most recently updated.
         */
        updateTime?: string | null;
        /**
         * Output only. The VM os image version of NotebookRuntime.
         */
        version?: string | null;
    }
    /**
     * A template that specifies runtime configurations such as machine type, runtime version, network configurations, etc. Multiple runtimes can be created from a runtime template.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookRuntimeTemplate {
        /**
         * Output only. Timestamp when this NotebookRuntimeTemplate was created.
         */
        createTime?: string | null;
        /**
         * Optional. The specification of persistent disk attached to the runtime as data disk storage.
         */
        dataPersistentDiskSpec?: Schema$GoogleCloudAiplatformV1PersistentDiskSpec;
        /**
         * The description of the NotebookRuntimeTemplate.
         */
        description?: string | null;
        /**
         * Required. The display name of the NotebookRuntimeTemplate. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for the notebook runtime.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * EUC configuration of the NotebookRuntimeTemplate.
         */
        eucConfig?: Schema$GoogleCloudAiplatformV1NotebookEucConfig;
        /**
         * The idle shutdown configuration of NotebookRuntimeTemplate. This config will only be set when idle shutdown is enabled.
         */
        idleShutdownConfig?: Schema$GoogleCloudAiplatformV1NotebookIdleShutdownConfig;
        /**
         * Output only. Deprecated: This field has no behavior. Use notebook_runtime_type = 'ONE_CLICK' instead. The default template to use if not specified.
         */
        isDefault?: boolean | null;
        /**
         * The labels with user-defined metadata to organize the NotebookRuntimeTemplates. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. Immutable. The specification of a single machine for the template.
         */
        machineSpec?: Schema$GoogleCloudAiplatformV1MachineSpec;
        /**
         * The resource name of the NotebookRuntimeTemplate.
         */
        name?: string | null;
        /**
         * Optional. Network spec.
         */
        networkSpec?: Schema$GoogleCloudAiplatformV1NetworkSpec;
        /**
         * Optional. The Compute Engine tags to add to runtime (see [Tagging instances](https://cloud.google.com/vpc/docs/add-remove-network-tags)).
         */
        networkTags?: string[] | null;
        /**
         * Optional. Immutable. The type of the notebook runtime template.
         */
        notebookRuntimeType?: string | null;
        /**
         * Optional. Reservation Affinity of the notebook runtime template.
         */
        reservationAffinity?: Schema$GoogleCloudAiplatformV1NotebookReservationAffinity;
        /**
         * Deprecated: This field is ignored and the "Vertex AI Notebook Service Account" (service-PROJECT_NUMBER@gcp-sa-aiplatform-vm.iam.gserviceaccount.com) is used for the runtime workload identity. See https://cloud.google.com/iam/docs/service-agents#vertex-ai-notebook-service-account for more details. For NotebookExecutionJob, use NotebookExecutionJob.service_account instead. The service account that the runtime workload runs as. You can use any service account within the same project, but you must have the service account user permission to use the instance. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
         */
        serviceAccount?: string | null;
        /**
         * Optional. Immutable. Runtime Shielded VM spec.
         */
        shieldedVmConfig?: Schema$GoogleCloudAiplatformV1ShieldedVmConfig;
        /**
         * Optional. The notebook software configuration of the notebook runtime.
         */
        softwareConfig?: Schema$GoogleCloudAiplatformV1NotebookSoftwareConfig;
        /**
         * Output only. Timestamp when this NotebookRuntimeTemplate was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * Points to a NotebookRuntimeTemplateRef.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookRuntimeTemplateRef {
        /**
         * Immutable. A resource name of the NotebookRuntimeTemplate.
         */
        notebookRuntimeTemplate?: string | null;
    }
    /**
     * Notebook Software Config.
     */
    export interface Schema$GoogleCloudAiplatformV1NotebookSoftwareConfig {
        /**
         * Optional. Environment variables to be passed to the container. Maximum limit is 100.
         */
        env?: Schema$GoogleCloudAiplatformV1EnvVar[];
        /**
         * Optional. Post startup script config.
         */
        postStartupScriptConfig?: Schema$GoogleCloudAiplatformV1PostStartupScriptConfig;
    }
    /**
     * Config for evaluation output.
     */
    export interface Schema$GoogleCloudAiplatformV1OutputConfig {
        /**
         * Cloud storage destination for evaluation output.
         */
        gcsDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
    }
    /**
     * Input for pairwise metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseMetricInput {
        /**
         * Required. Pairwise metric instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1PairwiseMetricInstance;
        /**
         * Required. Spec for pairwise metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1PairwiseMetricSpec;
    }
    /**
     * Pairwise metric instance. Usually one instance corresponds to one row in an evaluation dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseMetricInstance {
        /**
         * Key-value contents for the mutlimodality input, including text, image, video, audio, and pdf, etc. The key is placeholder in metric prompt template, and the value is the multimodal content.
         */
        contentMapInstance?: Schema$GoogleCloudAiplatformV1ContentMap;
        /**
         * Instance specified as a json string. String key-value pairs are expected in the json_instance to render PairwiseMetricSpec.instance_prompt_template.
         */
        jsonInstance?: string | null;
    }
    /**
     * Spec for pairwise metric result.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseMetricResult {
        /**
         * Output only. Spec for custom output.
         */
        customOutput?: Schema$GoogleCloudAiplatformV1CustomOutput;
        /**
         * Output only. Explanation for pairwise metric score.
         */
        explanation?: string | null;
        /**
         * Output only. Pairwise metric choice.
         */
        pairwiseChoice?: string | null;
    }
    /**
     * Spec for pairwise metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseMetricSpec {
        /**
         * Optional. The field name of the baseline response.
         */
        baselineResponseFieldName?: string | null;
        /**
         * Optional. The field name of the candidate response.
         */
        candidateResponseFieldName?: string | null;
        /**
         * Optional. CustomOutputFormatConfig allows customization of metric output. When this config is set, the default output is replaced with the raw output string. If a custom format is chosen, the `pairwise_choice` and `explanation` fields in the corresponding metric result will be empty.
         */
        customOutputFormatConfig?: Schema$GoogleCloudAiplatformV1CustomOutputFormatConfig;
        /**
         * Required. Metric prompt template for pairwise metric.
         */
        metricPromptTemplate?: string | null;
        /**
         * Optional. System instructions for pairwise metric.
         */
        systemInstruction?: string | null;
    }
    /**
     * Input for pairwise question answering quality metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityInput {
        /**
         * Required. Pairwise question answering quality instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityInstance;
        /**
         * Required. Spec for pairwise question answering quality score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualitySpec;
    }
    /**
     * Spec for pairwise question answering quality instance.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityInstance {
        /**
         * Required. Output of the baseline model.
         */
        baselinePrediction?: string | null;
        /**
         * Required. Text to answer the question.
         */
        context?: string | null;
        /**
         * Required. Question Answering prompt for LLM.
         */
        instruction?: string | null;
        /**
         * Required. Output of the candidate model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for pairwise question answering quality result.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityResult {
        /**
         * Output only. Confidence for question answering quality score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for question answering quality score.
         */
        explanation?: string | null;
        /**
         * Output only. Pairwise question answering prediction choice.
         */
        pairwiseChoice?: string | null;
    }
    /**
     * Spec for pairwise question answering quality score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualitySpec {
        /**
         * Optional. Whether to use instance.reference to compute question answering quality.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Input for pairwise summarization quality metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualityInput {
        /**
         * Required. Pairwise summarization quality instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualityInstance;
        /**
         * Required. Spec for pairwise summarization quality score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualitySpec;
    }
    /**
     * Spec for pairwise summarization quality instance.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualityInstance {
        /**
         * Required. Output of the baseline model.
         */
        baselinePrediction?: string | null;
        /**
         * Required. Text to be summarized.
         */
        context?: string | null;
        /**
         * Required. Summarization prompt for LLM.
         */
        instruction?: string | null;
        /**
         * Required. Output of the candidate model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for pairwise summarization quality result.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualityResult {
        /**
         * Output only. Confidence for summarization quality score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for summarization quality score.
         */
        explanation?: string | null;
        /**
         * Output only. Pairwise summarization prediction choice.
         */
        pairwiseChoice?: string | null;
    }
    /**
     * Spec for pairwise summarization quality score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PairwiseSummarizationQualitySpec {
        /**
         * Optional. Whether to use instance.reference to compute pairwise summarization quality.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * A datatype containing media that is part of a multi-part `Content` message. A `Part` consists of data which has an associated datatype. A `Part` can only contain one of the accepted types in `Part.data`. A `Part` must have a fixed IANA MIME type identifying the type and subtype of the media if `inline_data` or `file_data` field is filled with raw bytes.
     */
    export interface Schema$GoogleCloudAiplatformV1Part {
        /**
         * Optional. Result of executing the [ExecutableCode].
         */
        codeExecutionResult?: Schema$GoogleCloudAiplatformV1CodeExecutionResult;
        /**
         * Optional. Code generated by the model that is meant to be executed.
         */
        executableCode?: Schema$GoogleCloudAiplatformV1ExecutableCode;
        /**
         * Optional. URI based data.
         */
        fileData?: Schema$GoogleCloudAiplatformV1FileData;
        /**
         * Optional. A predicted [FunctionCall] returned from the model that contains a string representing the [FunctionDeclaration.name] with the parameters and their values.
         */
        functionCall?: Schema$GoogleCloudAiplatformV1FunctionCall;
        /**
         * Optional. The result output of a [FunctionCall] that contains a string representing the [FunctionDeclaration.name] and a structured JSON object containing any output from the function call. It is used as context to the model.
         */
        functionResponse?: Schema$GoogleCloudAiplatformV1FunctionResponse;
        /**
         * Optional. Inlined bytes data.
         */
        inlineData?: Schema$GoogleCloudAiplatformV1Blob;
        /**
         * Optional. Text part (can be code).
         */
        text?: string | null;
        /**
         * Optional. Video metadata. The metadata should only be specified while the video data is presented in inline_data or file_data.
         */
        videoMetadata?: Schema$GoogleCloudAiplatformV1VideoMetadata;
    }
    /**
     * Request message for JobService.PauseModelDeploymentMonitoringJob.
     */
    export interface Schema$GoogleCloudAiplatformV1PauseModelDeploymentMonitoringJobRequest {
    }
    /**
     * Request message for ScheduleService.PauseSchedule.
     */
    export interface Schema$GoogleCloudAiplatformV1PauseScheduleRequest {
    }
    /**
     * Represents the spec of persistent disk options.
     */
    export interface Schema$GoogleCloudAiplatformV1PersistentDiskSpec {
        /**
         * Size in GB of the disk (default is 100GB).
         */
        diskSizeGb?: string | null;
        /**
         * Type of the disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) "pd-standard" (Persistent Disk Hard Disk Drive) "pd-balanced" (Balanced Persistent Disk) "pd-extreme" (Extreme Persistent Disk)
         */
        diskType?: string | null;
    }
    /**
     * Represents long-lasting resources that are dedicated to users to runs custom workloads. A PersistentResource can have multiple node pools and each node pool can have its own machine spec.
     */
    export interface Schema$GoogleCloudAiplatformV1PersistentResource {
        /**
         * Output only. Time when the PersistentResource was created.
         */
        createTime?: string | null;
        /**
         * Optional. The display name of the PersistentResource. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Customer-managed encryption key spec for a PersistentResource. If set, this PersistentResource and all sub-resources of this PersistentResource will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Only populated when persistent resource's state is `STOPPING` or `ERROR`.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Optional. The labels with user-defined metadata to organize PersistentResource. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Immutable. Resource name of a PersistentResource.
         */
        name?: string | null;
        /**
         * Optional. The full name of the Compute Engine [network](/compute/docs/networks-and-firewalls#networks) to peered with Vertex AI to host the persistent resources. For example, `projects/12345/global/networks/myVPC`. [Format](/compute/docs/reference/rest/v1/networks/insert) is of the form `projects/{project\}/global/networks/{network\}`. Where {project\} is a project number, as in `12345`, and {network\} is a network name. To specify this field, you must have already [configured VPC Network Peering for Vertex AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering). If this field is left unspecified, the resources aren't peered with any network.
         */
        network?: string | null;
        /**
         * Optional. A list of names for the reserved IP ranges under the VPC network that can be used for this persistent resource. If set, we will deploy the persistent resource within the provided IP ranges. Otherwise, the persistent resource is deployed to any IP ranges under the provided VPC network. Example: ['vertex-ai-ip-range'].
         */
        reservedIpRanges?: string[] | null;
        /**
         * Required. The spec of the pools of different resources.
         */
        resourcePools?: Schema$GoogleCloudAiplatformV1ResourcePool[];
        /**
         * Output only. Runtime information of the Persistent Resource.
         */
        resourceRuntime?: Schema$GoogleCloudAiplatformV1ResourceRuntime;
        /**
         * Optional. Persistent Resource runtime spec. For example, used for Ray cluster configuration.
         */
        resourceRuntimeSpec?: Schema$GoogleCloudAiplatformV1ResourceRuntimeSpec;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Time when the PersistentResource for the first time entered the `RUNNING` state.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of a Study.
         */
        state?: string | null;
        /**
         * Output only. Time when the PersistentResource was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * An instance of a machine learning PipelineJob.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineJob {
        /**
         * Output only. Pipeline creation time.
         */
        createTime?: string | null;
        /**
         * The display name of the Pipeline. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for a pipelineJob. If set, this PipelineJob and all of its sub-resources will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Pipeline end time.
         */
        endTime?: string | null;
        /**
         * Output only. The error that occurred during pipeline execution. Only populated when the pipeline's state is FAILED or CANCELLED.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The details of pipeline run. Not available in the list view.
         */
        jobDetail?: Schema$GoogleCloudAiplatformV1PipelineJobDetail;
        /**
         * The labels with user-defined metadata to organize PipelineJob. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels. Note there is some reserved label key for Vertex AI Pipelines. - `vertex-ai-pipelines-run-billing-id`, user set value will get overrided.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. The resource name of the PipelineJob.
         */
        name?: string | null;
        /**
         * The full name of the Compute Engine [network](/compute/docs/networks-and-firewalls#networks) to which the Pipeline Job's workload should be peered. For example, `projects/12345/global/networks/myVPC`. [Format](/compute/docs/reference/rest/v1/networks/insert) is of the form `projects/{project\}/global/networks/{network\}`. Where {project\} is a project number, as in `12345`, and {network\} is a network name. Private services access must already be configured for the network. Pipeline job will apply the network configuration to the Google Cloud resources being launched, if applied, such as Vertex AI Training or Dataflow job. If left unspecified, the workload is not peered with any network.
         */
        network?: string | null;
        /**
         * The spec of the pipeline.
         */
        pipelineSpec?: {
            [key: string]: any;
        } | null;
        /**
         * Optional. Whether to do component level validations before job creation.
         */
        preflightValidations?: boolean | null;
        /**
         * A list of names for the reserved ip ranges under the VPC network that can be used for this Pipeline Job's workload. If set, we will deploy the Pipeline Job's workload within the provided ip ranges. Otherwise, the job will be deployed to any ip ranges under the provided VPC network. Example: ['vertex-ai-ip-range'].
         */
        reservedIpRanges?: string[] | null;
        /**
         * Runtime config of the pipeline.
         */
        runtimeConfig?: Schema$GoogleCloudAiplatformV1PipelineJobRuntimeConfig;
        /**
         * Output only. The schedule resource name. Only returned if the Pipeline is created by Schedule API.
         */
        scheduleName?: string | null;
        /**
         * The service account that the pipeline workload runs as. If not specified, the Compute Engine default service account in the project will be used. See https://cloud.google.com/compute/docs/access/service-accounts#default_service_account Users starting the pipeline must have the `iam.serviceAccounts.actAs` permission on this service account.
         */
        serviceAccount?: string | null;
        /**
         * Output only. Pipeline start time.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the job.
         */
        state?: string | null;
        /**
         * Output only. Pipeline template metadata. Will fill up fields if PipelineJob.template_uri is from supported template registry.
         */
        templateMetadata?: Schema$GoogleCloudAiplatformV1PipelineTemplateMetadata;
        /**
         * A template uri from where the PipelineJob.pipeline_spec, if empty, will be downloaded. Currently, only uri from Vertex Template Registry & Gallery is supported. Reference to https://cloud.google.com/vertex-ai/docs/pipelines/create-pipeline-template.
         */
        templateUri?: string | null;
        /**
         * Output only. Timestamp when this PipelineJob was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * The runtime detail of PipelineJob.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineJobDetail {
        /**
         * Output only. The context of the pipeline.
         */
        pipelineContext?: Schema$GoogleCloudAiplatformV1Context;
        /**
         * Output only. The context of the current pipeline run.
         */
        pipelineRunContext?: Schema$GoogleCloudAiplatformV1Context;
        /**
         * Output only. The runtime details of the tasks under the pipeline.
         */
        taskDetails?: Schema$GoogleCloudAiplatformV1PipelineTaskDetail[];
    }
    /**
     * The runtime config of a PipelineJob.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineJobRuntimeConfig {
        /**
         * Represents the failure policy of a pipeline. Currently, the default of a pipeline is that the pipeline will continue to run until no more tasks can be executed, also known as PIPELINE_FAILURE_POLICY_FAIL_SLOW. However, if a pipeline is set to PIPELINE_FAILURE_POLICY_FAIL_FAST, it will stop scheduling any new tasks when a task has failed. Any scheduled tasks will continue to completion.
         */
        failurePolicy?: string | null;
        /**
         * Required. A path in a Cloud Storage bucket, which will be treated as the root output directory of the pipeline. It is used by the system to generate the paths of output artifacts. The artifact paths are generated with a sub-path pattern `{job_id\}/{task_id\}/{output_key\}` under the specified output directory. The service account specified in this pipeline must have the `storage.objects.get` and `storage.objects.create` permissions for this bucket.
         */
        gcsOutputDirectory?: string | null;
        /**
         * The runtime artifacts of the PipelineJob. The key will be the input artifact name and the value would be one of the InputArtifact.
         */
        inputArtifacts?: {
            [key: string]: Schema$GoogleCloudAiplatformV1PipelineJobRuntimeConfigInputArtifact;
        } | null;
        /**
         * Deprecated. Use RuntimeConfig.parameter_values instead. The runtime parameters of the PipelineJob. The parameters will be passed into PipelineJob.pipeline_spec to replace the placeholders at runtime. This field is used by pipelines built using `PipelineJob.pipeline_spec.schema_version` 2.0.0 or lower, such as pipelines built using Kubeflow Pipelines SDK 1.8 or lower.
         */
        parameters?: {
            [key: string]: Schema$GoogleCloudAiplatformV1Value;
        } | null;
        /**
         * The runtime parameters of the PipelineJob. The parameters will be passed into PipelineJob.pipeline_spec to replace the placeholders at runtime. This field is used by pipelines built using `PipelineJob.pipeline_spec.schema_version` 2.1.0, such as pipelines built using Kubeflow Pipelines SDK 1.9 or higher and the v2 DSL.
         */
        parameterValues?: {
            [key: string]: any;
        } | null;
    }
    /**
     * The type of an input artifact.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineJobRuntimeConfigInputArtifact {
        /**
         * Artifact resource id from MLMD. Which is the last portion of an artifact resource name: `projects/{project\}/locations/{location\}/metadataStores/default/artifacts/{artifact_id\}`. The artifact must stay within the same project, location and default metadatastore as the pipeline.
         */
        artifactId?: string | null;
    }
    /**
     * The runtime detail of a task execution.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineTaskDetail {
        /**
         * Output only. Task create time.
         */
        createTime?: string | null;
        /**
         * Output only. Task end time.
         */
        endTime?: string | null;
        /**
         * Output only. The error that occurred during task execution. Only populated when the task's state is FAILED or CANCELLED.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The execution metadata of the task.
         */
        execution?: Schema$GoogleCloudAiplatformV1Execution;
        /**
         * Output only. The detailed execution info.
         */
        executorDetail?: Schema$GoogleCloudAiplatformV1PipelineTaskExecutorDetail;
        /**
         * Output only. The runtime input artifacts of the task.
         */
        inputs?: {
            [key: string]: Schema$GoogleCloudAiplatformV1PipelineTaskDetailArtifactList;
        } | null;
        /**
         * Output only. The runtime output artifacts of the task.
         */
        outputs?: {
            [key: string]: Schema$GoogleCloudAiplatformV1PipelineTaskDetailArtifactList;
        } | null;
        /**
         * Output only. The id of the parent task if the task is within a component scope. Empty if the task is at the root level.
         */
        parentTaskId?: string | null;
        /**
         * Output only. A list of task status. This field keeps a record of task status evolving over time.
         */
        pipelineTaskStatus?: Schema$GoogleCloudAiplatformV1PipelineTaskDetailPipelineTaskStatus[];
        /**
         * Output only. Task start time.
         */
        startTime?: string | null;
        /**
         * Output only. State of the task.
         */
        state?: string | null;
        /**
         * Output only. The system generated ID of the task.
         */
        taskId?: string | null;
        /**
         * Output only. The user specified name of the task that is defined in pipeline_spec.
         */
        taskName?: string | null;
    }
    /**
     * A list of artifact metadata.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineTaskDetailArtifactList {
        /**
         * Output only. A list of artifact metadata.
         */
        artifacts?: Schema$GoogleCloudAiplatformV1Artifact[];
    }
    /**
     * A single record of the task status.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineTaskDetailPipelineTaskStatus {
        /**
         * Output only. The error that occurred during the state. May be set when the state is any of the non-final state (PENDING/RUNNING/CANCELLING) or FAILED state. If the state is FAILED, the error here is final and not going to be retried. If the state is a non-final state, the error indicates a system-error being retried.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The state of the task.
         */
        state?: string | null;
        /**
         * Output only. Update time of this status.
         */
        updateTime?: string | null;
    }
    /**
     * The runtime detail of a pipeline executor.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineTaskExecutorDetail {
        /**
         * Output only. The detailed info for a container executor.
         */
        containerDetail?: Schema$GoogleCloudAiplatformV1PipelineTaskExecutorDetailContainerDetail;
        /**
         * Output only. The detailed info for a custom job executor.
         */
        customJobDetail?: Schema$GoogleCloudAiplatformV1PipelineTaskExecutorDetailCustomJobDetail;
    }
    /**
     * The detail of a container execution. It contains the job names of the lifecycle of a container execution.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineTaskExecutorDetailContainerDetail {
        /**
         * Output only. The names of the previously failed CustomJob for the main container executions. The list includes the all attempts in chronological order.
         */
        failedMainJobs?: string[] | null;
        /**
         * Output only. The names of the previously failed CustomJob for the pre-caching-check container executions. This job will be available if the PipelineJob.pipeline_spec specifies the `pre_caching_check` hook in the lifecycle events. The list includes the all attempts in chronological order.
         */
        failedPreCachingCheckJobs?: string[] | null;
        /**
         * Output only. The name of the CustomJob for the main container execution.
         */
        mainJob?: string | null;
        /**
         * Output only. The name of the CustomJob for the pre-caching-check container execution. This job will be available if the PipelineJob.pipeline_spec specifies the `pre_caching_check` hook in the lifecycle events.
         */
        preCachingCheckJob?: string | null;
    }
    /**
     * The detailed info for a custom job executor.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineTaskExecutorDetailCustomJobDetail {
        /**
         * Output only. The names of the previously failed CustomJob. The list includes the all attempts in chronological order.
         */
        failedJobs?: string[] | null;
        /**
         * Output only. The name of the CustomJob.
         */
        job?: string | null;
    }
    /**
     * Pipeline template metadata if PipelineJob.template_uri is from supported template registry. Currently, the only supported registry is Artifact Registry.
     */
    export interface Schema$GoogleCloudAiplatformV1PipelineTemplateMetadata {
        /**
         * The version_name in artifact registry. Will always be presented in output if the PipelineJob.template_uri is from supported template registry. Format is "sha256:abcdef123456...".
         */
        version?: string | null;
    }
    /**
     * Input for pointwise metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PointwiseMetricInput {
        /**
         * Required. Pointwise metric instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1PointwiseMetricInstance;
        /**
         * Required. Spec for pointwise metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1PointwiseMetricSpec;
    }
    /**
     * Pointwise metric instance. Usually one instance corresponds to one row in an evaluation dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1PointwiseMetricInstance {
        /**
         * Key-value contents for the mutlimodality input, including text, image, video, audio, and pdf, etc. The key is placeholder in metric prompt template, and the value is the multimodal content.
         */
        contentMapInstance?: Schema$GoogleCloudAiplatformV1ContentMap;
        /**
         * Instance specified as a json string. String key-value pairs are expected in the json_instance to render PointwiseMetricSpec.instance_prompt_template.
         */
        jsonInstance?: string | null;
    }
    /**
     * Spec for pointwise metric result.
     */
    export interface Schema$GoogleCloudAiplatformV1PointwiseMetricResult {
        /**
         * Output only. Spec for custom output.
         */
        customOutput?: Schema$GoogleCloudAiplatformV1CustomOutput;
        /**
         * Output only. Explanation for pointwise metric score.
         */
        explanation?: string | null;
        /**
         * Output only. Pointwise metric score.
         */
        score?: number | null;
    }
    /**
     * Spec for pointwise metric.
     */
    export interface Schema$GoogleCloudAiplatformV1PointwiseMetricSpec {
        /**
         * Optional. CustomOutputFormatConfig allows customization of metric output. By default, metrics return a score and explanation. When this config is set, the default output is replaced with either: - The raw output string. - A parsed output based on a user-defined schema. If a custom format is chosen, the `score` and `explanation` fields in the corresponding metric result will be empty.
         */
        customOutputFormatConfig?: Schema$GoogleCloudAiplatformV1CustomOutputFormatConfig;
        /**
         * Required. Metric prompt template for pointwise metric.
         */
        metricPromptTemplate?: string | null;
        /**
         * Optional. System instructions for pointwise metric.
         */
        systemInstruction?: string | null;
    }
    /**
     * Represents a network port in a container.
     */
    export interface Schema$GoogleCloudAiplatformV1Port {
        /**
         * The number of the port to expose on the pod's IP address. Must be a valid port number, between 1 and 65535 inclusive.
         */
        containerPort?: number | null;
    }
    /**
     * Post startup script config.
     */
    export interface Schema$GoogleCloudAiplatformV1PostStartupScriptConfig {
        /**
         * Optional. Post startup script to run after runtime is started.
         */
        postStartupScript?: string | null;
        /**
         * Optional. Post startup script behavior that defines download and execution behavior.
         */
        postStartupScriptBehavior?: string | null;
        /**
         * Optional. Post startup script url to download. Example: `gs://bucket/script.sh`
         */
        postStartupScriptUrl?: string | null;
    }
    /**
     * The configuration for the prebuilt speaker to use.
     */
    export interface Schema$GoogleCloudAiplatformV1PrebuiltVoiceConfig {
        /**
         * The name of the preset voice to use.
         */
        voiceName?: string | null;
    }
    /**
     * Assigns input data to training, validation, and test sets based on the value of a provided key. Supported only for tabular Datasets.
     */
    export interface Schema$GoogleCloudAiplatformV1PredefinedSplit {
        /**
         * Required. The key is a name of one of the Dataset's data columns. The value of the key (either the label's value or value in the column) must be one of {`training`, `validation`, `test`\}, and it defines to which set the given piece of data is assigned. If for a piece of data the key is not present or has an invalid value, that piece is ignored by the pipeline.
         */
        key?: string | null;
    }
    /**
     * Request message for PredictionService.PredictLongRunning.
     */
    export interface Schema$GoogleCloudAiplatformV1PredictLongRunningRequest {
        /**
         * Required. The instances that are the input to the prediction call. A DeployedModel may have an upper limit on the number of instances it supports per request, and when it is exceeded the prediction call errors in case of AutoML Models, or, in case of customer created Models, the behaviour is as documented by that Model. The schema of any single instance may be specified via Endpoint's DeployedModels' Model's PredictSchemata's instance_schema_uri.
         */
        instances?: any[] | null;
        /**
         * Optional. The parameters that govern the prediction. The schema of the parameters may be specified via Endpoint's DeployedModels' Model's PredictSchemata's parameters_schema_uri.
         */
        parameters?: any | null;
    }
    /**
     * Request message for PredictionService.Predict.
     */
    export interface Schema$GoogleCloudAiplatformV1PredictRequest {
        /**
         * Required. The instances that are the input to the prediction call. A DeployedModel may have an upper limit on the number of instances it supports per request, and when it is exceeded the prediction call errors in case of AutoML Models, or, in case of customer created Models, the behaviour is as documented by that Model. The schema of any single instance may be specified via Endpoint's DeployedModels' Model's PredictSchemata's instance_schema_uri.
         */
        instances?: any[] | null;
        /**
         * The parameters that govern the prediction. The schema of the parameters may be specified via Endpoint's DeployedModels' Model's PredictSchemata's parameters_schema_uri.
         */
        parameters?: any | null;
    }
    /**
     * Configuration for logging request-response to a BigQuery table.
     */
    export interface Schema$GoogleCloudAiplatformV1PredictRequestResponseLoggingConfig {
        /**
         * BigQuery table for logging. If only given a project, a new dataset will be created with name `logging__` where will be made BigQuery-dataset-name compatible (e.g. most special characters will become underscores). If no table name is given, a new table will be created with name `request_response_logging`
         */
        bigqueryDestination?: Schema$GoogleCloudAiplatformV1BigQueryDestination;
        /**
         * If logging is enabled or not.
         */
        enabled?: boolean | null;
        /**
         * Percentage of requests to be logged, expressed as a fraction in range(0,1].
         */
        samplingRate?: number | null;
    }
    /**
     * Response message for PredictionService.Predict.
     */
    export interface Schema$GoogleCloudAiplatformV1PredictResponse {
        /**
         * ID of the Endpoint's DeployedModel that served this prediction.
         */
        deployedModelId?: string | null;
        /**
         * Output only. Request-level metadata returned by the model. The metadata type will be dependent upon the model implementation.
         */
        metadata?: any | null;
        /**
         * Output only. The resource name of the Model which is deployed as the DeployedModel that this prediction hits.
         */
        model?: string | null;
        /**
         * Output only. The display name of the Model which is deployed as the DeployedModel that this prediction hits.
         */
        modelDisplayName?: string | null;
        /**
         * Output only. The version ID of the Model which is deployed as the DeployedModel that this prediction hits.
         */
        modelVersionId?: string | null;
        /**
         * The predictions that are the output of the predictions call. The schema of any single prediction may be specified via Endpoint's DeployedModels' Model's PredictSchemata's prediction_schema_uri.
         */
        predictions?: any[] | null;
    }
    /**
     * Contains the schemata used in Model's predictions and explanations via PredictionService.Predict, PredictionService.Explain and BatchPredictionJob.
     */
    export interface Schema$GoogleCloudAiplatformV1PredictSchemata {
        /**
         * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format of a single instance, which are used in PredictRequest.instances, ExplainRequest.instances and BatchPredictionJob.input_config. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models always have this field populated by Vertex AI. Note: The URI given on output will be immutable and probably different, including the URI scheme, than the one given on input. The output URI will point to a location where the user only has a read access.
         */
        instanceSchemaUri?: string | null;
        /**
         * Immutable. Points to a YAML file stored on Google Cloud Storage describing the parameters of prediction and explanation via PredictRequest.parameters, ExplainRequest.parameters and BatchPredictionJob.model_parameters. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models always have this field populated by Vertex AI, if no parameters are supported, then it is set to an empty string. Note: The URI given on output will be immutable and probably different, including the URI scheme, than the one given on input. The output URI will point to a location where the user only has a read access.
         */
        parametersSchemaUri?: string | null;
        /**
         * Immutable. Points to a YAML file stored on Google Cloud Storage describing the format of a single prediction produced by this Model, which are returned via PredictResponse.predictions, ExplainResponse.explanations, and BatchPredictionJob.output_config. The schema is defined as an OpenAPI 3.0.2 [Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject). AutoML Models always have this field populated by Vertex AI. Note: The URI given on output will be immutable and probably different, including the URI scheme, than the one given on input. The output URI will point to a location where the user only has a read access.
         */
        predictionSchemaUri?: string | null;
    }
    /**
     * Preset configuration for example-based explanations
     */
    export interface Schema$GoogleCloudAiplatformV1Presets {
        /**
         * The modality of the uploaded model, which automatically configures the distance measurement and feature normalization for the underlying example index and queries. If your model does not precisely fit one of these types, it is okay to choose the closest type.
         */
        modality?: string | null;
        /**
         * Preset option controlling parameters for speed-precision trade-off when querying for examples. If omitted, defaults to `PRECISE`.
         */
        query?: string | null;
    }
    /**
     * PrivateEndpoints proto is used to provide paths for users to send requests privately. To send request via private service access, use predict_http_uri, explain_http_uri or health_http_uri. To send request via private service connect, use service_attachment.
     */
    export interface Schema$GoogleCloudAiplatformV1PrivateEndpoints {
        /**
         * Output only. Http(s) path to send explain requests.
         */
        explainHttpUri?: string | null;
        /**
         * Output only. Http(s) path to send health check requests.
         */
        healthHttpUri?: string | null;
        /**
         * Output only. Http(s) path to send prediction requests.
         */
        predictHttpUri?: string | null;
        /**
         * Output only. The name of the service attachment resource. Populated if private service connect is enabled.
         */
        serviceAttachment?: string | null;
    }
    /**
     * Represents configuration for private service connect.
     */
    export interface Schema$GoogleCloudAiplatformV1PrivateServiceConnectConfig {
        /**
         * Required. If true, expose the IndexEndpoint via private service connect.
         */
        enablePrivateServiceConnect?: boolean | null;
        /**
         * A list of Projects from which the forwarding rule will target the service attachment.
         */
        projectAllowlist?: string[] | null;
        /**
         * Output only. The name of the generated service attachment resource. This is only populated if the endpoint is deployed with PrivateServiceConnect.
         */
        serviceAttachment?: string | null;
    }
    /**
     * Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
     */
    export interface Schema$GoogleCloudAiplatformV1Probe {
        /**
         * ExecAction probes the health of a container by executing a command.
         */
        exec?: Schema$GoogleCloudAiplatformV1ProbeExecAction;
        /**
         * Number of consecutive failures before the probe is considered failed. Defaults to 3. Minimum value is 1. Maps to Kubernetes probe argument 'failureThreshold'.
         */
        failureThreshold?: number | null;
        /**
         * GrpcAction probes the health of a container by sending a gRPC request.
         */
        grpc?: Schema$GoogleCloudAiplatformV1ProbeGrpcAction;
        /**
         * HttpGetAction probes the health of a container by sending an HTTP GET request.
         */
        httpGet?: Schema$GoogleCloudAiplatformV1ProbeHttpGetAction;
        /**
         * Number of seconds to wait before starting the probe. Defaults to 0. Minimum value is 0. Maps to Kubernetes probe argument 'initialDelaySeconds'.
         */
        initialDelaySeconds?: number | null;
        /**
         * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Must be less than timeout_seconds. Maps to Kubernetes probe argument 'periodSeconds'.
         */
        periodSeconds?: number | null;
        /**
         * Number of consecutive successes before the probe is considered successful. Defaults to 1. Minimum value is 1. Maps to Kubernetes probe argument 'successThreshold'.
         */
        successThreshold?: number | null;
        /**
         * TcpSocketAction probes the health of a container by opening a TCP socket connection.
         */
        tcpSocket?: Schema$GoogleCloudAiplatformV1ProbeTcpSocketAction;
        /**
         * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Must be greater or equal to period_seconds. Maps to Kubernetes probe argument 'timeoutSeconds'.
         */
        timeoutSeconds?: number | null;
    }
    /**
     * ExecAction specifies a command to execute.
     */
    export interface Schema$GoogleCloudAiplatformV1ProbeExecAction {
        /**
         * Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
         */
        command?: string[] | null;
    }
    /**
     * GrpcAction checks the health of a container using a gRPC service.
     */
    export interface Schema$GoogleCloudAiplatformV1ProbeGrpcAction {
        /**
         * Port number of the gRPC service. Number must be in the range 1 to 65535.
         */
        port?: number | null;
        /**
         * Service is the name of the service to place in the gRPC HealthCheckRequest. See https://github.com/grpc/grpc/blob/master/doc/health-checking.md. If this is not specified, the default behavior is defined by gRPC.
         */
        service?: string | null;
    }
    /**
     * HttpGetAction describes an action based on HTTP Get requests.
     */
    export interface Schema$GoogleCloudAiplatformV1ProbeHttpGetAction {
        /**
         * Host name to connect to, defaults to the model serving container's IP. You probably want to set "Host" in httpHeaders instead.
         */
        host?: string | null;
        /**
         * Custom headers to set in the request. HTTP allows repeated headers.
         */
        httpHeaders?: Schema$GoogleCloudAiplatformV1ProbeHttpHeader[];
        /**
         * Path to access on the HTTP server.
         */
        path?: string | null;
        /**
         * Number of the port to access on the container. Number must be in the range 1 to 65535.
         */
        port?: number | null;
        /**
         * Scheme to use for connecting to the host. Defaults to HTTP. Acceptable values are "HTTP" or "HTTPS".
         */
        scheme?: string | null;
    }
    /**
     * HttpHeader describes a custom header to be used in HTTP probes
     */
    export interface Schema$GoogleCloudAiplatformV1ProbeHttpHeader {
        /**
         * The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
         */
        name?: string | null;
        /**
         * The header field value
         */
        value?: string | null;
    }
    /**
     * TcpSocketAction probes the health of a container by opening a TCP socket connection.
     */
    export interface Schema$GoogleCloudAiplatformV1ProbeTcpSocketAction {
        /**
         * Optional: Host name to connect to, defaults to the model serving container's IP.
         */
        host?: string | null;
        /**
         * Number of the port to access on the container. Number must be in the range 1 to 65535.
         */
        port?: number | null;
    }
    /**
     * PscAutomatedEndpoints defines the output of the forwarding rule automatically created by each PscAutomationConfig.
     */
    export interface Schema$GoogleCloudAiplatformV1PscAutomatedEndpoints {
        /**
         * Ip Address created by the automated forwarding rule.
         */
        matchAddress?: string | null;
        /**
         * Corresponding network in pscAutomationConfigs.
         */
        network?: string | null;
        /**
         * Corresponding project_id in pscAutomationConfigs
         */
        projectId?: string | null;
    }
    /**
     * PSC config that is used to automatically create forwarding rule via ServiceConnectionMap.
     */
    export interface Schema$GoogleCloudAiplatformV1PSCAutomationConfig {
        /**
         * Required. The full name of the Google Compute Engine [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks). [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert): `projects/{project\}/global/networks/{network\}`. Where {project\} is a project number, as in '12345', and {network\} is network name.
         */
        network?: string | null;
        /**
         * Required. Project id used to create forwarding rule.
         */
        projectId?: string | null;
    }
    /**
     * A Model Garden Publisher Model.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModel {
        /**
         * Optional. Additional information about the model's Frameworks.
         */
        frameworks?: string[] | null;
        /**
         * Optional. Indicates the launch stage of the model.
         */
        launchStage?: string | null;
        /**
         * Output only. The resource name of the PublisherModel.
         */
        name?: string | null;
        /**
         * Required. Indicates the open source category of the publisher model.
         */
        openSourceCategory?: string | null;
        /**
         * Optional. The schemata that describes formats of the PublisherModel's predictions and explanations as given and returned via PredictionService.Predict.
         */
        predictSchemata?: Schema$GoogleCloudAiplatformV1PredictSchemata;
        /**
         * Optional. Output only. Immutable. Used to indicate this model has a publisher model and provide the template of the publisher model resource name.
         */
        publisherModelTemplate?: string | null;
        /**
         * Optional. Supported call-to-action options.
         */
        supportedActions?: Schema$GoogleCloudAiplatformV1PublisherModelCallToAction;
        /**
         * Output only. Immutable. The version ID of the PublisherModel. A new version is committed when a new model version is uploaded under an existing model id. It is an auto-incrementing decimal number in string representation.
         */
        versionId?: string | null;
        /**
         * Optional. Indicates the state of the model version.
         */
        versionState?: string | null;
    }
    /**
     * Actions could take on this Publisher Model.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToAction {
        /**
         * Optional. Create application using the PublisherModel.
         */
        createApplication?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. Deploy the PublisherModel to Vertex Endpoint.
         */
        deploy?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeploy;
        /**
         * Optional. Deploy PublisherModel to Google Kubernetes Engine.
         */
        deployGke?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeployGke;
        /**
         * Optional. Multiple setups to deploy the PublisherModel to Vertex Endpoint.
         */
        multiDeployVertex?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeployVertex;
        /**
         * Optional. Open evaluation pipeline of the PublisherModel.
         */
        openEvaluationPipeline?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. Open fine-tuning pipeline of the PublisherModel.
         */
        openFineTuningPipeline?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. Open fine-tuning pipelines of the PublisherModel.
         */
        openFineTuningPipelines?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionOpenFineTuningPipelines;
        /**
         * Optional. Open in Generation AI Studio.
         */
        openGenerationAiStudio?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. Open Genie / Playground.
         */
        openGenie?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. Open notebook of the PublisherModel.
         */
        openNotebook?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. Open notebooks of the PublisherModel.
         */
        openNotebooks?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionOpenNotebooks;
        /**
         * Optional. Open prompt-tuning pipeline of the PublisherModel.
         */
        openPromptTuningPipeline?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. Request for access.
         */
        requestAccess?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences;
        /**
         * Optional. To view Rest API docs.
         */
        viewRestApi?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionViewRestApi;
    }
    /**
     * Model metadata that is needed for UploadModel or DeployModel/CreateEndpoint requests.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeploy {
        /**
         * Optional. The path to the directory containing the Model artifact and any of its supporting files.
         */
        artifactUri?: string | null;
        /**
         * A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
         */
        automaticResources?: Schema$GoogleCloudAiplatformV1AutomaticResources;
        /**
         * Optional. The specification of the container that is to be used when deploying this Model in Vertex AI. Not present for Large Models.
         */
        containerSpec?: Schema$GoogleCloudAiplatformV1ModelContainerSpec;
        /**
         * A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
         */
        dedicatedResources?: Schema$GoogleCloudAiplatformV1DedicatedResources;
        /**
         * Optional. Metadata information about this deployment config.
         */
        deployMetadata?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeployDeployMetadata;
        /**
         * Optional. The name of the deploy task (e.g., "text to image generation").
         */
        deployTaskName?: string | null;
        /**
         * Optional. Large model reference. When this is set, model_artifact_spec is not needed.
         */
        largeModelReference?: Schema$GoogleCloudAiplatformV1LargeModelReference;
        /**
         * Optional. Default model display name.
         */
        modelDisplayName?: string | null;
        /**
         * Optional. The signed URI for ephemeral Cloud Storage access to model artifact.
         */
        publicArtifactUri?: string | null;
        /**
         * The resource name of the shared DeploymentResourcePool to deploy on. Format: `projects/{project\}/locations/{location\}/deploymentResourcePools/{deployment_resource_pool\}`
         */
        sharedResources?: string | null;
        /**
         * Required. The title of the regional resource reference.
         */
        title?: string | null;
    }
    /**
     * Metadata information about the deployment for managing deployment config.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeployDeployMetadata {
        /**
         * Optional. Labels for the deployment config. For managing deployment config like verifying, source of deployment config, etc.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. Sample request for deployed endpoint.
         */
        sampleRequest?: string | null;
    }
    /**
     * Configurations for PublisherModel GKE deployment
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeployGke {
        /**
         * Optional. GKE deployment configuration in yaml format.
         */
        gkeYamlConfigs?: string[] | null;
    }
    /**
     * Multiple setups to deploy the PublisherModel.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeployVertex {
        /**
         * Optional. One click deployment configurations.
         */
        multiDeployVertex?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionDeploy[];
    }
    /**
     * Open fine tuning pipelines.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionOpenFineTuningPipelines {
        /**
         * Required. Regional resource references to fine tuning pipelines.
         */
        fineTuningPipelines?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences[];
    }
    /**
     * Open notebooks.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionOpenNotebooks {
        /**
         * Required. Regional resource references to notebooks.
         */
        notebooks?: Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences[];
    }
    /**
     * The regional resource name or the URI. Key is region, e.g., us-central1, europe-west2, global, etc..
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionRegionalResourceReferences {
        /**
         * Required.
         */
        references?: {
            [key: string]: Schema$GoogleCloudAiplatformV1PublisherModelResourceReference;
        } | null;
        /**
         * Optional. Description of the resource.
         */
        resourceDescription?: string | null;
        /**
         * Optional. Title of the resource.
         */
        resourceTitle?: string | null;
        /**
         * Optional. Use case (CUJ) of the resource.
         */
        resourceUseCase?: string | null;
        /**
         * Required.
         */
        title?: string | null;
    }
    /**
     * Rest API docs.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelCallToActionViewRestApi {
        /**
         * Required.
         */
        documentations?: Schema$GoogleCloudAiplatformV1PublisherModelDocumentation[];
        /**
         * Required. The title of the view rest API.
         */
        title?: string | null;
    }
    /**
     * A named piece of documentation.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelDocumentation {
        /**
         * Required. Content of this piece of document (in Markdown format).
         */
        content?: string | null;
        /**
         * Required. E.g., OVERVIEW, USE CASES, DOCUMENTATION, SDK & SAMPLES, JAVA, NODE.JS, etc..
         */
        title?: string | null;
    }
    /**
     * Reference to a resource.
     */
    export interface Schema$GoogleCloudAiplatformV1PublisherModelResourceReference {
        /**
         * Description of the resource.
         */
        description?: string | null;
        /**
         * The resource name of the Google Cloud resource.
         */
        resourceName?: string | null;
        /**
         * The URI of the resource.
         */
        uri?: string | null;
        /**
         * Use case (CUJ) of the resource.
         */
        useCase?: string | null;
    }
    /**
     * Details of operations that perform MetadataService.PurgeArtifacts.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeArtifactsMetadata {
        /**
         * Operation metadata for purging Artifacts.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for MetadataService.PurgeArtifacts.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeArtifactsRequest {
        /**
         * Required. A required filter matching the Artifacts to be purged. E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
         */
        filter?: string | null;
        /**
         * Optional. Flag to indicate to actually perform the purge. If `force` is set to false, the method will return a sample of Artifact names that would be deleted.
         */
        force?: boolean | null;
    }
    /**
     * Response message for MetadataService.PurgeArtifacts.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeArtifactsResponse {
        /**
         * The number of Artifacts that this request deleted (or, if `force` is false, the number of Artifacts that will be deleted). This can be an estimate.
         */
        purgeCount?: string | null;
        /**
         * A sample of the Artifact names that will be deleted. Only populated if `force` is set to false. The maximum number of samples is 100 (it is possible to return fewer).
         */
        purgeSample?: string[] | null;
    }
    /**
     * Details of operations that perform MetadataService.PurgeContexts.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeContextsMetadata {
        /**
         * Operation metadata for purging Contexts.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for MetadataService.PurgeContexts.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeContextsRequest {
        /**
         * Required. A required filter matching the Contexts to be purged. E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
         */
        filter?: string | null;
        /**
         * Optional. Flag to indicate to actually perform the purge. If `force` is set to false, the method will return a sample of Context names that would be deleted.
         */
        force?: boolean | null;
    }
    /**
     * Response message for MetadataService.PurgeContexts.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeContextsResponse {
        /**
         * The number of Contexts that this request deleted (or, if `force` is false, the number of Contexts that will be deleted). This can be an estimate.
         */
        purgeCount?: string | null;
        /**
         * A sample of the Context names that will be deleted. Only populated if `force` is set to false. The maximum number of samples is 100 (it is possible to return fewer).
         */
        purgeSample?: string[] | null;
    }
    /**
     * Details of operations that perform MetadataService.PurgeExecutions.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeExecutionsMetadata {
        /**
         * Operation metadata for purging Executions.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for MetadataService.PurgeExecutions.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeExecutionsRequest {
        /**
         * Required. A required filter matching the Executions to be purged. E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
         */
        filter?: string | null;
        /**
         * Optional. Flag to indicate to actually perform the purge. If `force` is set to false, the method will return a sample of Execution names that would be deleted.
         */
        force?: boolean | null;
    }
    /**
     * Response message for MetadataService.PurgeExecutions.
     */
    export interface Schema$GoogleCloudAiplatformV1PurgeExecutionsResponse {
        /**
         * The number of Executions that this request deleted (or, if `force` is false, the number of Executions that will be deleted). This can be an estimate.
         */
        purgeCount?: string | null;
        /**
         * A sample of the Execution names that will be deleted. Only populated if `force` is set to false. The maximum number of samples is 100 (it is possible to return fewer).
         */
        purgeSample?: string[] | null;
    }
    /**
     * The spec of a Python packaged code.
     */
    export interface Schema$GoogleCloudAiplatformV1PythonPackageSpec {
        /**
         * Command line arguments to be passed to the Python task.
         */
        args?: string[] | null;
        /**
         * Environment variables to be passed to the python module. Maximum limit is 100.
         */
        env?: Schema$GoogleCloudAiplatformV1EnvVar[];
        /**
         * Required. The URI of a container image in Artifact Registry that will run the provided Python package. Vertex AI provides a wide range of executor images with pre-installed packages to meet users' various use cases. See the list of [pre-built containers for training](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers). You must use an image from this list.
         */
        executorImageUri?: string | null;
        /**
         * Required. The Google Cloud Storage location of the Python package files which are the training program and its dependent packages. The maximum number of package URIs is 100.
         */
        packageUris?: string[] | null;
        /**
         * Required. The Python module name to run after installing the packages.
         */
        pythonModule?: string | null;
    }
    /**
     * Response message for QueryDeployedModels method.
     */
    export interface Schema$GoogleCloudAiplatformV1QueryDeployedModelsResponse {
        /**
         * References to the DeployedModels that share the specified deploymentResourcePool.
         */
        deployedModelRefs?: Schema$GoogleCloudAiplatformV1DeployedModelRef[];
        /**
         * DEPRECATED Use deployed_model_refs instead.
         */
        deployedModels?: Schema$GoogleCloudAiplatformV1DeployedModel[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The total number of DeployedModels on this DeploymentResourcePool.
         */
        totalDeployedModelCount?: number | null;
        /**
         * The total number of Endpoints that have DeployedModels on this DeploymentResourcePool.
         */
        totalEndpointCount?: number | null;
    }
    /**
     * Request message for ReasoningEngineExecutionService.Query.
     */
    export interface Schema$GoogleCloudAiplatformV1QueryReasoningEngineRequest {
        /**
         * Optional. Class method to be used for the query. It is optional and defaults to "query" if unspecified.
         */
        classMethod?: string | null;
        /**
         * Optional. Input content provided by users in JSON object format. Examples include text query, function calling parameters, media bytes, etc.
         */
        input?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Response message for ReasoningEngineExecutionService.Query
     */
    export interface Schema$GoogleCloudAiplatformV1QueryReasoningEngineResponse {
        /**
         * Response provided by users in JSON object format.
         */
        output?: any | null;
    }
    /**
     * Input for question answering correctness metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessInput {
        /**
         * Required. Question answering correctness instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessInstance;
        /**
         * Required. Spec for question answering correctness score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessSpec;
    }
    /**
     * Spec for question answering correctness instance.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessInstance {
        /**
         * Optional. Text provided as context to answer the question.
         */
        context?: string | null;
        /**
         * Required. The question asked and other instruction in the inference prompt.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for question answering correctness result.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessResult {
        /**
         * Output only. Confidence for question answering correctness score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for question answering correctness score.
         */
        explanation?: string | null;
        /**
         * Output only. Question Answering Correctness score.
         */
        score?: number | null;
    }
    /**
     * Spec for question answering correctness metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringCorrectnessSpec {
        /**
         * Optional. Whether to use instance.reference to compute question answering correctness.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Input for question answering helpfulness metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessInput {
        /**
         * Required. Question answering helpfulness instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessInstance;
        /**
         * Required. Spec for question answering helpfulness score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessSpec;
    }
    /**
     * Spec for question answering helpfulness instance.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessInstance {
        /**
         * Optional. Text provided as context to answer the question.
         */
        context?: string | null;
        /**
         * Required. The question asked and other instruction in the inference prompt.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for question answering helpfulness result.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessResult {
        /**
         * Output only. Confidence for question answering helpfulness score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for question answering helpfulness score.
         */
        explanation?: string | null;
        /**
         * Output only. Question Answering Helpfulness score.
         */
        score?: number | null;
    }
    /**
     * Spec for question answering helpfulness metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessSpec {
        /**
         * Optional. Whether to use instance.reference to compute question answering helpfulness.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Input for question answering quality metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringQualityInput {
        /**
         * Required. Question answering quality instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1QuestionAnsweringQualityInstance;
        /**
         * Required. Spec for question answering quality score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1QuestionAnsweringQualitySpec;
    }
    /**
     * Spec for question answering quality instance.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringQualityInstance {
        /**
         * Required. Text to answer the question.
         */
        context?: string | null;
        /**
         * Required. Question Answering prompt for LLM.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for question answering quality result.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringQualityResult {
        /**
         * Output only. Confidence for question answering quality score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for question answering quality score.
         */
        explanation?: string | null;
        /**
         * Output only. Question Answering Quality score.
         */
        score?: number | null;
    }
    /**
     * Spec for question answering quality score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringQualitySpec {
        /**
         * Optional. Whether to use instance.reference to compute question answering quality.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Input for question answering relevance metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceInput {
        /**
         * Required. Question answering relevance instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceInstance;
        /**
         * Required. Spec for question answering relevance score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceSpec;
    }
    /**
     * Spec for question answering relevance instance.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceInstance {
        /**
         * Optional. Text provided as context to answer the question.
         */
        context?: string | null;
        /**
         * Required. The question asked and other instruction in the inference prompt.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for question answering relevance result.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceResult {
        /**
         * Output only. Confidence for question answering relevance score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for question answering relevance score.
         */
        explanation?: string | null;
        /**
         * Output only. Question Answering Relevance score.
         */
        score?: number | null;
    }
    /**
     * Spec for question answering relevance metric.
     */
    export interface Schema$GoogleCloudAiplatformV1QuestionAnsweringRelevanceSpec {
        /**
         * Optional. Whether to use instance.reference to compute question answering relevance.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * A RagChunk includes the content of a chunk of a RagFile, and associated metadata.
     */
    export interface Schema$GoogleCloudAiplatformV1RagChunk {
        /**
         * If populated, represents where the chunk starts and ends in the document.
         */
        pageSpan?: Schema$GoogleCloudAiplatformV1RagChunkPageSpan;
        /**
         * The content of the chunk.
         */
        text?: string | null;
    }
    /**
     * Represents where the chunk starts and ends in the document.
     */
    export interface Schema$GoogleCloudAiplatformV1RagChunkPageSpan {
        /**
         * Page where chunk starts in the document. Inclusive. 1-indexed.
         */
        firstPage?: number | null;
        /**
         * Page where chunk ends in the document. Inclusive. 1-indexed.
         */
        lastPage?: number | null;
    }
    /**
     * Relevant contexts for one query.
     */
    export interface Schema$GoogleCloudAiplatformV1RagContexts {
        /**
         * All its contexts.
         */
        contexts?: Schema$GoogleCloudAiplatformV1RagContextsContext[];
    }
    /**
     * A context of the query.
     */
    export interface Schema$GoogleCloudAiplatformV1RagContextsContext {
        /**
         * Context of the retrieved chunk.
         */
        chunk?: Schema$GoogleCloudAiplatformV1RagChunk;
        /**
         * According to the underlying Vector DB and the selected metric type, the score can be either the distance or the similarity between the query and the context and its range depends on the metric type. For example, if the metric type is COSINE_DISTANCE, it represents the distance between the query and the context. The larger the distance, the less relevant the context is to the query. The range is [0, 2], while 0 means the most relevant and 2 means the least relevant.
         */
        score?: number | null;
        /**
         * The file display name.
         */
        sourceDisplayName?: string | null;
        /**
         * If the file is imported from Cloud Storage or Google Drive, source_uri will be original file URI in Cloud Storage or Google Drive; if file is uploaded, source_uri will be file display name.
         */
        sourceUri?: string | null;
        /**
         * The text chunk.
         */
        text?: string | null;
    }
    /**
     * A RagCorpus is a RagFile container and a project can have multiple RagCorpora.
     */
    export interface Schema$GoogleCloudAiplatformV1RagCorpus {
        /**
         * Output only. RagCorpus state.
         */
        corpusStatus?: Schema$GoogleCloudAiplatformV1CorpusStatus;
        /**
         * Output only. Timestamp when this RagCorpus was created.
         */
        createTime?: string | null;
        /**
         * Optional. The description of the RagCorpus.
         */
        description?: string | null;
        /**
         * Required. The display name of the RagCorpus. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Output only. The resource name of the RagCorpus.
         */
        name?: string | null;
        /**
         * Output only. Timestamp when this RagCorpus was last updated.
         */
        updateTime?: string | null;
        /**
         * Optional. Immutable. The config for the Vector DBs.
         */
        vectorDbConfig?: Schema$GoogleCloudAiplatformV1RagVectorDbConfig;
        /**
         * Optional. Immutable. The config for the Vertex AI Search.
         */
        vertexAiSearchConfig?: Schema$GoogleCloudAiplatformV1VertexAiSearchConfig;
    }
    /**
     * Config for the embedding model to use for RAG.
     */
    export interface Schema$GoogleCloudAiplatformV1RagEmbeddingModelConfig {
        /**
         * The Vertex AI Prediction Endpoint that either refers to a publisher model or an endpoint that is hosting a 1P fine-tuned text embedding model. Endpoints hosting non-1P fine-tuned text embedding models are currently not supported. This is used for dense vector search.
         */
        vertexPredictionEndpoint?: Schema$GoogleCloudAiplatformV1RagEmbeddingModelConfigVertexPredictionEndpoint;
    }
    /**
     * Config representing a model hosted on Vertex Prediction Endpoint.
     */
    export interface Schema$GoogleCloudAiplatformV1RagEmbeddingModelConfigVertexPredictionEndpoint {
        /**
         * Required. The endpoint resource name. Format: `projects/{project\}/locations/{location\}/publishers/{publisher\}/models/{model\}` or `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        endpoint?: string | null;
        /**
         * Output only. The resource name of the model that is deployed on the endpoint. Present only when the endpoint is not a publisher model. Pattern: `projects/{project\}/locations/{location\}/models/{model\}`
         */
        model?: string | null;
        /**
         * Output only. Version ID of the model that is deployed on the endpoint. Present only when the endpoint is not a publisher model.
         */
        modelVersionId?: string | null;
    }
    /**
     * A RagFile contains user data for chunking, embedding and indexing.
     */
    export interface Schema$GoogleCloudAiplatformV1RagFile {
        /**
         * Output only. Timestamp when this RagFile was created.
         */
        createTime?: string | null;
        /**
         * Optional. The description of the RagFile.
         */
        description?: string | null;
        /**
         * Output only. The RagFile is encapsulated and uploaded in the UploadRagFile request.
         */
        directUploadSource?: Schema$GoogleCloudAiplatformV1DirectUploadSource;
        /**
         * Required. The display name of the RagFile. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Output only. State of the RagFile.
         */
        fileStatus?: Schema$GoogleCloudAiplatformV1FileStatus;
        /**
         * Output only. Google Cloud Storage location of the RagFile. It does not support wildcards in the Cloud Storage uri for now.
         */
        gcsSource?: Schema$GoogleCloudAiplatformV1GcsSource;
        /**
         * Output only. Google Drive location. Supports importing individual files as well as Google Drive folders.
         */
        googleDriveSource?: Schema$GoogleCloudAiplatformV1GoogleDriveSource;
        /**
         * The RagFile is imported from a Jira query.
         */
        jiraSource?: Schema$GoogleCloudAiplatformV1JiraSource;
        /**
         * Output only. The resource name of the RagFile.
         */
        name?: string | null;
        /**
         * The RagFile is imported from a SharePoint source.
         */
        sharePointSources?: Schema$GoogleCloudAiplatformV1SharePointSources;
        /**
         * The RagFile is imported from a Slack channel.
         */
        slackSource?: Schema$GoogleCloudAiplatformV1SlackSource;
        /**
         * Output only. Timestamp when this RagFile was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Specifies the size and overlap of chunks for RagFiles.
     */
    export interface Schema$GoogleCloudAiplatformV1RagFileChunkingConfig {
        /**
         * Specifies the fixed length chunking config.
         */
        fixedLengthChunking?: Schema$GoogleCloudAiplatformV1RagFileChunkingConfigFixedLengthChunking;
    }
    /**
     * Specifies the fixed length chunking config.
     */
    export interface Schema$GoogleCloudAiplatformV1RagFileChunkingConfigFixedLengthChunking {
        /**
         * The overlap between chunks.
         */
        chunkOverlap?: number | null;
        /**
         * The size of the chunks.
         */
        chunkSize?: number | null;
    }
    /**
     * Specifies the parsing config for RagFiles.
     */
    export interface Schema$GoogleCloudAiplatformV1RagFileParsingConfig {
        /**
         * The Layout Parser to use for RagFiles.
         */
        layoutParser?: Schema$GoogleCloudAiplatformV1RagFileParsingConfigLayoutParser;
    }
    /**
     * Document AI Layout Parser config.
     */
    export interface Schema$GoogleCloudAiplatformV1RagFileParsingConfigLayoutParser {
        /**
         * The maximum number of requests the job is allowed to make to the Document AI processor per minute. Consult https://cloud.google.com/document-ai/quotas and the Quota page for your project to set an appropriate value here. If unspecified, a default value of 120 QPM would be used.
         */
        maxParsingRequestsPerMin?: number | null;
        /**
         * The full resource name of a Document AI processor or processor version. The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the `additional_config.parse_as_scanned_pdf` field must be false. Format: * `projects/{project_id\}/locations/{location\}/processors/{processor_id\}` * `projects/{project_id\}/locations/{location\}/processors/{processor_id\}/processorVersions/{processor_version_id\}`
         */
        processorName?: string | null;
    }
    /**
     * Specifies the transformation config for RagFiles.
     */
    export interface Schema$GoogleCloudAiplatformV1RagFileTransformationConfig {
        /**
         * Specifies the chunking config for RagFiles.
         */
        ragFileChunkingConfig?: Schema$GoogleCloudAiplatformV1RagFileChunkingConfig;
    }
    /**
     * A query to retrieve relevant contexts.
     */
    export interface Schema$GoogleCloudAiplatformV1RagQuery {
        /**
         * Optional. The retrieval config for the query.
         */
        ragRetrievalConfig?: Schema$GoogleCloudAiplatformV1RagRetrievalConfig;
        /**
         * Optional. The query in text format to get relevant contexts.
         */
        text?: string | null;
    }
    /**
     * Specifies the context retrieval config.
     */
    export interface Schema$GoogleCloudAiplatformV1RagRetrievalConfig {
        /**
         * Optional. Config for filters.
         */
        filter?: Schema$GoogleCloudAiplatformV1RagRetrievalConfigFilter;
        /**
         * Optional. Config for ranking and reranking.
         */
        ranking?: Schema$GoogleCloudAiplatformV1RagRetrievalConfigRanking;
        /**
         * Optional. The number of contexts to retrieve.
         */
        topK?: number | null;
    }
    /**
     * Config for filters.
     */
    export interface Schema$GoogleCloudAiplatformV1RagRetrievalConfigFilter {
        /**
         * Optional. String for metadata filtering.
         */
        metadataFilter?: string | null;
        /**
         * Optional. Only returns contexts with vector distance smaller than the threshold.
         */
        vectorDistanceThreshold?: number | null;
        /**
         * Optional. Only returns contexts with vector similarity larger than the threshold.
         */
        vectorSimilarityThreshold?: number | null;
    }
    /**
     * Config for ranking and reranking.
     */
    export interface Schema$GoogleCloudAiplatformV1RagRetrievalConfigRanking {
        /**
         * Optional. Config for LlmRanker.
         */
        llmRanker?: Schema$GoogleCloudAiplatformV1RagRetrievalConfigRankingLlmRanker;
        /**
         * Optional. Config for Rank Service.
         */
        rankService?: Schema$GoogleCloudAiplatformV1RagRetrievalConfigRankingRankService;
    }
    /**
     * Config for LlmRanker.
     */
    export interface Schema$GoogleCloudAiplatformV1RagRetrievalConfigRankingLlmRanker {
        /**
         * Optional. The model name used for ranking. See [Supported models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/inference#supported-models).
         */
        modelName?: string | null;
    }
    /**
     * Config for Rank Service.
     */
    export interface Schema$GoogleCloudAiplatformV1RagRetrievalConfigRankingRankService {
        /**
         * Optional. The model name of the rank service. Format: `semantic-ranker-512@latest`
         */
        modelName?: string | null;
    }
    /**
     * Config for the Vector DB to use for RAG.
     */
    export interface Schema$GoogleCloudAiplatformV1RagVectorDbConfig {
        /**
         * Authentication config for the chosen Vector DB.
         */
        apiAuth?: Schema$GoogleCloudAiplatformV1ApiAuth;
        /**
         * The config for the Pinecone.
         */
        pinecone?: Schema$GoogleCloudAiplatformV1RagVectorDbConfigPinecone;
        /**
         * Optional. Immutable. The embedding model config of the Vector DB.
         */
        ragEmbeddingModelConfig?: Schema$GoogleCloudAiplatformV1RagEmbeddingModelConfig;
        /**
         * The config for the RAG-managed Vector DB.
         */
        ragManagedDb?: Schema$GoogleCloudAiplatformV1RagVectorDbConfigRagManagedDb;
        /**
         * The config for the Vertex Vector Search.
         */
        vertexVectorSearch?: Schema$GoogleCloudAiplatformV1RagVectorDbConfigVertexVectorSearch;
    }
    /**
     * The config for the Pinecone.
     */
    export interface Schema$GoogleCloudAiplatformV1RagVectorDbConfigPinecone {
        /**
         * Pinecone index name. This value cannot be changed after it's set.
         */
        indexName?: string | null;
    }
    /**
     * The config for the default RAG-managed Vector DB.
     */
    export interface Schema$GoogleCloudAiplatformV1RagVectorDbConfigRagManagedDb {
    }
    /**
     * The config for the Vertex Vector Search.
     */
    export interface Schema$GoogleCloudAiplatformV1RagVectorDbConfigVertexVectorSearch {
        /**
         * The resource name of the Index. Format: `projects/{project\}/locations/{location\}/indexes/{index\}`
         */
        index?: string | null;
        /**
         * The resource name of the Index Endpoint. Format: `projects/{project\}/locations/{location\}/indexEndpoints/{index_endpoint\}`
         */
        indexEndpoint?: string | null;
    }
    /**
     * Raw output.
     */
    export interface Schema$GoogleCloudAiplatformV1RawOutput {
        /**
         * Output only. Raw output string.
         */
        rawOutput?: string[] | null;
    }
    /**
     * Request message for PredictionService.RawPredict.
     */
    export interface Schema$GoogleCloudAiplatformV1RawPredictRequest {
        /**
         * The prediction input. Supports HTTP headers and arbitrary data payload. A DeployedModel may have an upper limit on the number of instances it supports per request. When this limit it is exceeded for an AutoML model, the RawPredict method returns an error. When this limit is exceeded for a custom-trained model, the behavior varies depending on the model. You can specify the schema for each instance in the predict_schemata.instance_schema_uri field when you create a Model. This schema applies when you deploy the `Model` as a `DeployedModel` to an Endpoint and use the `RawPredict` method.
         */
        httpBody?: Schema$GoogleApiHttpBody;
    }
    /**
     * Configuration for the Ray OSS Logs.
     */
    export interface Schema$GoogleCloudAiplatformV1RayLogsSpec {
        /**
         * Optional. Flag to disable the export of Ray OSS logs to Cloud Logging.
         */
        disabled?: boolean | null;
    }
    /**
     * Configuration for the Ray metrics.
     */
    export interface Schema$GoogleCloudAiplatformV1RayMetricSpec {
        /**
         * Optional. Flag to disable the Ray metrics collection.
         */
        disabled?: boolean | null;
    }
    /**
     * Configuration information for the Ray cluster. For experimental launch, Ray cluster creation and Persistent cluster creation are 1:1 mapping: We will provision all the nodes within the Persistent cluster as Ray nodes.
     */
    export interface Schema$GoogleCloudAiplatformV1RaySpec {
        /**
         * Optional. This will be used to indicate which resource pool will serve as the Ray head node(the first node within that pool). Will use the machine from the first workerpool as the head node by default if this field isn't set.
         */
        headNodeResourcePoolId?: string | null;
        /**
         * Optional. Default image for user to choose a preferred ML framework (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers). Either this or the resource_pool_images is required. Use this field if you need all the resource pools to have the same Ray image. Otherwise, use the {@code resource_pool_images\} field.
         */
        imageUri?: string | null;
        /**
         * Optional. OSS Ray logging configurations.
         */
        rayLogsSpec?: Schema$GoogleCloudAiplatformV1RayLogsSpec;
        /**
         * Optional. Ray metrics configurations.
         */
        rayMetricSpec?: Schema$GoogleCloudAiplatformV1RayMetricSpec;
        /**
         * Optional. Required if image_uri isn't set. A map of resource_pool_id to prebuild Ray image if user need to use different images for different head/worker pools. This map needs to cover all the resource pool ids. Example: { "ray_head_node_pool": "head image" "ray_worker_node_pool1": "worker image" "ray_worker_node_pool2": "another worker image" \}
         */
        resourcePoolImages?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Request message for FeaturestoreOnlineServingService.ReadFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadFeatureValuesRequest {
        /**
         * Required. ID for a specific entity. For example, for a machine learning model predicting user clicks on a website, an entity ID could be `user_123`.
         */
        entityId?: string | null;
        /**
         * Required. Selector choosing Features of the target EntityType.
         */
        featureSelector?: Schema$GoogleCloudAiplatformV1FeatureSelector;
    }
    /**
     * Response message for FeaturestoreOnlineServingService.ReadFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponse {
        /**
         * Entity view with Feature values. This may be the entity in the Featurestore if values for all Features were requested, or a projection of the entity in the Featurestore if values for only some Features were requested.
         */
        entityView?: Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityView;
        /**
         * Response header.
         */
        header?: Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseHeader;
    }
    /**
     * Entity view with Feature values.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityView {
        /**
         * Each piece of data holds the k requested values for one requested Feature. If no values for the requested Feature exist, the corresponding cell will be empty. This has the same size and is in the same order as the features from the header ReadFeatureValuesResponse.header.
         */
        data?: Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityViewData[];
        /**
         * ID of the requested entity.
         */
        entityId?: string | null;
    }
    /**
     * Container to hold value(s), successive in time, for one Feature from the request.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseEntityViewData {
        /**
         * Feature value if a single value is requested.
         */
        value?: Schema$GoogleCloudAiplatformV1FeatureValue;
        /**
         * Feature values list if values, successive in time, are requested. If the requested number of values is greater than the number of existing Feature values, nonexistent values are omitted instead of being returned as empty.
         */
        values?: Schema$GoogleCloudAiplatformV1FeatureValueList;
    }
    /**
     * Metadata for requested Features.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseFeatureDescriptor {
        /**
         * Feature ID.
         */
        id?: string | null;
    }
    /**
     * Response header with metadata for the requested ReadFeatureValuesRequest.entity_type and Features.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseHeader {
        /**
         * The resource name of the EntityType from the ReadFeatureValuesRequest. Value format: `projects/{project\}/locations/{location\}/featurestores/{featurestore\}/entityTypes/{entityType\}`.
         */
        entityType?: string | null;
        /**
         * List of Feature metadata corresponding to each piece of ReadFeatureValuesResponse.EntityView.data.
         */
        featureDescriptors?: Schema$GoogleCloudAiplatformV1ReadFeatureValuesResponseFeatureDescriptor[];
    }
    /**
     * The request message for MatchService.ReadIndexDatapoints.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadIndexDatapointsRequest {
        /**
         * The ID of the DeployedIndex that will serve the request.
         */
        deployedIndexId?: string | null;
        /**
         * IDs of the datapoints to be searched for.
         */
        ids?: string[] | null;
    }
    /**
     * The response message for MatchService.ReadIndexDatapoints.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadIndexDatapointsResponse {
        /**
         * The result list of datapoints.
         */
        datapoints?: Schema$GoogleCloudAiplatformV1IndexDatapoint[];
    }
    /**
     * Response message for TensorboardService.ReadTensorboardBlobData.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadTensorboardBlobDataResponse {
        /**
         * Blob messages containing blob bytes.
         */
        blobs?: Schema$GoogleCloudAiplatformV1TensorboardBlob[];
    }
    /**
     * Response message for TensorboardService.ReadTensorboardSize.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadTensorboardSizeResponse {
        /**
         * Payload storage size for the TensorBoard
         */
        storageSizeByte?: string | null;
    }
    /**
     * Response message for TensorboardService.ReadTensorboardTimeSeriesData.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadTensorboardTimeSeriesDataResponse {
        /**
         * The returned time series data.
         */
        timeSeriesData?: Schema$GoogleCloudAiplatformV1TimeSeriesData;
    }
    /**
     * Response message for TensorboardService.ReadTensorboardUsage.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadTensorboardUsageResponse {
        /**
         * Maps year-month (YYYYMM) string to per month usage data.
         */
        monthlyUsageData?: {
            [key: string]: Schema$GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerMonthUsageData;
        } | null;
    }
    /**
     * Per month usage data
     */
    export interface Schema$GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerMonthUsageData {
        /**
         * Usage data for each user in the given month.
         */
        userUsageData?: Schema$GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerUserUsageData[];
    }
    /**
     * Per user usage data.
     */
    export interface Schema$GoogleCloudAiplatformV1ReadTensorboardUsageResponsePerUserUsageData {
        /**
         * User's username
         */
        username?: string | null;
        /**
         * Number of times the user has read data within the Tensorboard.
         */
        viewCount?: string | null;
    }
    /**
     * ReasoningEngine provides a customizable runtime for models to determine which actions to take and in which order.
     */
    export interface Schema$GoogleCloudAiplatformV1ReasoningEngine {
        /**
         * Output only. Timestamp when this ReasoningEngine was created.
         */
        createTime?: string | null;
        /**
         * Optional. The description of the ReasoningEngine.
         */
        description?: string | null;
        /**
         * Required. The display name of the ReasoningEngine.
         */
        displayName?: string | null;
        /**
         * Optional. Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Identifier. The resource name of the ReasoningEngine.
         */
        name?: string | null;
        /**
         * Optional. Configurations of the ReasoningEngine
         */
        spec?: Schema$GoogleCloudAiplatformV1ReasoningEngineSpec;
        /**
         * Output only. Timestamp when this ReasoningEngine was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * ReasoningEngine configurations
     */
    export interface Schema$GoogleCloudAiplatformV1ReasoningEngineSpec {
        /**
         * Optional. The OSS agent framework used to develop the agent. Currently supported values: "google-adk", "langchain", "langgraph", "ag2", "llama-index", "custom".
         */
        agentFramework?: string | null;
        /**
         * Optional. Declarations for object class methods in OpenAPI specification format.
         */
        classMethods?: Array<{
            [key: string]: any;
        }> | null;
        /**
         * Optional. The specification of a Reasoning Engine deployment.
         */
        deploymentSpec?: Schema$GoogleCloudAiplatformV1ReasoningEngineSpecDeploymentSpec;
        /**
         * Optional. User provided package spec of the ReasoningEngine. Ignored when users directly specify a deployment image through `deployment_spec.first_party_image_override`, but keeping the field_behavior to avoid introducing breaking changes.
         */
        packageSpec?: Schema$GoogleCloudAiplatformV1ReasoningEngineSpecPackageSpec;
    }
    /**
     * The specification of a Reasoning Engine deployment.
     */
    export interface Schema$GoogleCloudAiplatformV1ReasoningEngineSpecDeploymentSpec {
        /**
         * Optional. Environment variables to be set with the Reasoning Engine deployment. The environment variables can be updated through the UpdateReasoningEngine API.
         */
        env?: Schema$GoogleCloudAiplatformV1EnvVar[];
        /**
         * Optional. Environment variables where the value is a secret in Cloud Secret Manager. To use this feature, add 'Secret Manager Secret Accessor' role (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine Service Agent.
         */
        secretEnv?: Schema$GoogleCloudAiplatformV1SecretEnvVar[];
    }
    /**
     * User provided package spec like pickled object and package requirements.
     */
    export interface Schema$GoogleCloudAiplatformV1ReasoningEngineSpecPackageSpec {
        /**
         * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
         */
        dependencyFilesGcsUri?: string | null;
        /**
         * Optional. The Cloud Storage URI of the pickled python object.
         */
        pickleObjectGcsUri?: string | null;
        /**
         * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11. If not specified, default value is 3.10.
         */
        pythonVersion?: string | null;
        /**
         * Optional. The Cloud Storage URI of the `requirements.txt` file
         */
        requirementsGcsUri?: string | null;
    }
    /**
     * Request message for GenAiTuningService.RebaseTunedModel.
     */
    export interface Schema$GoogleCloudAiplatformV1RebaseTunedModelRequest {
        /**
         * Optional. The Google Cloud Storage location to write the artifacts.
         */
        artifactDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
        /**
         * Optional. By default, bison to gemini migration will always create new model/endpoint, but for gemini-1.0 to gemini-1.5 migration, we default deploy to the same endpoint. See details in this Section.
         */
        deployToSameEndpoint?: boolean | null;
        /**
         * Required. TunedModel reference to retrieve the legacy model information.
         */
        tunedModelRef?: Schema$GoogleCloudAiplatformV1TunedModelRef;
        /**
         * Optional. The TuningJob to be updated. Users can use this TuningJob field to overwrite tuning configs.
         */
        tuningJob?: Schema$GoogleCloudAiplatformV1TuningJob;
    }
    /**
     * Details of operations that perform reboot PersistentResource.
     */
    export interface Schema$GoogleCloudAiplatformV1RebootPersistentResourceOperationMetadata {
        /**
         * Operation metadata for PersistentResource.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * Progress Message for Reboot LRO
         */
        progressMessage?: string | null;
    }
    /**
     * Request message for PersistentResourceService.RebootPersistentResource.
     */
    export interface Schema$GoogleCloudAiplatformV1RebootPersistentResourceRequest {
    }
    /**
     * Request message for MetadataService.DeleteContextChildrenRequest.
     */
    export interface Schema$GoogleCloudAiplatformV1RemoveContextChildrenRequest {
        /**
         * The resource names of the child Contexts.
         */
        childContexts?: string[] | null;
    }
    /**
     * Response message for MetadataService.RemoveContextChildren.
     */
    export interface Schema$GoogleCloudAiplatformV1RemoveContextChildrenResponse {
    }
    /**
     * Request message for IndexService.RemoveDatapoints
     */
    export interface Schema$GoogleCloudAiplatformV1RemoveDatapointsRequest {
        /**
         * A list of datapoint ids to be deleted.
         */
        datapointIds?: string[] | null;
    }
    /**
     * Response message for IndexService.RemoveDatapoints
     */
    export interface Schema$GoogleCloudAiplatformV1RemoveDatapointsResponse {
    }
    /**
     * A ReservationAffinity can be used to configure a Vertex AI resource (e.g., a DeployedModel) to draw its Compute Engine resources from a Shared Reservation, or exclusively from on-demand capacity.
     */
    export interface Schema$GoogleCloudAiplatformV1ReservationAffinity {
        /**
         * Optional. Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, use `compute.googleapis.com/reservation-name` as the key and specify the name of your reservation as its value.
         */
        key?: string | null;
        /**
         * Required. Specifies the reservation affinity type.
         */
        reservationAffinityType?: string | null;
        /**
         * Optional. Corresponds to the label values of a reservation resource. This must be the full resource name of the reservation or reservation block.
         */
        values?: string[] | null;
    }
    /**
     * Represents the spec of a group of resources of the same type, for example machine type, disk, and accelerators, in a PersistentResource.
     */
    export interface Schema$GoogleCloudAiplatformV1ResourcePool {
        /**
         * Optional. Optional spec to configure GKE or Ray-on-Vertex autoscaling
         */
        autoscalingSpec?: Schema$GoogleCloudAiplatformV1ResourcePoolAutoscalingSpec;
        /**
         * Optional. Disk spec for the machine in this node pool.
         */
        diskSpec?: Schema$GoogleCloudAiplatformV1DiskSpec;
        /**
         * Immutable. The unique ID in a PersistentResource for referring to this resource pool. User can specify it if necessary. Otherwise, it's generated automatically.
         */
        id?: string | null;
        /**
         * Required. Immutable. The specification of a single machine.
         */
        machineSpec?: Schema$GoogleCloudAiplatformV1MachineSpec;
        /**
         * Optional. The total number of machines to use for this resource pool.
         */
        replicaCount?: string | null;
        /**
         * Output only. The number of machines currently in use by training jobs for this resource pool. Will replace idle_replica_count.
         */
        usedReplicaCount?: string | null;
    }
    /**
     * The min/max number of replicas allowed if enabling autoscaling
     */
    export interface Schema$GoogleCloudAiplatformV1ResourcePoolAutoscalingSpec {
        /**
         * Optional. max replicas in the node pool, must be ≥ replica_count and \> min_replica_count or will throw error
         */
        maxReplicaCount?: string | null;
        /**
         * Optional. min replicas in the node pool, must be ≤ replica_count and < max_replica_count or will throw error. For autoscaling enabled Ray-on-Vertex, we allow min_replica_count of a resource_pool to be 0 to match the OSS Ray behavior(https://docs.ray.io/en/latest/cluster/vms/user-guides/configuring-autoscaling.html#cluster-config-parameters). As for Persistent Resource, the min_replica_count must be \> 0, we added a corresponding validation inside CreatePersistentResourceRequestValidator.java.
         */
        minReplicaCount?: string | null;
    }
    /**
     * Persistent Cluster runtime information as output
     */
    export interface Schema$GoogleCloudAiplatformV1ResourceRuntime {
        /**
         * Output only. URIs for user to connect to the Cluster. Example: { "RAY_HEAD_NODE_INTERNAL_IP": "head-node-IP:10001" "RAY_DASHBOARD_URI": "ray-dashboard-address:8888" \}
         */
        accessUris?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Configuration for the runtime on a PersistentResource instance, including but not limited to: * Service accounts used to run the workloads. * Whether to make it a dedicated Ray Cluster.
     */
    export interface Schema$GoogleCloudAiplatformV1ResourceRuntimeSpec {
        /**
         * Optional. Ray cluster configuration. Required when creating a dedicated RayCluster on the PersistentResource.
         */
        raySpec?: Schema$GoogleCloudAiplatformV1RaySpec;
        /**
         * Optional. Configure the use of workload identity on the PersistentResource
         */
        serviceAccountSpec?: Schema$GoogleCloudAiplatformV1ServiceAccountSpec;
    }
    /**
     * Statistics information about resource consumption.
     */
    export interface Schema$GoogleCloudAiplatformV1ResourcesConsumed {
        /**
         * Output only. The number of replica hours used. Note that many replicas may run in parallel, and additionally any given work may be queued for some time. Therefore this value is not strictly related to wall time.
         */
        replicaHours?: number | null;
    }
    /**
     * Runtime operation information for DatasetService.RestoreDatasetVersion.
     */
    export interface Schema$GoogleCloudAiplatformV1RestoreDatasetVersionOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for JobService.ResumeModelDeploymentMonitoringJob.
     */
    export interface Schema$GoogleCloudAiplatformV1ResumeModelDeploymentMonitoringJobRequest {
    }
    /**
     * Request message for ScheduleService.ResumeSchedule.
     */
    export interface Schema$GoogleCloudAiplatformV1ResumeScheduleRequest {
        /**
         * Optional. Whether to backfill missed runs when the schedule is resumed from PAUSED state. If set to true, all missed runs will be scheduled. New runs will be scheduled after the backfill is complete. This will also update Schedule.catch_up field. Default to false.
         */
        catchUp?: boolean | null;
    }
    /**
     * Defines a retrieval tool that model can call to access external knowledge.
     */
    export interface Schema$GoogleCloudAiplatformV1Retrieval {
        /**
         * Optional. Deprecated. This option is no longer supported.
         */
        disableAttribution?: boolean | null;
        /**
         * Set to use data source powered by Vertex AI Search.
         */
        vertexAiSearch?: Schema$GoogleCloudAiplatformV1VertexAISearch;
        /**
         * Set to use data source powered by Vertex RAG store. User data is uploaded via the VertexRagDataService.
         */
        vertexRagStore?: Schema$GoogleCloudAiplatformV1VertexRagStore;
    }
    /**
     * Retrieval config.
     */
    export interface Schema$GoogleCloudAiplatformV1RetrievalConfig {
        /**
         * The language code of the user.
         */
        languageCode?: string | null;
        /**
         * The location of the user.
         */
        latLng?: Schema$GoogleTypeLatLng;
    }
    /**
     * Metadata related to retrieval in the grounding flow.
     */
    export interface Schema$GoogleCloudAiplatformV1RetrievalMetadata {
        /**
         * Optional. Score indicating how likely information from Google Search could help answer the prompt. The score is in the range `[0, 1]`, where 0 is the least likely and 1 is the most likely. This score is only populated when Google Search grounding and dynamic retrieval is enabled. It will be compared to the threshold to determine whether to trigger Google Search.
         */
        googleSearchDynamicRetrievalScore?: number | null;
    }
    /**
     * Request message for VertexRagService.RetrieveContexts.
     */
    export interface Schema$GoogleCloudAiplatformV1RetrieveContextsRequest {
        /**
         * Required. Single RAG retrieve query.
         */
        query?: Schema$GoogleCloudAiplatformV1RagQuery;
        /**
         * The data source for Vertex RagStore.
         */
        vertexRagStore?: Schema$GoogleCloudAiplatformV1RetrieveContextsRequestVertexRagStore;
    }
    /**
     * The data source for Vertex RagStore.
     */
    export interface Schema$GoogleCloudAiplatformV1RetrieveContextsRequestVertexRagStore {
        /**
         * Optional. The representation of the rag source. It can be used to specify corpus only or ragfiles. Currently only support one corpus or multiple files from one corpus. In the future we may open up multiple corpora support.
         */
        ragResources?: Schema$GoogleCloudAiplatformV1RetrieveContextsRequestVertexRagStoreRagResource[];
        /**
         * Optional. Only return contexts with vector distance smaller than the threshold.
         */
        vectorDistanceThreshold?: number | null;
    }
    /**
     * The definition of the Rag resource.
     */
    export interface Schema$GoogleCloudAiplatformV1RetrieveContextsRequestVertexRagStoreRagResource {
        /**
         * Optional. RagCorpora resource name. Format: `projects/{project\}/locations/{location\}/ragCorpora/{rag_corpus\}`
         */
        ragCorpus?: string | null;
        /**
         * Optional. rag_file_id. The files should be in the same rag_corpus set in rag_corpus field.
         */
        ragFileIds?: string[] | null;
    }
    /**
     * Response message for VertexRagService.RetrieveContexts.
     */
    export interface Schema$GoogleCloudAiplatformV1RetrieveContextsResponse {
        /**
         * The contexts of the query.
         */
        contexts?: Schema$GoogleCloudAiplatformV1RagContexts;
    }
    /**
     * Input for rouge metric.
     */
    export interface Schema$GoogleCloudAiplatformV1RougeInput {
        /**
         * Required. Repeated rouge instances.
         */
        instances?: Schema$GoogleCloudAiplatformV1RougeInstance[];
        /**
         * Required. Spec for rouge score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1RougeSpec;
    }
    /**
     * Spec for rouge instance.
     */
    export interface Schema$GoogleCloudAiplatformV1RougeInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Required. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Rouge metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1RougeMetricValue {
        /**
         * Output only. Rouge score.
         */
        score?: number | null;
    }
    /**
     * Results for rouge metric.
     */
    export interface Schema$GoogleCloudAiplatformV1RougeResults {
        /**
         * Output only. Rouge metric values.
         */
        rougeMetricValues?: Schema$GoogleCloudAiplatformV1RougeMetricValue[];
    }
    /**
     * Spec for rouge score metric - calculates the recall of n-grams in prediction as compared to reference - returns a score ranging between 0 and 1.
     */
    export interface Schema$GoogleCloudAiplatformV1RougeSpec {
        /**
         * Optional. Supported rouge types are rougen[1-9], rougeL, and rougeLsum.
         */
        rougeType?: string | null;
        /**
         * Optional. Whether to split summaries while using rougeLsum.
         */
        splitSummaries?: boolean | null;
        /**
         * Optional. Whether to use stemmer to compute rouge score.
         */
        useStemmer?: boolean | null;
    }
    /**
     * Instance and metric spec for RubricBasedInstructionFollowing metric.
     */
    export interface Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingInput {
        /**
         * Required. Instance for RubricBasedInstructionFollowing metric.
         */
        instance?: Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingInstance;
        /**
         * Required. Spec for RubricBasedInstructionFollowing metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingSpec;
    }
    /**
     * Instance for RubricBasedInstructionFollowing metric - one instance corresponds to one row in an evaluation dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingInstance {
        /**
         * Required. Instance specified as a json string. String key-value pairs are expected in the json_instance to render RubricBasedInstructionFollowing prompt templates.
         */
        jsonInstance?: string | null;
    }
    /**
     * Result for RubricBasedInstructionFollowing metric.
     */
    export interface Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingResult {
        /**
         * Output only. List of per rubric critique results.
         */
        rubricCritiqueResults?: Schema$GoogleCloudAiplatformV1RubricCritiqueResult[];
        /**
         * Output only. Overall score for the instruction following.
         */
        score?: number | null;
    }
    /**
     * Spec for RubricBasedInstructionFollowing metric - returns rubrics and verdicts corresponding to rubrics along with overall score.
     */
    export interface Schema$GoogleCloudAiplatformV1RubricBasedInstructionFollowingSpec {
    }
    /**
     * Rubric critique result.
     */
    export interface Schema$GoogleCloudAiplatformV1RubricCritiqueResult {
        /**
         * Output only. Rubric to be evaluated.
         */
        rubric?: string | null;
        /**
         * Output only. Verdict for the rubric - true if the rubric is met, false otherwise.
         */
        verdict?: boolean | null;
    }
    /**
     * Input for safety metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SafetyInput {
        /**
         * Required. Safety instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1SafetyInstance;
        /**
         * Required. Spec for safety metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1SafetySpec;
    }
    /**
     * Spec for safety instance.
     */
    export interface Schema$GoogleCloudAiplatformV1SafetyInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
    }
    /**
     * Safety rating corresponding to the generated content.
     */
    export interface Schema$GoogleCloudAiplatformV1SafetyRating {
        /**
         * Output only. Indicates whether the content was filtered out because of this rating.
         */
        blocked?: boolean | null;
        /**
         * Output only. Harm category.
         */
        category?: string | null;
        /**
         * Output only. Harm probability levels in the content.
         */
        probability?: string | null;
        /**
         * Output only. Harm probability score.
         */
        probabilityScore?: number | null;
        /**
         * Output only. Harm severity levels in the content.
         */
        severity?: string | null;
        /**
         * Output only. Harm severity score.
         */
        severityScore?: number | null;
    }
    /**
     * Spec for safety result.
     */
    export interface Schema$GoogleCloudAiplatformV1SafetyResult {
        /**
         * Output only. Confidence for safety score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for safety score.
         */
        explanation?: string | null;
        /**
         * Output only. Safety score.
         */
        score?: number | null;
    }
    /**
     * Safety settings.
     */
    export interface Schema$GoogleCloudAiplatformV1SafetySetting {
        /**
         * Required. Harm category.
         */
        category?: string | null;
        /**
         * Optional. Specify if the threshold is used for probability or severity score. If not specified, the threshold is used for probability score.
         */
        method?: string | null;
        /**
         * Required. The harm block threshold.
         */
        threshold?: string | null;
    }
    /**
     * Spec for safety metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SafetySpec {
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Active learning data sampling config. For every active learning labeling iteration, it will select a batch of data based on the sampling strategy.
     */
    export interface Schema$GoogleCloudAiplatformV1SampleConfig {
        /**
         * The percentage of data needed to be labeled in each following batch (except the first batch).
         */
        followingBatchSamplePercentage?: number | null;
        /**
         * The percentage of data needed to be labeled in the first batch.
         */
        initialBatchSamplePercentage?: number | null;
        /**
         * Field to choose sampling strategy. Sampling strategy will decide which data should be selected for human labeling in every batch.
         */
        sampleStrategy?: string | null;
    }
    /**
     * An attribution method that approximates Shapley values for features that contribute to the label being predicted. A sampling strategy is used to approximate the value rather than considering all subsets of features.
     */
    export interface Schema$GoogleCloudAiplatformV1SampledShapleyAttribution {
        /**
         * Required. The number of feature permutations to consider when approximating the Shapley values. Valid range of its value is [1, 50], inclusively.
         */
        pathCount?: number | null;
    }
    /**
     * Sampling Strategy for logging, can be for both training and prediction dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1SamplingStrategy {
        /**
         * Random sample config. Will support more sampling strategies later.
         */
        randomSampleConfig?: Schema$GoogleCloudAiplatformV1SamplingStrategyRandomSampleConfig;
    }
    /**
     * Requests are randomly selected.
     */
    export interface Schema$GoogleCloudAiplatformV1SamplingStrategyRandomSampleConfig {
        /**
         * Sample rate (0, 1]
         */
        sampleRate?: number | null;
    }
    /**
     * A SavedQuery is a view of the dataset. It references a subset of annotations by problem type and filters.
     */
    export interface Schema$GoogleCloudAiplatformV1SavedQuery {
        /**
         * Output only. Filters on the Annotations in the dataset.
         */
        annotationFilter?: string | null;
        /**
         * Output only. Number of AnnotationSpecs in the context of the SavedQuery.
         */
        annotationSpecCount?: number | null;
        /**
         * Output only. Timestamp when this SavedQuery was created.
         */
        createTime?: string | null;
        /**
         * Required. The user-defined name of the SavedQuery. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Used to perform a consistent read-modify-write update. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Some additional information about the SavedQuery.
         */
        metadata?: any | null;
        /**
         * Output only. Resource name of the SavedQuery.
         */
        name?: string | null;
        /**
         * Required. Problem type of the SavedQuery. Allowed values: * IMAGE_CLASSIFICATION_SINGLE_LABEL * IMAGE_CLASSIFICATION_MULTI_LABEL * IMAGE_BOUNDING_POLY * IMAGE_BOUNDING_BOX * TEXT_CLASSIFICATION_SINGLE_LABEL * TEXT_CLASSIFICATION_MULTI_LABEL * TEXT_EXTRACTION * TEXT_SENTIMENT * VIDEO_CLASSIFICATION * VIDEO_OBJECT_TRACKING
         */
        problemType?: string | null;
        /**
         * Output only. If the Annotations belonging to the SavedQuery can be used for AutoML training.
         */
        supportAutomlTraining?: boolean | null;
        /**
         * Output only. Timestamp when SavedQuery was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * One point viewable on a scalar metric plot.
     */
    export interface Schema$GoogleCloudAiplatformV1Scalar {
        /**
         * Value of the point at this step / timestamp.
         */
        value?: number | null;
    }
    /**
     * An instance of a Schedule periodically schedules runs to make API calls based on user specified time specification and API request type.
     */
    export interface Schema$GoogleCloudAiplatformV1Schedule {
        /**
         * Optional. Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
         */
        allowQueueing?: boolean | null;
        /**
         * Output only. Whether to backfill missed runs when the schedule is resumed from PAUSED state. If set to true, all missed runs will be scheduled. New runs will be scheduled after the backfill is complete. Default to false.
         */
        catchUp?: boolean | null;
        /**
         * Request for NotebookService.CreateNotebookExecutionJob.
         */
        createNotebookExecutionJobRequest?: Schema$GoogleCloudAiplatformV1CreateNotebookExecutionJobRequest;
        /**
         * Request for PipelineService.CreatePipelineJob. CreatePipelineJobRequest.parent field is required (format: projects/{project\}/locations/{location\}).
         */
        createPipelineJobRequest?: Schema$GoogleCloudAiplatformV1CreatePipelineJobRequest;
        /**
         * Output only. Timestamp when this Schedule was created.
         */
        createTime?: string | null;
        /**
         * Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE\}" or "TZ=${IANA_TIME_ZONE\}". The ${IANA_TIME_ZONE\} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
         */
        cron?: string | null;
        /**
         * Required. User provided name of the Schedule. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Timestamp after which no new runs can be scheduled. If specified, The schedule will be completed when either end_time is reached or when scheduled_run_count \>= max_run_count. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
         */
        endTime?: string | null;
        /**
         * Output only. Timestamp when this Schedule was last paused. Unset if never paused.
         */
        lastPauseTime?: string | null;
        /**
         * Output only. Timestamp when this Schedule was last resumed. Unset if never resumed from pause.
         */
        lastResumeTime?: string | null;
        /**
         * Output only. Response of the last scheduled run. This is the response for starting the scheduled requests and not the execution of the operations/jobs created by the requests (if applicable). Unset if no run has been scheduled yet.
         */
        lastScheduledRunResponse?: Schema$GoogleCloudAiplatformV1ScheduleRunResponse;
        /**
         * Required. Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the operations/jobs created by the requests (if applicable).
         */
        maxConcurrentRunCount?: string | null;
        /**
         * Optional. Maximum run count of the schedule. If specified, The schedule will be completed when either started_run_count \>= max_run_count or when end_time is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
         */
        maxRunCount?: string | null;
        /**
         * Immutable. The resource name of the Schedule.
         */
        name?: string | null;
        /**
         * Output only. Timestamp when this Schedule should schedule the next run. Having a next_run_time in the past means the runs are being started behind schedule.
         */
        nextRunTime?: string | null;
        /**
         * Output only. The number of runs started by this schedule.
         */
        startedRunCount?: string | null;
        /**
         * Optional. Timestamp after which the first run can be scheduled. Default to Schedule create time if not specified.
         */
        startTime?: string | null;
        /**
         * Output only. The state of this Schedule.
         */
        state?: string | null;
        /**
         * Output only. Timestamp when this Schedule was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Status of a scheduled run.
     */
    export interface Schema$GoogleCloudAiplatformV1ScheduleRunResponse {
        /**
         * The response of the scheduled run.
         */
        runResponse?: string | null;
        /**
         * The scheduled run time based on the user-specified schedule.
         */
        scheduledRunTime?: string | null;
    }
    /**
     * All parameters related to queuing and scheduling of custom jobs.
     */
    export interface Schema$GoogleCloudAiplatformV1Scheduling {
        /**
         * Optional. Indicates if the job should retry for internal errors after the job starts running. If true, overrides `Scheduling.restart_job_on_worker_restart` to false.
         */
        disableRetries?: boolean | null;
        /**
         * Optional. This is the maximum duration that a job will wait for the requested resources to be provisioned if the scheduling strategy is set to [Strategy.DWS_FLEX_START]. If set to 0, the job will wait indefinitely. The default is 24 hours.
         */
        maxWaitDuration?: string | null;
        /**
         * Optional. Restarts the entire CustomJob if a worker gets restarted. This feature can be used by distributed training jobs that are not resilient to workers leaving and joining a job.
         */
        restartJobOnWorkerRestart?: boolean | null;
        /**
         * Optional. This determines which type of scheduling strategy to use.
         */
        strategy?: string | null;
        /**
         * Optional. The maximum job running time. The default is 7 days.
         */
        timeout?: string | null;
    }
    /**
     * Schema is used to define the format of input/output data. Represents a select subset of an [OpenAPI 3.0 schema object](https://spec.openapis.org/oas/v3.0.3#schema-object). More fields may be added in the future as needed.
     */
    export interface Schema$GoogleCloudAiplatformV1Schema {
        /**
         * Optional. The value should be validated against any (one or more) of the subschemas in the list.
         */
        anyOf?: Schema$GoogleCloudAiplatformV1Schema[];
        /**
         * Optional. Default value of the data.
         */
        default?: any | null;
        /**
         * Optional. The description of the data.
         */
        description?: string | null;
        /**
         * Optional. Possible values of the element of primitive type with enum format. Examples: 1. We can define direction as : {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]\} 2. We can define apartment number as : {type:INTEGER, format:enum, enum:["101", "201", "301"]\}
         */
        enum?: string[] | null;
        /**
         * Optional. Example of the object. Will only populated when the object is the root.
         */
        example?: any | null;
        /**
         * Optional. The format of the data. Supported formats: for NUMBER type: "float", "double" for INTEGER type: "int32", "int64" for STRING type: "email", "byte", etc
         */
        format?: string | null;
        /**
         * Optional. SCHEMA FIELDS FOR TYPE ARRAY Schema of the elements of Type.ARRAY.
         */
        items?: Schema$GoogleCloudAiplatformV1Schema;
        /**
         * Optional. Maximum value of the Type.INTEGER and Type.NUMBER
         */
        maximum?: number | null;
        /**
         * Optional. Maximum number of the elements for Type.ARRAY.
         */
        maxItems?: string | null;
        /**
         * Optional. Maximum length of the Type.STRING
         */
        maxLength?: string | null;
        /**
         * Optional. Maximum number of the properties for Type.OBJECT.
         */
        maxProperties?: string | null;
        /**
         * Optional. SCHEMA FIELDS FOR TYPE INTEGER and NUMBER Minimum value of the Type.INTEGER and Type.NUMBER
         */
        minimum?: number | null;
        /**
         * Optional. Minimum number of the elements for Type.ARRAY.
         */
        minItems?: string | null;
        /**
         * Optional. SCHEMA FIELDS FOR TYPE STRING Minimum length of the Type.STRING
         */
        minLength?: string | null;
        /**
         * Optional. Minimum number of the properties for Type.OBJECT.
         */
        minProperties?: string | null;
        /**
         * Optional. Indicates if the value may be null.
         */
        nullable?: boolean | null;
        /**
         * Optional. Pattern of the Type.STRING to restrict a string to a regular expression.
         */
        pattern?: string | null;
        /**
         * Optional. SCHEMA FIELDS FOR TYPE OBJECT Properties of Type.OBJECT.
         */
        properties?: {
            [key: string]: Schema$GoogleCloudAiplatformV1Schema;
        } | null;
        /**
         * Optional. The order of the properties. Not a standard field in open api spec. Only used to support the order of the properties.
         */
        propertyOrdering?: string[] | null;
        /**
         * Optional. Required properties of Type.OBJECT.
         */
        required?: string[] | null;
        /**
         * Optional. The title of the Schema.
         */
        title?: string | null;
        /**
         * Optional. The type of the data.
         */
        type?: string | null;
    }
    /**
     * An entry of mapping between color and AnnotationSpec. The mapping is used in segmentation mask.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaAnnotationSpecColor {
        /**
         * The color of the AnnotationSpec in a segmentation mask.
         */
        color?: Schema$GoogleTypeColor;
        /**
         * The display name of the AnnotationSpec represented by the color in the segmentation mask.
         */
        displayName?: string | null;
        /**
         * The ID of the AnnotationSpec represented by the color in the segmentation mask.
         */
        id?: string | null;
    }
    /**
     * Annotation details specific to image object detection.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageBoundingBoxAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * The rightmost coordinate of the bounding box.
         */
        xMax?: number | null;
        /**
         * The leftmost coordinate of the bounding box.
         */
        xMin?: number | null;
        /**
         * The bottommost coordinate of the bounding box.
         */
        yMax?: number | null;
        /**
         * The topmost coordinate of the bounding box.
         */
        yMin?: number | null;
    }
    /**
     * Annotation details specific to image classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageClassificationAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
    }
    /**
     * Payload of Image DataItem.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageDataItem {
        /**
         * Required. Google Cloud Storage URI points to the original image in user's bucket. The image is up to 30MB in size.
         */
        gcsUri?: string | null;
        /**
         * Output only. The mime type of the content of the image. Only the images in below listed mime types are supported. - image/jpeg - image/gif - image/png - image/webp - image/bmp - image/tiff - image/vnd.microsoft.icon
         */
        mimeType?: string | null;
    }
    /**
     * The metadata of Datasets that contain Image DataItems.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageDatasetMetadata {
        /**
         * Points to a YAML file stored on Google Cloud Storage describing payload of the Image DataItems that belong to this Dataset.
         */
        dataItemSchemaUri?: string | null;
        /**
         * Google Cloud Storage Bucket name that contains the blob data of this Dataset.
         */
        gcsBucket?: string | null;
    }
    /**
     * Annotation details specific to image segmentation.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageSegmentationAnnotation {
        /**
         * Mask based segmentation annotation. Only one mask annotation can exist for one image.
         */
        maskAnnotation?: Schema$GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationMaskAnnotation;
        /**
         * Polygon annotation.
         */
        polygonAnnotation?: Schema$GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolygonAnnotation;
        /**
         * Polyline annotation.
         */
        polylineAnnotation?: Schema$GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolylineAnnotation;
    }
    /**
     * The mask based segmentation annotation.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationMaskAnnotation {
        /**
         * The mapping between color and AnnotationSpec for this Annotation.
         */
        annotationSpecColors?: Schema$GoogleCloudAiplatformV1SchemaAnnotationSpecColor[];
        /**
         * Google Cloud Storage URI that points to the mask image. The image must be in PNG format. It must have the same size as the DataItem's image. Each pixel in the image mask represents the AnnotationSpec which the pixel in the image DataItem belong to. Each color is mapped to one AnnotationSpec based on annotation_spec_colors.
         */
        maskGcsUri?: string | null;
    }
    /**
     * Represents a polygon in image.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolygonAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * The vertexes are connected one by one and the last vertex is connected to the first one to represent a polygon.
         */
        vertexes?: Schema$GoogleCloudAiplatformV1SchemaVertex[];
    }
    /**
     * Represents a polyline in image.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaImageSegmentationAnnotationPolylineAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * The vertexes are connected one by one and the last vertex in not connected to the first one.
         */
        vertexes?: Schema$GoogleCloudAiplatformV1SchemaVertex[];
    }
    /**
     * Bounding box matching model metrics for a single intersection-over-union threshold and multiple label match confidence thresholds.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsBoundingBoxMetrics {
        /**
         * Metrics for each label-match confidence_threshold from 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is derived from them.
         */
        confidenceMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsBoundingBoxMetricsConfidenceMetrics[];
        /**
         * The intersection-over-union threshold value used to compute this metrics entry.
         */
        iouThreshold?: number | null;
        /**
         * The mean average precision, most often close to `auPrc`.
         */
        meanAveragePrecision?: number | null;
    }
    /**
     * Metrics for a single confidence threshold.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsBoundingBoxMetricsConfidenceMetrics {
        /**
         * The confidence threshold value used to compute the metrics.
         */
        confidenceThreshold?: number | null;
        /**
         * The harmonic mean of recall and precision.
         */
        f1Score?: number | null;
        /**
         * Precision under the given confidence threshold.
         */
        precision?: number | null;
        /**
         * Recall under the given confidence threshold.
         */
        recall?: number | null;
    }
    /**
     * Metrics for classification evaluation results.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsClassificationEvaluationMetrics {
        /**
         * The Area Under Precision-Recall Curve metric. Micro-averaged for the overall evaluation.
         */
        auPrc?: number | null;
        /**
         * The Area Under Receiver Operating Characteristic curve metric. Micro-averaged for the overall evaluation.
         */
        auRoc?: number | null;
        /**
         * Metrics for each `confidenceThreshold` in 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and `positionThreshold` = INT32_MAX_VALUE. ROC and precision-recall curves, and other aggregated metrics are derived from them. The confidence metrics entries may also be supplied for additional values of `positionThreshold`, but from these no aggregated metrics are computed.
         */
        confidenceMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsClassificationEvaluationMetricsConfidenceMetrics[];
        /**
         * Confusion matrix of the evaluation.
         */
        confusionMatrix?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrix;
        /**
         * The Log Loss metric.
         */
        logLoss?: number | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsClassificationEvaluationMetricsConfidenceMetrics {
        /**
         * Metrics are computed with an assumption that the Model never returns predictions with score lower than this value.
         */
        confidenceThreshold?: number | null;
        /**
         * Confusion matrix of the evaluation for this confidence_threshold.
         */
        confusionMatrix?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrix;
        /**
         * The harmonic mean of recall and precision. For summary metrics, it computes the micro-averaged F1 score.
         */
        f1Score?: number | null;
        /**
         * The harmonic mean of recallAt1 and precisionAt1.
         */
        f1ScoreAt1?: number | null;
        /**
         * Macro-averaged F1 Score.
         */
        f1ScoreMacro?: number | null;
        /**
         * Micro-averaged F1 Score.
         */
        f1ScoreMicro?: number | null;
        /**
         * The number of ground truth labels that are not matched by a Model created label.
         */
        falseNegativeCount?: string | null;
        /**
         * The number of Model created labels that do not match a ground truth label.
         */
        falsePositiveCount?: string | null;
        /**
         * False Positive Rate for the given confidence threshold.
         */
        falsePositiveRate?: number | null;
        /**
         * The False Positive Rate when only considering the label that has the highest prediction score and not below the confidence threshold for each DataItem.
         */
        falsePositiveRateAt1?: number | null;
        /**
         * Metrics are computed with an assumption that the Model always returns at most this many predictions (ordered by their score, descendingly), but they all still need to meet the `confidenceThreshold`.
         */
        maxPredictions?: number | null;
        /**
         * Precision for the given confidence threshold.
         */
        precision?: number | null;
        /**
         * The precision when only considering the label that has the highest prediction score and not below the confidence threshold for each DataItem.
         */
        precisionAt1?: number | null;
        /**
         * Recall (True Positive Rate) for the given confidence threshold.
         */
        recall?: number | null;
        /**
         * The Recall (True Positive Rate) when only considering the label that has the highest prediction score and not below the confidence threshold for each DataItem.
         */
        recallAt1?: number | null;
        /**
         * The number of labels that were not created by the Model, but if they would, they would not match a ground truth label.
         */
        trueNegativeCount?: string | null;
        /**
         * The number of Model created labels that match a ground truth label.
         */
        truePositiveCount?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrix {
        /**
         * AnnotationSpecs used in the confusion matrix. For AutoML Text Extraction, a special negative AnnotationSpec with empty `id` and `displayName` of "NULL" will be added as the last element.
         */
        annotationSpecs?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrixAnnotationSpecRef[];
        /**
         * Rows in the confusion matrix. The number of rows is equal to the size of `annotationSpecs`. `rowsi` is the number of DataItems that have ground truth of the `annotationSpecs[i]` and are predicted as `annotationSpecs[j]` by the Model being evaluated. For Text Extraction, when `annotationSpecs[i]` is the last element in `annotationSpecs`, i.e. the special negative AnnotationSpec, `rowsi` is the number of predicted entities of `annoatationSpec[j]` that are not labeled as any of the ground truth AnnotationSpec. When annotationSpecs[j] is the special negative AnnotationSpec, `rowsi` is the number of entities have ground truth of `annotationSpec[i]` that are not predicted as an entity by the Model. The value of the last cell, i.e. `rowi` where i == j and `annotationSpec[i]` is the special negative AnnotationSpec, is always 0.
         */
        rows?: any[][] | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrixAnnotationSpecRef {
        /**
         * Display name of the AnnotationSpec.
         */
        displayName?: string | null;
        /**
         * ID of the AnnotationSpec.
         */
        id?: string | null;
    }
    /**
     * Metrics for forecasting evaluation results.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsForecastingEvaluationMetrics {
        /**
         * Mean Absolute Error (MAE).
         */
        meanAbsoluteError?: number | null;
        /**
         * Mean absolute percentage error. Infinity when there are zeros in the ground truth.
         */
        meanAbsolutePercentageError?: number | null;
        /**
         * The quantile metrics entries for each quantile.
         */
        quantileMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsForecastingEvaluationMetricsQuantileMetricsEntry[];
        /**
         * Root Mean Squared Error (RMSE).
         */
        rootMeanSquaredError?: number | null;
        /**
         * Root mean squared log error. Undefined when there are negative ground truth values or predictions.
         */
        rootMeanSquaredLogError?: number | null;
        /**
         * Root Mean Square Percentage Error. Square root of MSPE. Undefined/imaginary when MSPE is negative.
         */
        rootMeanSquaredPercentageError?: number | null;
        /**
         * Coefficient of determination as Pearson correlation coefficient. Undefined when ground truth or predictions are constant or near constant.
         */
        rSquared?: number | null;
        /**
         * Weighted Absolute Percentage Error. Does not use weights, this is just what the metric is called. Undefined if actual values sum to zero. Will be very large if actual values sum to a very small number.
         */
        weightedAbsolutePercentageError?: number | null;
    }
    /**
     * Entry for the Quantiles loss type optimization objective.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsForecastingEvaluationMetricsQuantileMetricsEntry {
        /**
         * This is a custom metric that calculates the percentage of true values that were less than the predicted value for that quantile. Only populated when optimization_objective is minimize-quantile-loss and each entry corresponds to an entry in quantiles The percent value can be used to compare with the quantile value, which is the target value.
         */
        observedQuantile?: number | null;
        /**
         * The quantile for this entry.
         */
        quantile?: number | null;
        /**
         * The scaled pinball loss of this quantile.
         */
        scaledPinballLoss?: number | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsGeneralTextGenerationEvaluationMetrics {
        /**
         * BLEU (bilingual evaluation understudy) scores based on sacrebleu implementation.
         */
        bleu?: number | null;
        /**
         * ROUGE-L (Longest Common Subsequence) scoring at summary level.
         */
        rougeLSum?: number | null;
    }
    /**
     * Metrics for image object detection evaluation results.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsImageObjectDetectionEvaluationMetrics {
        /**
         * The single metric for bounding boxes evaluation: the `meanAveragePrecision` averaged over all `boundingBoxMetricsEntries`.
         */
        boundingBoxMeanAveragePrecision?: number | null;
        /**
         * The bounding boxes match metrics for each intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 pair.
         */
        boundingBoxMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsBoundingBoxMetrics[];
        /**
         * The total number of bounding boxes (i.e. summed over all images) the ground truth used to create this evaluation had.
         */
        evaluatedBoundingBoxCount?: number | null;
    }
    /**
     * Metrics for image segmentation evaluation results.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsImageSegmentationEvaluationMetrics {
        /**
         * Metrics for each confidenceThreshold in 0.00,0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 Precision-recall curve can be derived from it.
         */
        confidenceMetricsEntries?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsImageSegmentationEvaluationMetricsConfidenceMetricsEntry[];
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsImageSegmentationEvaluationMetricsConfidenceMetricsEntry {
        /**
         * Metrics are computed with an assumption that the model never returns predictions with score lower than this value.
         */
        confidenceThreshold?: number | null;
        /**
         * Confusion matrix for the given confidence threshold.
         */
        confusionMatrix?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrix;
        /**
         * DSC or the F1 score, The harmonic mean of recall and precision.
         */
        diceScoreCoefficient?: number | null;
        /**
         * The intersection-over-union score. The measure of overlap of the annotation's category mask with ground truth category mask on the DataItem.
         */
        iouScore?: number | null;
        /**
         * Precision for the given confidence threshold.
         */
        precision?: number | null;
        /**
         * Recall (True Positive Rate) for the given confidence threshold.
         */
        recall?: number | null;
    }
    /**
     * Metrics for general pairwise text generation evaluation results.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsPairwiseTextGenerationEvaluationMetrics {
        /**
         * Fraction of cases where the autorater agreed with the human raters.
         */
        accuracy?: number | null;
        /**
         * Percentage of time the autorater decided the baseline model had the better response.
         */
        baselineModelWinRate?: number | null;
        /**
         * A measurement of agreement between the autorater and human raters that takes the likelihood of random agreement into account.
         */
        cohensKappa?: number | null;
        /**
         * Harmonic mean of precision and recall.
         */
        f1Score?: number | null;
        /**
         * Number of examples where the autorater chose the baseline model, but humans preferred the model.
         */
        falseNegativeCount?: string | null;
        /**
         * Number of examples where the autorater chose the model, but humans preferred the baseline model.
         */
        falsePositiveCount?: string | null;
        /**
         * Percentage of time humans decided the baseline model had the better response.
         */
        humanPreferenceBaselineModelWinRate?: number | null;
        /**
         * Percentage of time humans decided the model had the better response.
         */
        humanPreferenceModelWinRate?: number | null;
        /**
         * Percentage of time the autorater decided the model had the better response.
         */
        modelWinRate?: number | null;
        /**
         * Fraction of cases where the autorater and humans thought the model had a better response out of all cases where the autorater thought the model had a better response. True positive divided by all positive.
         */
        precision?: number | null;
        /**
         * Fraction of cases where the autorater and humans thought the model had a better response out of all cases where the humans thought the model had a better response.
         */
        recall?: number | null;
        /**
         * Number of examples where both the autorater and humans decided that the model had the worse response.
         */
        trueNegativeCount?: string | null;
        /**
         * Number of examples where both the autorater and humans decided that the model had the better response.
         */
        truePositiveCount?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsQuestionAnsweringEvaluationMetrics {
        /**
         * The rate at which the input predicted strings exactly match their references.
         */
        exactMatch?: number | null;
    }
    /**
     * Metrics for regression evaluation results.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsRegressionEvaluationMetrics {
        /**
         * Mean Absolute Error (MAE).
         */
        meanAbsoluteError?: number | null;
        /**
         * Mean absolute percentage error. Infinity when there are zeros in the ground truth.
         */
        meanAbsolutePercentageError?: number | null;
        /**
         * Root Mean Squared Error (RMSE).
         */
        rootMeanSquaredError?: number | null;
        /**
         * Root mean squared log error. Undefined when there are negative ground truth values or predictions.
         */
        rootMeanSquaredLogError?: number | null;
        /**
         * Coefficient of determination as Pearson correlation coefficient. Undefined when ground truth or predictions are constant or near constant.
         */
        rSquared?: number | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsSummarizationEvaluationMetrics {
        /**
         * ROUGE-L (Longest Common Subsequence) scoring at summary level.
         */
        rougeLSum?: number | null;
    }
    /**
     * Metrics for text extraction evaluation results.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTextExtractionEvaluationMetrics {
        /**
         * Metrics that have confidence thresholds. Precision-recall curve can be derived from them.
         */
        confidenceMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTextExtractionEvaluationMetricsConfidenceMetrics[];
        /**
         * Confusion matrix of the evaluation. Only set for Models where number of AnnotationSpecs is no more than 10. Only set for ModelEvaluations, not for ModelEvaluationSlices.
         */
        confusionMatrix?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrix;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTextExtractionEvaluationMetricsConfidenceMetrics {
        /**
         * Metrics are computed with an assumption that the Model never returns predictions with score lower than this value.
         */
        confidenceThreshold?: number | null;
        /**
         * The harmonic mean of recall and precision.
         */
        f1Score?: number | null;
        /**
         * Precision for the given confidence threshold.
         */
        precision?: number | null;
        /**
         * Recall (True Positive Rate) for the given confidence threshold.
         */
        recall?: number | null;
    }
    /**
     * Model evaluation metrics for text sentiment problems.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTextSentimentEvaluationMetrics {
        /**
         * Confusion matrix of the evaluation. Only set for ModelEvaluations, not for ModelEvaluationSlices.
         */
        confusionMatrix?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsConfusionMatrix;
        /**
         * The harmonic mean of recall and precision.
         */
        f1Score?: number | null;
        /**
         * Linear weighted kappa. Only set for ModelEvaluations, not for ModelEvaluationSlices.
         */
        linearKappa?: number | null;
        /**
         * Mean absolute error. Only set for ModelEvaluations, not for ModelEvaluationSlices.
         */
        meanAbsoluteError?: number | null;
        /**
         * Mean squared error. Only set for ModelEvaluations, not for ModelEvaluationSlices.
         */
        meanSquaredError?: number | null;
        /**
         * Precision.
         */
        precision?: number | null;
        /**
         * Quadratic weighted kappa. Only set for ModelEvaluations, not for ModelEvaluationSlices.
         */
        quadraticKappa?: number | null;
        /**
         * Recall.
         */
        recall?: number | null;
    }
    /**
     * UNIMPLEMENTED. Track matching model metrics for a single track match threshold and multiple label match confidence thresholds.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTrackMetrics {
        /**
         * Metrics for each label-match `confidenceThreshold` from 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99. Precision-recall curve is derived from them.
         */
        confidenceMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTrackMetricsConfidenceMetrics[];
        /**
         * The intersection-over-union threshold value between bounding boxes across frames used to compute this metric entry.
         */
        iouThreshold?: number | null;
        /**
         * The mean bounding box iou over all confidence thresholds.
         */
        meanBoundingBoxIou?: number | null;
        /**
         * The mean mismatch rate over all confidence thresholds.
         */
        meanMismatchRate?: number | null;
        /**
         * The mean average precision over all confidence thresholds.
         */
        meanTrackingAveragePrecision?: number | null;
    }
    /**
     * Metrics for a single confidence threshold.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTrackMetricsConfidenceMetrics {
        /**
         * Bounding box intersection-over-union precision. Measures how well the bounding boxes overlap between each other (e.g. complete overlap or just barely above iou_threshold).
         */
        boundingBoxIou?: number | null;
        /**
         * The confidence threshold value used to compute the metrics.
         */
        confidenceThreshold?: number | null;
        /**
         * Mismatch rate, which measures the tracking consistency, i.e. correctness of instance ID continuity.
         */
        mismatchRate?: number | null;
        /**
         * Tracking precision.
         */
        trackingPrecision?: number | null;
        /**
         * Tracking recall.
         */
        trackingRecall?: number | null;
    }
    /**
     * The Evaluation metrics given a specific precision_window_length.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsVideoActionMetrics {
        /**
         * Metrics for each label-match confidence_threshold from 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99.
         */
        confidenceMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsVideoActionMetricsConfidenceMetrics[];
        /**
         * The mean average precision.
         */
        meanAveragePrecision?: number | null;
        /**
         * This VideoActionMetrics is calculated based on this prediction window length. If the predicted action's timestamp is inside the time window whose center is the ground truth action's timestamp with this specific length, the prediction result is treated as a true positive.
         */
        precisionWindowLength?: string | null;
    }
    /**
     * Metrics for a single confidence threshold.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsVideoActionMetricsConfidenceMetrics {
        /**
         * Output only. The confidence threshold value used to compute the metrics.
         */
        confidenceThreshold?: number | null;
        /**
         * Output only. The harmonic mean of recall and precision.
         */
        f1Score?: number | null;
        /**
         * Output only. Precision for the given confidence threshold.
         */
        precision?: number | null;
        /**
         * Output only. Recall for the given confidence threshold.
         */
        recall?: number | null;
    }
    /**
     * Model evaluation metrics for video action recognition.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsVideoActionRecognitionMetrics {
        /**
         * The number of ground truth actions used to create this evaluation.
         */
        evaluatedActionCount?: number | null;
        /**
         * The metric entries for precision window lengths: 1s,2s,3s.
         */
        videoActionMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsVideoActionMetrics[];
    }
    /**
     * Model evaluation metrics for video object tracking problems. Evaluates prediction quality of both labeled bounding boxes and labeled tracks (i.e. series of bounding boxes sharing same label and instance ID).
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsVideoObjectTrackingMetrics {
        /**
         * The single metric for bounding boxes evaluation: the `meanAveragePrecision` averaged over all `boundingBoxMetrics`.
         */
        boundingBoxMeanAveragePrecision?: number | null;
        /**
         * The bounding boxes match metrics for each intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 pair.
         */
        boundingBoxMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsBoundingBoxMetrics[];
        /**
         * UNIMPLEMENTED. The total number of bounding boxes (i.e. summed over all frames) the ground truth used to create this evaluation had.
         */
        evaluatedBoundingBoxCount?: number | null;
        /**
         * UNIMPLEMENTED. The number of video frames used to create this evaluation.
         */
        evaluatedFrameCount?: number | null;
        /**
         * UNIMPLEMENTED. The total number of tracks (i.e. as seen across all frames) the ground truth used to create this evaluation had.
         */
        evaluatedTrackCount?: number | null;
        /**
         * UNIMPLEMENTED. The single metric for tracks accuracy evaluation: the `meanAveragePrecision` averaged over all `trackMetrics`.
         */
        trackMeanAveragePrecision?: number | null;
        /**
         * UNIMPLEMENTED. The single metric for tracks bounding box iou evaluation: the `meanBoundingBoxIou` averaged over all `trackMetrics`.
         */
        trackMeanBoundingBoxIou?: number | null;
        /**
         * UNIMPLEMENTED. The single metric for tracking consistency evaluation: the `meanMismatchRate` averaged over all `trackMetrics`.
         */
        trackMeanMismatchRate?: number | null;
        /**
         * UNIMPLEMENTED. The tracks match metrics for each intersection-over-union threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 and each label confidence threshold 0.05,0.10,...,0.95,0.96,0.97,0.98,0.99 pair.
         */
        trackMetrics?: Schema$GoogleCloudAiplatformV1SchemaModelevaluationMetricsTrackMetrics[];
    }
    /**
     * Prediction input format for Image Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceImageClassificationPredictionInstance {
        /**
         * The image bytes or Cloud Storage URI to make the prediction on.
         */
        content?: string | null;
        /**
         * The MIME type of the content of the image. Only the images in below listed MIME types are supported. - image/jpeg - image/gif - image/png - image/webp - image/bmp - image/tiff - image/vnd.microsoft.icon
         */
        mimeType?: string | null;
    }
    /**
     * Prediction input format for Image Object Detection.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceImageObjectDetectionPredictionInstance {
        /**
         * The image bytes or Cloud Storage URI to make the prediction on.
         */
        content?: string | null;
        /**
         * The MIME type of the content of the image. Only the images in below listed MIME types are supported. - image/jpeg - image/gif - image/png - image/webp - image/bmp - image/tiff - image/vnd.microsoft.icon
         */
        mimeType?: string | null;
    }
    /**
     * Prediction input format for Image Segmentation.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceImageSegmentationPredictionInstance {
        /**
         * The image bytes to make the predictions on.
         */
        content?: string | null;
        /**
         * The MIME type of the content of the image. Only the images in below listed MIME types are supported. - image/jpeg - image/png
         */
        mimeType?: string | null;
    }
    /**
     * Prediction input format for Text Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceTextClassificationPredictionInstance {
        /**
         * The text snippet to make the predictions on.
         */
        content?: string | null;
        /**
         * The MIME type of the text snippet. The supported MIME types are listed below. - text/plain
         */
        mimeType?: string | null;
    }
    /**
     * Prediction input format for Text Extraction.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceTextExtractionPredictionInstance {
        /**
         * The text snippet to make the predictions on.
         */
        content?: string | null;
        /**
         * This field is only used for batch prediction. If a key is provided, the batch prediction result will by mapped to this key. If omitted, then the batch prediction result will contain the entire input instance. Vertex AI will not check if keys in the request are duplicates, so it is up to the caller to ensure the keys are unique.
         */
        key?: string | null;
        /**
         * The MIME type of the text snippet. The supported MIME types are listed below. - text/plain
         */
        mimeType?: string | null;
    }
    /**
     * Prediction input format for Text Sentiment.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceTextSentimentPredictionInstance {
        /**
         * The text snippet to make the predictions on.
         */
        content?: string | null;
        /**
         * The MIME type of the text snippet. The supported MIME types are listed below. - text/plain
         */
        mimeType?: string | null;
    }
    /**
     * Prediction input format for Video Action Recognition.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceVideoActionRecognitionPredictionInstance {
        /**
         * The Google Cloud Storage location of the video on which to perform the prediction.
         */
        content?: string | null;
        /**
         * The MIME type of the content of the video. Only the following are supported: video/mp4 video/avi video/quicktime
         */
        mimeType?: string | null;
        /**
         * The end, exclusive, of the video's time segment on which to perform the prediction. Expressed as a number of seconds as measured from the start of the video, with "s" appended at the end. Fractions are allowed, up to a microsecond precision, and "inf" or "Infinity" is allowed, which means the end of the video.
         */
        timeSegmentEnd?: string | null;
        /**
         * The beginning, inclusive, of the video's time segment on which to perform the prediction. Expressed as a number of seconds as measured from the start of the video, with "s" appended at the end. Fractions are allowed, up to a microsecond precision.
         */
        timeSegmentStart?: string | null;
    }
    /**
     * Prediction input format for Video Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceVideoClassificationPredictionInstance {
        /**
         * The Google Cloud Storage location of the video on which to perform the prediction.
         */
        content?: string | null;
        /**
         * The MIME type of the content of the video. Only the following are supported: video/mp4 video/avi video/quicktime
         */
        mimeType?: string | null;
        /**
         * The end, exclusive, of the video's time segment on which to perform the prediction. Expressed as a number of seconds as measured from the start of the video, with "s" appended at the end. Fractions are allowed, up to a microsecond precision, and "inf" or "Infinity" is allowed, which means the end of the video.
         */
        timeSegmentEnd?: string | null;
        /**
         * The beginning, inclusive, of the video's time segment on which to perform the prediction. Expressed as a number of seconds as measured from the start of the video, with "s" appended at the end. Fractions are allowed, up to a microsecond precision.
         */
        timeSegmentStart?: string | null;
    }
    /**
     * Prediction input format for Video Object Tracking.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictInstanceVideoObjectTrackingPredictionInstance {
        /**
         * The Google Cloud Storage location of the video on which to perform the prediction.
         */
        content?: string | null;
        /**
         * The MIME type of the content of the video. Only the following are supported: video/mp4 video/avi video/quicktime
         */
        mimeType?: string | null;
        /**
         * The end, exclusive, of the video's time segment on which to perform the prediction. Expressed as a number of seconds as measured from the start of the video, with "s" appended at the end. Fractions are allowed, up to a microsecond precision, and "inf" or "Infinity" is allowed, which means the end of the video.
         */
        timeSegmentEnd?: string | null;
        /**
         * The beginning, inclusive, of the video's time segment on which to perform the prediction. Expressed as a number of seconds as measured from the start of the video, with "s" appended at the end. Fractions are allowed, up to a microsecond precision.
         */
        timeSegmentStart?: string | null;
    }
    /**
     * Represents a line of JSONL in the batch prediction output file.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictionResult {
        /**
         * The error result. Do not set prediction if this is set.
         */
        error?: Schema$GoogleCloudAiplatformV1SchemaPredictionResultError;
        /**
         * User's input instance. Struct is used here instead of Any so that JsonFormat does not append an extra "@type" field when we convert the proto to JSON.
         */
        instance?: {
            [key: string]: any;
        } | null;
        /**
         * Optional user-provided key from the input instance.
         */
        key?: string | null;
        /**
         * The prediction result. Value is used here instead of Any so that JsonFormat does not append an extra "@type" field when we convert the proto to JSON and so we can represent array of objects. Do not set error if this is set.
         */
        prediction?: any | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictionResultError {
        /**
         * Error message with additional details.
         */
        message?: string | null;
        /**
         * Error status. This will be serialized into the enum name e.g. "NOT_FOUND".
         */
        status?: string | null;
    }
    /**
     * The configuration for grounding checking.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsGroundingConfig {
        /**
         * If set, skip finding claim attributions (i.e not generate grounding citation).
         */
        disableAttribution?: boolean | null;
        /**
         * The sources for the grounding checking.
         */
        sources?: Schema$GoogleCloudAiplatformV1SchemaPredictParamsGroundingConfigSourceEntry[];
    }
    /**
     * Single source entry for the grounding checking.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsGroundingConfigSourceEntry {
        /**
         * The uri of the Vertex AI Search data source. Deprecated. Use vertex_ai_search_datastore instead.
         */
        enterpriseDatastore?: string | null;
        /**
         * The grounding text passed inline with the Predict API. It can support up to 1 million bytes.
         */
        inlineContext?: string | null;
        /**
         * The type of the grounding checking source.
         */
        type?: string | null;
        /**
         * The uri of the Vertex AI Search data source.
         */
        vertexAiSearchDatastore?: string | null;
    }
    /**
     * Prediction model parameters for Image Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsImageClassificationPredictionParams {
        /**
         * The Model only returns predictions with at least this confidence score. Default value is 0.0
         */
        confidenceThreshold?: number | null;
        /**
         * The Model only returns up to that many top, by confidence score, predictions per instance. If this number is very high, the Model may return fewer predictions. Default value is 10.
         */
        maxPredictions?: number | null;
    }
    /**
     * Prediction model parameters for Image Object Detection.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsImageObjectDetectionPredictionParams {
        /**
         * The Model only returns predictions with at least this confidence score. Default value is 0.0
         */
        confidenceThreshold?: number | null;
        /**
         * The Model only returns up to that many top, by confidence score, predictions per instance. Note that number of returned predictions is also limited by metadata's predictionsLimit. Default value is 10.
         */
        maxPredictions?: number | null;
    }
    /**
     * Prediction model parameters for Image Segmentation.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsImageSegmentationPredictionParams {
        /**
         * When the model predicts category of pixels of the image, it will only provide predictions for pixels that it is at least this much confident about. All other pixels will be classified as background. Default value is 0.5.
         */
        confidenceThreshold?: number | null;
    }
    /**
     * Prediction model parameters for Video Action Recognition.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsVideoActionRecognitionPredictionParams {
        /**
         * The Model only returns predictions with at least this confidence score. Default value is 0.0
         */
        confidenceThreshold?: number | null;
        /**
         * The model only returns up to that many top, by confidence score, predictions per frame of the video. If this number is very high, the Model may return fewer predictions per frame. Default value is 50.
         */
        maxPredictions?: number | null;
    }
    /**
     * Prediction model parameters for Video Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsVideoClassificationPredictionParams {
        /**
         * The Model only returns predictions with at least this confidence score. Default value is 0.0
         */
        confidenceThreshold?: number | null;
        /**
         * The Model only returns up to that many top, by confidence score, predictions per instance. If this number is very high, the Model may return fewer predictions. Default value is 10,000.
         */
        maxPredictions?: number | null;
        /**
         * Set to true to request classification for a video at one-second intervals. Vertex AI returns labels and their confidence scores for each second of the entire time segment of the video that user specified in the input WARNING: Model evaluation is not done for this classification type, the quality of it depends on the training data, but there are no metrics provided to describe that quality. Default value is false
         */
        oneSecIntervalClassification?: boolean | null;
        /**
         * Set to true to request segment-level classification. Vertex AI returns labels and their confidence scores for the entire time segment of the video that user specified in the input instance. Default value is true
         */
        segmentClassification?: boolean | null;
        /**
         * Set to true to request shot-level classification. Vertex AI determines the boundaries for each camera shot in the entire time segment of the video that user specified in the input instance. Vertex AI then returns labels and their confidence scores for each detected shot, along with the start and end time of the shot. WARNING: Model evaluation is not done for this classification type, the quality of it depends on the training data, but there are no metrics provided to describe that quality. Default value is false
         */
        shotClassification?: boolean | null;
    }
    /**
     * Prediction model parameters for Video Object Tracking.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictParamsVideoObjectTrackingPredictionParams {
        /**
         * The Model only returns predictions with at least this confidence score. Default value is 0.0
         */
        confidenceThreshold?: number | null;
        /**
         * The model only returns up to that many top, by confidence score, predictions per frame of the video. If this number is very high, the Model may return fewer predictions per frame. Default value is 50.
         */
        maxPredictions?: number | null;
        /**
         * Only bounding boxes with shortest edge at least that long as a relative value of video frame size are returned. Default value is 0.0.
         */
        minBoundingBoxSize?: number | null;
    }
    /**
     * Prediction output format for Image and Text Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionClassificationPredictionResult {
        /**
         * The Model's confidences in correctness of the predicted IDs, higher value means higher confidence. Order matches the Ids.
         */
        confidences?: number[] | null;
        /**
         * The display names of the AnnotationSpecs that had been identified, order matches the IDs.
         */
        displayNames?: string[] | null;
        /**
         * The resource IDs of the AnnotationSpecs that had been identified.
         */
        ids?: string[] | null;
    }
    /**
     * Prediction output format for Image Object Detection.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionImageObjectDetectionPredictionResult {
        /**
         * Bounding boxes, i.e. the rectangles over the image, that pinpoint the found AnnotationSpecs. Given in order that matches the IDs. Each bounding box is an array of 4 numbers `xMin`, `xMax`, `yMin`, and `yMax`, which represent the extremal coordinates of the box. They are relative to the image size, and the point 0,0 is in the top left of the image.
         */
        bboxes?: any[][] | null;
        /**
         * The Model's confidences in correctness of the predicted IDs, higher value means higher confidence. Order matches the Ids.
         */
        confidences?: number[] | null;
        /**
         * The display names of the AnnotationSpecs that had been identified, order matches the IDs.
         */
        displayNames?: string[] | null;
        /**
         * The resource IDs of the AnnotationSpecs that had been identified, ordered by the confidence score descendingly.
         */
        ids?: string[] | null;
    }
    /**
     * Prediction output format for Image Segmentation.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionImageSegmentationPredictionResult {
        /**
         * A PNG image where each pixel in the mask represents the category in which the pixel in the original image was predicted to belong to. The size of this image will be the same as the original image. The mapping between the AnntoationSpec and the color can be found in model's metadata. The model will choose the most likely category and if none of the categories reach the confidence threshold, the pixel will be marked as background.
         */
        categoryMask?: string | null;
        /**
         * A one channel image which is encoded as an 8bit lossless PNG. The size of the image will be the same as the original image. For a specific pixel, darker color means less confidence in correctness of the cateogry in the categoryMask for the corresponding pixel. Black means no confidence and white means complete confidence.
         */
        confidenceMask?: string | null;
    }
    /**
     * Prediction output format for Tabular Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionTabularClassificationPredictionResult {
        /**
         * The name of the classes being classified, contains all possible values of the target column.
         */
        classes?: string[] | null;
        /**
         * The model's confidence in each class being correct, higher value means higher confidence. The N-th score corresponds to the N-th class in classes.
         */
        scores?: number[] | null;
    }
    /**
     * Prediction output format for Tabular Regression.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionTabularRegressionPredictionResult {
        /**
         * The lower bound of the prediction interval.
         */
        lowerBound?: number | null;
        /**
         * Quantile predictions, in 1-1 correspondence with quantile_values.
         */
        quantilePredictions?: number[] | null;
        /**
         * Quantile values.
         */
        quantileValues?: number[] | null;
        /**
         * The upper bound of the prediction interval.
         */
        upperBound?: number | null;
        /**
         * The regression value.
         */
        value?: number | null;
    }
    /**
     * Prediction output format for Text Extraction.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionTextExtractionPredictionResult {
        /**
         * The Model's confidences in correctness of the predicted IDs, higher value means higher confidence. Order matches the Ids.
         */
        confidences?: number[] | null;
        /**
         * The display names of the AnnotationSpecs that had been identified, order matches the IDs.
         */
        displayNames?: string[] | null;
        /**
         * The resource IDs of the AnnotationSpecs that had been identified, ordered by the confidence score descendingly.
         */
        ids?: string[] | null;
        /**
         * The end offsets, inclusive, of the text segment in which the AnnotationSpec has been identified. Expressed as a zero-based number of characters as measured from the start of the text snippet.
         */
        textSegmentEndOffsets?: string[] | null;
        /**
         * The start offsets, inclusive, of the text segment in which the AnnotationSpec has been identified. Expressed as a zero-based number of characters as measured from the start of the text snippet.
         */
        textSegmentStartOffsets?: string[] | null;
    }
    /**
     * Prediction output format for Text Sentiment
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionTextSentimentPredictionResult {
        /**
         * The integer sentiment labels between 0 (inclusive) and sentimentMax label (inclusive), while 0 maps to the least positive sentiment and sentimentMax maps to the most positive one. The higher the score is, the more positive the sentiment in the text snippet is. Note: sentimentMax is an integer value between 1 (inclusive) and 10 (inclusive).
         */
        sentiment?: number | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionTftFeatureImportance {
        attributeColumns?: string[] | null;
        attributeWeights?: number[] | null;
        contextColumns?: string[] | null;
        /**
         * TFT feature importance values. Each pair for {context/horizon/attribute\} should have the same shape since the weight corresponds to the column names.
         */
        contextWeights?: number[] | null;
        horizonColumns?: string[] | null;
        horizonWeights?: number[] | null;
    }
    /**
     * Prediction output format for Time Series Forecasting.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionTimeSeriesForecastingPredictionResult {
        /**
         * Quantile predictions, in 1-1 correspondence with quantile_values.
         */
        quantilePredictions?: number[] | null;
        /**
         * Quantile values.
         */
        quantileValues?: number[] | null;
        /**
         * Only use these if TFt is enabled.
         */
        tftFeatureImportance?: Schema$GoogleCloudAiplatformV1SchemaPredictPredictionTftFeatureImportance;
        /**
         * The regression value.
         */
        value?: number | null;
    }
    /**
     * Prediction output format for Video Action Recognition.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionVideoActionRecognitionPredictionResult {
        /**
         * The Model's confidence in correction of this prediction, higher value means higher confidence.
         */
        confidence?: number | null;
        /**
         * The display name of the AnnotationSpec that had been identified.
         */
        displayName?: string | null;
        /**
         * The resource ID of the AnnotationSpec that had been identified.
         */
        id?: string | null;
        /**
         * The end, exclusive, of the video's time segment in which the AnnotationSpec has been identified. Expressed as a number of seconds as measured from the start of the video, with fractions up to a microsecond precision, and with "s" appended at the end.
         */
        timeSegmentEnd?: string | null;
        /**
         * The beginning, inclusive, of the video's time segment in which the AnnotationSpec has been identified. Expressed as a number of seconds as measured from the start of the video, with fractions up to a microsecond precision, and with "s" appended at the end.
         */
        timeSegmentStart?: string | null;
    }
    /**
     * Prediction output format for Video Classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionVideoClassificationPredictionResult {
        /**
         * The Model's confidence in correction of this prediction, higher value means higher confidence.
         */
        confidence?: number | null;
        /**
         * The display name of the AnnotationSpec that had been identified.
         */
        displayName?: string | null;
        /**
         * The resource ID of the AnnotationSpec that had been identified.
         */
        id?: string | null;
        /**
         * The end, exclusive, of the video's time segment in which the AnnotationSpec has been identified. Expressed as a number of seconds as measured from the start of the video, with fractions up to a microsecond precision, and with "s" appended at the end. Note that for 'segment-classification' prediction type, this equals the original 'timeSegmentEnd' from the input instance, for other types it is the end of a shot or a 1 second interval respectively.
         */
        timeSegmentEnd?: string | null;
        /**
         * The beginning, inclusive, of the video's time segment in which the AnnotationSpec has been identified. Expressed as a number of seconds as measured from the start of the video, with fractions up to a microsecond precision, and with "s" appended at the end. Note that for 'segment-classification' prediction type, this equals the original 'timeSegmentStart' from the input instance, for other types it is the start of a shot or a 1 second interval respectively.
         */
        timeSegmentStart?: string | null;
        /**
         * The type of the prediction. The requested types can be configured via parameters. This will be one of - segment-classification - shot-classification - one-sec-interval-classification
         */
        type?: string | null;
    }
    /**
     * Prediction output format for Video Object Tracking.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionVideoObjectTrackingPredictionResult {
        /**
         * The Model's confidence in correction of this prediction, higher value means higher confidence.
         */
        confidence?: number | null;
        /**
         * The display name of the AnnotationSpec that had been identified.
         */
        displayName?: string | null;
        /**
         * All of the frames of the video in which a single object instance has been detected. The bounding boxes in the frames identify the same object.
         */
        frames?: Schema$GoogleCloudAiplatformV1SchemaPredictPredictionVideoObjectTrackingPredictionResultFrame[];
        /**
         * The resource ID of the AnnotationSpec that had been identified.
         */
        id?: string | null;
        /**
         * The end, inclusive, of the video's time segment in which the object instance has been detected. Expressed as a number of seconds as measured from the start of the video, with fractions up to a microsecond precision, and with "s" appended at the end.
         */
        timeSegmentEnd?: string | null;
        /**
         * The beginning, inclusive, of the video's time segment in which the object instance has been detected. Expressed as a number of seconds as measured from the start of the video, with fractions up to a microsecond precision, and with "s" appended at the end.
         */
        timeSegmentStart?: string | null;
    }
    /**
     * The fields `xMin`, `xMax`, `yMin`, and `yMax` refer to a bounding box, i.e. the rectangle over the video frame pinpointing the found AnnotationSpec. The coordinates are relative to the frame size, and the point 0,0 is in the top left of the frame.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPredictPredictionVideoObjectTrackingPredictionResultFrame {
        /**
         * A time (frame) of a video in which the object has been detected. Expressed as a number of seconds as measured from the start of the video, with fractions up to a microsecond precision, and with "s" appended at the end.
         */
        timeOffset?: string | null;
        /**
         * The rightmost coordinate of the bounding box.
         */
        xMax?: number | null;
        /**
         * The leftmost coordinate of the bounding box.
         */
        xMin?: number | null;
        /**
         * The bottommost coordinate of the bounding box.
         */
        yMax?: number | null;
        /**
         * The topmost coordinate of the bounding box.
         */
        yMin?: number | null;
    }
    /**
     * The A2 schema of a prompt.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptApiSchema {
        /**
         * The Schema version that represents changes to the API behavior.
         */
        apiSchemaVersion?: string | null;
        /**
         * A list of execution instances for constructing a ready-to-use prompt.
         */
        executions?: Schema$GoogleCloudAiplatformV1SchemaPromptInstancePromptExecution[];
        /**
         * Multimodal prompt which embeds preambles to prompt string.
         */
        multimodalPrompt?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecMultimodalPrompt;
        /**
         * The prompt variation that stores preambles in separate fields.
         */
        structuredPrompt?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecStructuredPrompt;
        /**
         * The prompt variation for Translation use case.
         */
        translationPrompt?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationPrompt;
    }
    /**
     * A prompt instance's parameters set that contains a set of variable values.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptInstancePromptExecution {
        /**
         * Maps variable names to their value.
         */
        arguments?: {
            [key: string]: Schema$GoogleCloudAiplatformV1SchemaPromptInstanceVariableValue;
        } | null;
    }
    /**
     * The value of a variable in prompt.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptInstanceVariableValue {
        /**
         * The parts of the variable value.
         */
        partList?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecPartList;
    }
    /**
     * Prompt variation that embeds preambles to prompt string.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecMultimodalPrompt {
        /**
         * The prompt message.
         */
        promptMessage?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecPromptMessage;
    }
    /**
     * A list of elements and information that make up a portion of prompt.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecPartList {
        /**
         * A list of elements that can be part of a prompt.
         */
        parts?: Schema$GoogleCloudAiplatformV1Part[];
    }
    /**
     * The prompt message that aligns with the prompt message in google.cloud.aiplatform.master.GenerateContentRequest.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecPromptMessage {
        /**
         * The content of the current conversation with the model. For single-turn queries, this is a single instance. For multi-turn queries, this is a repeated field that contains conversation history + latest request.
         */
        contents?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Generation config.
         */
        generationConfig?: Schema$GoogleCloudAiplatformV1GenerationConfig;
        /**
         * The model name.
         */
        model?: string | null;
        /**
         * Per request settings for blocking unsafe content. Enforced on GenerateContentResponse.candidates.
         */
        safetySettings?: Schema$GoogleCloudAiplatformV1SafetySetting[];
        /**
         * The user provided system instructions for the model. Note: only text should be used in parts and content in each part will be in a separate paragraph.
         */
        systemInstruction?: Schema$GoogleCloudAiplatformV1Content;
        /**
         * Tool config. This config is shared for all tools provided in the request.
         */
        toolConfig?: Schema$GoogleCloudAiplatformV1ToolConfig;
        /**
         * A list of `Tools` the model may use to generate the next response. A `Tool` is a piece of code that enables the system to interact with external systems to perform an action, or set of actions, outside of knowledge and scope of the model.
         */
        tools?: Schema$GoogleCloudAiplatformV1Tool[];
    }
    /**
     * A pair of sentences used as reference in source and target languages.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecReferenceSentencePair {
        /**
         * Source sentence in the sentence pair.
         */
        sourceSentence?: string | null;
        /**
         * Target sentence in the sentence pair.
         */
        targetSentence?: string | null;
    }
    /**
     * A list of reference sentence pairs.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecReferenceSentencePairList {
        /**
         * Reference sentence pairs.
         */
        referenceSentencePairs?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecReferenceSentencePair[];
    }
    /**
     * Prompt variation that stores preambles in separate fields.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecStructuredPrompt {
        /**
         * Preamble: The context of the prompt.
         */
        context?: Schema$GoogleCloudAiplatformV1Content;
        /**
         * Preamble: A set of examples for expected model response.
         */
        examples?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecPartList[];
        /**
         * Preamble: For infill prompt, the prefix before expected model response.
         */
        infillPrefix?: string | null;
        /**
         * Preamble: For infill prompt, the suffix after expected model response.
         */
        infillSuffix?: string | null;
        /**
         * Preamble: The input prefixes before each example input.
         */
        inputPrefixes?: string[] | null;
        /**
         * Preamble: The output prefixes before each example output.
         */
        outputPrefixes?: string[] | null;
        /**
         * Preamble: The input test data for prediction. Each PartList in this field represents one text-only input set for a single model request.
         */
        predictionInputs?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecPartList[];
        /**
         * The prompt message.
         */
        promptMessage?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecPromptMessage;
    }
    /**
     * The translation example that contains reference sentences from various sources.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationExample {
        /**
         * The reference sentences from inline text.
         */
        referenceSentencePairLists?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecReferenceSentencePairList[];
        /**
         * The reference sentences from file.
         */
        referenceSentencesFileInputs?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationSentenceFileInput[];
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationFileInputSource {
        /**
         * The file's contents.
         */
        content?: string | null;
        /**
         * The file's display name.
         */
        displayName?: string | null;
        /**
         * The file's mime type.
         */
        mimeType?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationGcsInputSource {
        /**
         * Source data URI. For example, `gs://my_bucket/my_object`.
         */
        inputUri?: string | null;
    }
    /**
     * Optional settings for translation prompt.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationOption {
        /**
         * How many shots to use.
         */
        numberOfShots?: number | null;
    }
    /**
     * Prompt variation for Translation use case.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationPrompt {
        /**
         * The translation example.
         */
        example?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationExample;
        /**
         * The translation option.
         */
        option?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationOption;
        /**
         * The prompt message.
         */
        promptMessage?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecPromptMessage;
        /**
         * The source language code.
         */
        sourceLanguageCode?: string | null;
        /**
         * The target language code.
         */
        targetLanguageCode?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationSentenceFileInput {
        /**
         * Inlined file source.
         */
        fileInputSource?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationFileInputSource;
        /**
         * Cloud Storage file source.
         */
        gcsInputSource?: Schema$GoogleCloudAiplatformV1SchemaPromptSpecTranslationGcsInputSource;
    }
    /**
     * The metadata of Datasets that contain tables data.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTablesDatasetMetadata {
        inputConfig?: Schema$GoogleCloudAiplatformV1SchemaTablesDatasetMetadataInputConfig;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTablesDatasetMetadataBigQuerySource {
        /**
         * The URI of a BigQuery table. e.g. bq://projectId.bqDatasetId.bqTableId
         */
        uri?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTablesDatasetMetadataGcsSource {
        /**
         * Cloud Storage URI of one or more files. Only CSV files are supported. The first line of the CSV file is used as the header. If there are multiple files, the header is the first line of the lexicographically first file, the other files must either contain the exact same header or omit the header.
         */
        uri?: string[] | null;
    }
    /**
     * The tables Dataset's data source. The Dataset doesn't store the data directly, but only pointer(s) to its data.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTablesDatasetMetadataInputConfig {
        bigquerySource?: Schema$GoogleCloudAiplatformV1SchemaTablesDatasetMetadataBigQuerySource;
        gcsSource?: Schema$GoogleCloudAiplatformV1SchemaTablesDatasetMetadataGcsSource;
    }
    /**
     * Annotation details specific to text classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextClassificationAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
    }
    /**
     * Payload of Text DataItem.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextDataItem {
        /**
         * Output only. Google Cloud Storage URI points to a copy of the original text in the Vertex-managed bucket in the user's project. The text file is up to 10MB in size.
         */
        gcsUri?: string | null;
    }
    /**
     * The metadata of Datasets that contain Text DataItems.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextDatasetMetadata {
        /**
         * Points to a YAML file stored on Google Cloud Storage describing payload of the Text DataItems that belong to this Dataset.
         */
        dataItemSchemaUri?: string | null;
        /**
         * Google Cloud Storage Bucket name that contains the blob data of this Dataset.
         */
        gcsBucket?: string | null;
    }
    /**
     * Annotation details specific to text extraction.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextExtractionAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * The segment of the text content.
         */
        textSegment?: Schema$GoogleCloudAiplatformV1SchemaTextSegment;
    }
    /**
     * The metadata of Datasets that contain Text Prompt data.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextPromptDatasetMetadata {
        /**
         * Number of candidates.
         */
        candidateCount?: string | null;
        /**
         * The Google Cloud Storage URI that stores the prompt data.
         */
        gcsUri?: string | null;
        /**
         * Grounding checking configuration.
         */
        groundingConfig?: Schema$GoogleCloudAiplatformV1SchemaPredictParamsGroundingConfig;
        /**
         * Whether the prompt dataset has prompt variable.
         */
        hasPromptVariable?: boolean | null;
        /**
         * Whether or not the user has enabled logit probabilities in the model parameters.
         */
        logprobs?: boolean | null;
        /**
         * Value of the maximum number of tokens generated set when the dataset was saved.
         */
        maxOutputTokens?: string | null;
        /**
         * User-created prompt note. Note size limit is 2KB.
         */
        note?: string | null;
        /**
         * The API schema of the prompt to support both UI and SDK usages.
         */
        promptApiSchema?: Schema$GoogleCloudAiplatformV1SchemaPromptApiSchema;
        /**
         * Type of the prompt dataset.
         */
        promptType?: string | null;
        /**
         * Seeding enables model to return a deterministic response on a best effort basis. Determinism isn't guaranteed. This field determines whether or not seeding is enabled.
         */
        seedEnabled?: boolean | null;
        /**
         * The actual value of the seed.
         */
        seedValue?: string | null;
        /**
         * Customized stop sequences.
         */
        stopSequences?: string[] | null;
        /**
         * The content of the prompt dataset system instruction.
         */
        systemInstruction?: string | null;
        /**
         * The Google Cloud Storage URI that stores the system instruction, starting with gs://.
         */
        systemInstructionGcsUri?: string | null;
        /**
         * Temperature value used for sampling set when the dataset was saved. This value is used to tune the degree of randomness.
         */
        temperature?: number | null;
        /**
         * The content of the prompt dataset.
         */
        text?: string | null;
        /**
         * Top K value set when the dataset was saved. This value determines how many candidates with highest probability from the vocab would be selected for each decoding step.
         */
        topK?: string | null;
        /**
         * Top P value set when the dataset was saved. Given topK tokens for decoding, top candidates will be selected until the sum of their probabilities is topP.
         */
        topP?: number | null;
    }
    /**
     * The text segment inside of DataItem.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextSegment {
        /**
         * The text content in the segment for output only.
         */
        content?: string | null;
        /**
         * Zero-based character index of the first character past the end of the text segment (counting character from the beginning of the text). The character at the end_offset is NOT included in the text segment.
         */
        endOffset?: string | null;
        /**
         * Zero-based character index of the first character of the text segment (counting characters from the beginning of the text).
         */
        startOffset?: string | null;
    }
    /**
     * Annotation details specific to text sentiment.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextSentimentAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * The sentiment score for text.
         */
        sentiment?: number | null;
        /**
         * The sentiment max score for text.
         */
        sentimentMax?: number | null;
    }
    /**
     * The metadata of SavedQuery contains TextSentiment Annotations.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTextSentimentSavedQueryMetadata {
        /**
         * The maximum sentiment of sentiment Anntoation in this SavedQuery.
         */
        sentimentMax?: number | null;
    }
    /**
     * A time period inside of a DataItem that has a time dimension (e.g. video).
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTimeSegment {
        /**
         * End of the time segment (exclusive), represented as the duration since the start of the DataItem.
         */
        endTimeOffset?: string | null;
        /**
         * Start of the time segment (inclusive), represented as the duration since the start of the DataItem.
         */
        startTimeOffset?: string | null;
    }
    /**
     * The metadata of Datasets that contain time series data.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadata {
        inputConfig?: Schema$GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataInputConfig;
        /**
         * The column name of the time column that identifies time order in the time series.
         */
        timeColumn?: string | null;
        /**
         * The column name of the time series identifier column that identifies the time series.
         */
        timeSeriesIdentifierColumn?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataBigQuerySource {
        /**
         * The URI of a BigQuery table.
         */
        uri?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataGcsSource {
        /**
         * Cloud Storage URI of one or more files. Only CSV files are supported. The first line of the CSV file is used as the header. If there are multiple files, the header is the first line of the lexicographically first file, the other files must either contain the exact same header or omit the header.
         */
        uri?: string[] | null;
    }
    /**
     * The time series Dataset's data source. The Dataset doesn't store the data directly, but only pointer(s) to its data.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataInputConfig {
        bigquerySource?: Schema$GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataBigQuerySource;
        gcsSource?: Schema$GoogleCloudAiplatformV1SchemaTimeSeriesDatasetMetadataGcsSource;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Forecasting Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecasting {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputs;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingMetadata;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputs {
        /**
         * Additional experiment flags for the time series forcasting training.
         */
        additionalExperiments?: string[] | null;
        /**
         * Names of columns that are available and provided when a forecast is requested. These columns contain information for the given entity (identified by the time_series_identifier_column column) that is known at forecast. For example, predicted weather for a specific day.
         */
        availableAtForecastColumns?: string[] | null;
        /**
         * The amount of time into the past training and prediction data is used for model training and prediction respectively. Expressed in number of units defined by the `data_granularity` field.
         */
        contextWindow?: string | null;
        /**
         * Expected difference in time granularity between rows in the data.
         */
        dataGranularity?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsGranularity;
        /**
         * If probabilistic inference is enabled, the model will fit a distribution that captures the uncertainty of a prediction. At inference time, the predictive distribution is used to make a point prediction that minimizes the optimization objective. For example, the mean of a predictive distribution is the point prediction that minimizes RMSE loss. If quantiles are specified, then the quantiles of the distribution are also returned. The optimization objective cannot be minimize-quantile-loss.
         */
        enableProbabilisticInference?: boolean | null;
        /**
         * Configuration for exporting test set predictions to a BigQuery table. If this configuration is absent, then the export is not performed.
         */
        exportEvaluatedDataItemsConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig;
        /**
         * The amount of time into the future for which forecasted values for the target are returned. Expressed in number of units defined by the `data_granularity` field.
         */
        forecastHorizon?: string | null;
        /**
         * Configuration that defines the hierarchical relationship of time series and parameters for hierarchical forecasting strategies.
         */
        hierarchyConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHierarchyConfig;
        /**
         * The geographical region based on which the holiday effect is applied in modeling by adding holiday categorical array feature that include all holidays matching the date. This option only allowed when data_granularity is day. By default, holiday effect modeling is disabled. To turn it on, specify the holiday region using this option.
         */
        holidayRegions?: string[] | null;
        /**
         * Objective function the model is optimizing towards. The training process creates a model that optimizes the value of the objective function over the validation set. The supported optimization objectives: * "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE). * "minimize-mae" - Minimize mean-absolute error (MAE). * "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE). * "minimize-rmspe" - Minimize root-mean-squared percentage error (RMSPE). * "minimize-wape-mae" - Minimize the combination of weighted absolute percentage error (WAPE) and mean-absolute-error (MAE). * "minimize-quantile-loss" - Minimize the quantile loss at the quantiles defined in `quantiles`. * "minimize-mape" - Minimize the mean absolute percentage error.
         */
        optimizationObjective?: string | null;
        /**
         * Quantiles to use for minimize-quantile-loss `optimization_objective`, or for probabilistic inference. Up to 5 quantiles are allowed of values between 0 and 1, exclusive. Required if the value of optimization_objective is minimize-quantile-loss. Represents the percent quantiles to use for that objective. Quantiles must be unique.
         */
        quantiles?: number[] | null;
        /**
         * The name of the column that the Model is to predict values for. This column must be unavailable at forecast.
         */
        targetColumn?: string | null;
        /**
         * The name of the column that identifies time order in the time series. This column must be available at forecast.
         */
        timeColumn?: string | null;
        /**
         * Column names that should be used as attribute columns. The value of these columns does not vary as a function of time. For example, store ID or item color.
         */
        timeSeriesAttributeColumns?: string[] | null;
        /**
         * The name of the column that identifies the time series.
         */
        timeSeriesIdentifierColumn?: string | null;
        /**
         * Required. The train budget of creating this model, expressed in milli node hours i.e. 1,000 value in this field means 1 node hour. The training cost of the model will not exceed this budget. The final cost will be attempted to be close to the budget, though may end up being (even) noticeably smaller - at the backend's discretion. This especially may happen when further model training ceases to provide any improvements. If the budget is set to a value known to be insufficient to train a model for the given dataset, the training won't be attempted and will error. The train budget must be between 1,000 and 72,000 milli node hours, inclusive.
         */
        trainBudgetMilliNodeHours?: string | null;
        /**
         * Each transformation will apply transform function to given input column. And the result will be used for training. When creating transformation for BigQuery Struct column, the column should be flattened using "." as the delimiter.
         */
        transformations?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformation[];
        /**
         * Names of columns that are unavailable when a forecast is requested. This column contains information for the given entity (identified by the time_series_identifier_column) that is unknown before the forecast For example, actual weather on a given day.
         */
        unavailableAtForecastColumns?: string[] | null;
        /**
         * Validation options for the data validation component. The available options are: * "fail-pipeline" - default, will validate against the validation and fail the pipeline if it fails. * "ignore-validation" - ignore the results of the validation and continue
         */
        validationOptions?: string | null;
        /**
         * Column name that should be used as the weight column. Higher values in this column give more importance to the row during model training. The column must have numeric values between 0 and 10000 inclusively; 0 means the row is ignored for training. If weight column field is not set, then all rows are assumed to have equal weight of 1.
         */
        weightColumn?: string | null;
        /**
         * Config containing strategy for generating sliding windows.
         */
        windowConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionWindowConfig;
    }
    /**
     * A duration of time expressed in time granularity units.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsGranularity {
        /**
         * The number of granularity_units between data points in the training data. If `granularity_unit` is `minute`, can be 1, 5, 10, 15, or 30. For all other values of `granularity_unit`, must be 1.
         */
        quantity?: string | null;
        /**
         * The time granularity unit of this time period. The supported units are: * "minute" * "hour" * "day" * "week" * "month" * "year"
         */
        unit?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformation {
        auto?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationAutoTransformation;
        categorical?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalTransformation;
        numeric?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericTransformation;
        text?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextTransformation;
        timestamp?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTimestampTransformation;
    }
    /**
     * Training pipeline will infer the proper transformation based on the statistic of dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationAutoTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The categorical string as is--no change to case, punctuation, spelling, tense, and so on. * Convert the category name to a dictionary lookup index and generate an embedding for each index. * Categories that appear less than 5 times in the training dataset are treated as the "unknown" category. The "unknown" category gets its own special lookup index and resulting embedding.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationCategoricalTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The value converted to float32. * The z_score of the value. * log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value. * z_score of log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value. * A boolean value that indicates whether the value is valid.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationNumericTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The text as is--no change to case, punctuation, spelling, tense, and so on. * Convert the category name to a dictionary lookup index and generate an embedding for each index.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTextTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * Apply the transformation functions for Numerical columns. * Determine the year, month, day,and weekday. Treat each value from the timestamp as a Categorical column. * Invalid numerical values (for example, values that fall outside of a typical timestamp range, or are extreme values) receive no special treatment and are not removed.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingInputsTransformationTimestampTransformation {
        columnName?: string | null;
        /**
         * The format in which that time field is expressed. The time_format must either be one of: * `unix-seconds` * `unix-milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for respectively number of seconds, milliseconds, microseconds and nanoseconds since start of the Unix epoch); or be written in `strftime` syntax. If time_format is not set, then the default format is RFC 3339 `date-time` format, where `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z)
         */
        timeFormat?: string | null;
    }
    /**
     * Model metadata specific to AutoML Forecasting.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlForecastingMetadata {
        /**
         * BigQuery destination uri for exported evaluated examples.
         */
        evaluatedDataItemsBigqueryUri?: string | null;
        /**
         * Output only. The actual training cost of the model, expressed in milli node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed to not exceed the train budget.
         */
        trainCostMilliNodeHours?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Image Classification Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassification {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationInputs;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationMetadata;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationInputs {
        /**
         * The ID of the `base` model. If it is specified, the new model will be trained based on the `base` model. Otherwise, the new model will be trained from scratch. The `base` model must be in the same Project and Location as the new Model to train, and have the same modelType.
         */
        baseModelId?: string | null;
        /**
         * The training budget of creating this model, expressed in milli node hours i.e. 1,000 value in this field means 1 node hour. The actual metadata.costMilliNodeHours will be equal or less than this value. If further model training ceases to provide any improvements, it will stop without using the full budget and the metadata.successfulStopReason will be `model-converged`. Note, node_hour = actual_hour * number_of_nodes_involved. For modelType `cloud`(default), the budget must be between 8,000 and 800,000 milli node hours, inclusive. The default value is 192,000 which represents one day in wall time, considering 8 nodes are used. For model types `mobile-tf-low-latency-1`, `mobile-tf-versatile-1`, `mobile-tf-high-accuracy-1`, the training budget must be between 1,000 and 100,000 milli node hours, inclusive. The default value is 24,000 which represents one day in wall time on a single node that is used.
         */
        budgetMilliNodeHours?: string | null;
        /**
         * Use the entire training budget. This disables the early stopping feature. When false the early stopping feature is enabled, which means that AutoML Image Classification might stop training before the entire training budget has been used.
         */
        disableEarlyStopping?: boolean | null;
        modelType?: string | null;
        /**
         * If false, a single-label (multi-class) Model will be trained (i.e. assuming that for each image just up to one annotation may be applicable). If true, a multi-label Model will be trained (i.e. assuming that for each image multiple annotations may be applicable).
         */
        multiLabel?: boolean | null;
        /**
         * Trainer type for Vision TrainRequest.
         */
        tunableParameter?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutomlImageTrainingTunableParameter;
        /**
         * The ID of `base` model for upTraining. If it is specified, the new model will be upTrained based on the `base` model for upTraining. Otherwise, the new model will be trained from scratch. The `base` model for upTraining must be in the same Project and Location as the new Model to train, and have the same modelType.
         */
        uptrainBaseModelId?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageClassificationMetadata {
        /**
         * The actual training cost of creating this model, expressed in milli node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
         */
        costMilliNodeHours?: string | null;
        /**
         * For successful job completions, this is the reason why the job has finished.
         */
        successfulStopReason?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Image Object Detection Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetection {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionInputs;
        /**
         * The metadata information
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionMetadata;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionInputs {
        /**
         * The training budget of creating this model, expressed in milli node hours i.e. 1,000 value in this field means 1 node hour. The actual metadata.costMilliNodeHours will be equal or less than this value. If further model training ceases to provide any improvements, it will stop without using the full budget and the metadata.successfulStopReason will be `model-converged`. Note, node_hour = actual_hour * number_of_nodes_involved. For modelType `cloud`(default), the budget must be between 20,000 and 900,000 milli node hours, inclusive. The default value is 216,000 which represents one day in wall time, considering 9 nodes are used. For model types `mobile-tf-low-latency-1`, `mobile-tf-versatile-1`, `mobile-tf-high-accuracy-1` the training budget must be between 1,000 and 100,000 milli node hours, inclusive. The default value is 24,000 which represents one day in wall time on a single node that is used.
         */
        budgetMilliNodeHours?: string | null;
        /**
         * Use the entire training budget. This disables the early stopping feature. When false the early stopping feature is enabled, which means that AutoML Image Object Detection might stop training before the entire training budget has been used.
         */
        disableEarlyStopping?: boolean | null;
        modelType?: string | null;
        /**
         * Trainer type for Vision TrainRequest.
         */
        tunableParameter?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutomlImageTrainingTunableParameter;
        /**
         * The ID of `base` model for upTraining. If it is specified, the new model will be upTrained based on the `base` model for upTraining. Otherwise, the new model will be trained from scratch. The `base` model for upTraining must be in the same Project and Location as the new Model to train, and have the same modelType.
         */
        uptrainBaseModelId?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageObjectDetectionMetadata {
        /**
         * The actual training cost of creating this model, expressed in milli node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
         */
        costMilliNodeHours?: string | null;
        /**
         * For successful job completions, this is the reason why the job has finished.
         */
        successfulStopReason?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Image Segmentation Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentation {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationInputs;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationMetadata;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationInputs {
        /**
         * The ID of the `base` model. If it is specified, the new model will be trained based on the `base` model. Otherwise, the new model will be trained from scratch. The `base` model must be in the same Project and Location as the new Model to train, and have the same modelType.
         */
        baseModelId?: string | null;
        /**
         * The training budget of creating this model, expressed in milli node hours i.e. 1,000 value in this field means 1 node hour. The actual metadata.costMilliNodeHours will be equal or less than this value. If further model training ceases to provide any improvements, it will stop without using the full budget and the metadata.successfulStopReason will be `model-converged`. Note, node_hour = actual_hour * number_of_nodes_involved. Or actual_wall_clock_hours = train_budget_milli_node_hours / (number_of_nodes_involved * 1000) For modelType `cloud-high-accuracy-1`(default), the budget must be between 20,000 and 2,000,000 milli node hours, inclusive. The default value is 192,000 which represents one day in wall time (1000 milli * 24 hours * 8 nodes).
         */
        budgetMilliNodeHours?: string | null;
        modelType?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlImageSegmentationMetadata {
        /**
         * The actual training cost of creating this model, expressed in milli node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed to not exceed inputs.budgetMilliNodeHours.
         */
        costMilliNodeHours?: string | null;
        /**
         * For successful job completions, this is the reason why the job has finished.
         */
        successfulStopReason?: string | null;
    }
    /**
     * A wrapper class which contains the tunable parameters in an AutoML Image training job.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutomlImageTrainingTunableParameter {
        /**
         * Optional. An unique name of pretrained model checkpoint provided in model garden, it will be mapped to a GCS location internally.
         */
        checkpointName?: string | null;
        /**
         * Customizable dataset settings, used in the `model_garden_trainer`.
         */
        datasetConfig?: {
            [key: string]: string;
        } | null;
        /**
         * Optioinal. StudySpec of hyperparameter tuning job. Required for `model_garden_trainer`.
         */
        studySpec?: Schema$GoogleCloudAiplatformV1StudySpec;
        /**
         * Customizable trainer settings, used in the `model_garden_trainer`.
         */
        trainerConfig?: {
            [key: string]: string;
        } | null;
        trainerType?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Tables Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTables {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputs;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesMetadata;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputs {
        /**
         * Additional experiment flags for the Tables training pipeline.
         */
        additionalExperiments?: string[] | null;
        /**
         * Use the entire training budget. This disables the early stopping feature. By default, the early stopping feature is enabled, which means that AutoML Tables might stop training before the entire training budget has been used.
         */
        disableEarlyStopping?: boolean | null;
        /**
         * Configuration for exporting test set predictions to a BigQuery table. If this configuration is absent, then the export is not performed.
         */
        exportEvaluatedDataItemsConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig;
        /**
         * Objective function the model is optimizing towards. The training process creates a model that maximizes/minimizes the value of the objective function over the validation set. The supported optimization objectives depend on the prediction type. If the field is not set, a default objective function is used. classification (binary): "maximize-au-roc" (default) - Maximize the area under the receiver operating characteristic (ROC) curve. "minimize-log-loss" - Minimize log loss. "maximize-au-prc" - Maximize the area under the precision-recall curve. "maximize-precision-at-recall" - Maximize precision for a specified recall value. "maximize-recall-at-precision" - Maximize recall for a specified precision value. classification (multi-class): "minimize-log-loss" (default) - Minimize log loss. regression: "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE). "minimize-mae" - Minimize mean-absolute error (MAE). "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE).
         */
        optimizationObjective?: string | null;
        /**
         * Required when optimization_objective is "maximize-recall-at-precision". Must be between 0 and 1, inclusive.
         */
        optimizationObjectivePrecisionValue?: number | null;
        /**
         * Required when optimization_objective is "maximize-precision-at-recall". Must be between 0 and 1, inclusive.
         */
        optimizationObjectiveRecallValue?: number | null;
        /**
         * The type of prediction the Model is to produce. "classification" - Predict one out of multiple target values is picked for each row. "regression" - Predict a value based on its relation to other values. This type is available only to columns that contain semantically numeric values, i.e. integers or floating point number, even if stored as e.g. strings.
         */
        predictionType?: string | null;
        /**
         * The column name of the target column that the model is to predict.
         */
        targetColumn?: string | null;
        /**
         * Required. The train budget of creating this model, expressed in milli node hours i.e. 1,000 value in this field means 1 node hour. The training cost of the model will not exceed this budget. The final cost will be attempted to be close to the budget, though may end up being (even) noticeably smaller - at the backend's discretion. This especially may happen when further model training ceases to provide any improvements. If the budget is set to a value known to be insufficient to train a model for the given dataset, the training won't be attempted and will error. The train budget must be between 1,000 and 72,000 milli node hours, inclusive.
         */
        trainBudgetMilliNodeHours?: string | null;
        /**
         * Each transformation will apply transform function to given input column. And the result will be used for training. When creating transformation for BigQuery Struct column, the column should be flattened using "." as the delimiter.
         */
        transformations?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformation[];
        /**
         * Column name that should be used as the weight column. Higher values in this column give more importance to the row during model training. The column must have numeric values between 0 and 10000 inclusively; 0 means the row is ignored for training. If weight column field is not set, then all rows are assumed to have equal weight of 1.
         */
        weightColumnName?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformation {
        auto?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationAutoTransformation;
        categorical?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalTransformation;
        numeric?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericTransformation;
        repeatedCategorical?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalArrayTransformation;
        repeatedNumeric?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericArrayTransformation;
        repeatedText?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextArrayTransformation;
        text?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextTransformation;
        timestamp?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTimestampTransformation;
    }
    /**
     * Training pipeline will infer the proper transformation based on the statistic of dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationAutoTransformation {
        columnName?: string | null;
    }
    /**
     * Treats the column as categorical array and performs following transformation functions. * For each element in the array, convert the category name to a dictionary lookup index and generate an embedding for each index. Combine the embedding of all elements into a single embedding using the mean. * Empty arrays treated as an embedding of zeroes.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalArrayTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The categorical string as is--no change to case, punctuation, spelling, tense, and so on. * Convert the category name to a dictionary lookup index and generate an embedding for each index. * Categories that appear less than 5 times in the training dataset are treated as the "unknown" category. The "unknown" category gets its own special lookup index and resulting embedding.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationCategoricalTransformation {
        columnName?: string | null;
    }
    /**
     * Treats the column as numerical array and performs following transformation functions. * All transformations for Numerical types applied to the average of the all elements. * The average of empty arrays is treated as zero.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericArrayTransformation {
        columnName?: string | null;
        /**
         * If invalid values is allowed, the training pipeline will create a boolean feature that indicated whether the value is valid. Otherwise, the training pipeline will discard the input row from trainining data.
         */
        invalidValuesAllowed?: boolean | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The value converted to float32. * The z_score of the value. * log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value. * z_score of log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value. * A boolean value that indicates whether the value is valid.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationNumericTransformation {
        columnName?: string | null;
        /**
         * If invalid values is allowed, the training pipeline will create a boolean feature that indicated whether the value is valid. Otherwise, the training pipeline will discard the input row from trainining data.
         */
        invalidValuesAllowed?: boolean | null;
    }
    /**
     * Treats the column as text array and performs following transformation functions. * Concatenate all text values in the array into a single text value using a space (" ") as a delimiter, and then treat the result as a single text value. Apply the transformations for Text columns. * Empty arrays treated as an empty text.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextArrayTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The text as is--no change to case, punctuation, spelling, tense, and so on. * Tokenize text to words. Convert each words to a dictionary lookup index and generate an embedding for each index. Combine the embedding of all elements into a single embedding using the mean. * Tokenization is based on unicode script boundaries. * Missing values get their own lookup index and resulting embedding. * Stop-words receive no special treatment and are not removed.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTextTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * Apply the transformation functions for Numerical columns. * Determine the year, month, day,and weekday. Treat each value from the * timestamp as a Categorical column. * Invalid numerical values (for example, values that fall outside of a typical timestamp range, or are extreme values) receive no special treatment and are not removed.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesInputsTransformationTimestampTransformation {
        columnName?: string | null;
        /**
         * If invalid values is allowed, the training pipeline will create a boolean feature that indicated whether the value is valid. Otherwise, the training pipeline will discard the input row from trainining data.
         */
        invalidValuesAllowed?: boolean | null;
        /**
         * The format in which that time field is expressed. The time_format must either be one of: * `unix-seconds` * `unix-milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for respectively number of seconds, milliseconds, microseconds and nanoseconds since start of the Unix epoch); or be written in `strftime` syntax. If time_format is not set, then the default format is RFC 3339 `date-time` format, where `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z)
         */
        timeFormat?: string | null;
    }
    /**
     * Model metadata specific to AutoML Tables.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTablesMetadata {
        /**
         * BigQuery destination uri for exported evaluated examples.
         */
        evaluatedDataItemsBigqueryUri?: string | null;
        /**
         * Output only. The actual training cost of the model, expressed in milli node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed to not exceed the train budget.
         */
        trainCostMilliNodeHours?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Text Classification Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextClassification {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextClassificationInputs;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextClassificationInputs {
        multiLabel?: boolean | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Text Extraction Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextExtraction {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextExtractionInputs;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextExtractionInputs {
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Text Sentiment Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextSentiment {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextSentimentInputs;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlTextSentimentInputs {
        /**
         * A sentiment is expressed as an integer ordinal, where higher value means a more positive sentiment. The range of sentiments that will be used is between 0 and sentimentMax (inclusive on both ends), and all the values in the range must be represented in the dataset before a model can be created. Only the Annotations with this sentimentMax will be used for training. sentimentMax value must be between 1 and 10 (inclusive).
         */
        sentimentMax?: number | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Video Action Recognition Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoActionRecognition {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoActionRecognitionInputs;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoActionRecognitionInputs {
        modelType?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Video Classification Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoClassification {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoClassificationInputs;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoClassificationInputs {
        modelType?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Video ObjectTracking Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoObjectTracking {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoObjectTrackingInputs;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionAutoMlVideoObjectTrackingInputs {
        modelType?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionCustomJobMetadata {
        /**
         * The resource name of the CustomJob that has been created to carry out this custom task.
         */
        backingCustomJob?: string | null;
    }
    /**
     * A TrainingJob that trains a custom code Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionCustomTask {
        /**
         * The input parameters of this CustomTask.
         */
        inputs?: Schema$GoogleCloudAiplatformV1CustomJobSpec;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionCustomJobMetadata;
    }
    /**
     * Configuration for exporting test set predictions to a BigQuery table.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig {
        /**
         * URI of desired destination BigQuery table. Expected format: `bq://{project_id\}:{dataset_id\}:{table\}` If not specified, then results are exported to the following auto-created BigQuery table: `{project_id\}:export_evaluated_examples_{model_name\}_{yyyy_MM_dd'T'HH_mm_ss_SSS'Z'\}.evaluated_examples`
         */
        destinationBigqueryUri?: string | null;
        /**
         * If true and an export destination is specified, then the contents of the destination are overwritten. Otherwise, if the export destination already exists, then the export operation fails.
         */
        overrideExistingTable?: boolean | null;
    }
    /**
     * Configuration that defines the hierarchical relationship of time series and parameters for hierarchical forecasting strategies.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHierarchyConfig {
        /**
         * A list of time series attribute column names that define the time series hierarchy. Only one level of hierarchy is supported, ex. 'region' for a hierarchy of stores or 'department' for a hierarchy of products. If multiple columns are specified, time series will be grouped by their combined values, ex. ('blue', 'large') for 'color' and 'size', up to 5 columns are accepted. If no group columns are specified, all time series are considered to be part of the same group.
         */
        groupColumns?: string[] | null;
        /**
         * The weight of the loss for predictions aggregated over both the horizon and time series in the same hierarchy group.
         */
        groupTemporalTotalWeight?: number | null;
        /**
         * The weight of the loss for predictions aggregated over time series in the same group.
         */
        groupTotalWeight?: number | null;
        /**
         * The weight of the loss for predictions aggregated over the horizon for a single time series.
         */
        temporalTotalWeight?: number | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobMetadata {
        /**
         * The resource name of the HyperparameterTuningJob that has been created to carry out this HyperparameterTuning task.
         */
        backingHyperparameterTuningJob?: string | null;
        /**
         * The resource name of the CustomJob that has been created to run the best Trial of this HyperparameterTuning task.
         */
        bestTrialBackingCustomJob?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobSpec {
        /**
         * The number of failed Trials that need to be seen before failing the HyperparameterTuningJob. If set to 0, Vertex AI decides how many Trials must fail before the whole job fails.
         */
        maxFailedTrialCount?: number | null;
        /**
         * The desired total number of Trials.
         */
        maxTrialCount?: number | null;
        /**
         * The desired number of Trials to run in parallel.
         */
        parallelTrialCount?: number | null;
        /**
         * Study configuration of the HyperparameterTuningJob.
         */
        studySpec?: Schema$GoogleCloudAiplatformV1StudySpec;
        /**
         * The spec of a trial job. The same spec applies to the CustomJobs created in all the trials.
         */
        trialJobSpec?: Schema$GoogleCloudAiplatformV1CustomJobSpec;
    }
    /**
     * A TrainingJob that tunes Hypererparameters of a custom code Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningTask {
        /**
         * The input parameters of this HyperparameterTuningTask.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobSpec;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHyperparameterTuningJobMetadata;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Forecasting Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecasting {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputs;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingMetadata;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputs {
        /**
         * Additional experiment flags for the time series forcasting training.
         */
        additionalExperiments?: string[] | null;
        /**
         * Names of columns that are available and provided when a forecast is requested. These columns contain information for the given entity (identified by the time_series_identifier_column column) that is known at forecast. For example, predicted weather for a specific day.
         */
        availableAtForecastColumns?: string[] | null;
        /**
         * The amount of time into the past training and prediction data is used for model training and prediction respectively. Expressed in number of units defined by the `data_granularity` field.
         */
        contextWindow?: string | null;
        /**
         * Expected difference in time granularity between rows in the data.
         */
        dataGranularity?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsGranularity;
        /**
         * Configuration for exporting test set predictions to a BigQuery table. If this configuration is absent, then the export is not performed.
         */
        exportEvaluatedDataItemsConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig;
        /**
         * The amount of time into the future for which forecasted values for the target are returned. Expressed in number of units defined by the `data_granularity` field.
         */
        forecastHorizon?: string | null;
        /**
         * Configuration that defines the hierarchical relationship of time series and parameters for hierarchical forecasting strategies.
         */
        hierarchyConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHierarchyConfig;
        /**
         * The geographical region based on which the holiday effect is applied in modeling by adding holiday categorical array feature that include all holidays matching the date. This option only allowed when data_granularity is day. By default, holiday effect modeling is disabled. To turn it on, specify the holiday region using this option.
         */
        holidayRegions?: string[] | null;
        /**
         * Objective function the model is optimizing towards. The training process creates a model that optimizes the value of the objective function over the validation set. The supported optimization objectives: * "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE). * "minimize-mae" - Minimize mean-absolute error (MAE). * "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE). * "minimize-rmspe" - Minimize root-mean-squared percentage error (RMSPE). * "minimize-wape-mae" - Minimize the combination of weighted absolute percentage error (WAPE) and mean-absolute-error (MAE). * "minimize-quantile-loss" - Minimize the quantile loss at the quantiles defined in `quantiles`. * "minimize-mape" - Minimize the mean absolute percentage error.
         */
        optimizationObjective?: string | null;
        /**
         * Quantiles to use for minimize-quantile-loss `optimization_objective`. Up to 5 quantiles are allowed of values between 0 and 1, exclusive. Required if the value of optimization_objective is minimize-quantile-loss. Represents the percent quantiles to use for that objective. Quantiles must be unique.
         */
        quantiles?: number[] | null;
        /**
         * The name of the column that the Model is to predict values for. This column must be unavailable at forecast.
         */
        targetColumn?: string | null;
        /**
         * The name of the column that identifies time order in the time series. This column must be available at forecast.
         */
        timeColumn?: string | null;
        /**
         * Column names that should be used as attribute columns. The value of these columns does not vary as a function of time. For example, store ID or item color.
         */
        timeSeriesAttributeColumns?: string[] | null;
        /**
         * The name of the column that identifies the time series.
         */
        timeSeriesIdentifierColumn?: string | null;
        /**
         * Required. The train budget of creating this model, expressed in milli node hours i.e. 1,000 value in this field means 1 node hour. The training cost of the model will not exceed this budget. The final cost will be attempted to be close to the budget, though may end up being (even) noticeably smaller - at the backend's discretion. This especially may happen when further model training ceases to provide any improvements. If the budget is set to a value known to be insufficient to train a model for the given dataset, the training won't be attempted and will error. The train budget must be between 1,000 and 72,000 milli node hours, inclusive.
         */
        trainBudgetMilliNodeHours?: string | null;
        /**
         * Each transformation will apply transform function to given input column. And the result will be used for training. When creating transformation for BigQuery Struct column, the column should be flattened using "." as the delimiter.
         */
        transformations?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformation[];
        /**
         * Names of columns that are unavailable when a forecast is requested. This column contains information for the given entity (identified by the time_series_identifier_column) that is unknown before the forecast For example, actual weather on a given day.
         */
        unavailableAtForecastColumns?: string[] | null;
        /**
         * Validation options for the data validation component. The available options are: * "fail-pipeline" - default, will validate against the validation and fail the pipeline if it fails. * "ignore-validation" - ignore the results of the validation and continue
         */
        validationOptions?: string | null;
        /**
         * Column name that should be used as the weight column. Higher values in this column give more importance to the row during model training. The column must have numeric values between 0 and 10000 inclusively; 0 means the row is ignored for training. If weight column field is not set, then all rows are assumed to have equal weight of 1. This column must be available at forecast.
         */
        weightColumn?: string | null;
        /**
         * Config containing strategy for generating sliding windows.
         */
        windowConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionWindowConfig;
    }
    /**
     * A duration of time expressed in time granularity units.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsGranularity {
        /**
         * The number of granularity_units between data points in the training data. If `granularity_unit` is `minute`, can be 1, 5, 10, 15, or 30. For all other values of `granularity_unit`, must be 1.
         */
        quantity?: string | null;
        /**
         * The time granularity unit of this time period. The supported units are: * "minute" * "hour" * "day" * "week" * "month" * "year"
         */
        unit?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformation {
        auto?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationAutoTransformation;
        categorical?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationCategoricalTransformation;
        numeric?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationNumericTransformation;
        text?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTextTransformation;
        timestamp?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTimestampTransformation;
    }
    /**
     * Training pipeline will infer the proper transformation based on the statistic of dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationAutoTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The categorical string as is--no change to case, punctuation, spelling, tense, and so on. * Convert the category name to a dictionary lookup index and generate an embedding for each index. * Categories that appear less than 5 times in the training dataset are treated as the "unknown" category. The "unknown" category gets its own special lookup index and resulting embedding.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationCategoricalTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The value converted to float32. * The z_score of the value. * log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value. * z_score of log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationNumericTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The text as is--no change to case, punctuation, spelling, tense, and so on. * Convert the category name to a dictionary lookup index and generate an embedding for each index.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTextTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * Apply the transformation functions for Numerical columns. * Determine the year, month, day,and weekday. Treat each value from the timestamp as a Categorical column. * Invalid numerical values (for example, values that fall outside of a typical timestamp range, or are extreme values) receive no special treatment and are not removed.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingInputsTransformationTimestampTransformation {
        columnName?: string | null;
        /**
         * The format in which that time field is expressed. The time_format must either be one of: * `unix-seconds` * `unix-milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for respectively number of seconds, milliseconds, microseconds and nanoseconds since start of the Unix epoch); or be written in `strftime` syntax. If time_format is not set, then the default format is RFC 3339 `date-time` format, where `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z)
         */
        timeFormat?: string | null;
    }
    /**
     * Model metadata specific to Seq2Seq Plus Forecasting.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionSeq2SeqPlusForecastingMetadata {
        /**
         * BigQuery destination uri for exported evaluated examples.
         */
        evaluatedDataItemsBigqueryUri?: string | null;
        /**
         * Output only. The actual training cost of the model, expressed in milli node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed to not exceed the train budget.
         */
        trainCostMilliNodeHours?: string | null;
    }
    /**
     * A TrainingJob that trains and uploads an AutoML Forecasting Model.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecasting {
        /**
         * The input parameters of this TrainingJob.
         */
        inputs?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputs;
        /**
         * The metadata information.
         */
        metadata?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingMetadata;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputs {
        /**
         * Additional experiment flags for the time series forcasting training.
         */
        additionalExperiments?: string[] | null;
        /**
         * Names of columns that are available and provided when a forecast is requested. These columns contain information for the given entity (identified by the time_series_identifier_column column) that is known at forecast. For example, predicted weather for a specific day.
         */
        availableAtForecastColumns?: string[] | null;
        /**
         * The amount of time into the past training and prediction data is used for model training and prediction respectively. Expressed in number of units defined by the `data_granularity` field.
         */
        contextWindow?: string | null;
        /**
         * Expected difference in time granularity between rows in the data.
         */
        dataGranularity?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsGranularity;
        /**
         * Configuration for exporting test set predictions to a BigQuery table. If this configuration is absent, then the export is not performed.
         */
        exportEvaluatedDataItemsConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionExportEvaluatedDataItemsConfig;
        /**
         * The amount of time into the future for which forecasted values for the target are returned. Expressed in number of units defined by the `data_granularity` field.
         */
        forecastHorizon?: string | null;
        /**
         * Configuration that defines the hierarchical relationship of time series and parameters for hierarchical forecasting strategies.
         */
        hierarchyConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionHierarchyConfig;
        /**
         * The geographical region based on which the holiday effect is applied in modeling by adding holiday categorical array feature that include all holidays matching the date. This option only allowed when data_granularity is day. By default, holiday effect modeling is disabled. To turn it on, specify the holiday region using this option.
         */
        holidayRegions?: string[] | null;
        /**
         * Objective function the model is optimizing towards. The training process creates a model that optimizes the value of the objective function over the validation set. The supported optimization objectives: * "minimize-rmse" (default) - Minimize root-mean-squared error (RMSE). * "minimize-mae" - Minimize mean-absolute error (MAE). * "minimize-rmsle" - Minimize root-mean-squared log error (RMSLE). * "minimize-rmspe" - Minimize root-mean-squared percentage error (RMSPE). * "minimize-wape-mae" - Minimize the combination of weighted absolute percentage error (WAPE) and mean-absolute-error (MAE). * "minimize-quantile-loss" - Minimize the quantile loss at the quantiles defined in `quantiles`. * "minimize-mape" - Minimize the mean absolute percentage error.
         */
        optimizationObjective?: string | null;
        /**
         * Quantiles to use for minimize-quantile-loss `optimization_objective`. Up to 5 quantiles are allowed of values between 0 and 1, exclusive. Required if the value of optimization_objective is minimize-quantile-loss. Represents the percent quantiles to use for that objective. Quantiles must be unique.
         */
        quantiles?: number[] | null;
        /**
         * The name of the column that the Model is to predict values for. This column must be unavailable at forecast.
         */
        targetColumn?: string | null;
        /**
         * The name of the column that identifies time order in the time series. This column must be available at forecast.
         */
        timeColumn?: string | null;
        /**
         * Column names that should be used as attribute columns. The value of these columns does not vary as a function of time. For example, store ID or item color.
         */
        timeSeriesAttributeColumns?: string[] | null;
        /**
         * The name of the column that identifies the time series.
         */
        timeSeriesIdentifierColumn?: string | null;
        /**
         * Required. The train budget of creating this model, expressed in milli node hours i.e. 1,000 value in this field means 1 node hour. The training cost of the model will not exceed this budget. The final cost will be attempted to be close to the budget, though may end up being (even) noticeably smaller - at the backend's discretion. This especially may happen when further model training ceases to provide any improvements. If the budget is set to a value known to be insufficient to train a model for the given dataset, the training won't be attempted and will error. The train budget must be between 1,000 and 72,000 milli node hours, inclusive.
         */
        trainBudgetMilliNodeHours?: string | null;
        /**
         * Each transformation will apply transform function to given input column. And the result will be used for training. When creating transformation for BigQuery Struct column, the column should be flattened using "." as the delimiter.
         */
        transformations?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformation[];
        /**
         * Names of columns that are unavailable when a forecast is requested. This column contains information for the given entity (identified by the time_series_identifier_column) that is unknown before the forecast For example, actual weather on a given day.
         */
        unavailableAtForecastColumns?: string[] | null;
        /**
         * Validation options for the data validation component. The available options are: * "fail-pipeline" - default, will validate against the validation and fail the pipeline if it fails. * "ignore-validation" - ignore the results of the validation and continue
         */
        validationOptions?: string | null;
        /**
         * Column name that should be used as the weight column. Higher values in this column give more importance to the row during model training. The column must have numeric values between 0 and 10000 inclusively; 0 means the row is ignored for training. If weight column field is not set, then all rows are assumed to have equal weight of 1. This column must be available at forecast.
         */
        weightColumn?: string | null;
        /**
         * Config containing strategy for generating sliding windows.
         */
        windowConfig?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionWindowConfig;
    }
    /**
     * A duration of time expressed in time granularity units.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsGranularity {
        /**
         * The number of granularity_units between data points in the training data. If `granularity_unit` is `minute`, can be 1, 5, 10, 15, or 30. For all other values of `granularity_unit`, must be 1.
         */
        quantity?: string | null;
        /**
         * The time granularity unit of this time period. The supported units are: * "minute" * "hour" * "day" * "week" * "month" * "year"
         */
        unit?: string | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformation {
        auto?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationAutoTransformation;
        categorical?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationCategoricalTransformation;
        numeric?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationNumericTransformation;
        text?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationTextTransformation;
        timestamp?: Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationTimestampTransformation;
    }
    /**
     * Training pipeline will infer the proper transformation based on the statistic of dataset.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationAutoTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The categorical string as is--no change to case, punctuation, spelling, tense, and so on. * Convert the category name to a dictionary lookup index and generate an embedding for each index. * Categories that appear less than 5 times in the training dataset are treated as the "unknown" category. The "unknown" category gets its own special lookup index and resulting embedding.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationCategoricalTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The value converted to float32. * The z_score of the value. * log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value. * z_score of log(value+1) when the value is greater than or equal to 0. Otherwise, this transformation is not applied and the value is considered a missing value.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationNumericTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * The text as is--no change to case, punctuation, spelling, tense, and so on. * Convert the category name to a dictionary lookup index and generate an embedding for each index.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationTextTransformation {
        columnName?: string | null;
    }
    /**
     * Training pipeline will perform following transformation functions. * Apply the transformation functions for Numerical columns. * Determine the year, month, day,and weekday. Treat each value from the timestamp as a Categorical column. * Invalid numerical values (for example, values that fall outside of a typical timestamp range, or are extreme values) receive no special treatment and are not removed.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingInputsTransformationTimestampTransformation {
        columnName?: string | null;
        /**
         * The format in which that time field is expressed. The time_format must either be one of: * `unix-seconds` * `unix-milliseconds` * `unix-microseconds` * `unix-nanoseconds` (for respectively number of seconds, milliseconds, microseconds and nanoseconds since start of the Unix epoch); or be written in `strftime` syntax. If time_format is not set, then the default format is RFC 3339 `date-time` format, where `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z)
         */
        timeFormat?: string | null;
    }
    /**
     * Model metadata specific to TFT Forecasting.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionTftForecastingMetadata {
        /**
         * BigQuery destination uri for exported evaluated examples.
         */
        evaluatedDataItemsBigqueryUri?: string | null;
        /**
         * Output only. The actual training cost of the model, expressed in milli node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed to not exceed the train budget.
         */
        trainCostMilliNodeHours?: string | null;
    }
    /**
     * Config that contains the strategy used to generate sliding windows in time series training. A window is a series of rows that comprise the context up to the time of prediction, and the horizon following. The corresponding row for each window marks the start of the forecast horizon. Each window is used as an input example for training/evaluation.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaTrainingjobDefinitionWindowConfig {
        /**
         * Name of the column that should be used to generate sliding windows. The column should contain either booleans or string booleans; if the value of the row is True, generate a sliding window with the horizon starting at that row. The column will not be used as a feature in training.
         */
        column?: string | null;
        /**
         * Maximum number of windows that should be generated across all time series.
         */
        maxCount?: string | null;
        /**
         * Stride length used to generate input examples. Within one time series, every {$STRIDE_LENGTH\} rows will be used to generate a sliding window.
         */
        strideLength?: string | null;
    }
    /**
     * A vertex represents a 2D point in the image. NOTE: the normalized vertex coordinates are relative to the original image and range from 0 to 1.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaVertex {
        /**
         * X coordinate.
         */
        x?: number | null;
        /**
         * Y coordinate.
         */
        y?: number | null;
    }
    /**
     * Annotation details specific to video action recognition.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaVideoActionRecognitionAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * This Annotation applies to the time period represented by the TimeSegment. If it's not set, the Annotation applies to the whole video.
         */
        timeSegment?: Schema$GoogleCloudAiplatformV1SchemaTimeSegment;
    }
    /**
     * Annotation details specific to video classification.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaVideoClassificationAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * This Annotation applies to the time period represented by the TimeSegment. If it's not set, the Annotation applies to the whole video.
         */
        timeSegment?: Schema$GoogleCloudAiplatformV1SchemaTimeSegment;
    }
    /**
     * Payload of Video DataItem.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaVideoDataItem {
        /**
         * Required. Google Cloud Storage URI points to the original video in user's bucket. The video is up to 50 GB in size and up to 3 hour in duration.
         */
        gcsUri?: string | null;
        /**
         * Output only. The mime type of the content of the video. Only the videos in below listed mime types are supported. Supported mime_type: - video/mp4 - video/avi - video/quicktime
         */
        mimeType?: string | null;
    }
    /**
     * The metadata of Datasets that contain Video DataItems.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaVideoDatasetMetadata {
        /**
         * Points to a YAML file stored on Google Cloud Storage describing payload of the Video DataItems that belong to this Dataset.
         */
        dataItemSchemaUri?: string | null;
        /**
         * Google Cloud Storage Bucket name that contains the blob data of this Dataset.
         */
        gcsBucket?: string | null;
    }
    /**
     * Annotation details specific to video object tracking.
     */
    export interface Schema$GoogleCloudAiplatformV1SchemaVideoObjectTrackingAnnotation {
        /**
         * The resource Id of the AnnotationSpec that this Annotation pertains to.
         */
        annotationSpecId?: string | null;
        /**
         * The display name of the AnnotationSpec that this Annotation pertains to.
         */
        displayName?: string | null;
        /**
         * The instance of the object, expressed as a positive integer. Used to track the same object across different frames.
         */
        instanceId?: string | null;
        /**
         * A time (frame) of a video to which this annotation pertains. Represented as the duration since the video's start.
         */
        timeOffset?: string | null;
        /**
         * The rightmost coordinate of the bounding box.
         */
        xMax?: number | null;
        /**
         * The leftmost coordinate of the bounding box.
         */
        xMin?: number | null;
        /**
         * The bottommost coordinate of the bounding box.
         */
        yMax?: number | null;
        /**
         * The topmost coordinate of the bounding box.
         */
        yMin?: number | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaVisualInspectionClassificationLabelSavedQueryMetadata {
        /**
         * Whether or not the classification label is multi_label.
         */
        multiLabel?: boolean | null;
    }
    export interface Schema$GoogleCloudAiplatformV1SchemaVisualInspectionMaskSavedQueryMetadata {
    }
    /**
     * Response message for DatasetService.SearchDataItems.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchDataItemsResponse {
        /**
         * The DataItemViews read.
         */
        dataItemViews?: Schema$GoogleCloudAiplatformV1DataItemView[];
        /**
         * A token to retrieve next page of results. Pass to SearchDataItemsRequest.page_token to obtain that page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Google search entry point.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchEntryPoint {
        /**
         * Optional. Web content snippet that can be embedded in a web page or an app webview.
         */
        renderedContent?: string | null;
        /**
         * Optional. Base64 encoded JSON representing array of tuple.
         */
        sdkBlob?: string | null;
    }
    /**
     * Response message for FeaturestoreService.SearchFeatures.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchFeaturesResponse {
        /**
         * The Features matching the request. Fields returned: * `name` * `description` * `labels` * `create_time` * `update_time`
         */
        features?: Schema$GoogleCloudAiplatformV1Feature[];
        /**
         * A token, which can be sent as SearchFeaturesRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Request message for MigrationService.SearchMigratableResources.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchMigratableResourcesRequest {
        /**
         * A filter for your search. You can use the following types of filters: * Resource type filters. The following strings filter for a specific type of MigratableResource: * `ml_engine_model_version:*` * `automl_model:*` * `automl_dataset:*` * `data_labeling_dataset:*` * "Migrated or not" filters. The following strings filter for resources that either have or have not already been migrated: * `last_migrate_time:*` filters for migrated resources. * `NOT last_migrate_time:*` filters for not yet migrated resources.
         */
        filter?: string | null;
        /**
         * The standard page size. The default and maximum value is 100.
         */
        pageSize?: number | null;
        /**
         * The standard page token.
         */
        pageToken?: string | null;
    }
    /**
     * Response message for MigrationService.SearchMigratableResources.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchMigratableResourcesResponse {
        /**
         * All migratable resources that can be migrated to the location specified in the request.
         */
        migratableResources?: Schema$GoogleCloudAiplatformV1MigratableResource[];
        /**
         * The standard next-page token. The migratable_resources may not fill page_size in SearchMigratableResourcesRequest even when there are subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Request message for JobService.SearchModelDeploymentMonitoringStatsAnomalies.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequest {
        /**
         * Required. The DeployedModel ID of the [ModelDeploymentMonitoringObjectiveConfig.deployed_model_id].
         */
        deployedModelId?: string | null;
        /**
         * The latest timestamp of stats being generated. If not set, indicates feching stats till the latest possible one.
         */
        endTime?: string | null;
        /**
         * The feature display name. If specified, only return the stats belonging to this feature. Format: ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.feature_display_name, example: "user_destination".
         */
        featureDisplayName?: string | null;
        /**
         * Required. Objectives of the stats to retrieve.
         */
        objectives?: Schema$GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequestStatsAnomaliesObjective[];
        /**
         * The standard list page size.
         */
        pageSize?: number | null;
        /**
         * A page token received from a previous JobService.SearchModelDeploymentMonitoringStatsAnomalies call.
         */
        pageToken?: string | null;
        /**
         * The earliest timestamp of stats being generated. If not set, indicates fetching stats till the earliest possible one.
         */
        startTime?: string | null;
    }
    /**
     * Stats requested for specific objective.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequestStatsAnomaliesObjective {
        /**
         * If set, all attribution scores between SearchModelDeploymentMonitoringStatsAnomaliesRequest.start_time and SearchModelDeploymentMonitoringStatsAnomaliesRequest.end_time are fetched, and page token doesn't take effect in this case. Only used to retrieve attribution score for the top Features which has the highest attribution score in the latest monitoring run.
         */
        topFeatureCount?: number | null;
        type?: string | null;
    }
    /**
     * Response message for JobService.SearchModelDeploymentMonitoringStatsAnomalies.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesResponse {
        /**
         * Stats retrieved for requested objectives. There are at most 1000 ModelMonitoringStatsAnomalies.FeatureHistoricStatsAnomalies.prediction_stats in the response.
         */
        monitoringStats?: Schema$GoogleCloudAiplatformV1ModelMonitoringStatsAnomalies[];
        /**
         * The page token that can be used by the next JobService.SearchModelDeploymentMonitoringStatsAnomalies call.
         */
        nextPageToken?: string | null;
    }
    /**
     * The request message for FeatureOnlineStoreService.SearchNearestEntities.
     */
    export interface Schema$GoogleCloudAiplatformV1SearchNearestEntitiesRequest {
        /**
         * Required. The query.
         */
        query?: Schema$GoogleCloudAiplatformV1NearestNeighborQuery;
        /**
         * Optional. If set to true, the full entities (including all vector values and metadata) of the nearest neighbors are returned; otherwise only entity id of the nearest neighbors will be returned. Note that returning full entities will significantly increase the latency and cost of the query.
         */
        returnFullEntity?: boolean | null;
    }
    /**
     * Response message for FeatureOnlineStoreService.SearchNearestEntities
     */
    export interface Schema$GoogleCloudAiplatformV1SearchNearestEntitiesResponse {
        /**
         * The nearest neighbors of the query entity.
         */
        nearestNeighbors?: Schema$GoogleCloudAiplatformV1NearestNeighbors;
    }
    /**
     * Represents an environment variable where the value is a secret in Cloud Secret Manager.
     */
    export interface Schema$GoogleCloudAiplatformV1SecretEnvVar {
        /**
         * Required. Name of the secret environment variable.
         */
        name?: string | null;
        /**
         * Required. Reference to a secret stored in the Cloud Secret Manager that will provide the value for this environment variable.
         */
        secretRef?: Schema$GoogleCloudAiplatformV1SecretRef;
    }
    /**
     * Reference to a secret stored in the Cloud Secret Manager that will provide the value for this environment variable.
     */
    export interface Schema$GoogleCloudAiplatformV1SecretRef {
        /**
         * Required. The name of the secret in Cloud Secret Manager. Format: {secret_name\}.
         */
        secret?: string | null;
        /**
         * The Cloud Secret Manager secret version. Can be 'latest' for the latest version, an integer for a specific version, or a version alias.
         */
        version?: string | null;
    }
    /**
     * Segment of the content.
     */
    export interface Schema$GoogleCloudAiplatformV1Segment {
        /**
         * Output only. End index in the given Part, measured in bytes. Offset from the start of the Part, exclusive, starting at zero.
         */
        endIndex?: number | null;
        /**
         * Output only. The index of a Part object within its parent Content object.
         */
        partIndex?: number | null;
        /**
         * Output only. Start index in the given Part, measured in bytes. Offset from the start of the Part, inclusive, starting at zero.
         */
        startIndex?: number | null;
        /**
         * Output only. The text corresponding to the segment from the response.
         */
        text?: string | null;
    }
    /**
     * Configuration for the use of custom service account to run the workloads.
     */
    export interface Schema$GoogleCloudAiplatformV1ServiceAccountSpec {
        /**
         * Required. If true, custom user-managed service account is enforced to run any workloads (for example, Vertex Jobs) on the resource. Otherwise, uses the [Vertex AI Custom Code Service Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
         */
        enableCustomServiceAccount?: boolean | null;
        /**
         * Optional. Required when all below conditions are met * `enable_custom_service_account` is true; * any runtime is specified via `ResourceRuntimeSpec` on creation time, for example, Ray The users must have `iam.serviceAccounts.actAs` permission on this service account and then the specified runtime containers will run as it. Do not set this field if you want to submit jobs using custom service account to this PersistentResource after creation, but only specify the `service_account` inside the job.
         */
        serviceAccount?: string | null;
    }
    /**
     * The SharePointSources to pass to ImportRagFiles.
     */
    export interface Schema$GoogleCloudAiplatformV1SharePointSources {
        /**
         * The SharePoint sources.
         */
        sharePointSources?: Schema$GoogleCloudAiplatformV1SharePointSourcesSharePointSource[];
    }
    /**
     * An individual SharePointSource.
     */
    export interface Schema$GoogleCloudAiplatformV1SharePointSourcesSharePointSource {
        /**
         * The Application ID for the app registered in Microsoft Azure Portal. The application must also be configured with MS Graph permissions "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
         */
        clientId?: string | null;
        /**
         * The application secret for the app registered in Azure.
         */
        clientSecret?: Schema$GoogleCloudAiplatformV1ApiAuthApiKeyConfig;
        /**
         * The ID of the drive to download from.
         */
        driveId?: string | null;
        /**
         * The name of the drive to download from.
         */
        driveName?: string | null;
        /**
         * Output only. The SharePoint file id. Output only.
         */
        fileId?: string | null;
        /**
         * The ID of the SharePoint folder to download from.
         */
        sharepointFolderId?: string | null;
        /**
         * The path of the SharePoint folder to download from.
         */
        sharepointFolderPath?: string | null;
        /**
         * The name of the SharePoint site to download from. This can be the site name or the site id.
         */
        sharepointSiteName?: string | null;
        /**
         * Unique identifier of the Azure Active Directory Instance.
         */
        tenantId?: string | null;
    }
    /**
     * A set of Shielded Instance options. See [Images using supported Shielded VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
     */
    export interface Schema$GoogleCloudAiplatformV1ShieldedVmConfig {
        /**
         * Defines whether the instance has [Secure Boot](https://cloud.google.com/compute/shielded-vm/docs/shielded-vm#secure-boot) enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
         */
        enableSecureBoot?: boolean | null;
    }
    /**
     * The Slack source for the ImportRagFilesRequest.
     */
    export interface Schema$GoogleCloudAiplatformV1SlackSource {
        /**
         * Required. The Slack channels.
         */
        channels?: Schema$GoogleCloudAiplatformV1SlackSourceSlackChannels[];
    }
    /**
     * SlackChannels contains the Slack channels and corresponding access token.
     */
    export interface Schema$GoogleCloudAiplatformV1SlackSourceSlackChannels {
        /**
         * Required. The SecretManager secret version resource name (e.g. projects/{project\}/secrets/{secret\}/versions/{version\}) storing the Slack channel access token that has access to the slack channel IDs. See: https://api.slack.com/tutorials/tracks/getting-a-token.
         */
        apiKeyConfig?: Schema$GoogleCloudAiplatformV1ApiAuthApiKeyConfig;
        /**
         * Required. The Slack channel IDs.
         */
        channels?: Schema$GoogleCloudAiplatformV1SlackSourceSlackChannelsSlackChannel[];
    }
    /**
     * SlackChannel contains the Slack channel ID and the time range to import.
     */
    export interface Schema$GoogleCloudAiplatformV1SlackSourceSlackChannelsSlackChannel {
        /**
         * Required. The Slack channel ID.
         */
        channelId?: string | null;
        /**
         * Optional. The ending timestamp for messages to import.
         */
        endTime?: string | null;
        /**
         * Optional. The starting timestamp for messages to import.
         */
        startTime?: string | null;
    }
    /**
     * Config for SmoothGrad approximation of gradients. When enabled, the gradients are approximated by averaging the gradients from noisy samples in the vicinity of the inputs. Adding noise can help improve the computed gradients. Refer to this paper for more details: https://arxiv.org/pdf/1706.03825.pdf
     */
    export interface Schema$GoogleCloudAiplatformV1SmoothGradConfig {
        /**
         * This is similar to noise_sigma, but provides additional flexibility. A separate noise sigma can be provided for each feature, which is useful if their distributions are different. No noise is added to features that are not set. If this field is unset, noise_sigma will be used for all features.
         */
        featureNoiseSigma?: Schema$GoogleCloudAiplatformV1FeatureNoiseSigma;
        /**
         * This is a single float value and will be used to add noise to all the features. Use this field when all features are normalized to have the same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where features are normalized to have 0-mean and 1-variance. Learn more about [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization). For best results the recommended value is about 10% - 20% of the standard deviation of the input feature. Refer to section 3.2 of the SmoothGrad paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1. If the distribution is different per feature, set feature_noise_sigma instead for each feature.
         */
        noiseSigma?: number | null;
        /**
         * The number of gradient samples to use for approximation. The higher this number, the more accurate the gradient is, but the runtime complexity increases by this factor as well. Valid range of its value is [1, 50]. Defaults to 3.
         */
        noisySampleCount?: number | null;
    }
    /**
     * SpecialistPool represents customers' own workforce to work on their data labeling jobs. It includes a group of specialist managers and workers. Managers are responsible for managing the workers in this pool as well as customers' data labeling jobs associated with this pool. Customers create specialist pool as well as start data labeling jobs on Cloud, managers and workers handle the jobs using CrowdCompute console.
     */
    export interface Schema$GoogleCloudAiplatformV1SpecialistPool {
        /**
         * Required. The user-defined name of the SpecialistPool. The name can be up to 128 characters long and can consist of any UTF-8 characters. This field should be unique on project-level.
         */
        displayName?: string | null;
        /**
         * Required. The resource name of the SpecialistPool.
         */
        name?: string | null;
        /**
         * Output only. The resource name of the pending data labeling jobs.
         */
        pendingDataLabelingJobs?: string[] | null;
        /**
         * The email addresses of the managers in the SpecialistPool.
         */
        specialistManagerEmails?: string[] | null;
        /**
         * Output only. The number of managers in this SpecialistPool.
         */
        specialistManagersCount?: number | null;
        /**
         * The email addresses of workers in the SpecialistPool.
         */
        specialistWorkerEmails?: string[] | null;
    }
    /**
     * Configuration for Speculative Decoding.
     */
    export interface Schema$GoogleCloudAiplatformV1SpeculativeDecodingSpec {
        /**
         * draft model speculation.
         */
        draftModelSpeculation?: Schema$GoogleCloudAiplatformV1SpeculativeDecodingSpecDraftModelSpeculation;
        /**
         * N-Gram speculation.
         */
        ngramSpeculation?: Schema$GoogleCloudAiplatformV1SpeculativeDecodingSpecNgramSpeculation;
        /**
         * The number of speculative tokens to generate at each step.
         */
        speculativeTokenCount?: number | null;
    }
    /**
     * Draft model speculation works by using the smaller model to generate candidate tokens for speculative decoding.
     */
    export interface Schema$GoogleCloudAiplatformV1SpeculativeDecodingSpecDraftModelSpeculation {
        /**
         * Required. The resource name of the draft model.
         */
        draftModel?: string | null;
    }
    /**
     * N-Gram speculation works by trying to find matching tokens in the previous prompt sequence and use those as speculation for generating new tokens.
     */
    export interface Schema$GoogleCloudAiplatformV1SpeculativeDecodingSpecNgramSpeculation {
        /**
         * The number of last N input tokens used as ngram to search/match against the previous prompt sequence. This is equal to the N in N-Gram. The default value is 3 if not specified.
         */
        ngramSize?: number | null;
    }
    /**
     * The speech generation config.
     */
    export interface Schema$GoogleCloudAiplatformV1SpeechConfig {
        /**
         * Optional. Language code (ISO 639. e.g. en-US) for the speech synthesization.
         */
        languageCode?: string | null;
        /**
         * The configuration for the speaker to use.
         */
        voiceConfig?: Schema$GoogleCloudAiplatformV1VoiceConfig;
    }
    /**
     * Metadata information for NotebookService.StartNotebookRuntime.
     */
    export interface Schema$GoogleCloudAiplatformV1StartNotebookRuntimeOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * A human-readable message that shows the intermediate progress details of NotebookRuntime.
         */
        progressMessage?: string | null;
    }
    /**
     * Request message for NotebookService.StartNotebookRuntime.
     */
    export interface Schema$GoogleCloudAiplatformV1StartNotebookRuntimeRequest {
    }
    /**
     * Request message for NotebookService.StopNotebookRuntime.
     */
    export interface Schema$GoogleCloudAiplatformV1StopNotebookRuntimeRequest {
    }
    /**
     * Request message for VizierService.StopTrial.
     */
    export interface Schema$GoogleCloudAiplatformV1StopTrialRequest {
    }
    /**
     * Assigns input data to the training, validation, and test sets so that the distribution of values found in the categorical column (as specified by the `key` field) is mirrored within each split. The fraction values determine the relative sizes of the splits. For example, if the specified column has three values, with 50% of the rows having value "A", 25% value "B", and 25% value "C", and the split fractions are specified as 80/10/10, then the training set will constitute 80% of the training data, with about 50% of the training set rows having the value "A" for the specified column, about 25% having the value "B", and about 25% having the value "C". Only the top 500 occurring values are used; any values not in the top 500 values are randomly assigned to a split. If less than three rows contain a specific value, those rows are randomly assigned. Supported only for tabular Datasets.
     */
    export interface Schema$GoogleCloudAiplatformV1StratifiedSplit {
        /**
         * Required. The key is a name of one of the Dataset's data columns. The key provided must be for a categorical column.
         */
        key?: string | null;
        /**
         * The fraction of the input data that is to be used to evaluate the Model.
         */
        testFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to train the Model.
         */
        trainingFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to validate the Model.
         */
        validationFraction?: number | null;
    }
    /**
     * Request message for PredictionService.StreamingPredict. The first message must contain endpoint field and optionally input. The subsequent messages must contain input.
     */
    export interface Schema$GoogleCloudAiplatformV1StreamingPredictRequest {
        /**
         * The prediction input.
         */
        inputs?: Schema$GoogleCloudAiplatformV1Tensor[];
        /**
         * The parameters that govern the prediction.
         */
        parameters?: Schema$GoogleCloudAiplatformV1Tensor;
    }
    /**
     * Response message for PredictionService.StreamingPredict.
     */
    export interface Schema$GoogleCloudAiplatformV1StreamingPredictResponse {
        /**
         * The prediction output.
         */
        outputs?: Schema$GoogleCloudAiplatformV1Tensor[];
        /**
         * The parameters that govern the prediction.
         */
        parameters?: Schema$GoogleCloudAiplatformV1Tensor;
    }
    /**
     * Request message for FeaturestoreOnlineServingService.StreamingReadFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1StreamingReadFeatureValuesRequest {
        /**
         * Required. IDs of entities to read Feature values of. The maximum number of IDs is 100. For example, for a machine learning model predicting user clicks on a website, an entity ID could be `user_123`.
         */
        entityIds?: string[] | null;
        /**
         * Required. Selector choosing Features of the target EntityType. Feature IDs will be deduplicated.
         */
        featureSelector?: Schema$GoogleCloudAiplatformV1FeatureSelector;
    }
    /**
     * Request message for ReasoningEngineExecutionService.StreamQuery.
     */
    export interface Schema$GoogleCloudAiplatformV1StreamQueryReasoningEngineRequest {
        /**
         * Optional. Class method to be used for the stream query. It is optional and defaults to "stream_query" if unspecified.
         */
        classMethod?: string | null;
        /**
         * Optional. Input content provided by users in JSON object format. Examples include text query, function calling parameters, media bytes, etc.
         */
        input?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Request message for PredictionService.StreamRawPredict.
     */
    export interface Schema$GoogleCloudAiplatformV1StreamRawPredictRequest {
        /**
         * The prediction input. Supports HTTP headers and arbitrary data payload.
         */
        httpBody?: Schema$GoogleApiHttpBody;
    }
    /**
     * A list of string values.
     */
    export interface Schema$GoogleCloudAiplatformV1StringArray {
        /**
         * A list of string values.
         */
        values?: string[] | null;
    }
    /**
     * One field of a Struct (or object) type feature value.
     */
    export interface Schema$GoogleCloudAiplatformV1StructFieldValue {
        /**
         * Name of the field in the struct feature.
         */
        name?: string | null;
        /**
         * The value for this field.
         */
        value?: Schema$GoogleCloudAiplatformV1FeatureValue;
    }
    /**
     * Struct (or object) type feature value.
     */
    export interface Schema$GoogleCloudAiplatformV1StructValue {
        /**
         * A list of field values.
         */
        values?: Schema$GoogleCloudAiplatformV1StructFieldValue[];
    }
    /**
     * A message representing a Study.
     */
    export interface Schema$GoogleCloudAiplatformV1Study {
        /**
         * Output only. Time at which the study was created.
         */
        createTime?: string | null;
        /**
         * Required. Describes the Study, default value is empty string.
         */
        displayName?: string | null;
        /**
         * Output only. A human readable reason why the Study is inactive. This should be empty if a study is ACTIVE or COMPLETED.
         */
        inactiveReason?: string | null;
        /**
         * Output only. The name of a study. The study's globally unique identifier. Format: `projects/{project\}/locations/{location\}/studies/{study\}`
         */
        name?: string | null;
        /**
         * Output only. The detailed state of a Study.
         */
        state?: string | null;
        /**
         * Required. Configuration of the Study.
         */
        studySpec?: Schema$GoogleCloudAiplatformV1StudySpec;
    }
    /**
     * Represents specification of a Study.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpec {
        /**
         * The search algorithm specified for the Study.
         */
        algorithm?: string | null;
        /**
         * The automated early stopping spec using convex stopping rule.
         */
        convexAutomatedStoppingSpec?: Schema$GoogleCloudAiplatformV1StudySpecConvexAutomatedStoppingSpec;
        /**
         * The automated early stopping spec using decay curve rule.
         */
        decayCurveStoppingSpec?: Schema$GoogleCloudAiplatformV1StudySpecDecayCurveAutomatedStoppingSpec;
        /**
         * Describe which measurement selection type will be used
         */
        measurementSelectionType?: string | null;
        /**
         * The automated early stopping spec using median rule.
         */
        medianAutomatedStoppingSpec?: Schema$GoogleCloudAiplatformV1StudySpecMedianAutomatedStoppingSpec;
        /**
         * Required. Metric specs for the Study.
         */
        metrics?: Schema$GoogleCloudAiplatformV1StudySpecMetricSpec[];
        /**
         * The observation noise level of the study. Currently only supported by the Vertex AI Vizier service. Not supported by HyperparameterTuningJob or TrainingPipeline.
         */
        observationNoise?: string | null;
        /**
         * Required. The set of parameters to tune.
         */
        parameters?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpec[];
        /**
         * Conditions for automated stopping of a Study. Enable automated stopping by configuring at least one condition.
         */
        studyStoppingConfig?: Schema$GoogleCloudAiplatformV1StudySpecStudyStoppingConfig;
    }
    /**
     * Configuration for ConvexAutomatedStoppingSpec. When there are enough completed trials (configured by min_measurement_count), for pending trials with enough measurements and steps, the policy first computes an overestimate of the objective value at max_num_steps according to the slope of the incomplete objective value curve. No prediction can be made if the curve is completely flat. If the overestimation is worse than the best objective value of the completed trials, this pending trial will be early-stopped, but a last measurement will be added to the pending trial with max_num_steps and predicted objective value from the autoregression model.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecConvexAutomatedStoppingSpec {
        /**
         * The hyper-parameter name used in the tuning job that stands for learning rate. Leave it blank if learning rate is not in a parameter in tuning. The learning_rate is used to estimate the objective value of the ongoing trial.
         */
        learningRateParameterName?: string | null;
        /**
         * Steps used in predicting the final objective for early stopped trials. In general, it's set to be the same as the defined steps in training / tuning. If not defined, it will learn it from the completed trials. When use_steps is false, this field is set to the maximum elapsed seconds.
         */
        maxStepCount?: string | null;
        /**
         * The minimal number of measurements in a Trial. Early-stopping checks will not trigger if less than min_measurement_count+1 completed trials or pending trials with less than min_measurement_count measurements. If not defined, the default value is 5.
         */
        minMeasurementCount?: string | null;
        /**
         * Minimum number of steps for a trial to complete. Trials which do not have a measurement with step_count \> min_step_count won't be considered for early stopping. It's ok to set it to 0, and a trial can be early stopped at any stage. By default, min_step_count is set to be one-tenth of the max_step_count. When use_elapsed_duration is true, this field is set to the minimum elapsed seconds.
         */
        minStepCount?: string | null;
        /**
         * ConvexAutomatedStoppingSpec by default only updates the trials that needs to be early stopped using a newly trained auto-regressive model. When this flag is set to True, all stopped trials from the beginning are potentially updated in terms of their `final_measurement`. Also, note that the training logic of autoregressive models is different in this case. Enabling this option has shown better results and this may be the default option in the future.
         */
        updateAllStoppedTrials?: boolean | null;
        /**
         * This bool determines whether or not the rule is applied based on elapsed_secs or steps. If use_elapsed_duration==false, the early stopping decision is made according to the predicted objective values according to the target steps. If use_elapsed_duration==true, elapsed_secs is used instead of steps. Also, in this case, the parameters max_num_steps and min_num_steps are overloaded to contain max_elapsed_seconds and min_elapsed_seconds.
         */
        useElapsedDuration?: boolean | null;
    }
    /**
     * The decay curve automated stopping rule builds a Gaussian Process Regressor to predict the final objective value of a Trial based on the already completed Trials and the intermediate measurements of the current Trial. Early stopping is requested for the current Trial if there is very low probability to exceed the optimal value found so far.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecDecayCurveAutomatedStoppingSpec {
        /**
         * True if Measurement.elapsed_duration is used as the x-axis of each Trials Decay Curve. Otherwise, Measurement.step_count will be used as the x-axis.
         */
        useElapsedDuration?: boolean | null;
    }
    /**
     * The median automated stopping rule stops a pending Trial if the Trial's best objective_value is strictly below the median 'performance' of all completed Trials reported up to the Trial's last measurement. Currently, 'performance' refers to the running average of the objective values reported by the Trial in each measurement.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecMedianAutomatedStoppingSpec {
        /**
         * True if median automated stopping rule applies on Measurement.elapsed_duration. It means that elapsed_duration field of latest measurement of current Trial is used to compute median objective value for each completed Trials.
         */
        useElapsedDuration?: boolean | null;
    }
    /**
     * Represents a metric to optimize.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecMetricSpec {
        /**
         * Required. The optimization goal of the metric.
         */
        goal?: string | null;
        /**
         * Required. The ID of the metric. Must not contain whitespaces and must be unique amongst all MetricSpecs.
         */
        metricId?: string | null;
        /**
         * Used for safe search. In the case, the metric will be a safety metric. You must provide a separate metric for objective metric.
         */
        safetyConfig?: Schema$GoogleCloudAiplatformV1StudySpecMetricSpecSafetyMetricConfig;
    }
    /**
     * Used in safe optimization to specify threshold levels and risk tolerance.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecMetricSpecSafetyMetricConfig {
        /**
         * Desired minimum fraction of safe trials (over total number of trials) that should be targeted by the algorithm at any time during the study (best effort). This should be between 0.0 and 1.0 and a value of 0.0 means that there is no minimum and an algorithm proceeds without targeting any specific fraction. A value of 1.0 means that the algorithm attempts to only Suggest safe Trials.
         */
        desiredMinSafeTrialsFraction?: number | null;
        /**
         * Safety threshold (boundary value between safe and unsafe). NOTE that if you leave SafetyMetricConfig unset, a default value of 0 will be used.
         */
        safetyThreshold?: number | null;
    }
    /**
     * Represents a single parameter to optimize.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpec {
        /**
         * The value spec for a 'CATEGORICAL' parameter.
         */
        categoricalValueSpec?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecCategoricalValueSpec;
        /**
         * A conditional parameter node is active if the parameter's value matches the conditional node's parent_value_condition. If two items in conditional_parameter_specs have the same name, they must have disjoint parent_value_condition.
         */
        conditionalParameterSpecs?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpec[];
        /**
         * The value spec for a 'DISCRETE' parameter.
         */
        discreteValueSpec?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecDiscreteValueSpec;
        /**
         * The value spec for a 'DOUBLE' parameter.
         */
        doubleValueSpec?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecDoubleValueSpec;
        /**
         * The value spec for an 'INTEGER' parameter.
         */
        integerValueSpec?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecIntegerValueSpec;
        /**
         * Required. The ID of the parameter. Must not contain whitespaces and must be unique amongst all ParameterSpecs.
         */
        parameterId?: string | null;
        /**
         * How the parameter should be scaled. Leave unset for `CATEGORICAL` parameters.
         */
        scaleType?: string | null;
    }
    /**
     * Value specification for a parameter in `CATEGORICAL` type.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecCategoricalValueSpec {
        /**
         * A default value for a `CATEGORICAL` parameter that is assumed to be a relatively good starting point. Unset value signals that there is no offered starting point. Currently only supported by the Vertex AI Vizier service. Not supported by HyperparameterTuningJob or TrainingPipeline.
         */
        defaultValue?: string | null;
        /**
         * Required. The list of possible categories.
         */
        values?: string[] | null;
    }
    /**
     * Represents a parameter spec with condition from its parent parameter.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpec {
        /**
         * Required. The spec for a conditional parameter.
         */
        parameterSpec?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpec;
        /**
         * The spec for matching values from a parent parameter of `CATEGORICAL` type.
         */
        parentCategoricalValues?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecCategoricalValueCondition;
        /**
         * The spec for matching values from a parent parameter of `DISCRETE` type.
         */
        parentDiscreteValues?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecDiscreteValueCondition;
        /**
         * The spec for matching values from a parent parameter of `INTEGER` type.
         */
        parentIntValues?: Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecIntValueCondition;
    }
    /**
     * Represents the spec to match categorical values from parent parameter.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecCategoricalValueCondition {
        /**
         * Required. Matches values of the parent parameter of 'CATEGORICAL' type. All values must exist in `categorical_value_spec` of parent parameter.
         */
        values?: string[] | null;
    }
    /**
     * Represents the spec to match discrete values from parent parameter.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecDiscreteValueCondition {
        /**
         * Required. Matches values of the parent parameter of 'DISCRETE' type. All values must exist in `discrete_value_spec` of parent parameter. The Epsilon of the value matching is 1e-10.
         */
        values?: number[] | null;
    }
    /**
     * Represents the spec to match integer values from parent parameter.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecConditionalParameterSpecIntValueCondition {
        /**
         * Required. Matches values of the parent parameter of 'INTEGER' type. All values must lie in `integer_value_spec` of parent parameter.
         */
        values?: string[] | null;
    }
    /**
     * Value specification for a parameter in `DISCRETE` type.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecDiscreteValueSpec {
        /**
         * A default value for a `DISCRETE` parameter that is assumed to be a relatively good starting point. Unset value signals that there is no offered starting point. It automatically rounds to the nearest feasible discrete point. Currently only supported by the Vertex AI Vizier service. Not supported by HyperparameterTuningJob or TrainingPipeline.
         */
        defaultValue?: number | null;
        /**
         * Required. A list of possible values. The list should be in increasing order and at least 1e-10 apart. For instance, this parameter might have possible settings of 1.5, 2.5, and 4.0. This list should not contain more than 1,000 values.
         */
        values?: number[] | null;
    }
    /**
     * Value specification for a parameter in `DOUBLE` type.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecDoubleValueSpec {
        /**
         * A default value for a `DOUBLE` parameter that is assumed to be a relatively good starting point. Unset value signals that there is no offered starting point. Currently only supported by the Vertex AI Vizier service. Not supported by HyperparameterTuningJob or TrainingPipeline.
         */
        defaultValue?: number | null;
        /**
         * Required. Inclusive maximum value of the parameter.
         */
        maxValue?: number | null;
        /**
         * Required. Inclusive minimum value of the parameter.
         */
        minValue?: number | null;
    }
    /**
     * Value specification for a parameter in `INTEGER` type.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecParameterSpecIntegerValueSpec {
        /**
         * A default value for an `INTEGER` parameter that is assumed to be a relatively good starting point. Unset value signals that there is no offered starting point. Currently only supported by the Vertex AI Vizier service. Not supported by HyperparameterTuningJob or TrainingPipeline.
         */
        defaultValue?: string | null;
        /**
         * Required. Inclusive maximum value of the parameter.
         */
        maxValue?: string | null;
        /**
         * Required. Inclusive minimum value of the parameter.
         */
        minValue?: string | null;
    }
    /**
     * The configuration (stopping conditions) for automated stopping of a Study. Conditions include trial budgets, time budgets, and convergence detection.
     */
    export interface Schema$GoogleCloudAiplatformV1StudySpecStudyStoppingConfig {
        /**
         * If the objective value has not improved for this much time, stop the study. WARNING: Effective only for single-objective studies.
         */
        maxDurationNoProgress?: string | null;
        /**
         * If the specified time or duration has passed, stop the study.
         */
        maximumRuntimeConstraint?: Schema$GoogleCloudAiplatformV1StudyTimeConstraint;
        /**
         * If there are more than this many trials, stop the study.
         */
        maxNumTrials?: number | null;
        /**
         * If the objective value has not improved for this many consecutive trials, stop the study. WARNING: Effective only for single-objective studies.
         */
        maxNumTrialsNoProgress?: number | null;
        /**
         * Each "stopping rule" in this proto specifies an "if" condition. Before Vizier would generate a new suggestion, it first checks each specified stopping rule, from top to bottom in this list. Note that the first few rules (e.g. minimum_runtime_constraint, min_num_trials) will prevent other stopping rules from being evaluated until they are met. For example, setting `min_num_trials=5` and `always_stop_after= 1 hour` means that the Study will ONLY stop after it has 5 COMPLETED trials, even if more than an hour has passed since its creation. It follows the first applicable rule (whose "if" condition is satisfied) to make a stopping decision. If none of the specified rules are applicable, then Vizier decides that the study should not stop. If Vizier decides that the study should stop, the study enters STOPPING state (or STOPPING_ASAP if should_stop_asap = true). IMPORTANT: The automatic study state transition happens precisely as described above; that is, deleting trials or updating StudyConfig NEVER automatically moves the study state back to ACTIVE. If you want to _resume_ a Study that was stopped, 1) change the stopping conditions if necessary, 2) activate the study, and then 3) ask for suggestions. If the specified time or duration has not passed, do not stop the study.
         */
        minimumRuntimeConstraint?: Schema$GoogleCloudAiplatformV1StudyTimeConstraint;
        /**
         * If there are fewer than this many COMPLETED trials, do not stop the study.
         */
        minNumTrials?: number | null;
        /**
         * If true, a Study enters STOPPING_ASAP whenever it would normally enters STOPPING state. The bottom line is: set to true if you want to interrupt on-going evaluations of Trials as soon as the study stopping condition is met. (Please see Study.State documentation for the source of truth).
         */
        shouldStopAsap?: boolean | null;
    }
    /**
     * Time-based Constraint for Study
     */
    export interface Schema$GoogleCloudAiplatformV1StudyTimeConstraint {
        /**
         * Compares the wallclock time to this time. Must use UTC timezone.
         */
        endTime?: string | null;
        /**
         * Counts the wallclock time passed since the creation of this Study.
         */
        maxDuration?: string | null;
    }
    /**
     * Details of operations that perform Trials suggestion.
     */
    export interface Schema$GoogleCloudAiplatformV1SuggestTrialsMetadata {
        /**
         * The identifier of the client that is requesting the suggestion. If multiple SuggestTrialsRequests have the same `client_id`, the service will return the identical suggested Trial if the Trial is pending, and provide a new Trial if the last suggested Trial was completed.
         */
        clientId?: string | null;
        /**
         * Operation metadata for suggesting Trials.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for VizierService.SuggestTrials.
     */
    export interface Schema$GoogleCloudAiplatformV1SuggestTrialsRequest {
        /**
         * Required. The identifier of the client that is requesting the suggestion. If multiple SuggestTrialsRequests have the same `client_id`, the service will return the identical suggested Trial if the Trial is pending, and provide a new Trial if the last suggested Trial was completed.
         */
        clientId?: string | null;
        /**
         * Optional. This allows you to specify the "context" for a Trial; a context is a slice (a subspace) of the search space. Typical uses for contexts: 1) You are using Vizier to tune a server for best performance, but there's a strong weekly cycle. The context specifies the day-of-week. This allows Tuesday to generalize from Wednesday without assuming that everything is identical. 2) Imagine you're optimizing some medical treatment for people. As they walk in the door, you know certain facts about them (e.g. sex, weight, height, blood-pressure). Put that information in the context, and Vizier will adapt its suggestions to the patient. 3) You want to do a fair A/B test efficiently. Specify the "A" and "B" conditions as contexts, and Vizier will generalize between "A" and "B" conditions. If they are similar, this will allow Vizier to converge to the optimum faster than if "A" and "B" were separate Studies. NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the CreateTrial() RPC; that's the asynchronous option where you don't need a close association between contexts and suggestions. NOTE: All the Parameters you set in a context MUST be defined in the Study. NOTE: You must supply 0 or $suggestion_count contexts. If you don't supply any contexts, Vizier will make suggestions from the full search space specified in the StudySpec; if you supply a full set of context, each suggestion will match the corresponding context. NOTE: A Context with no features set matches anything, and allows suggestions from the full search space. NOTE: Contexts MUST lie within the search space specified in the StudySpec. It's an error if they don't. NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before new suggestions are generated. NOTE: Generation of suggestions involves a match between a Context and (optionally) a REQUESTED trial; if that match is not fully specified, a suggestion will be geneated in the merged subspace.
         */
        contexts?: Schema$GoogleCloudAiplatformV1TrialContext[];
        /**
         * Required. The number of suggestions requested. It must be positive.
         */
        suggestionCount?: number | null;
    }
    /**
     * Response message for VizierService.SuggestTrials.
     */
    export interface Schema$GoogleCloudAiplatformV1SuggestTrialsResponse {
        /**
         * The time at which operation processing completed.
         */
        endTime?: string | null;
        /**
         * The time at which the operation was started.
         */
        startTime?: string | null;
        /**
         * The state of the Study.
         */
        studyState?: string | null;
        /**
         * A list of Trials.
         */
        trials?: Schema$GoogleCloudAiplatformV1Trial[];
    }
    /**
     * Input for summarization helpfulness metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessInput {
        /**
         * Required. Summarization helpfulness instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessInstance;
        /**
         * Required. Spec for summarization helpfulness score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessSpec;
    }
    /**
     * Spec for summarization helpfulness instance.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessInstance {
        /**
         * Required. Text to be summarized.
         */
        context?: string | null;
        /**
         * Optional. Summarization prompt for LLM.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for summarization helpfulness result.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessResult {
        /**
         * Output only. Confidence for summarization helpfulness score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for summarization helpfulness score.
         */
        explanation?: string | null;
        /**
         * Output only. Summarization Helpfulness score.
         */
        score?: number | null;
    }
    /**
     * Spec for summarization helpfulness score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationHelpfulnessSpec {
        /**
         * Optional. Whether to use instance.reference to compute summarization helpfulness.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Input for summarization quality metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationQualityInput {
        /**
         * Required. Summarization quality instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1SummarizationQualityInstance;
        /**
         * Required. Spec for summarization quality score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1SummarizationQualitySpec;
    }
    /**
     * Spec for summarization quality instance.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationQualityInstance {
        /**
         * Required. Text to be summarized.
         */
        context?: string | null;
        /**
         * Required. Summarization prompt for LLM.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for summarization quality result.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationQualityResult {
        /**
         * Output only. Confidence for summarization quality score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for summarization quality score.
         */
        explanation?: string | null;
        /**
         * Output only. Summarization Quality score.
         */
        score?: number | null;
    }
    /**
     * Spec for summarization quality score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationQualitySpec {
        /**
         * Optional. Whether to use instance.reference to compute summarization quality.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Input for summarization verbosity metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationVerbosityInput {
        /**
         * Required. Summarization verbosity instance.
         */
        instance?: Schema$GoogleCloudAiplatformV1SummarizationVerbosityInstance;
        /**
         * Required. Spec for summarization verbosity score metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1SummarizationVerbositySpec;
    }
    /**
     * Spec for summarization verbosity instance.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationVerbosityInstance {
        /**
         * Required. Text to be summarized.
         */
        context?: string | null;
        /**
         * Optional. Summarization prompt for LLM.
         */
        instruction?: string | null;
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Optional. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Spec for summarization verbosity result.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationVerbosityResult {
        /**
         * Output only. Confidence for summarization verbosity score.
         */
        confidence?: number | null;
        /**
         * Output only. Explanation for summarization verbosity score.
         */
        explanation?: string | null;
        /**
         * Output only. Summarization Verbosity score.
         */
        score?: number | null;
    }
    /**
     * Spec for summarization verbosity score metric.
     */
    export interface Schema$GoogleCloudAiplatformV1SummarizationVerbositySpec {
        /**
         * Optional. Whether to use instance.reference to compute summarization verbosity.
         */
        useReference?: boolean | null;
        /**
         * Optional. Which version to use for evaluation.
         */
        version?: number | null;
    }
    /**
     * Hyperparameters for SFT.
     */
    export interface Schema$GoogleCloudAiplatformV1SupervisedHyperParameters {
        /**
         * Optional. Adapter size for tuning.
         */
        adapterSize?: string | null;
        /**
         * Optional. Number of complete passes the model makes over the entire training dataset during training.
         */
        epochCount?: string | null;
        /**
         * Optional. Multiplier for adjusting the default learning rate.
         */
        learningRateMultiplier?: number | null;
    }
    /**
     * Dataset distribution for Supervised Tuning.
     */
    export interface Schema$GoogleCloudAiplatformV1SupervisedTuningDatasetDistribution {
        /**
         * Output only. Sum of a given population of values that are billable.
         */
        billableSum?: string | null;
        /**
         * Output only. Defines the histogram bucket.
         */
        buckets?: Schema$GoogleCloudAiplatformV1SupervisedTuningDatasetDistributionDatasetBucket[];
        /**
         * Output only. The maximum of the population values.
         */
        max?: number | null;
        /**
         * Output only. The arithmetic mean of the values in the population.
         */
        mean?: number | null;
        /**
         * Output only. The median of the values in the population.
         */
        median?: number | null;
        /**
         * Output only. The minimum of the population values.
         */
        min?: number | null;
        /**
         * Output only. The 5th percentile of the values in the population.
         */
        p5?: number | null;
        /**
         * Output only. The 95th percentile of the values in the population.
         */
        p95?: number | null;
        /**
         * Output only. Sum of a given population of values.
         */
        sum?: string | null;
    }
    /**
     * Dataset bucket used to create a histogram for the distribution given a population of values.
     */
    export interface Schema$GoogleCloudAiplatformV1SupervisedTuningDatasetDistributionDatasetBucket {
        /**
         * Output only. Number of values in the bucket.
         */
        count?: number | null;
        /**
         * Output only. Left bound of the bucket.
         */
        left?: number | null;
        /**
         * Output only. Right bound of the bucket.
         */
        right?: number | null;
    }
    /**
     * Tuning data statistics for Supervised Tuning.
     */
    export interface Schema$GoogleCloudAiplatformV1SupervisedTuningDataStats {
        /**
         * Output only. For each index in `truncated_example_indices`, the user-facing reason why the example was dropped. Must not include example itself.
         */
        droppedExampleReasons?: string[] | null;
        /**
         * Output only. Number of billable characters in the tuning dataset.
         */
        totalBillableCharacterCount?: string | null;
        /**
         * Output only. Number of billable tokens in the tuning dataset.
         */
        totalBillableTokenCount?: string | null;
        /**
         * Output only. The number of examples in the dataset that have been dropped. An example can be dropped for reasons including: too many tokens, contains an invalid image, contains too many images, etc.
         */
        totalTruncatedExampleCount?: string | null;
        /**
         * Output only. Number of tuning characters in the tuning dataset.
         */
        totalTuningCharacterCount?: string | null;
        /**
         * Output only. A partial sample of the indices (starting from 1) of the dropped examples.
         */
        truncatedExampleIndices?: string[] | null;
        /**
         * Output only. Number of examples in the tuning dataset.
         */
        tuningDatasetExampleCount?: string | null;
        /**
         * Output only. Number of tuning steps for this Tuning Job.
         */
        tuningStepCount?: string | null;
        /**
         * Output only. Sample user messages in the training dataset uri.
         */
        userDatasetExamples?: Schema$GoogleCloudAiplatformV1Content[];
        /**
         * Output only. Dataset distributions for the user input tokens.
         */
        userInputTokenDistribution?: Schema$GoogleCloudAiplatformV1SupervisedTuningDatasetDistribution;
        /**
         * Output only. Dataset distributions for the messages per example.
         */
        userMessagePerExampleDistribution?: Schema$GoogleCloudAiplatformV1SupervisedTuningDatasetDistribution;
        /**
         * Output only. Dataset distributions for the user output tokens.
         */
        userOutputTokenDistribution?: Schema$GoogleCloudAiplatformV1SupervisedTuningDatasetDistribution;
    }
    /**
     * Tuning Spec for Supervised Tuning for first party models.
     */
    export interface Schema$GoogleCloudAiplatformV1SupervisedTuningSpec {
        /**
         * Optional. Hyperparameters for SFT.
         */
        hyperParameters?: Schema$GoogleCloudAiplatformV1SupervisedHyperParameters;
        /**
         * Required. Cloud Storage path to file containing training dataset for tuning. The dataset must be formatted as a JSONL file.
         */
        trainingDatasetUri?: string | null;
        /**
         * Optional. Cloud Storage path to file containing validation dataset for tuning. The dataset must be formatted as a JSONL file.
         */
        validationDatasetUri?: string | null;
    }
    /**
     * Request message for FeatureOnlineStoreAdminService.SyncFeatureView.
     */
    export interface Schema$GoogleCloudAiplatformV1SyncFeatureViewRequest {
    }
    /**
     * Response message for FeatureOnlineStoreAdminService.SyncFeatureView.
     */
    export interface Schema$GoogleCloudAiplatformV1SyncFeatureViewResponse {
        /**
         * Format: `projects/{project\}/locations/{location\}/featureOnlineStores/{feature_online_store\}/featureViews/{feature_view\}/featureViewSyncs/{feature_view_sync\}`
         */
        featureViewSync?: string | null;
    }
    /**
     * A tensor value type.
     */
    export interface Schema$GoogleCloudAiplatformV1Tensor {
        /**
         * Type specific representations that make it easy to create tensor protos in all languages. Only the representation corresponding to "dtype" can be set. The values hold the flattened representation of the tensor in row major order. BOOL
         */
        boolVal?: boolean[] | null;
        /**
         * STRING
         */
        bytesVal?: string[] | null;
        /**
         * DOUBLE
         */
        doubleVal?: number[] | null;
        /**
         * The data type of tensor.
         */
        dtype?: string | null;
        /**
         * FLOAT
         */
        floatVal?: number[] | null;
        /**
         * INT64
         */
        int64Val?: string[] | null;
        /**
         * INT_8 INT_16 INT_32
         */
        intVal?: number[] | null;
        /**
         * A list of tensor values.
         */
        listVal?: Schema$GoogleCloudAiplatformV1Tensor[];
        /**
         * Shape of the tensor.
         */
        shape?: string[] | null;
        /**
         * STRING
         */
        stringVal?: string[] | null;
        /**
         * A map of string to tensor.
         */
        structVal?: {
            [key: string]: Schema$GoogleCloudAiplatformV1Tensor;
        } | null;
        /**
         * Serialized raw tensor content.
         */
        tensorVal?: string | null;
        /**
         * UINT64
         */
        uint64Val?: string[] | null;
        /**
         * UINT8 UINT16 UINT32
         */
        uintVal?: number[] | null;
    }
    /**
     * Tensorboard is a physical database that stores users' training metrics. A default Tensorboard is provided in each region of a Google Cloud project. If needed users can also create extra Tensorboards in their projects.
     */
    export interface Schema$GoogleCloudAiplatformV1Tensorboard {
        /**
         * Output only. Consumer project Cloud Storage path prefix used to store blob data, which can either be a bucket or directory. Does not end with a '/'.
         */
        blobStoragePathPrefix?: string | null;
        /**
         * Output only. Timestamp when this Tensorboard was created.
         */
        createTime?: string | null;
        /**
         * Description of this Tensorboard.
         */
        description?: string | null;
        /**
         * Required. User provided name of this Tensorboard.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for a Tensorboard. If set, this Tensorboard and all sub-resources of this Tensorboard will be secured by this key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Used to perform a consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Used to indicate if the TensorBoard instance is the default one. Each project & region can have at most one default TensorBoard instance. Creation of a default TensorBoard instance and updating an existing TensorBoard instance to be default will mark all other TensorBoard instances (if any) as non default.
         */
        isDefault?: boolean | null;
        /**
         * The labels with user-defined metadata to organize your Tensorboards. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Tensorboard (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Name of the Tensorboard. Format: `projects/{project\}/locations/{location\}/tensorboards/{tensorboard\}`
         */
        name?: string | null;
        /**
         * Output only. The number of Runs stored in this Tensorboard.
         */
        runCount?: number | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzi?: boolean | null;
        /**
         * Output only. Reserved for future use.
         */
        satisfiesPzs?: boolean | null;
        /**
         * Output only. Timestamp when this Tensorboard was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * One blob (e.g, image, graph) viewable on a blob metric plot.
     */
    export interface Schema$GoogleCloudAiplatformV1TensorboardBlob {
        /**
         * Optional. The bytes of the blob is not present unless it's returned by the ReadTensorboardBlobData endpoint.
         */
        data?: string | null;
        /**
         * Output only. A URI safe key uniquely identifying a blob. Can be used to locate the blob stored in the Cloud Storage bucket of the consumer project.
         */
        id?: string | null;
    }
    /**
     * One point viewable on a blob metric plot, but mostly just a wrapper message to work around repeated fields can't be used directly within `oneof` fields.
     */
    export interface Schema$GoogleCloudAiplatformV1TensorboardBlobSequence {
        /**
         * List of blobs contained within the sequence.
         */
        values?: Schema$GoogleCloudAiplatformV1TensorboardBlob[];
    }
    /**
     * A TensorboardExperiment is a group of TensorboardRuns, that are typically the results of a training job run, in a Tensorboard.
     */
    export interface Schema$GoogleCloudAiplatformV1TensorboardExperiment {
        /**
         * Output only. Timestamp when this TensorboardExperiment was created.
         */
        createTime?: string | null;
        /**
         * Description of this TensorboardExperiment.
         */
        description?: string | null;
        /**
         * User provided name of this TensorboardExperiment.
         */
        displayName?: string | null;
        /**
         * Used to perform consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The labels with user-defined metadata to organize your TensorboardExperiment. Label keys and values cannot be longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one Dataset (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with `aiplatform.googleapis.com/` and are immutable. The following system labels exist for each Dataset: * `aiplatform.googleapis.com/dataset_metadata_schema`: output only. Its value is the metadata_schema's title.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Name of the TensorboardExperiment. Format: `projects/{project\}/locations/{location\}/tensorboards/{tensorboard\}/experiments/{experiment\}`
         */
        name?: string | null;
        /**
         * Immutable. Source of the TensorboardExperiment. Example: a custom training job.
         */
        source?: string | null;
        /**
         * Output only. Timestamp when this TensorboardExperiment was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * TensorboardRun maps to a specific execution of a training job with a given set of hyperparameter values, model definition, dataset, etc
     */
    export interface Schema$GoogleCloudAiplatformV1TensorboardRun {
        /**
         * Output only. Timestamp when this TensorboardRun was created.
         */
        createTime?: string | null;
        /**
         * Description of this TensorboardRun.
         */
        description?: string | null;
        /**
         * Required. User provided name of this TensorboardRun. This value must be unique among all TensorboardRuns belonging to the same parent TensorboardExperiment.
         */
        displayName?: string | null;
        /**
         * Used to perform a consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * The labels with user-defined metadata to organize your TensorboardRuns. This field will be used to filter and visualize Runs in the Tensorboard UI. For example, a Vertex AI training job can set a label aiplatform.googleapis.com/training_job_id=xxxxx to all the runs created within that job. An end user can set a label experiment_id=xxxxx for all the runs produced in a Jupyter notebook. These runs can be grouped by a label value and visualized together in the Tensorboard UI. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. No more than 64 user labels can be associated with one TensorboardRun (System labels are excluded). See https://goo.gl/xmQnxf for more information and examples of labels. System reserved label keys are prefixed with "aiplatform.googleapis.com/" and are immutable.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Name of the TensorboardRun. Format: `projects/{project\}/locations/{location\}/tensorboards/{tensorboard\}/experiments/{experiment\}/runs/{run\}`
         */
        name?: string | null;
        /**
         * Output only. Timestamp when this TensorboardRun was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * One point viewable on a tensor metric plot.
     */
    export interface Schema$GoogleCloudAiplatformV1TensorboardTensor {
        /**
         * Required. Serialized form of https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/framework/tensor.proto
         */
        value?: string | null;
        /**
         * Optional. Version number of TensorProto used to serialize value.
         */
        versionNumber?: number | null;
    }
    /**
     * TensorboardTimeSeries maps to times series produced in training runs
     */
    export interface Schema$GoogleCloudAiplatformV1TensorboardTimeSeries {
        /**
         * Output only. Timestamp when this TensorboardTimeSeries was created.
         */
        createTime?: string | null;
        /**
         * Description of this TensorboardTimeSeries.
         */
        description?: string | null;
        /**
         * Required. User provided name of this TensorboardTimeSeries. This value should be unique among all TensorboardTimeSeries resources belonging to the same TensorboardRun resource (parent resource).
         */
        displayName?: string | null;
        /**
         * Used to perform a consistent read-modify-write updates. If not set, a blind "overwrite" update happens.
         */
        etag?: string | null;
        /**
         * Output only. Scalar, Tensor, or Blob metadata for this TensorboardTimeSeries.
         */
        metadata?: Schema$GoogleCloudAiplatformV1TensorboardTimeSeriesMetadata;
        /**
         * Output only. Name of the TensorboardTimeSeries.
         */
        name?: string | null;
        /**
         * Data of the current plugin, with the size limited to 65KB.
         */
        pluginData?: string | null;
        /**
         * Immutable. Name of the plugin this time series pertain to. Such as Scalar, Tensor, Blob
         */
        pluginName?: string | null;
        /**
         * Output only. Timestamp when this TensorboardTimeSeries was last updated.
         */
        updateTime?: string | null;
        /**
         * Required. Immutable. Type of TensorboardTimeSeries value.
         */
        valueType?: string | null;
    }
    /**
     * Describes metadata for a TensorboardTimeSeries.
     */
    export interface Schema$GoogleCloudAiplatformV1TensorboardTimeSeriesMetadata {
        /**
         * Output only. The largest blob sequence length (number of blobs) of all data points in this time series, if its ValueType is BLOB_SEQUENCE.
         */
        maxBlobSequenceLength?: string | null;
        /**
         * Output only. Max step index of all data points within a TensorboardTimeSeries.
         */
        maxStep?: string | null;
        /**
         * Output only. Max wall clock timestamp of all data points within a TensorboardTimeSeries.
         */
        maxWallTime?: string | null;
    }
    /**
     * The storage details for TFRecord output content.
     */
    export interface Schema$GoogleCloudAiplatformV1TFRecordDestination {
        /**
         * Required. Google Cloud Storage location.
         */
        gcsDestination?: Schema$GoogleCloudAiplatformV1GcsDestination;
    }
    /**
     * The config for feature monitoring threshold.
     */
    export interface Schema$GoogleCloudAiplatformV1ThresholdConfig {
        /**
         * Specify a threshold value that can trigger the alert. If this threshold config is for feature distribution distance: 1. For categorical feature, the distribution distance is calculated by L-inifinity norm. 2. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature.
         */
        value?: number | null;
    }
    /**
     * All the data stored in a TensorboardTimeSeries.
     */
    export interface Schema$GoogleCloudAiplatformV1TimeSeriesData {
        /**
         * Required. The ID of the TensorboardTimeSeries, which will become the final component of the TensorboardTimeSeries' resource name
         */
        tensorboardTimeSeriesId?: string | null;
        /**
         * Required. Data points in this time series.
         */
        values?: Schema$GoogleCloudAiplatformV1TimeSeriesDataPoint[];
        /**
         * Required. Immutable. The value type of this time series. All the values in this time series data must match this value type.
         */
        valueType?: string | null;
    }
    /**
     * A TensorboardTimeSeries data point.
     */
    export interface Schema$GoogleCloudAiplatformV1TimeSeriesDataPoint {
        /**
         * A blob sequence value.
         */
        blobs?: Schema$GoogleCloudAiplatformV1TensorboardBlobSequence;
        /**
         * A scalar value.
         */
        scalar?: Schema$GoogleCloudAiplatformV1Scalar;
        /**
         * Step index of this data point within the run.
         */
        step?: string | null;
        /**
         * A tensor value.
         */
        tensor?: Schema$GoogleCloudAiplatformV1TensorboardTensor;
        /**
         * Wall clock timestamp when this data point is generated by the end user.
         */
        wallTime?: string | null;
    }
    /**
     * Assigns input data to training, validation, and test sets based on a provided timestamps. The youngest data pieces are assigned to training set, next to validation set, and the oldest to the test set. Supported only for tabular Datasets.
     */
    export interface Schema$GoogleCloudAiplatformV1TimestampSplit {
        /**
         * Required. The key is a name of one of the Dataset's data columns. The values of the key (the values in the column) must be in RFC 3339 `date-time` format, where `time-offset` = `"Z"` (e.g. 1985-04-12T23:20:50.52Z). If for a piece of data the key is not present or has an invalid value, that piece is ignored by the pipeline.
         */
        key?: string | null;
        /**
         * The fraction of the input data that is to be used to evaluate the Model.
         */
        testFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to train the Model.
         */
        trainingFraction?: number | null;
        /**
         * The fraction of the input data that is to be used to validate the Model.
         */
        validationFraction?: number | null;
    }
    /**
     * Tokens info with a list of tokens and the corresponding list of token ids.
     */
    export interface Schema$GoogleCloudAiplatformV1TokensInfo {
        /**
         * Optional. Optional fields for the role from the corresponding Content.
         */
        role?: string | null;
        /**
         * A list of token ids from the input.
         */
        tokenIds?: string[] | null;
        /**
         * A list of tokens from the input.
         */
        tokens?: string[] | null;
    }
    /**
     * Tool details that the model may use to generate response. A `Tool` is a piece of code that enables the system to interact with external systems to perform an action, or set of actions, outside of knowledge and scope of the model. A Tool object should contain exactly one type of Tool (e.g FunctionDeclaration, Retrieval or GoogleSearchRetrieval).
     */
    export interface Schema$GoogleCloudAiplatformV1Tool {
        /**
         * Optional. CodeExecution tool type. Enables the model to execute code as part of generation.
         */
        codeExecution?: Schema$GoogleCloudAiplatformV1ToolCodeExecution;
        /**
         * Optional. Tool to support searching public web data, powered by Vertex AI Search and Sec4 compliance.
         */
        enterpriseWebSearch?: Schema$GoogleCloudAiplatformV1EnterpriseWebSearch;
        /**
         * Optional. Function tool type. One or more function declarations to be passed to the model along with the current user query. Model may decide to call a subset of these functions by populating FunctionCall in the response. User should provide a FunctionResponse for each function call in the next turn. Based on the function responses, Model will generate the final response back to the user. Maximum 128 function declarations can be provided.
         */
        functionDeclarations?: Schema$GoogleCloudAiplatformV1FunctionDeclaration[];
        /**
         * Optional. GoogleSearch tool type. Tool to support Google Search in Model. Powered by Google.
         */
        googleSearch?: Schema$GoogleCloudAiplatformV1ToolGoogleSearch;
        /**
         * Optional. GoogleSearchRetrieval tool type. Specialized retrieval tool that is powered by Google search.
         */
        googleSearchRetrieval?: Schema$GoogleCloudAiplatformV1GoogleSearchRetrieval;
        /**
         * Optional. Retrieval tool type. System will always execute the provided retrieval tool(s) to get external knowledge to answer the prompt. Retrieval results are presented to the model for generation.
         */
        retrieval?: Schema$GoogleCloudAiplatformV1Retrieval;
    }
    /**
     * Spec for tool call.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolCall {
        /**
         * Optional. Spec for tool input
         */
        toolInput?: string | null;
        /**
         * Required. Spec for tool name
         */
        toolName?: string | null;
    }
    /**
     * Input for tool call valid metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolCallValidInput {
        /**
         * Required. Repeated tool call valid instances.
         */
        instances?: Schema$GoogleCloudAiplatformV1ToolCallValidInstance[];
        /**
         * Required. Spec for tool call valid metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1ToolCallValidSpec;
    }
    /**
     * Spec for tool call valid instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolCallValidInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Required. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Tool call valid metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolCallValidMetricValue {
        /**
         * Output only. Tool call valid score.
         */
        score?: number | null;
    }
    /**
     * Results for tool call valid metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolCallValidResults {
        /**
         * Output only. Tool call valid metric values.
         */
        toolCallValidMetricValues?: Schema$GoogleCloudAiplatformV1ToolCallValidMetricValue[];
    }
    /**
     * Spec for tool call valid metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolCallValidSpec {
    }
    /**
     * Tool that executes code generated by the model, and automatically returns the result to the model. See also [ExecutableCode]and [CodeExecutionResult] which are input and output to this tool.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolCodeExecution {
    }
    /**
     * Tool config. This config is shared for all tools provided in the request.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolConfig {
        /**
         * Optional. Function calling config.
         */
        functionCallingConfig?: Schema$GoogleCloudAiplatformV1FunctionCallingConfig;
        /**
         * Optional. Retrieval config.
         */
        retrievalConfig?: Schema$GoogleCloudAiplatformV1RetrievalConfig;
    }
    /**
     * GoogleSearch tool type. Tool to support Google Search in Model. Powered by Google.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolGoogleSearch {
    }
    /**
     * Input for tool name match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolNameMatchInput {
        /**
         * Required. Repeated tool name match instances.
         */
        instances?: Schema$GoogleCloudAiplatformV1ToolNameMatchInstance[];
        /**
         * Required. Spec for tool name match metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1ToolNameMatchSpec;
    }
    /**
     * Spec for tool name match instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolNameMatchInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Required. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Tool name match metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolNameMatchMetricValue {
        /**
         * Output only. Tool name match score.
         */
        score?: number | null;
    }
    /**
     * Results for tool name match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolNameMatchResults {
        /**
         * Output only. Tool name match metric values.
         */
        toolNameMatchMetricValues?: Schema$GoogleCloudAiplatformV1ToolNameMatchMetricValue[];
    }
    /**
     * Spec for tool name match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolNameMatchSpec {
    }
    /**
     * Input for tool parameter key match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchInput {
        /**
         * Required. Repeated tool parameter key match instances.
         */
        instances?: Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchInstance[];
        /**
         * Required. Spec for tool parameter key match metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchSpec;
    }
    /**
     * Spec for tool parameter key match instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Required. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Tool parameter key match metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchMetricValue {
        /**
         * Output only. Tool parameter key match score.
         */
        score?: number | null;
    }
    /**
     * Results for tool parameter key match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchResults {
        /**
         * Output only. Tool parameter key match metric values.
         */
        toolParameterKeyMatchMetricValues?: Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchMetricValue[];
    }
    /**
     * Spec for tool parameter key match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKeyMatchSpec {
    }
    /**
     * Input for tool parameter key value match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKVMatchInput {
        /**
         * Required. Repeated tool parameter key value match instances.
         */
        instances?: Schema$GoogleCloudAiplatformV1ToolParameterKVMatchInstance[];
        /**
         * Required. Spec for tool parameter key value match metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1ToolParameterKVMatchSpec;
    }
    /**
     * Spec for tool parameter key value match instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKVMatchInstance {
        /**
         * Required. Output of the evaluated model.
         */
        prediction?: string | null;
        /**
         * Required. Ground truth used to compare against the prediction.
         */
        reference?: string | null;
    }
    /**
     * Tool parameter key value match metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKVMatchMetricValue {
        /**
         * Output only. Tool parameter key value match score.
         */
        score?: number | null;
    }
    /**
     * Results for tool parameter key value match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKVMatchResults {
        /**
         * Output only. Tool parameter key value match metric values.
         */
        toolParameterKvMatchMetricValues?: Schema$GoogleCloudAiplatformV1ToolParameterKVMatchMetricValue[];
    }
    /**
     * Spec for tool parameter key value match metric.
     */
    export interface Schema$GoogleCloudAiplatformV1ToolParameterKVMatchSpec {
        /**
         * Optional. Whether to use STRICT string match on parameter values.
         */
        useStrictStringMatch?: boolean | null;
    }
    /**
     * CMLE training config. For every active learning labeling iteration, system will train a machine learning model on CMLE. The trained model will be used by data sampling algorithm to select DataItems.
     */
    export interface Schema$GoogleCloudAiplatformV1TrainingConfig {
        /**
         * The timeout hours for the CMLE training job, expressed in milli hours i.e. 1,000 value in this field means 1 hour.
         */
        timeoutTrainingMilliHours?: string | null;
    }
    /**
     * The TrainingPipeline orchestrates tasks associated with training a Model. It always executes the training task, and optionally may also export data from Vertex AI's Dataset which becomes the training input, upload the Model to Vertex AI, and evaluate the Model.
     */
    export interface Schema$GoogleCloudAiplatformV1TrainingPipeline {
        /**
         * Output only. Time when the TrainingPipeline was created.
         */
        createTime?: string | null;
        /**
         * Required. The user-defined name of this TrainingPipeline.
         */
        displayName?: string | null;
        /**
         * Customer-managed encryption key spec for a TrainingPipeline. If set, this TrainingPipeline will be secured by this key. Note: Model trained by this TrainingPipeline is also secured by this key if model_to_upload is not set separately.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Time when the TrainingPipeline entered any of the following states: `PIPELINE_STATE_SUCCEEDED`, `PIPELINE_STATE_FAILED`, `PIPELINE_STATE_CANCELLED`.
         */
        endTime?: string | null;
        /**
         * Output only. Only populated when the pipeline's state is `PIPELINE_STATE_FAILED` or `PIPELINE_STATE_CANCELLED`.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Specifies Vertex AI owned input data that may be used for training the Model. The TrainingPipeline's training_task_definition should make clear whether this config is used and if there are any special requirements on how it should be filled. If nothing about this config is mentioned in the training_task_definition, then it should be assumed that the TrainingPipeline does not depend on this configuration.
         */
        inputDataConfig?: Schema$GoogleCloudAiplatformV1InputDataConfig;
        /**
         * The labels with user-defined metadata to organize TrainingPipelines. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. The ID to use for the uploaded Model, which will become the final component of the model resource name. This value may be up to 63 characters, and valid characters are `[a-z0-9_-]`. The first character cannot be a number or hyphen.
         */
        modelId?: string | null;
        /**
         * Describes the Model that may be uploaded (via ModelService.UploadModel) by this TrainingPipeline. The TrainingPipeline's training_task_definition should make clear whether this Model description should be populated, and if there are any special requirements regarding how it should be filled. If nothing is mentioned in the training_task_definition, then it should be assumed that this field should not be filled and the training task either uploads the Model without a need of this information, or that training task does not support uploading a Model as part of the pipeline. When the Pipeline's state becomes `PIPELINE_STATE_SUCCEEDED` and the trained Model had been uploaded into Vertex AI, then the model_to_upload's resource name is populated. The Model is always uploaded into the Project and Location in which this pipeline is.
         */
        modelToUpload?: Schema$GoogleCloudAiplatformV1Model;
        /**
         * Output only. Resource name of the TrainingPipeline.
         */
        name?: string | null;
        /**
         * Optional. When specify this field, the `model_to_upload` will not be uploaded as a new model, instead, it will become a new version of this `parent_model`.
         */
        parentModel?: string | null;
        /**
         * Output only. Time when the TrainingPipeline for the first time entered the `PIPELINE_STATE_RUNNING` state.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the pipeline.
         */
        state?: string | null;
        /**
         * Required. A Google Cloud Storage path to the YAML file that defines the training task which is responsible for producing the model artifact, and may also include additional auxiliary work. The definition files that can be used here are found in gs://google-cloud-aiplatform/schema/trainingjob/definition/. Note: The URI given on output will be immutable and probably different, including the URI scheme, than the one given on input. The output URI will point to a location where the user only has a read access.
         */
        trainingTaskDefinition?: string | null;
        /**
         * Required. The training task's parameter(s), as specified in the training_task_definition's `inputs`.
         */
        trainingTaskInputs?: any | null;
        /**
         * Output only. The metadata information as specified in the training_task_definition's `metadata`. This metadata is an auxiliary runtime and final information about the training task. While the pipeline is running this information is populated only at a best effort basis. Only present if the pipeline's training_task_definition contains `metadata` object.
         */
        trainingTaskMetadata?: any | null;
        /**
         * Output only. Time when the TrainingPipeline was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * Spec for trajectory.
     */
    export interface Schema$GoogleCloudAiplatformV1Trajectory {
        /**
         * Required. Tool calls in the trajectory.
         */
        toolCalls?: Schema$GoogleCloudAiplatformV1ToolCall[];
    }
    /**
     * Instances and metric spec for TrajectoryAnyOrderMatch metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchInput {
        /**
         * Required. Repeated TrajectoryAnyOrderMatch instance.
         */
        instances?: Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchInstance[];
        /**
         * Required. Spec for TrajectoryAnyOrderMatch metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchSpec;
    }
    /**
     * Spec for TrajectoryAnyOrderMatch instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchInstance {
        /**
         * Required. Spec for predicted tool call trajectory.
         */
        predictedTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
        /**
         * Required. Spec for reference tool call trajectory.
         */
        referenceTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
    }
    /**
     * TrajectoryAnyOrderMatch metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchMetricValue {
        /**
         * Output only. TrajectoryAnyOrderMatch score.
         */
        score?: number | null;
    }
    /**
     * Results for TrajectoryAnyOrderMatch metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchResults {
        /**
         * Output only. TrajectoryAnyOrderMatch metric values.
         */
        trajectoryAnyOrderMatchMetricValues?: Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchMetricValue[];
    }
    /**
     * Spec for TrajectoryAnyOrderMatch metric - returns 1 if all tool calls in the reference trajectory appear in the predicted trajectory in any order, else 0.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryAnyOrderMatchSpec {
    }
    /**
     * Instances and metric spec for TrajectoryExactMatch metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryExactMatchInput {
        /**
         * Required. Repeated TrajectoryExactMatch instance.
         */
        instances?: Schema$GoogleCloudAiplatformV1TrajectoryExactMatchInstance[];
        /**
         * Required. Spec for TrajectoryExactMatch metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1TrajectoryExactMatchSpec;
    }
    /**
     * Spec for TrajectoryExactMatch instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryExactMatchInstance {
        /**
         * Required. Spec for predicted tool call trajectory.
         */
        predictedTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
        /**
         * Required. Spec for reference tool call trajectory.
         */
        referenceTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
    }
    /**
     * TrajectoryExactMatch metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryExactMatchMetricValue {
        /**
         * Output only. TrajectoryExactMatch score.
         */
        score?: number | null;
    }
    /**
     * Results for TrajectoryExactMatch metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryExactMatchResults {
        /**
         * Output only. TrajectoryExactMatch metric values.
         */
        trajectoryExactMatchMetricValues?: Schema$GoogleCloudAiplatformV1TrajectoryExactMatchMetricValue[];
    }
    /**
     * Spec for TrajectoryExactMatch metric - returns 1 if tool calls in the reference trajectory exactly match the predicted trajectory, else 0.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryExactMatchSpec {
    }
    /**
     * Instances and metric spec for TrajectoryInOrderMatch metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchInput {
        /**
         * Required. Repeated TrajectoryInOrderMatch instance.
         */
        instances?: Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchInstance[];
        /**
         * Required. Spec for TrajectoryInOrderMatch metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchSpec;
    }
    /**
     * Spec for TrajectoryInOrderMatch instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchInstance {
        /**
         * Required. Spec for predicted tool call trajectory.
         */
        predictedTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
        /**
         * Required. Spec for reference tool call trajectory.
         */
        referenceTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
    }
    /**
     * TrajectoryInOrderMatch metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchMetricValue {
        /**
         * Output only. TrajectoryInOrderMatch score.
         */
        score?: number | null;
    }
    /**
     * Results for TrajectoryInOrderMatch metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchResults {
        /**
         * Output only. TrajectoryInOrderMatch metric values.
         */
        trajectoryInOrderMatchMetricValues?: Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchMetricValue[];
    }
    /**
     * Spec for TrajectoryInOrderMatch metric - returns 1 if tool calls in the reference trajectory appear in the predicted trajectory in the same order, else 0.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryInOrderMatchSpec {
    }
    /**
     * Instances and metric spec for TrajectoryPrecision metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryPrecisionInput {
        /**
         * Required. Repeated TrajectoryPrecision instance.
         */
        instances?: Schema$GoogleCloudAiplatformV1TrajectoryPrecisionInstance[];
        /**
         * Required. Spec for TrajectoryPrecision metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1TrajectoryPrecisionSpec;
    }
    /**
     * Spec for TrajectoryPrecision instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryPrecisionInstance {
        /**
         * Required. Spec for predicted tool call trajectory.
         */
        predictedTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
        /**
         * Required. Spec for reference tool call trajectory.
         */
        referenceTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
    }
    /**
     * TrajectoryPrecision metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryPrecisionMetricValue {
        /**
         * Output only. TrajectoryPrecision score.
         */
        score?: number | null;
    }
    /**
     * Results for TrajectoryPrecision metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryPrecisionResults {
        /**
         * Output only. TrajectoryPrecision metric values.
         */
        trajectoryPrecisionMetricValues?: Schema$GoogleCloudAiplatformV1TrajectoryPrecisionMetricValue[];
    }
    /**
     * Spec for TrajectoryPrecision metric - returns a float score based on average precision of individual tool calls.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryPrecisionSpec {
    }
    /**
     * Instances and metric spec for TrajectoryRecall metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryRecallInput {
        /**
         * Required. Repeated TrajectoryRecall instance.
         */
        instances?: Schema$GoogleCloudAiplatformV1TrajectoryRecallInstance[];
        /**
         * Required. Spec for TrajectoryRecall metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1TrajectoryRecallSpec;
    }
    /**
     * Spec for TrajectoryRecall instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryRecallInstance {
        /**
         * Required. Spec for predicted tool call trajectory.
         */
        predictedTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
        /**
         * Required. Spec for reference tool call trajectory.
         */
        referenceTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
    }
    /**
     * TrajectoryRecall metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryRecallMetricValue {
        /**
         * Output only. TrajectoryRecall score.
         */
        score?: number | null;
    }
    /**
     * Results for TrajectoryRecall metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryRecallResults {
        /**
         * Output only. TrajectoryRecall metric values.
         */
        trajectoryRecallMetricValues?: Schema$GoogleCloudAiplatformV1TrajectoryRecallMetricValue[];
    }
    /**
     * Spec for TrajectoryRecall metric - returns a float score based on average recall of individual tool calls.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectoryRecallSpec {
    }
    /**
     * Instances and metric spec for TrajectorySingleToolUse metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseInput {
        /**
         * Required. Repeated TrajectorySingleToolUse instance.
         */
        instances?: Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseInstance[];
        /**
         * Required. Spec for TrajectorySingleToolUse metric.
         */
        metricSpec?: Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseSpec;
    }
    /**
     * Spec for TrajectorySingleToolUse instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseInstance {
        /**
         * Required. Spec for predicted tool call trajectory.
         */
        predictedTrajectory?: Schema$GoogleCloudAiplatformV1Trajectory;
    }
    /**
     * TrajectorySingleToolUse metric value for an instance.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseMetricValue {
        /**
         * Output only. TrajectorySingleToolUse score.
         */
        score?: number | null;
    }
    /**
     * Results for TrajectorySingleToolUse metric.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseResults {
        /**
         * Output only. TrajectorySingleToolUse metric values.
         */
        trajectorySingleToolUseMetricValues?: Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseMetricValue[];
    }
    /**
     * Spec for TrajectorySingleToolUse metric - returns 1 if tool is present in the predicted trajectory, else 0.
     */
    export interface Schema$GoogleCloudAiplatformV1TrajectorySingleToolUseSpec {
        /**
         * Required. Spec for tool name to be checked for in the predicted trajectory.
         */
        toolName?: string | null;
    }
    /**
     * A message representing a Trial. A Trial contains a unique set of Parameters that has been or will be evaluated, along with the objective metrics got by running the Trial.
     */
    export interface Schema$GoogleCloudAiplatformV1Trial {
        /**
         * Output only. The identifier of the client that originally requested this Trial. Each client is identified by a unique client_id. When a client asks for a suggestion, Vertex AI Vizier will assign it a Trial. The client should evaluate the Trial, complete it, and report back to Vertex AI Vizier. If suggestion is asked again by same client_id before the Trial is completed, the same Trial will be returned. Multiple clients with different client_ids can ask for suggestions simultaneously, each of them will get their own Trial.
         */
        clientId?: string | null;
        /**
         * Output only. The CustomJob name linked to the Trial. It's set for a HyperparameterTuningJob's Trial.
         */
        customJob?: string | null;
        /**
         * Output only. Time when the Trial's status changed to `SUCCEEDED` or `INFEASIBLE`.
         */
        endTime?: string | null;
        /**
         * Output only. The final measurement containing the objective value.
         */
        finalMeasurement?: Schema$GoogleCloudAiplatformV1Measurement;
        /**
         * Output only. The identifier of the Trial assigned by the service.
         */
        id?: string | null;
        /**
         * Output only. A human readable string describing why the Trial is infeasible. This is set only if Trial state is `INFEASIBLE`.
         */
        infeasibleReason?: string | null;
        /**
         * Output only. A list of measurements that are strictly lexicographically ordered by their induced tuples (steps, elapsed_duration). These are used for early stopping computations.
         */
        measurements?: Schema$GoogleCloudAiplatformV1Measurement[];
        /**
         * Output only. Resource name of the Trial assigned by the service.
         */
        name?: string | null;
        /**
         * Output only. The parameters of the Trial.
         */
        parameters?: Schema$GoogleCloudAiplatformV1TrialParameter[];
        /**
         * Output only. Time when the Trial was started.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the Trial.
         */
        state?: string | null;
        /**
         * Output only. URIs for accessing [interactive shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell) (one URI for each training node). Only available if this trial is part of a HyperparameterTuningJob and the job's trial_job_spec.enable_web_access field is `true`. The keys are names of each node used for the trial; for example, `workerpool0-0` for the primary node, `workerpool1-0` for the first node in the second worker pool, and `workerpool1-1` for the second node in the second worker pool. The values are the URIs for each node's interactive shell.
         */
        webAccessUris?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GoogleCloudAiplatformV1TrialContext {
        /**
         * A human-readable field which can store a description of this context. This will become part of the resulting Trial's description field.
         */
        description?: string | null;
        /**
         * If/when a Trial is generated or selected from this Context, its Parameters will match any parameters specified here. (I.e. if this context specifies parameter name:'a' int_value:3, then a resulting Trial will have int_value:3 for its parameter named 'a'.) Note that we first attempt to match existing REQUESTED Trials with contexts, and if there are no matches, we generate suggestions in the subspace defined by the parameters specified here. NOTE: a Context without any Parameters matches the entire feasible search space.
         */
        parameters?: Schema$GoogleCloudAiplatformV1TrialParameter[];
    }
    /**
     * A message representing a parameter to be tuned.
     */
    export interface Schema$GoogleCloudAiplatformV1TrialParameter {
        /**
         * Output only. The ID of the parameter. The parameter should be defined in StudySpec's Parameters.
         */
        parameterId?: string | null;
        /**
         * Output only. The value of the parameter. `number_value` will be set if a parameter defined in StudySpec is in type 'INTEGER', 'DOUBLE' or 'DISCRETE'. `string_value` will be set if a parameter defined in StudySpec is in type 'CATEGORICAL'.
         */
        value?: any | null;
    }
    /**
     * The Model Registry Model and Online Prediction Endpoint associated with this TuningJob.
     */
    export interface Schema$GoogleCloudAiplatformV1TunedModel {
        /**
         * Output only. A resource name of an Endpoint. Format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`.
         */
        endpoint?: string | null;
        /**
         * Output only. The resource name of the TunedModel. Format: `projects/{project\}/locations/{location\}/models/{model\}`.
         */
        model?: string | null;
    }
    /**
     * TunedModel Reference for legacy model migration.
     */
    export interface Schema$GoogleCloudAiplatformV1TunedModelRef {
        /**
         * Support migration from tuning job list page, from bison model to gemini model.
         */
        pipelineJob?: string | null;
        /**
         * Support migration from model registry.
         */
        tunedModel?: string | null;
        /**
         * Support migration from tuning job list page, from gemini-1.0-pro-002 to 1.5 and above.
         */
        tuningJob?: string | null;
    }
    /**
     * The tuning data statistic values for TuningJob.
     */
    export interface Schema$GoogleCloudAiplatformV1TuningDataStats {
        /**
         * The SFT Tuning data stats.
         */
        supervisedTuningDataStats?: Schema$GoogleCloudAiplatformV1SupervisedTuningDataStats;
    }
    /**
     * Represents a TuningJob that runs with Google owned models.
     */
    export interface Schema$GoogleCloudAiplatformV1TuningJob {
        /**
         * The base model that is being tuned. See [Supported models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
         */
        baseModel?: string | null;
        /**
         * Output only. Time when the TuningJob was created.
         */
        createTime?: string | null;
        /**
         * Optional. The description of the TuningJob.
         */
        description?: string | null;
        /**
         * Customer-managed encryption key options for a TuningJob. If this is set, then all resources created by the TuningJob will be encrypted with the provided encryption key.
         */
        encryptionSpec?: Schema$GoogleCloudAiplatformV1EncryptionSpec;
        /**
         * Output only. Time when the TuningJob entered any of the following JobStates: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
         */
        endTime?: string | null;
        /**
         * Output only. Only populated when job's state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The Experiment associated with this TuningJob.
         */
        experiment?: string | null;
        /**
         * Optional. The labels with user-defined metadata to organize TuningJob and generated resources such as Model and Endpoint. Label keys and values can be no longer than 64 characters (Unicode codepoints), can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. See https://goo.gl/xmQnxf for more information and examples of labels.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Output only. Identifier. Resource name of a TuningJob. Format: `projects/{project\}/locations/{location\}/tuningJobs/{tuning_job\}`
         */
        name?: string | null;
        /**
         * The service account that the tuningJob workload runs as. If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the project will be used. See https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent Users starting the pipeline must have the `iam.serviceAccounts.actAs` permission on this service account.
         */
        serviceAccount?: string | null;
        /**
         * Output only. Time when the TuningJob for the first time entered the `JOB_STATE_RUNNING` state.
         */
        startTime?: string | null;
        /**
         * Output only. The detailed state of the job.
         */
        state?: string | null;
        /**
         * Tuning Spec for Supervised Fine Tuning.
         */
        supervisedTuningSpec?: Schema$GoogleCloudAiplatformV1SupervisedTuningSpec;
        /**
         * Output only. The tuned model resources associated with this TuningJob.
         */
        tunedModel?: Schema$GoogleCloudAiplatformV1TunedModel;
        /**
         * Optional. The display name of the TunedModel. The name can be up to 128 characters long and can consist of any UTF-8 characters.
         */
        tunedModelDisplayName?: string | null;
        /**
         * Output only. The tuning data statistics associated with this TuningJob.
         */
        tuningDataStats?: Schema$GoogleCloudAiplatformV1TuningDataStats;
        /**
         * Output only. Time when the TuningJob was most recently updated.
         */
        updateTime?: string | null;
    }
    /**
     * Runtime operation information for IndexEndpointService.UndeployIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1UndeployIndexOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for IndexEndpointService.UndeployIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1UndeployIndexRequest {
        /**
         * Required. The ID of the DeployedIndex to be undeployed from the IndexEndpoint.
         */
        deployedIndexId?: string | null;
    }
    /**
     * Response message for IndexEndpointService.UndeployIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1UndeployIndexResponse {
    }
    /**
     * Runtime operation information for EndpointService.UndeployModel.
     */
    export interface Schema$GoogleCloudAiplatformV1UndeployModelOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for EndpointService.UndeployModel.
     */
    export interface Schema$GoogleCloudAiplatformV1UndeployModelRequest {
        /**
         * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
         */
        deployedModelId?: string | null;
        /**
         * If this field is provided, then the Endpoint's traffic_split will be overwritten with it. If last DeployedModel is being undeployed from the Endpoint, the [Endpoint.traffic_split] will always end up empty when this call returns. A DeployedModel will be successfully undeployed only if it doesn't have any traffic assigned to it when this method executes, or if this field unassigns any traffic to it.
         */
        trafficSplit?: {
            [key: string]: number;
        } | null;
    }
    /**
     * Response message for EndpointService.UndeployModel.
     */
    export interface Schema$GoogleCloudAiplatformV1UndeployModelResponse {
    }
    /**
     * Contains model information necessary to perform batch prediction without requiring a full model import.
     */
    export interface Schema$GoogleCloudAiplatformV1UnmanagedContainerModel {
        /**
         * The path to the directory containing the Model artifact and any of its supporting files.
         */
        artifactUri?: string | null;
        /**
         * Input only. The specification of the container that is to be used when deploying this Model.
         */
        containerSpec?: Schema$GoogleCloudAiplatformV1ModelContainerSpec;
        /**
         * Contains the schemata used in Model's predictions and explanations
         */
        predictSchemata?: Schema$GoogleCloudAiplatformV1PredictSchemata;
    }
    /**
     * Runtime operation information for UpdateDeploymentResourcePool method.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateDeploymentResourcePoolOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for EndpointService.UpdateEndpointLongRunning.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateEndpointLongRunningRequest {
        /**
         * Required. The Endpoint which replaces the resource on the server. Currently we only support updating the `client_connection_config` field, all the other fields' update will be blocked.
         */
        endpoint?: Schema$GoogleCloudAiplatformV1Endpoint;
    }
    /**
     * Runtime operation information for ModelService.UpdateExplanationDataset.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateExplanationDatasetOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for ModelService.UpdateExplanationDataset.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateExplanationDatasetRequest {
        /**
         * The example config containing the location of the dataset.
         */
        examples?: Schema$GoogleCloudAiplatformV1Examples;
    }
    /**
     * Response message of ModelService.UpdateExplanationDataset operation.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateExplanationDatasetResponse {
    }
    /**
     * Details of operations that perform update FeatureGroup.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateFeatureGroupOperationMetadata {
        /**
         * Operation metadata for FeatureGroup.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform update FeatureOnlineStore.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateFeatureOnlineStoreOperationMetadata {
        /**
         * Operation metadata for FeatureOnlineStore.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform update Feature.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateFeatureOperationMetadata {
        /**
         * Operation metadata for Feature Update.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform update Featurestore.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateFeaturestoreOperationMetadata {
        /**
         * Operation metadata for Featurestore.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform update FeatureView.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateFeatureViewOperationMetadata {
        /**
         * Operation metadata for FeatureView Update.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Runtime operation information for IndexService.UpdateIndex.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateIndexOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * The operation metadata with regard to Matching Engine Index operation.
         */
        nearestNeighborSearchOperationMetadata?: Schema$GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata;
    }
    /**
     * Runtime operation information for JobService.UpdateModelDeploymentMonitoringJob.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateModelDeploymentMonitoringJobOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Details of operations that perform update PersistentResource.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdatePersistentResourceOperationMetadata {
        /**
         * Operation metadata for PersistentResource.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * Progress Message for Update LRO
         */
        progressMessage?: string | null;
    }
    /**
     * Runtime operation metadata for SpecialistPoolService.UpdateSpecialistPool.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateSpecialistPoolOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * Output only. The name of the SpecialistPool to which the specialists are being added. Format: `projects/{project_id\}/locations/{location_id\}/specialistPools/{specialist_pool\}`
         */
        specialistPool?: string | null;
    }
    /**
     * Details of operations that perform update Tensorboard.
     */
    export interface Schema$GoogleCloudAiplatformV1UpdateTensorboardOperationMetadata {
        /**
         * Operation metadata for Tensorboard.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Metadata information for NotebookService.UpgradeNotebookRuntime.
     */
    export interface Schema$GoogleCloudAiplatformV1UpgradeNotebookRuntimeOperationMetadata {
        /**
         * The operation generic information.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
        /**
         * A human-readable message that shows the intermediate progress details of NotebookRuntime.
         */
        progressMessage?: string | null;
    }
    /**
     * Request message for NotebookService.UpgradeNotebookRuntime.
     */
    export interface Schema$GoogleCloudAiplatformV1UpgradeNotebookRuntimeRequest {
    }
    /**
     * Details of ModelService.UploadModel operation.
     */
    export interface Schema$GoogleCloudAiplatformV1UploadModelOperationMetadata {
        /**
         * The common part of the operation metadata.
         */
        genericMetadata?: Schema$GoogleCloudAiplatformV1GenericOperationMetadata;
    }
    /**
     * Request message for ModelService.UploadModel.
     */
    export interface Schema$GoogleCloudAiplatformV1UploadModelRequest {
        /**
         * Required. The Model to create.
         */
        model?: Schema$GoogleCloudAiplatformV1Model;
        /**
         * Optional. The ID to use for the uploaded Model, which will become the final component of the model resource name. This value may be up to 63 characters, and valid characters are `[a-z0-9_-]`. The first character cannot be a number or hyphen.
         */
        modelId?: string | null;
        /**
         * Optional. The resource name of the model into which to upload the version. Only specify this field when uploading a new version.
         */
        parentModel?: string | null;
        /**
         * Optional. The user-provided custom service account to use to do the model upload. If empty, [Vertex AI Service Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents) will be used to access resources needed to upload the model. This account must belong to the target project where the model is uploaded to, i.e., the project specified in the `parent` field of this request and have necessary read permissions (to Google Cloud Storage, Artifact Registry, etc.).
         */
        serviceAccount?: string | null;
    }
    /**
     * Response message of ModelService.UploadModel operation.
     */
    export interface Schema$GoogleCloudAiplatformV1UploadModelResponse {
        /**
         * The name of the uploaded Model resource. Format: `projects/{project\}/locations/{location\}/models/{model\}`
         */
        model?: string | null;
        /**
         * Output only. The version ID of the model that is uploaded.
         */
        modelVersionId?: string | null;
    }
    /**
     * Config for uploading RagFile.
     */
    export interface Schema$GoogleCloudAiplatformV1UploadRagFileConfig {
        /**
         * Specifies the transformation config for RagFiles.
         */
        ragFileTransformationConfig?: Schema$GoogleCloudAiplatformV1RagFileTransformationConfig;
    }
    /**
     * Request message for VertexRagDataService.UploadRagFile.
     */
    export interface Schema$GoogleCloudAiplatformV1UploadRagFileRequest {
        /**
         * Required. The RagFile to upload.
         */
        ragFile?: Schema$GoogleCloudAiplatformV1RagFile;
        /**
         * Required. The config for the RagFiles to be uploaded into the RagCorpus. VertexRagDataService.UploadRagFile.
         */
        uploadRagFileConfig?: Schema$GoogleCloudAiplatformV1UploadRagFileConfig;
    }
    /**
     * Response message for VertexRagDataService.UploadRagFile.
     */
    export interface Schema$GoogleCloudAiplatformV1UploadRagFileResponse {
        /**
         * The error that occurred while processing the RagFile.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The RagFile that had been uploaded into the RagCorpus.
         */
        ragFile?: Schema$GoogleCloudAiplatformV1RagFile;
    }
    /**
     * Request message for IndexService.UpsertDatapoints
     */
    export interface Schema$GoogleCloudAiplatformV1UpsertDatapointsRequest {
        /**
         * A list of datapoints to be created/updated.
         */
        datapoints?: Schema$GoogleCloudAiplatformV1IndexDatapoint[];
        /**
         * Optional. Update mask is used to specify the fields to be overwritten in the datapoints by the update. The fields specified in the update_mask are relative to each IndexDatapoint inside datapoints, not the full request. Updatable fields: * Use `all_restricts` to update both restricts and numeric_restricts.
         */
        updateMask?: string | null;
    }
    /**
     * Response message for IndexService.UpsertDatapoints
     */
    export interface Schema$GoogleCloudAiplatformV1UpsertDatapointsResponse {
    }
    /**
     * References an API call. It contains more information about long running operation and Jobs that are triggered by the API call.
     */
    export interface Schema$GoogleCloudAiplatformV1UserActionReference {
        /**
         * For API calls that start a LabelingJob. Resource name of the LabelingJob. Format: `projects/{project\}/locations/{location\}/dataLabelingJobs/{data_labeling_job\}`
         */
        dataLabelingJob?: string | null;
        /**
         * The method name of the API RPC call. For example, "/google.cloud.aiplatform.{apiVersion\}.DatasetService.CreateDataset"
         */
        method?: string | null;
        /**
         * For API calls that return a long running operation. Resource name of the long running operation. Format: `projects/{project\}/locations/{location\}/operations/{operation\}`
         */
        operation?: string | null;
    }
    /**
     * Value is the value of the field.
     */
    export interface Schema$GoogleCloudAiplatformV1Value {
        /**
         * A double value.
         */
        doubleValue?: number | null;
        /**
         * An integer value.
         */
        intValue?: string | null;
        /**
         * A string value.
         */
        stringValue?: string | null;
    }
    /**
     * Retrieve from Vertex AI Search datastore or engine for grounding. datastore and engine are mutually exclusive. See https://cloud.google.com/products/agent-builder
     */
    export interface Schema$GoogleCloudAiplatformV1VertexAISearch {
        /**
         * Optional. Fully-qualified Vertex AI Search data store resource ID. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{dataStore\}`
         */
        datastore?: string | null;
        /**
         * Optional. Fully-qualified Vertex AI Search engine resource ID. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}`
         */
        engine?: string | null;
    }
    /**
     * Config for the Vertex AI Search.
     */
    export interface Schema$GoogleCloudAiplatformV1VertexAiSearchConfig {
        /**
         * Vertex AI Search Serving Config resource full name. For example, `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}/servingConfigs/{serving_config\}` or `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/servingConfigs/{serving_config\}`.
         */
        servingConfig?: string | null;
    }
    /**
     * Retrieve from Vertex RAG Store for grounding.
     */
    export interface Schema$GoogleCloudAiplatformV1VertexRagStore {
        /**
         * Optional. The representation of the rag source. It can be used to specify corpus only or ragfiles. Currently only support one corpus or multiple files from one corpus. In the future we may open up multiple corpora support.
         */
        ragResources?: Schema$GoogleCloudAiplatformV1VertexRagStoreRagResource[];
        /**
         * Optional. The retrieval config for the Rag query.
         */
        ragRetrievalConfig?: Schema$GoogleCloudAiplatformV1RagRetrievalConfig;
        /**
         * Optional. Number of top k results to return from the selected corpora.
         */
        similarityTopK?: number | null;
        /**
         * Optional. Only return results with vector distance smaller than the threshold.
         */
        vectorDistanceThreshold?: number | null;
    }
    /**
     * The definition of the Rag resource.
     */
    export interface Schema$GoogleCloudAiplatformV1VertexRagStoreRagResource {
        /**
         * Optional. RagCorpora resource name. Format: `projects/{project\}/locations/{location\}/ragCorpora/{rag_corpus\}`
         */
        ragCorpus?: string | null;
        /**
         * Optional. rag_file_id. The files should be in the same rag_corpus set in rag_corpus field.
         */
        ragFileIds?: string[] | null;
    }
    /**
     * Metadata describes the input video content.
     */
    export interface Schema$GoogleCloudAiplatformV1VideoMetadata {
        /**
         * Optional. The end offset of the video.
         */
        endOffset?: string | null;
        /**
         * Optional. The start offset of the video.
         */
        startOffset?: string | null;
    }
    /**
     * The configuration for the voice to use.
     */
    export interface Schema$GoogleCloudAiplatformV1VoiceConfig {
        /**
         * The configuration for the prebuilt voice to use.
         */
        prebuiltVoiceConfig?: Schema$GoogleCloudAiplatformV1PrebuiltVoiceConfig;
    }
    /**
     * Represents the spec of a worker pool in a job.
     */
    export interface Schema$GoogleCloudAiplatformV1WorkerPoolSpec {
        /**
         * The custom container task.
         */
        containerSpec?: Schema$GoogleCloudAiplatformV1ContainerSpec;
        /**
         * Disk spec.
         */
        diskSpec?: Schema$GoogleCloudAiplatformV1DiskSpec;
        /**
         * Optional. Immutable. The specification of a single machine.
         */
        machineSpec?: Schema$GoogleCloudAiplatformV1MachineSpec;
        /**
         * Optional. List of NFS mount spec.
         */
        nfsMounts?: Schema$GoogleCloudAiplatformV1NfsMount[];
        /**
         * The Python packaged task.
         */
        pythonPackageSpec?: Schema$GoogleCloudAiplatformV1PythonPackageSpec;
        /**
         * Optional. The number of worker replicas to use for this worker pool.
         */
        replicaCount?: string | null;
    }
    /**
     * Contains Feature values to be written for a specific entity.
     */
    export interface Schema$GoogleCloudAiplatformV1WriteFeatureValuesPayload {
        /**
         * Required. The ID of the entity.
         */
        entityId?: string | null;
        /**
         * Required. Feature values to be written, mapping from Feature ID to value. Up to 100,000 `feature_values` entries may be written across all payloads. The feature generation time, aligned by days, must be no older than five years (1825 days) and no later than one year (366 days) in the future.
         */
        featureValues?: {
            [key: string]: Schema$GoogleCloudAiplatformV1FeatureValue;
        } | null;
    }
    /**
     * Request message for FeaturestoreOnlineServingService.WriteFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1WriteFeatureValuesRequest {
        /**
         * Required. The entities to be written. Up to 100,000 feature values can be written across all `payloads`.
         */
        payloads?: Schema$GoogleCloudAiplatformV1WriteFeatureValuesPayload[];
    }
    /**
     * Response message for FeaturestoreOnlineServingService.WriteFeatureValues.
     */
    export interface Schema$GoogleCloudAiplatformV1WriteFeatureValuesResponse {
    }
    /**
     * Request message for TensorboardService.WriteTensorboardExperimentData.
     */
    export interface Schema$GoogleCloudAiplatformV1WriteTensorboardExperimentDataRequest {
        /**
         * Required. Requests containing per-run TensorboardTimeSeries data to write.
         */
        writeRunDataRequests?: Schema$GoogleCloudAiplatformV1WriteTensorboardRunDataRequest[];
    }
    /**
     * Response message for TensorboardService.WriteTensorboardExperimentData.
     */
    export interface Schema$GoogleCloudAiplatformV1WriteTensorboardExperimentDataResponse {
    }
    /**
     * Request message for TensorboardService.WriteTensorboardRunData.
     */
    export interface Schema$GoogleCloudAiplatformV1WriteTensorboardRunDataRequest {
        /**
         * Required. The resource name of the TensorboardRun to write data to. Format: `projects/{project\}/locations/{location\}/tensorboards/{tensorboard\}/experiments/{experiment\}/runs/{run\}`
         */
        tensorboardRun?: string | null;
        /**
         * Required. The TensorboardTimeSeries data to write. Values with in a time series are indexed by their step value. Repeated writes to the same step will overwrite the existing value for that step. The upper limit of data points per write request is 5000.
         */
        timeSeriesData?: Schema$GoogleCloudAiplatformV1TimeSeriesData[];
    }
    /**
     * Response message for TensorboardService.WriteTensorboardRunData.
     */
    export interface Schema$GoogleCloudAiplatformV1WriteTensorboardRunDataResponse {
    }
    /**
     * An explanation method that redistributes Integrated Gradients attributions to segmented regions, taking advantage of the model's fully differentiable structure. Refer to this paper for more details: https://arxiv.org/abs/1906.02825 Supported only by image Models.
     */
    export interface Schema$GoogleCloudAiplatformV1XraiAttribution {
        /**
         * Config for XRAI with blur baseline. When enabled, a linear path from the maximally blurred image to the input image is created. Using a blurred baseline instead of zero (black image) is motivated by the BlurIG approach explained here: https://arxiv.org/abs/2004.03383
         */
        blurBaselineConfig?: Schema$GoogleCloudAiplatformV1BlurBaselineConfig;
        /**
         * Config for SmoothGrad approximation of gradients. When enabled, the gradients are approximated by averaging the gradients from noisy samples in the vicinity of the inputs. Adding noise can help improve the computed gradients. Refer to this paper for more details: https://arxiv.org/pdf/1706.03825.pdf
         */
        smoothGradConfig?: Schema$GoogleCloudAiplatformV1SmoothGradConfig;
        /**
         * Required. The number of steps for approximating the path integral. A good value to start is 50 and gradually increase until the sum to diff property is met within the desired error range. Valid range of its value is [1, 100], inclusively.
         */
        stepCount?: number | null;
    }
    /**
     * The response message for Locations.ListLocations.
     */
    export interface Schema$GoogleCloudLocationListLocationsResponse {
        /**
         * A list of locations that matches the specified filter in the request.
         */
        locations?: Schema$GoogleCloudLocationLocation[];
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * A resource that represents a Google Cloud location.
     */
    export interface Schema$GoogleCloudLocationLocation {
        /**
         * The friendly name for this location, typically a nearby city name. For example, "Tokyo".
         */
        displayName?: string | null;
        /**
         * Cross-service attributes for the location. For example {"cloud.googleapis.com/region": "us-east1"\}
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * The canonical id for this location. For example: `"us-east1"`.
         */
        locationId?: string | null;
        /**
         * Service-specific metadata. For example the available capacity at the given location.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * Resource name for the location, which may vary between implementations. For example: `"projects/example-project/locations/us-east1"`
         */
        name?: string | null;
    }
    /**
     * Associates `members`, or principals, with a `role`.
     */
    export interface Schema$GoogleIamV1Binding {
        /**
         * The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        condition?: Schema$GoogleTypeExpr;
        /**
         * Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid\}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid\}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid\}.svc.id.goog[{namespace\}/{kubernetes-sa\}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid\}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain\}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/subject/{subject_attribute_value\}`: A single identity in a workforce identity pool. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/group/{group_id\}`: All workforce identities in a group. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/attribute.{attribute_name\}/{attribute_value\}`: All workforce identities with a specific attribute value. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/x`: All identities in a workforce identity pool. * `principal://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/subject/{subject_attribute_value\}`: A single identity in a workload identity pool. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/group/{group_id\}`: A workload identity pool group. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/attribute.{attribute_name\}/{attribute_value\}`: All identities in a workload identity pool with a certain attribute. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/x`: All identities in a workload identity pool. * `deleted:user:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid\}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid\}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid\}` and the recovered group retains the role in the binding. * `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/subject/{subject_attribute_value\}`: Deleted single identity in a workforce identity pool. For example, `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-pool-id/subject/my-subject-attribute-value`.
         */
        members?: string[] | null;
        /**
         * Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview of the IAM roles and permissions, see the [IAM documentation](https://cloud.google.com/iam/docs/roles-overview). For a list of the available pre-defined roles, see [here](https://cloud.google.com/iam/docs/understanding-roles).
         */
        role?: string | null;
    }
    /**
     * An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources. A `Policy` is a collection of `bindings`. A `binding` binds one or more `members`, or principals, to a single `role`. Principals can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role. For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies). **JSON example:** ``` { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] \}, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve@example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')", \} \} ], "etag": "BwWWja0YfJA=", "version": 3 \} ``` **YAML example:** ``` bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve@example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
     */
    export interface Schema$GoogleIamV1Policy {
        /**
         * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
         */
        bindings?: Schema$GoogleIamV1Binding[];
        /**
         * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
         */
        etag?: string | null;
        /**
         * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        version?: number | null;
    }
    /**
     * Request message for `SetIamPolicy` method.
     */
    export interface Schema$GoogleIamV1SetIamPolicyRequest {
        /**
         * REQUIRED: The complete policy to be applied to the `resource`. The size of the policy is limited to a few 10s of KB. An empty policy is a valid policy but certain Google Cloud services (such as Projects) might reject them.
         */
        policy?: Schema$GoogleIamV1Policy;
    }
    /**
     * Response message for `TestIamPermissions` method.
     */
    export interface Schema$GoogleIamV1TestIamPermissionsResponse {
        /**
         * A subset of `TestPermissionsRequest.permissions` that the caller is allowed.
         */
        permissions?: string[] | null;
    }
    /**
     * The response message for Operations.ListOperations.
     */
    export interface Schema$GoogleLongrunningListOperationsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
        /**
         * A list of operations that matches the specified filter in the request.
         */
        operations?: Schema$GoogleLongrunningOperation[];
    }
    /**
     * This resource represents a long-running operation that is the result of a network API call.
     */
    export interface Schema$GoogleLongrunningOperation {
        /**
         * If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
         */
        done?: boolean | null;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id\}`.
         */
        name?: string | null;
        /**
         * The normal, successful response of the operation. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        } | null;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); \}
     */
    export interface Schema$GoogleProtobufEmpty {
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$GoogleRpcStatus {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number | null;
        /**
         * A list of messages that carry the error details. There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }> | null;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string | null;
    }
    /**
     * Represents a color in the RGBA color space. This representation is designed for simplicity of conversion to and from color representations in various languages over compactness. For example, the fields of this representation can be trivially provided to the constructor of `java.awt.Color` in Java; it can also be trivially provided to UIColor's `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little work, it can be easily formatted into a CSS `rgba()` string in JavaScript. This reference page doesn't have information about the absolute color space that should be used to interpret the RGB value—for example, sRGB, Adobe RGB, DCI-P3, and BT.2020. By default, applications should assume the sRGB color space. When color equality needs to be decided, implementations, unless documented otherwise, treat two colors as equal if all their red, green, blue, and alpha values each differ by at most `1e-5`. Example (Java): import com.google.type.Color; // ... public static java.awt.Color fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ? protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color( protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); \} public static Color toProto(java.awt.Color color) { float red = (float) color.getRed(); float green = (float) color.getGreen(); float blue = (float) color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder = Color .newBuilder() .setRed(red / denominator) .setGreen(green / denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if (alpha != 255) { result.setAlpha( FloatValue .newBuilder() .setValue(((float) alpha) / denominator) .build()); \} return resultBuilder.build(); \} // ... Example (iOS / Obj-C): // ... static UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float green = [protocolor green]; float blue = [protocolor blue]; FloatValue* alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper != nil) { alpha = [alpha_wrapper value]; \} return [UIColor colorWithRed:red green:green blue:blue alpha:alpha]; \} static Color* toProto(UIColor* color) { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green blue:&blue alpha:&alpha]) { return nil; \} Color* result = [[Color alloc] init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue]; if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; \} [result autorelease]; return result; \} // ... Example (JavaScript): // ... var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red || 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue || 0.0; var red = Math.floor(redFrac * 255); var green = Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); \} var alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green, blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join(''); \}; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new Number((red << 16) | (green << 8) | blue); var hexString = rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) { resultBuilder.push('0'); \} resultBuilder.push(hexString); return resultBuilder.join(''); \}; // ...
     */
    export interface Schema$GoogleTypeColor {
        /**
         * The fraction of this color that should be applied to the pixel. That is, the final pixel color is defined by the equation: `pixel color = alpha * (this color) + (1.0 - alpha) * (background color)` This means that a value of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a completely transparent color. This uses a wrapper message rather than a simple float scalar so that it is possible to distinguish between a default value and the value being unset. If omitted, this color object is rendered as a solid color (as if the alpha value had been explicitly given a value of 1.0).
         */
        alpha?: number | null;
        /**
         * The amount of blue in the color as a value in the interval [0, 1].
         */
        blue?: number | null;
        /**
         * The amount of green in the color as a value in the interval [0, 1].
         */
        green?: number | null;
        /**
         * The amount of red in the color as a value in the interval [0, 1].
         */
        red?: number | null;
    }
    /**
     * Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
     */
    export interface Schema$GoogleTypeDate {
        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
         */
        day?: number | null;
        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        month?: number | null;
        /**
         * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
         */
        year?: number | null;
    }
    /**
     * Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
     */
    export interface Schema$GoogleTypeExpr {
        /**
         * Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string | null;
        /**
         * Textual representation of an expression in Common Expression Language syntax.
         */
        expression?: string | null;
        /**
         * Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
         */
        location?: string | null;
        /**
         * Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
         */
        title?: string | null;
    }
    /**
     * Represents a time interval, encoded as a Timestamp start (inclusive) and a Timestamp end (exclusive). The start must be less than or equal to the end. When the start equals the end, the interval is empty (matches no time). When both start and end are unspecified, the interval matches any time.
     */
    export interface Schema$GoogleTypeInterval {
        /**
         * Optional. Exclusive end of the interval. If specified, a Timestamp matching this interval will have to be before the end.
         */
        endTime?: string | null;
        /**
         * Optional. Inclusive start of the interval. If specified, a Timestamp matching this interval will have to be the same or after the start.
         */
        startTime?: string | null;
    }
    /**
     * An object that represents a latitude/longitude pair. This is expressed as a pair of doubles to represent degrees latitude and degrees longitude. Unless specified otherwise, this object must conform to the WGS84 standard. Values must be within normalized ranges.
     */
    export interface Schema$GoogleTypeLatLng {
        /**
         * The latitude in degrees. It must be in the range [-90.0, +90.0].
         */
        latitude?: number | null;
        /**
         * The longitude in degrees. It must be in the range [-180.0, +180.0].
         */
        longitude?: number | null;
    }
    /**
     * Represents an amount of money with its currency type.
     */
    export interface Schema$GoogleTypeMoney {
        /**
         * The three-letter currency code defined in ISO 4217.
         */
        currencyCode?: string | null;
        /**
         * Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
         */
        nanos?: number | null;
        /**
         * The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
         */
        units?: string | null;
    }
    export class Resource$Batchpredictionjobs {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a BatchPredictionJob. A BatchPredictionJob once created will right away be attempted to start.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Batchpredictionjobs$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Batchpredictionjobs$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1BatchPredictionJob>;
        create(params: Params$Resource$Batchpredictionjobs$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Batchpredictionjobs$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>): void;
        create(params: Params$Resource$Batchpredictionjobs$Create, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>): void;
        /**
         * Gets a BatchPredictionJob
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Batchpredictionjobs$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Batchpredictionjobs$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1BatchPredictionJob>;
        get(params: Params$Resource$Batchpredictionjobs$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Batchpredictionjobs$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>): void;
        get(params: Params$Resource$Batchpredictionjobs$Get, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1BatchPredictionJob>): void;
        /**
         * Lists BatchPredictionJobs in a Location.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Batchpredictionjobs$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Batchpredictionjobs$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1ListBatchPredictionJobsResponse>;
        list(params: Params$Resource$Batchpredictionjobs$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Batchpredictionjobs$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListBatchPredictionJobsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListBatchPredictionJobsResponse>): void;
        list(params: Params$Resource$Batchpredictionjobs$List, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListBatchPredictionJobsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListBatchPredictionJobsResponse>): void;
    }
    export interface Params$Resource$Batchpredictionjobs$Create extends StandardParameters {
        /**
         * Required. The resource name of the Location to create the BatchPredictionJob in. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1BatchPredictionJob;
    }
    export interface Params$Resource$Batchpredictionjobs$Get extends StandardParameters {
        /**
         * Required. The name of the BatchPredictionJob resource. Format: `projects/{project\}/locations/{location\}/batchPredictionJobs/{batch_prediction_job\}`
         */
        name?: string;
    }
    export interface Params$Resource$Batchpredictionjobs$List extends StandardParameters {
        /**
         * The standard list filter. Supported fields: * `display_name` supports `=`, `!=` comparisons, and `:` wildcard. * `model_display_name` supports `=`, `!=` comparisons. * `state` supports `=`, `!=` comparisons. * `create_time` supports `=`, `!=`,`<`, `<=`,`\>`, `\>=` comparisons. `create_time` must be in RFC 3339 format. * `labels` supports general map functions that is: `labels.key=value` - key:value equality `labels.key:* - key existence Some examples of using the filter are: * `state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"` * `state!="JOB_STATE_FAILED" OR display_name="my_job"` * `NOT display_name="my_job"` * `create_time\>"2021-05-18T00:00:00Z"` * `labels.keyA=valueA` * `labels.keyB:*`
         */
        filter?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token. Typically obtained via ListBatchPredictionJobsResponse.next_page_token of the previous JobService.ListBatchPredictionJobs call.
         */
        pageToken?: string;
        /**
         * Required. The resource name of the Location to list the BatchPredictionJobs from. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
        /**
         * Mask specifying which fields to read.
         */
        readMask?: string;
    }
    export class Resource$Datasets {
        context: APIRequestContext;
        datasetVersions: Resource$Datasets$Datasetversions;
        constructor(context: APIRequestContext);
        /**
         * Creates a Dataset.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Datasets$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Datasets$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        create(params: Params$Resource$Datasets$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Datasets$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Datasets$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deletes a Dataset.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Datasets$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Datasets$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        delete(params: Params$Resource$Datasets$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Datasets$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Datasets$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a Dataset.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Datasets$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Datasets$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1Dataset>;
        get(params: Params$Resource$Datasets$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Datasets$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>): void;
        get(params: Params$Resource$Datasets$Get, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>): void;
        /**
         * Lists Datasets in a Location.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Datasets$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Datasets$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1ListDatasetsResponse>;
        list(params: Params$Resource$Datasets$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Datasets$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetsResponse>): void;
        list(params: Params$Resource$Datasets$List, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetsResponse>): void;
        /**
         * Updates a Dataset.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Datasets$Patch, options: StreamMethodOptions): GaxiosPromise<Readable>;
        patch(params?: Params$Resource$Datasets$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1Dataset>;
        patch(params: Params$Resource$Datasets$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Datasets$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>): void;
        patch(params: Params$Resource$Datasets$Patch, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1Dataset>): void;
    }
    export interface Params$Resource$Datasets$Create extends StandardParameters {
        /**
         * Required. The resource name of the Location to create the Dataset in. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1Dataset;
    }
    export interface Params$Resource$Datasets$Delete extends StandardParameters {
        /**
         * Required. The resource name of the Dataset to delete. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`
         */
        name?: string;
    }
    export interface Params$Resource$Datasets$Get extends StandardParameters {
        /**
         * Required. The name of the Dataset resource.
         */
        name?: string;
        /**
         * Mask specifying which fields to read.
         */
        readMask?: string;
    }
    export interface Params$Resource$Datasets$List extends StandardParameters {
        /**
         * An expression for filtering the results of the request. For field names both snake_case and camelCase are supported. * `display_name`: supports = and != * `metadata_schema_uri`: supports = and != * `labels` supports general map functions that is: * `labels.key=value` - key:value equality * `labels.key:* or labels:key - key existence * A key including a space must be quoted. `labels."a key"`. Some examples: * `displayName="myDisplayName"` * `labels.myKey="myValue"`
         */
        filter?: string;
        /**
         * A comma-separated list of fields to order by, sorted in ascending order. Use "desc" after a field name for descending. Supported fields: * `display_name` * `create_time` * `update_time`
         */
        orderBy?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
        /**
         * Required. The name of the Dataset's parent resource. Format: `projects/{project\}/locations/{location\}`
         */
        parent?: string;
        /**
         * Mask specifying which fields to read.
         */
        readMask?: string;
    }
    export interface Params$Resource$Datasets$Patch extends StandardParameters {
        /**
         * Output only. Identifier. The resource name of the Dataset. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`
         */
        name?: string;
        /**
         * Required. The update mask applies to the resource. For the `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields: * `display_name` * `description` * `labels`
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1Dataset;
    }
    export class Resource$Datasets$Datasetversions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Create a version from a Dataset.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Datasets$Datasetversions$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Datasets$Datasetversions$Create, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        create(params: Params$Resource$Datasets$Datasetversions$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Datasets$Datasetversions$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Datasets$Datasetversions$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deletes a Dataset version.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Datasets$Datasetversions$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Datasets$Datasetversions$Delete, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        delete(params: Params$Resource$Datasets$Datasetversions$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Datasets$Datasetversions$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Datasets$Datasetversions$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a Dataset version.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Datasets$Datasetversions$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Datasets$Datasetversions$Get, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1DatasetVersion>;
        get(params: Params$Resource$Datasets$Datasetversions$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Datasets$Datasetversions$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>): void;
        get(params: Params$Resource$Datasets$Datasetversions$Get, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>): void;
        /**
         * Lists DatasetVersions in a Dataset.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Datasets$Datasetversions$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Datasets$Datasetversions$List, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1ListDatasetVersionsResponse>;
        list(params: Params$Resource$Datasets$Datasetversions$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Datasets$Datasetversions$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetVersionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetVersionsResponse>): void;
        list(params: Params$Resource$Datasets$Datasetversions$List, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetVersionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ListDatasetVersionsResponse>): void;
        /**
         * Updates a DatasetVersion.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Datasets$Datasetversions$Patch, options: StreamMethodOptions): GaxiosPromise<Readable>;
        patch(params?: Params$Resource$Datasets$Datasetversions$Patch, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1DatasetVersion>;
        patch(params: Params$Resource$Datasets$Datasetversions$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Datasets$Datasetversions$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>): void;
        patch(params: Params$Resource$Datasets$Datasetversions$Patch, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1DatasetVersion>): void;
        /**
         * Restores a dataset version.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        restore(params: Params$Resource$Datasets$Datasetversions$Restore, options: StreamMethodOptions): GaxiosPromise<Readable>;
        restore(params?: Params$Resource$Datasets$Datasetversions$Restore, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        restore(params: Params$Resource$Datasets$Datasetversions$Restore, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        restore(params: Params$Resource$Datasets$Datasetversions$Restore, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        restore(params: Params$Resource$Datasets$Datasetversions$Restore, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        restore(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Datasets$Datasetversions$Create extends StandardParameters {
        /**
         * Required. The name of the Dataset resource. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1DatasetVersion;
    }
    export interface Params$Resource$Datasets$Datasetversions$Delete extends StandardParameters {
        /**
         * Required. The resource name of the Dataset version to delete. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}/datasetVersions/{dataset_version\}`
         */
        name?: string;
    }
    export interface Params$Resource$Datasets$Datasetversions$Get extends StandardParameters {
        /**
         * Required. The resource name of the Dataset version to delete. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}/datasetVersions/{dataset_version\}`
         */
        name?: string;
        /**
         * Mask specifying which fields to read.
         */
        readMask?: string;
    }
    export interface Params$Resource$Datasets$Datasetversions$List extends StandardParameters {
        /**
         * Optional. The standard list filter.
         */
        filter?: string;
        /**
         * Optional. A comma-separated list of fields to order by, sorted in ascending order. Use "desc" after a field name for descending.
         */
        orderBy?: string;
        /**
         * Optional. The standard list page size.
         */
        pageSize?: number;
        /**
         * Optional. The standard list page token.
         */
        pageToken?: string;
        /**
         * Required. The resource name of the Dataset to list DatasetVersions from. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}`
         */
        parent?: string;
        /**
         * Optional. Mask specifying which fields to read.
         */
        readMask?: string;
    }
    export interface Params$Resource$Datasets$Datasetversions$Patch extends StandardParameters {
        /**
         * Output only. Identifier. The resource name of the DatasetVersion. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}/datasetVersions/{dataset_version\}`
         */
        name?: string;
        /**
         * Required. The update mask applies to the resource. For the `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields: * `display_name`
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1DatasetVersion;
    }
    export interface Params$Resource$Datasets$Datasetversions$Restore extends StandardParameters {
        /**
         * Required. The name of the DatasetVersion resource. Format: `projects/{project\}/locations/{location\}/datasets/{dataset\}/datasetVersions/{dataset_version\}`
         */
        name?: string;
    }
    export class Resource$Endpoints {
        context: APIRequestContext;
        chat: Resource$Endpoints$Chat;
        constructor(context: APIRequestContext);
        /**
         * Return a list of tokens based on the input text.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        computeTokens(params: Params$Resource$Endpoints$Computetokens, options: StreamMethodOptions): GaxiosPromise<Readable>;
        computeTokens(params?: Params$Resource$Endpoints$Computetokens, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1ComputeTokensResponse>;
        computeTokens(params: Params$Resource$Endpoints$Computetokens, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        computeTokens(params: Params$Resource$Endpoints$Computetokens, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1ComputeTokensResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ComputeTokensResponse>): void;
        computeTokens(params: Params$Resource$Endpoints$Computetokens, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ComputeTokensResponse>): void;
        computeTokens(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1ComputeTokensResponse>): void;
        /**
         * Perform a token counting.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        countTokens(params: Params$Resource$Endpoints$Counttokens, options: StreamMethodOptions): GaxiosPromise<Readable>;
        countTokens(params?: Params$Resource$Endpoints$Counttokens, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1CountTokensResponse>;
        countTokens(params: Params$Resource$Endpoints$Counttokens, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        countTokens(params: Params$Resource$Endpoints$Counttokens, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1CountTokensResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1CountTokensResponse>): void;
        countTokens(params: Params$Resource$Endpoints$Counttokens, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1CountTokensResponse>): void;
        countTokens(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1CountTokensResponse>): void;
        /**
         * Generate content with multimodal inputs.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        generateContent(params: Params$Resource$Endpoints$Generatecontent, options: StreamMethodOptions): GaxiosPromise<Readable>;
        generateContent(params?: Params$Resource$Endpoints$Generatecontent, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1GenerateContentResponse>;
        generateContent(params: Params$Resource$Endpoints$Generatecontent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        generateContent(params: Params$Resource$Endpoints$Generatecontent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>): void;
        generateContent(params: Params$Resource$Endpoints$Generatecontent, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>): void;
        generateContent(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>): void;
        /**
         * Perform an online prediction.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        predict(params: Params$Resource$Endpoints$Predict, options: StreamMethodOptions): GaxiosPromise<Readable>;
        predict(params?: Params$Resource$Endpoints$Predict, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1PredictResponse>;
        predict(params: Params$Resource$Endpoints$Predict, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        predict(params: Params$Resource$Endpoints$Predict, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1PredictResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1PredictResponse>): void;
        predict(params: Params$Resource$Endpoints$Predict, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1PredictResponse>): void;
        predict(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1PredictResponse>): void;
        /**
         * Generate content with multimodal inputs with streaming support.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        streamGenerateContent(params: Params$Resource$Endpoints$Streamgeneratecontent, options: StreamMethodOptions): GaxiosPromise<Readable>;
        streamGenerateContent(params?: Params$Resource$Endpoints$Streamgeneratecontent, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1GenerateContentResponse>;
        streamGenerateContent(params: Params$Resource$Endpoints$Streamgeneratecontent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        streamGenerateContent(params: Params$Resource$Endpoints$Streamgeneratecontent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>): void;
        streamGenerateContent(params: Params$Resource$Endpoints$Streamgeneratecontent, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>): void;
        streamGenerateContent(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1GenerateContentResponse>): void;
    }
    export interface Params$Resource$Endpoints$Computetokens extends StandardParameters {
        /**
         * Required. The name of the Endpoint requested to get lists of tokens and token ids.
         */
        endpoint?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1ComputeTokensRequest;
    }
    export interface Params$Resource$Endpoints$Counttokens extends StandardParameters {
        /**
         * Required. The name of the Endpoint requested to perform token counting. Format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        endpoint?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1CountTokensRequest;
    }
    export interface Params$Resource$Endpoints$Generatecontent extends StandardParameters {
        /**
         * Required. The fully qualified name of the publisher model or tuned model endpoint to use. Publisher model format: `projects/{project\}/locations/{location\}/publishers/x/models/x` Tuned model endpoint format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        model?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1GenerateContentRequest;
    }
    export interface Params$Resource$Endpoints$Predict extends StandardParameters {
        /**
         * Required. The name of the Endpoint requested to serve the prediction. Format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        endpoint?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1PredictRequest;
    }
    export interface Params$Resource$Endpoints$Streamgeneratecontent extends StandardParameters {
        /**
         * Required. The fully qualified name of the publisher model or tuned model endpoint to use. Publisher model format: `projects/{project\}/locations/{location\}/publishers/x/models/x` Tuned model endpoint format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        model?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1GenerateContentRequest;
    }
    export class Resource$Endpoints$Chat {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Exposes an OpenAI-compatible endpoint for chat completions.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        completions(params: Params$Resource$Endpoints$Chat$Completions, options: StreamMethodOptions): GaxiosPromise<Readable>;
        completions(params?: Params$Resource$Endpoints$Chat$Completions, options?: MethodOptions): GaxiosPromise<Schema$GoogleApiHttpBody>;
        completions(params: Params$Resource$Endpoints$Chat$Completions, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        completions(params: Params$Resource$Endpoints$Chat$Completions, options: MethodOptions | BodyResponseCallback<Schema$GoogleApiHttpBody>, callback: BodyResponseCallback<Schema$GoogleApiHttpBody>): void;
        completions(params: Params$Resource$Endpoints$Chat$Completions, callback: BodyResponseCallback<Schema$GoogleApiHttpBody>): void;
        completions(callback: BodyResponseCallback<Schema$GoogleApiHttpBody>): void;
    }
    export interface Params$Resource$Endpoints$Chat$Completions extends StandardParameters {
        /**
         * Required. The name of the endpoint requested to serve the prediction. Format: `projects/{project\}/locations/{location\}/endpoints/{endpoint\}`
         */
        endpoint?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleApiHttpBody;
    }
    export class Resource$Media {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Upload a file into a RagCorpus.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        upload(params: Params$Resource$Media$Upload, options: StreamMethodOptions): GaxiosPromise<Readable>;
        upload(params?: Params$Resource$Media$Upload, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1UploadRagFileResponse>;
        upload(params: Params$Resource$Media$Upload, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        upload(params: Params$Resource$Media$Upload, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1UploadRagFileResponse>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1UploadRagFileResponse>): void;
        upload(params: Params$Resource$Media$Upload, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1UploadRagFileResponse>): void;
        upload(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1UploadRagFileResponse>): void;
    }
    export interface Params$Resource$Media$Upload extends StandardParameters {
        /**
         * Required. The name of the RagCorpus resource into which to upload the file. Format: `projects/{project\}/locations/{location\}/ragCorpora/{rag_corpus\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudAiplatformV1UploadRagFileRequest;
        /**
         * Media metadata
         */
        media?: {
            /**
             * Media mime-type
             */
            mimeType?: string;
            /**
             * Media body contents
             */
            body?: any;
        };
    }
    export class Resource$Projects {
        context: APIRequestContext;
        locations: Resource$Projects$Locations;
        constructor(context: APIRequestContext);
        /**
         * Gets a GenAI cache config.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getCacheConfig(params: Params$Resource$Projects$Getcacheconfig, options: StreamMethodOptions): GaxiosPromise<Readable>;
        getCacheConfig(params?: Params$Resource$Projects$Getcacheconfig, options?: MethodOptions): GaxiosPromise<Schema$GoogleCloudAiplatformV1CacheConfig>;
        getCacheConfig(params: Params$Resource$Projects$Getcacheconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getCacheConfig(params: Params$Resource$Projects$Getcacheconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudAiplatformV1CacheConfig>, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1CacheConfig>): void;
        getCacheConfig(params: Params$Resource$Projects$Getcacheconfig, callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1CacheConfig>): void;
        getCacheConfig(callback: BodyResponseCallback<Schema$GoogleCloudAiplatformV1CacheConfig>): void;
        /**
         * Updates a cache config.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateCacheConfig(params: Params$Resource$Projects$Updatecacheconfig, options: StreamMethodOptions): GaxiosPromise<Readable>;
        updateCacheConfig(params?: Params$Resource$Projects$Updatecacheconfig, options?: MethodOptions): GaxiosPromise<Schema$GoogleLongrunningOperation>;
        updateCacheConfig(params: Params$Resource$Projects$Updatecacheconfig, options: StreamMethodOptions | BodyResponseCallback<R