const express = require('express');
const router = express.Router();
const NotificationController = require('../controllers/NotificationController');
const auth = require('../middleware/auth');

// Apply auth middleware to all routes
router.use(auth);

router.post('/', NotificationController.create);
router.get('/', NotificationController.getAll);
router.get('/:id', NotificationController.getById);
router.put('/:id', NotificationController.update);
router.delete('/:id', NotificationController.remove);
router.post('/process-upcoming', NotificationController.sendUpcomingNotifications);

module.exports = router;

