const express = require('express');
const router = express.Router();
const accountFieldController = require('../controllers/accountFieldController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Create new customer
router.post('/', accountFieldController.create);

// update the order
router.put('/order', accountFieldController.updateFieldOrder);

// Get all customers
router.get('/', accountFieldController.getAll);

// Get all fields with groups
router.get('/withgroups', accountFieldController.getAllWithGroups);

// Get customer by ID
router.get('/:id', accountFieldController.getById);

// Update customer
router.put('/:id', accountFieldController.update);

// Delete customer
router.put('/:id/status', accountFieldController.remove);



module.exports = router; 