const express = require('express');
const router = express.Router();
const addNoteController = require('../controllers/addNoteControllers');
const auth = require('../middleware/auth');
router.use(auth);

router.post('/',auth, addNoteController.addNote);

router.post('/addNoteWithFile',auth,addNoteController.upload.single('file'), addNoteController.addNotesWithFile);

router.get('/', auth, addNoteController.getNotes); 

// router.post('/getnotes', auth, addNoteController.getNoteById)
router.get('/:id/:belongsto', addNoteController.getNotesByUserId);

// router.('/getnotes/:id/:belongsto', addNoteController.getNotesByUserId);

router.put('/:id', auth, addNoteController.updateNote);

router.delete('/:id', auth, addNoteController.deleteNote);


module.exports = router;