const express = require('express');
const router = express.Router();
const adminController = require('../controllers/adminController');
const auth = require('../middleware/auth');

// Apply authentication middleware
router.use(auth);

// Users Admin routes
router.get('/userlist', adminController.userList);
router.get('/userlist/:id', adminController.userbyid);
router.post('/createuser', adminController.createUser);
router.put('/updateuser/:id', adminController.updateUser);



module.exports = router;