const express = require('express');
const router = express.Router();
const contactFieldController = require('../controllers/contactFieldController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Create new customer
router.post('/', contactFieldController.create);

// change the order 
router.put('/order', contactFieldController.updateFieldOrder);

// Get all customers
router.get('/', contactFieldController.getAll);

// Get all filters
router.post('/fieldsForCreateFilters', contactFieldController.viewAllFilters);

// Get customer by ID
router.get('/:id', contactFieldController.getById);

// Update customer
router.put('/:id', contactFieldController.update);

// Delete customer
router.delete('/:id', contactFieldController.remove);

module.exports = router; 