const express = require('express');
const router = express.Router();
const customerController = require('../controllers/contactController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Bulk import route
router.post('/uploadcsv', customerController.upload.single('file'), customerController.bulkImport);

// Filters
router.get('/filters', customerController.getAllFiltersList);
router.post('/filters', customerController.createFilterView);
router.delete('/filters/:id', customerController.deleteFilterView);
router.delete('/related_modules', customerController.removeRelatedModule);

router.post('/contactListWithFilters', customerController.getContactListWithFilters);
router.post('/filtersViewUpdate', customerController.updateFilterView);
// Contact Lifecycle Routes

router.get('/lifecycles', customerController.getLifecycles);
router.post('/lifecycles', customerController.createLifecycle);
router.put('/lifecycles/:id', customerController.updateLifecycle);
router.delete('/lifecycles/:id', customerController.deleteLifecycle);

// get lifecycle stages list
router.get('/lifecycles/:id', customerController.getLifecyclesById);

// Contact Lifecycle Stages Routes
router.get('/stages', customerController.getLifecycleStages);
router.post('/stages', customerController.createLifecycleStage);
router.put('/stages', customerController.updateLifecycleStages);
router.delete('/stages/:id', customerController.deleteLifecycleStage);

// Create new customer
router.post('/', customerController.create);

// Get all customers
router.get('/', customerController.getAll);

// Get customer by ID
router.get('/:id', customerController.getById);

// Update customer
router.put('/:id', customerController.update);

// Delete customer
router.delete('/:id', customerController.remove);

router.get('/:id/tasks', customerController.getContactTasks);

// Get meetings for a contact
router.get('/:id/meetings', auth, customerController.getContactMeetings);

// Get contact relations (account and deals)
router.get('/:id/relations', auth, customerController.getContactRelations);






module.exports = router; 