const express = require('express');
const router = express.Router();
const conveyanceController = require('../controllers/conveyanceController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Get conveyance data
router.post('/get', conveyanceController.getConveyance);

// View detailed conveyance for a specific date
router.post('/view', conveyanceController.viewConveyance);

// apply the Claim 
router.post('/claimapply', conveyanceController.claimapply);

// Claim history
router.get('/claimhistory', conveyanceController.claimhistory);



module.exports = router; 