const express = require('express');
const router = express.Router();
const cpqController = require('../controllers/cpqController');
const auth = require('../middleware/auth');

router.use(auth);

// Get CPQ settings
router.get('/settings', cpqController.getCPQSettings);

// Update CPQ settings
router.post('/settings/update', cpqController.updateCPQSettings);

module.exports = router; 