const express = require('express');
const router = express.Router();
const dashboardController = require('../controllers/dashboardController');
const auth = require('../middleware/auth');

router.use(auth);

// dashboard page routes
router.post('/totalcounts', dashboardController.totalcounts);
router.post('/attendance/daily', dashboardController.getDailyAttendance);
router.post('/attendance/weekly', dashboardController.getWeeklyAttendance);
router.get('/activitylist', dashboardController.activitylist)

module.exports = router;