const express = require('express');
const router = express.Router();
const dealFieldController = require('../controllers/dealFieldController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Create new customer
router.post('/', dealFieldController.create);

// update the order
router.put('/order', dealFieldController.updateFieldOrder)

// Get all customers
router.get('/',dealFieldController.getAll);

// Get customer by ID
router.get('/:id', dealFieldController.getById);

// Update customer
router.put('/:id', dealFieldController.update);

// Delete customer
router.delete('/:id', dealFieldController.remove);

module.exports = router; 