const express = require('express');
const router = express.Router();
const dealController = require('../controllers/dealController');
const auth = require('../middleware/auth');

// Create a new deal
router.post('/', auth, dealController.createDeal);

// Bulk import route
router.post('/uploadcsv', auth, dealController.upload.single('file'), dealController.bulkImport);


// Filters
router.get('/filters', dealController.getAllFiltersList);
router.post('/filters', dealController.createFilterView);
router.delete('/filters/:id', dealController.deleteFilterView);
router.post('/fieldsForCreateFilters', auth, dealController.getFieldsForFilter);
router.post('/dealListWithFilters',auth, dealController.getDealListWithFilters);
router.post('/filtersViewUpdate', dealController.updateFilterView);

// Get all deals
router.get('/', auth, dealController.getAllDeals);

// Get deal pipeline
router.get('/pipeline', auth, dealController.getdealpipeline);

// Get deal stages
router.get('/dealstages', dealController.getdealstages);
// router.post('/dealstages', dealController.createdealstages);
router.put('/dealstages', dealController.updatedealstages);

// Get a specific deal
router.get('/:id', auth, dealController.getDealById);

// Update a deal
router.put('/:id', auth, dealController.updateDeal);

// Delete a deal
router.delete('/:id', auth, dealController.deleteDeal);

// Get meetings for a deal
router.get('/:id/meetings', auth, dealController.getDealMeetings);

router.get('/:id/tasks', auth, dealController.getDealTasks);

// Add products to deal
router.post('/:id/products', auth, dealController.addDealProducts);

// Get deal relations
router.get('/:id/relations', auth, dealController.getDealRelations);

// Update deal stage
router.put('/stage/update', auth, dealController.updateStage);

// Get deal stage list
router.get('/dealstageslist/:id', dealController.getDealStageslist);



module.exports = router;