const express = require('express');
const router = express.Router();
const { check } = require('express-validator');
const { verifyDomain } = require('../controllers/domainController');

// POST /api/domain/verify
router.post('/verify', [
    check('subdomain').isString().trim().notEmpty().isLength({ max: 50 }),
    check('domain').isString().trim().notEmpty().isLength({ max: 50 })
], verifyDomain);

module.exports = router;