const express = require('express');
const router = express.Router();
const { upload, uploadFile, getFiles, deleteFile } = require('../controllers/fileUploadController');
const auth = require('../middleware/auth');

// Apply auth middleware to all routes
router.use(auth);

// Upload a file
router.post('/upload', upload.single('file'), uploadFile);
// router.post('/upload', uploadFile)

// Get all files for the authenticated user
router.get('/', getFiles);

// Get a single file by ID
router.get('/:id', getFiles);

// Delete a file
router.delete('/:id', deleteFile);

module.exports = router;