const express = require('express');
const router = express.Router();
const FileController = require('../controllers/fileController');
const auth = require('../middleware/auth');
const upload = require('../middleware/upload');

// Add file
router.post('/upload', auth, upload.single('file'), FileController.uploadFile);

// Get files by module
router.get('/list/:belongsto/:belongsto_id', auth, FileController.getFiles);

// Delete file
router.delete('/:id', auth, FileController.deleteFile);

module.exports = router;