const express = require('express');
const router = express.Router();
const productFieldController = require('../controllers/productFieldController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Get all product groups names
router.get('/groupname', productFieldController.getGroupName);  

// Create new customer
router.post('/', productFieldController.create);

// Get all customers
router.get('/',productFieldController.getAll);

// Get all customers with group name
router.get('/group',productFieldController.getAllProductsWithGroupName);

// Get customer by ID
router.get('/:id', productFieldController.getById);

// Update customer
router.put('/:id', productFieldController.update);

// Delete customer
router.delete('/:id', productFieldController.remove);

// Add product group
router.post('/group', productFieldController.addProductGroup);

// Update product group
router.put('/group/:id', productFieldController.updateProductGroup);

// Delete product group
router.delete('/group/:id', productFieldController.deleteProductGroup); 

module.exports = router; 