const express = require('express');
const router = express.Router();
const auth = require('../middleware/auth');
const quotationFieldController = require('../controllers/quotationFieldController');

// Create quotation field
router.post('/', auth, quotationFieldController.create);

// update order
router.put('/order', auth, quotationFieldController.order);

// Get all quotation fields
router.get('/', auth, quotationFieldController.findAll);

// Get quotation field by ID
router.get('/:id', auth, quotationFieldController.findById);

// Update quotation field
router.put('/:id', auth, quotationFieldController.update);

// Delete quotation field
router.delete('/:id', auth, quotationFieldController.deleteRecord);

// Add quotation
router.post('/quotation/add', auth, quotationFieldController.addQuotation);


module.exports = router;