const express = require('express');
const router = express.Router();
const QuotationController = require('../controllers/quotationController');
const auth = require('../middleware/auth');

// Create quotation
router.post('/create', auth, QuotationController.create);

// Get all quotations
router.get('/list', auth, QuotationController.getAll);

// Get quotation by ID
router.get('/:id', auth, QuotationController.getById);

// Update quotation
router.put('/:id', auth, QuotationController.update);

// Delete quotation
router.post('/:id/delete', auth, QuotationController.delete);

// Manage quote products
router.post('/products/manage', auth, QuotationController.manageQuoteProducts);

// Delete quote product
router.delete('/product/delete', auth, QuotationController.deleteQuoteProduct);

// Update quotation stage (using PUT instead of POST)
router.put('/stage/update', auth, QuotationController.updateStage);

// Generate and share PDF
router.get('/:id/pdf', auth, QuotationController.generateAndSharePDF);

// Get quotation products
router.get('/:id/products', auth, QuotationController.getQuoteProducts);

module.exports = router;