const express = require('express');
const router = express.Router();
const reportsController = require('../controllers/reportscontroller');
const auth = require('../middleware/auth');


// All routes require authentication
router.use(auth);

// get owner list
router.get('/owners', reportsController.getOwnerList)

// get deals report
router.get('/deals', reportsController.getDealsReport);

// get conveyance report
router.get('/conveyance', reportsController.getConveyanceReport);

// get claim report
router.get('/claim', reportsController.getClaimReport);

// get attendance report
router.get('/attendance', reportsController.getAttendanceReport);


module.exports = router;    