const express = require('express');
const router = express.Router();
const roleController = require('../controllers/roleController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);
// Create a new role
router.post('/roles', roleController.createRole);

// Get all roles
router.get('/roles', roleController.getAllRoles);

// Get a specific role
router.get('/roles/:id', roleController.getRoleById);

// Update a role
router.put('/roles/:id', roleController.updateRole);

// Delete a role (soft delete)
router.delete('/roles/:id', roleController.deleteRole);

module.exports = router;