const express = require('express');
const router = express.Router();
const salesAccountController = require('../controllers/salesAccountController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Bulk import route
router.post('/uploadcsv', salesAccountController.upload.single('file'), salesAccountController.bulkImport);



// Filters
router.get('/filters', salesAccountController.getAllFiltersList);
router.post('/filters', salesAccountController.createAccountFilterView);
router.delete('/filters/:id', salesAccountController.deleteAccountFilterView);
router.post('/fieldsForCreateFilters', auth, salesAccountController.getFieldsForFilter);
router.post('/accountListWithFilters',auth, salesAccountController.getAccountListWithFilters);
router.post('/filtersViewUpdate', salesAccountController.updateFilterView);
// Create new customer
router.post('/', salesAccountController.create);

// Get all customers
router.get('/', salesAccountController.getAll);

// Get customer by ID
router.get('/:id', salesAccountController.getById);

// Update customer
router.put('/:id', salesAccountController.update);

// Delete customer
router.delete('/:id', salesAccountController.remove);

// Delete customer
router.get('/:id/status', salesAccountController.remove);

// Get meetings for an account
router.get('/:id/meetings', auth, salesAccountController.getAccountMeetings);

router.get('/:id/tasks', auth, salesAccountController.getAccountTasks);

// Add products to account
router.get('/:id/relations', auth, salesAccountController.getAccountRelations);


module.exports = router; 