const express = require('express');
const router = express.Router();
const salesActivitiesController = require('../controllers/salesActivitiesController');

// Route for cron job - no authentication required
router.post('/create-attendance', salesActivitiesController.createAttendanceForAllUsers);

// Manual trigger route for testing - no authentication required
router.post('/manual-attendance-trigger', async (req, res) => {
    try {
        const attendanceScheduler = require('../services/attendanceScheduler');
        const result = await attendanceScheduler.manualTrigger();
        res.status(200).json({
            status: 200,
            success: true,
            message: 'Manual attendance trigger executed successfully',
            data: result
        });
    } catch (error) {
        console.error('Manual trigger error:', error);
        res.status(500).json({
            status: 500,
            success: false,
            message: 'Error in manual attendance trigger',
            error: error.message
        });
    }
});

router.post('/salesactivities/attendance', salesActivitiesController.createAttendanceForAllUsers);

const auth = require('../middleware/auth');

// All routes require authentication
// router.use(auth);
router.post('/', auth, salesActivitiesController.addSalesActivity);
router.get('/', auth, salesActivitiesController.listSalesActivities);
router.put('/:id', auth, salesActivitiesController.editSalesActivity);    
router.delete('/:id', auth, salesActivitiesController.deleteSalesActivity);
router.post('/attendance', auth, salesActivitiesController.createAttendanceForAllUsers);
router.get('/allattendance', auth, salesActivitiesController.getAllAttendanceHistory);
router.post('/menus', auth, salesActivitiesController.getSalesActivities);
router.post('/appointments/', auth, salesActivitiesController.createSalesActivityData);
// router.post('/appointments/', salesActivitiesController.createSalesActivityData);
router.get('/appointments/', auth, salesActivitiesController.getAllSalesActivityData);      
router.get('/appointments/meetings', auth, salesActivitiesController.getAllMeetings);
router.get('/appointments/meetings/:id', auth, salesActivitiesController.getAllMeetingsById);
router.put('/appointments/meetings/:id', auth, salesActivitiesController.updateSalesActivityData);
router.get('/appointments/:id', auth, salesActivitiesController.getSalesActivityData);
router.put('/appointments/:id', auth, salesActivitiesController.updateSalesActivityData);   
// router.put('/appointments/details/:id', salesActivitiesController.updateSalesActivity);
router.put('/appointments/:id/status', auth, salesActivitiesController.upload.fields([      
        { name: 'attachment', maxCount: 1 },
        { name: 'bill_attachment', maxCount: 1 }
]),salesActivitiesController.updateActivityStatus);
// Get all sales activities with data
router.get('/all', auth, salesActivitiesController.getAllSalesActivitywithData);     
// Get attendance history
router.get('/attendance/history', auth, salesActivitiesController.getAttendanceHistory);

// Get conveyance list
router.post('/conveyance/list', auth, salesActivitiesController.getConveyanceList);

router.get('/conveyance', auth, salesActivitiesController.getconveyance);


// conveyancechanges
router.get('/convayancechanges', auth, salesActivitiesController.getConvayanceChanges);
router.put('/convayancechanges/:id', salesActivitiesController.updateConvayanceChanges);

router.put('/claims/bulk', auth, salesActivitiesController.updateBulkClaims);

router.get('/claims', auth, salesActivitiesController.getallclaims);
// router.get('/claims', salesActivitiesController.getallclaims);
router.put('/claims/:id', auth, salesActivitiesController.updateclaim);

router.post('/related_to', auth, salesActivitiesController.getActivitiesByModule);

router.delete('/appointments/:id', auth, salesActivitiesController.deleteSalesActivityData);
router.put('/activity/:id/custom-fields', auth, salesActivitiesController.updateActivityWithCustomFields);

router.post('/softcheckout', auth, salesActivitiesController.soft_checkout);

module.exports = router;