const express = require('express');
const router = express.Router();
const SalesActivityCustomFieldController = require('../controllers/salesActivityCustomFieldController');
const auth = require('../middleware/auth');

router.post('/', auth, SalesActivityCustomFieldController.createField);
router.put('/:id', auth, SalesActivityCustomFieldController.updateField);
router.get('/', auth, SalesActivityCustomFieldController.listFields);
router.delete('/:id', auth, SalesActivityCustomFieldController.deleteField);

module.exports = router;