const express = require('express');
const router = express.Router();
const taskController = require('../controllers/taskController');
const auth = require('../middleware/auth');

// All routes require authentication
router.use(auth);

// Create new task
router.post('/', taskController.create);

// Get all tasks
router.get('/all', taskController.getAllTasks);

// Get all tasks
router.get('/', taskController.getAll);

// Get all tasks
router.get('/fields', taskController.getFields);

// Get task by ID
router.get('/:id', taskController.getById);

// Get task by ID
router.get('/all/:id', taskController.getTaskById);

// Update task
router.put('/:id', taskController.update);
router.put('/all/:id', taskController.update);

// Delete task
router.delete('/:id', taskController.remove);
// Get tasks by account ID
router.get('/accounts/:id/tasks', taskController.getAccountTasks);
// Get tasks by deal ID
router.get('/deals/:id/tasks', taskController.getDealTasks);

// Bulk import tasks
router.post('/bulk-import', taskController.upload.single('file'), taskController.bulkImport);

module.exports = router; 