const express = require('express');
const router = express.Router();
const TerritoryController = require('../controllers/territoryController');
const auth = require('../middleware/auth');

router.post('/', auth, TerritoryController.createTerritory);
router.put('/:id', auth, TerritoryController.updateTerritory);
router.get('/', auth, TerritoryController.listTerritories);
router.delete('/:id', auth, TerritoryController.deleteTerritory);

module.exports = router;