const cron = require('node-cron');
const salesActivityDataModel = require('../models/appointments');
const salesActivityModel = require('../models/salesActivity');
const User = require('../models/user');
const db = require('../config/db');

class AttendanceScheduler {
    constructor() {
        this.isInitialized = false;
    }

    initialize() {
        if (this.isInitialized) {
            console.log('Attendance scheduler already initialized');
            return;
        }

        // this.createAttendanceForAllUsers();
        // Schedule attendance creation at 12:01 AM daily
        cron.schedule('59 23 * * *', async () => {
            console.log('Running attendance creation cron job at:', new Date().toISOString());
            await this.createAttendanceForAllUsers();
        }, {
            scheduled: true,
            timezone: "Asia/Kolkata"
        });

        console.log('⏰ Cron job triggered at:', new Date().toLocaleString("en-IN", { timeZone: "Asia/Kolkata" }));;
        this.isInitialized = true;
    }

    async createAttendanceForAllUsers() {
        try {
            const users = await User.getActiveUsers();
            // console.log("date", new Date().toISOString().split('T')[0]);
            let start_date = new Date();
            start_date.setDate(start_date.getDate() + 1);
            start_date = start_date.toISOString().split('T')[0];
            const end_date = start_date;
            const start_time = "09:00";
            const end_time = "18:00";

            for (const user of users) {
                const [salesActivities] = await db.execute(
                    `SELECT * FROM salesactivitydatas 
                     WHERE owner_id = ? 
                     AND salesactivities_id IN (3) 
                     AND activity_date = ?
                     AND status = 'inprogress'`,
                    [user.id, new Date()]
                );
                if (salesActivities.length > 0) {
                    salesActivities.forEach(async (activity) => {
                        await salesActivityModel.softCheckout(activity.id, {
                            soft_checkout: 1,
                            soft_datetime: new Date()
                        });
                    });
                }
                console.log(user.id, new Date().toISOString().split('T')[0])
                const [Attendance] = await db.execute(
                    `SELECT * FROM salesactivitydatas 
                     WHERE owner_id = ? 
                     AND salesactivities_id IN (10) 
                     AND activity_date = ?
                     AND (status = 'inprogress' OR status = 'Inprogress')`,
                    [user.id, new Date().toISOString().split('T')[0]]
                );
                console.log("Attendance123456789", Attendance);
                if (Attendance.length > 0) {
                    Attendance.forEach(async (activity) => {
                        const result = await salesActivityModel.softCheckout(activity.id, {
                            status:'Closed',
                            checkout_time: new Date(),
                            checkout_location: activity.checkin_location,
                            checkout_latitude: activity.checkin_latitude,
                            checkout_longitude: activity.checkin_longitude
                        });
                        console.log({result})
                    });
                }
                // createSalesActivityData
                await salesActivityDataModel.createSalesActivityData({
                    salesactivities_id:10,
                    activity_type: 'Attendance',
                    activity_date: start_date,
                    activity_title: `Attendance for ${start_date} for ${user.name}`,
                    start_date: start_date,
                    end_date: end_date,
                    start_time: start_time,
                    end_time: end_time,
                    owner_id: user.id,
                    creater_id: 141,
                    status: 'Pending'
                });
            }
            console.log("Attendance created for all users");
        } catch (error) {
            console.error('Error in attendance creation cron job:', error.message);
            
            // Log more details if available
            if (error.response) {
                console.error('Response status:', error.response.status);
                console.error('Response data:', error.response.data);
            }
            
            throw error;
        }
    }

    // Method to manually trigger attendance creation (for testing)
    async manualTrigger() {
        console.log('Manually triggering attendance creation...');
        return await this.createAttendanceForAllUsers();
    }
}

module.exports = new AttendanceScheduler(); 