import { findAllActionReports } from '../models/actionReport.js';
import { ActionReport } from '../models/actionReport.js';

export const getAllActionReports = async (req, res) => {
    try {
        const userId = req.user.id;
        const { 
            branch, 
            userIds, // changed from userid to userIds
            startdate, 
            enddate
        } = req.body;

        // Get reports based on filters only (no searchUserId)
        const result = await findAllActionReports({
            userId,
            branch,
            userIds, // pass userIds array
            startDate: startdate,
            endDate: enddate
        });

        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Action reports fetched successfully',
            data: result
        });
    } catch (error) {
        console.error('Error in getAllActionReports:', error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching action reports',
            error: error.message
        });
    }
};

export const datatableActionReports = async (req, res) => {
    try {
        const {
            start = 1,
            length = 10,
            order_by = 'checkin_at',
            order_dir = 'DESC',
            search = '',
            userIds = [],
            branch = [],
            startDate,
            endDate
        } = req.body;

        // Parse arrays if sent as comma-separated strings
        const userIdsArr = typeof userIds === 'string' ? userIds.split(',').map(Number) : userIds;
        const branchArr = typeof branch === 'string' ? branch.split(',').map(Number) : branch;

        const page = parseInt(start);
        const limit = parseInt(length);
        const sortBy = order_by;
        const sortOrder = order_dir;

        const { reports, total } = await ActionReport.datatableList({
            page, limit, sortBy, sortOrder, search,
            userIds: userIdsArr,
            branch: branchArr,
            startDate,
            endDate
        });
        const totalPages = Math.ceil(total / limit);
        const paginationMeta = {
            total,
            page,
            limit,
            totalPages
        };
        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Action reports fetched successfully',
            data: reports,
            total,
            pagination: paginationMeta
        });
    } catch (error) {
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Error fetching datatable action reports',
            error: error.message
        });
    }
};