import { User } from '../models/user.js';
import { Branch } from '../models/branch.js';
import { Applog } from '../models/applogs.js';
import { AttendanceConfig } from '../models/attendanceconfig.js';
import jwt from 'jsonwebtoken';
import { hashPassword } from '../utils/hash.js';
import { db } from '../utils/database.js';

export const appLogin = async (req, res) => {
    try {
        const { mobile_no, password, app_version, device_token, deviceId } = req.body;

        // Validate required fields
        if (!mobile_no || !password || !deviceId) {
            return res.json({
                code: 400,
                status: false,
                message: 'Mobile number, password and device ID are required'
            });
        }

        // Find user by mobile number
        const user = await User.findByMobileWithRelations(mobile_no);
        if (!user) {
            return res.json({
                code: 404,
                status: false,
                message: 'User not found'
            });
        }
        const userid=user.id;
        console.log("login"+user.id);
        console.log("appversion"+app_version);
        const applog = await Applog.addlog(userid,app_version);
        // Verify password
        const hashedPassword = hashPassword(password);
        console.log('Hashed password:', hashedPassword);
        
        console.log('Password comparison:', {
            providedHash: hashedPassword,
            storedHash: user.password,
            matches: hashedPassword === user.password
        });

        if (hashedPassword !== user.password) {
            return res.json({
                code: 401,
                status: false,
                message: 'Invalid credentials'
            });
        }
        if ((user.roles_id != 3)&&(user.roles_id != 4)) {
            return res.json({
                code: 401,
                status: false,
                message: 'Your role does not have permission to log in.'
            });
        }

        // Get branch details
        const branch = await Branch.findById(user.branch_id);

        // Get attendance config
        const attendanceConfig = await AttendanceConfig.getConfig();

        // Generate JWT token
        const token = jwt.sign(
            { id: user.id, role: user.roles_id },
            process.env.JWT_SECRET,
            { expiresIn: '30d' }
        );

        // Check if device_token matches the stored one
        let deviceTokenMatch = false;
        console.log("user table device id"+user.device_id );
        console.log("my login user device id"+deviceId);
        if (user.device_id && deviceId) {
            deviceTokenMatch = user.device_id === deviceId;
        }
        else if(user.device_id==null){
            deviceTokenMatch = true;
        }
        else{
            deviceTokenMatch = false;
        }
        console.log(deviceTokenMatch);
        // Add this check for device token
        const deviceTokenUsedByOtherResult = await db.query(
            'SELECT COUNT(*) as count FROM users WHERE device_id = ? AND id != ?',
            [deviceId, user.id]
        );
        const deviceTokenUsedByOther = deviceTokenUsedByOtherResult[0]?.count || 0;
        console.log(deviceTokenUsedByOther);
        if(deviceTokenMatch==false){
return res.json({
                code: 601,
                status: false,
                message: 'This device token is already associated with another user. Do you want to continue on this mobile?',
                response: {
                    user: {
                        ...user,
                        password: undefined
                    },
                    token,
                    attendanceconfig: attendanceConfig,
                    branch,
                    deviceTokenMatch
                }
            });
        }
        if (deviceTokenUsedByOther > 0) {
            return res.json({
                code: 601,
                status: false,
                message: 'This device token is already associated with another user. Do you want to continue on this mobile?',
                response: {
                    user: {
                        ...user,
                        password: undefined
                    },
                    token,
                    attendanceconfig: attendanceConfig,
                    branch,
                    deviceTokenUsedByOther
                }
            });
        }

        // Update device info
        await User.updateDeviceInfo(user.id, {
            device_token,
            device_id: deviceId,
            app_version
        });

        // Prepare response
        const response = {
            code: 200,
            status: true,
            message: 'Login success',
            response: {
                user: {
                    ...user,
                    password: undefined
                },
                token,
                attendanceconfig: attendanceConfig,
                branch,
                deviceTokenMatch
            }
        };

        res.json(response);

    } catch (error) {
        console.error('App login error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Internal server error'
        });
    }
};