import { AppVersion } from '../models/appversion.js';

export const getAppVersion = async (req, res) => {
    try {
        const version = await AppVersion.getLatest();
        
        res.json({
            code: 200,
            status: true,
            message: "App version Info",
            response: version || {
                id: null,
                versionCode: "1.0",
                versionDate: null,
                isForceUpdate: "false",
                updateMessage: "",
                isAppMaintance: "false",
                maintanceMessage: "",
                created_at: null,
                updated_at: null
            }
        });
    } catch (error) {
        console.error('Get app version error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to get app version info'
        });
    }
};

export const updateMapKeys = async (req, res) => {
    try {
        const { webMapKey, androidMapKey, IOSMapKey } = req.body;
        
        await AppVersion.updateMapKeys(webMapKey, androidMapKey, IOSMapKey);
        
        res.json({
            code: 200,
            status: true,
            message: 'Map keys updated successfully'
        });
    } catch (error) {
        console.error('Update map keys error:', error);
        res.json({
            code: 500,
            status: false,
            message: 'Failed to update map keys'
        });
    }
};